<?php
if( ! defined( 'ABSPATH' ) ){
    exit; //Exit if accessed directly
}

?>

<div class="wdes-panel-block">
    <!-- Activate -->
    <div class="wdes-panel-wrapper">
        <!-- Heading -->
        <div class="wdes-panel-wrapper_heading">
            <img class="exclamation" src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/exclamation.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
            <h1><?php esc_html_e( 'Your license is not activated!', 'phox' ); ?></h1>
            <p><?php esc_html_e( 'Activate the theme license to access all features', 'phox' ); ?></p>
            <a class="btn btn-primary" href="<?php echo esc_url(admin_url('admin.php?page=phox-wizard')); ?>">
                <?php esc_html_e( 'Activate Theme', 'phox' ); ?>
                <?php $arrow = WDES_ADMIN_ASSETS_URI . '/img/arrow-up.svg'; ?>
                <?php echo '<img class="wdes-panel-wrapper_heading_btn_arrow" src="'. esc_url($arrow) .'" alt="'.esc_attr__('Phox', 'phox').'">';?>
            </a>
        </div>

        <!-- Guide -->
        <div class="wdes-panel-guide">
            <a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-install-phox-via-ftp/">
                <?php esc_html_e( 'For assistance check installation article', 'phox' ); ?>
            </a>
        </div>
    </div>
</div>