<?php
namespace Phox\core\admin;


if( ! defined( 'ABSPATH' ) ){
    exit; //Exit if accessed directly
}

class Status
{
    protected static $_instance = null;
    /**
     * @access private
     * @var array
     */
    private array $data;

    public function get_data(): array
    {
        return $this->data;
    }

    public function get_status(): array
    {
        return $this->status;
    }
    /**
     * @access private
     * @var array Status
     */
    private array $status;

    public static function instance()
    {

        if (is_null( self::$_instance) ) {
            self::$_instance = new self ;
        }

        return self::$_instance;

    }

    public function __construct()
    {
        $this->set_status();
    }

    /**
     * Server Software
     * It check if the server run Apache or nginx
     * This is the alternative way to use global server with flag server_software
     *
     * @return string
     */
    public function serv_software(){

        #wordpress global variables
        global $is_apache,$is_nginx;

        $default = '';

        if ($is_apache) {

            $default = 'Apache';

        }elseif( $is_nginx ){

            $default = 'nginx';

        }

        return $default;

    }

    /**
     * Check Server Whois
     *
     * We are use iana server to check the domain so it need to check if site is work and the site is support.
     *
     * @since 1.7.5
     * @return bool
     */
    public function whois_server(){

        $host = 'whois.iana.org';
        $ip   = gethostbyname($host);

        $check_connection = @fsockopen( $ip, '43', $errno, $errstr, 30 );

        if( $check_connection ){
            $result = true;
        }else{
            $result = false;
        }

        return $result;
    }

    public function set_status() {
        global $wpdb,$is_apache,$is_nginx;

        $data 	= array(
            'server'					    => $this->serv_software() ,
            'php'							=> phpversion(),
            'mysql'						    => $wpdb->db_version(),
            'memory_limit' 		            => wp_convert_hr_to_bytes( @ini_get( 'memory_limit' ) ),
            'time_limit' 			        => ini_get( 'max_execution_time' ),
            'max_input_vars' 	            => ini_get( 'max_input_vars' ),
            'upload_max_filesize'	        => wp_convert_hr_to_bytes (ini_get( 'upload_max_filesize' ) ),
            'post_max_size'				    => wp_convert_hr_to_bytes( ini_get( 'post_max_size' ) ),
            'home'						    => esc_url(home_url('/')),
            'siteurl'					    => esc_url(get_option( 'siteurl' )),
            'wp_version'		            => get_bloginfo( 'version' ),
            'language'				        => get_locale(),
            'rtl'							=> is_rtl() ? 'RTL' : 'LTR',
        );

        $status = array(
            'php'						=> !(!version_compare(PHP_VERSION, '8.1', '>=') || version_compare(PHP_VERSION, '8.4', '>=')),
            'suhosin'					=> extension_loaded( 'suhosin' ),
            'memory_limit'				=> $data['memory_limit'] >= 268435456,
            'time_limit'				=> ( ( $data['time_limit'] >= 180 ) || ( $data['time_limit'] == 0 ) ),
            'max_input_vars'			=> $data['max_input_vars'] >= 5000,
            'curl'						=> extension_loaded( 'curl' ),
            'dom'						=> class_exists( 'DOMDocument' ),
            'upload_max_filesize'       => $data['upload_max_filesize'] >= 8000000,
            'post_max_size' 			=> $data['post_max_size'] >= 8000000,
            'siteurl'					=> false,
            'wp_version'				=> version_compare( get_bloginfo( 'version' ), '4.9' ) >= 0,
            'multisite'					=> is_multisite(),
            'debug'						=> defined( 'WP_DEBUG' ) && WP_DEBUG,
            'fsockopen'       		    => (function_exists('fsockopen') || function_exists('curl_init')),
            'whois_server'              => $this->whois_server(),
            'icu_version'               => defined('INTL_ICU_VERSION') && version_compare(INTL_ICU_VERSION, '4.6', '>=')
        );

        $parse = array(
            'home' 		=> parse_url( $data['home'] ),
            'siteurl' => parse_url( $data['siteurl'] ),
        );

        if( isset( $parse['home']['host'] ) && isset( $parse['siteurl']['host'] ) ){
            if( $parse['home']['host'] == $parse['siteurl']['host'] ){
                $status['siteurl'] = true;
            }
        } elseif( isset( $parse['home']['path'] ) && isset( $parse['siteurl']['path'] ) ){
            if( $parse['home']['path'] == $parse['siteurl']['path'] ){
                $status['siteurl'] = true;
            }
        }

        $this->data		= $data;
        $this->status = $status;

    }
}