<?php

namespace Phox\core\admin;

class Notifications
{
    public function __construct()
    {
        add_action('admin_notices', [$this, 'display_plugin_status_notice']);
        add_action('admin_notices', [$this, 'display_whmcs_connection_notice']);
    }

    /**
     * Display notice about plugin status
     *
     * @return void
     */
    public function display_plugin_status_notice(): void
    {
        $was_stopped = get_transient('phox_plugin_was_stopped');
        if ($was_stopped) {
            echo '<div class="notice notice-warning is-dismissible">';
            echo '<p>' . esc_html__('Phox plugin was temporarily deactivated due to PHP version incompatibility.', 'phox') . '</p>';
            echo '</div>';
        }
    }

    /**
     * Display notice about WHMCS connection status
     *
     * @return void
     */
    public function display_whmcs_connection_notice(): void
    {
        $is_connected = get_transient('phox_whmcs_api_connected');
        if ($is_connected) {
            print '<div class="notice notice-warning is-dismissible">';
            print '<p>' . esc_html__('Please update the WHMCS role required for API access. For further details, visit the following link: ', 'phox') . '<a href="https://phox.whmcsdes.com/docs/how-to-create-api-credentials-in-whmcs/">How to create API Credentials in WHMCS?</a></p>';
            print '</div>';
        }
    }
}