<?php

namespace Phox\core\admin;


use Phox\core\admin\panel\wdes_options\pages\elements\actions\Fetch_Whmcs_Data;
use Phox\core\admin\panel\wdes_options\pages\elements\actions\Fetch_Whmcs_Man;

/**
 * Database Proxy
 *
 * Handle all process that need to connect with database or with result that come form database
 *
 * @since 2.3.6
 */
class DB_Proxy
{
    /**
     * Panel Column Name
     *
     * @since 2.3.6
     */
    public const  PANEL_COLUMN_NAME = 'phox';


    /**
     * Options
     *
     * @since 2.3.6
     * @var array $options
     */
    private array $options;

    /**
     * Set panel options
     *
     * Set data for can start make process on this data
     *
     * @since 2.3.6
     * @param array $data_source
     * @return void
     */
    public function set_panel_options(array $data_source): void
    {
        $this->options = $data_source;
    }

    /**
     *
     * Get Option
     *
     * Filter from all options and back with value for $option_id parameter
     *
     * @since 2.3.6
     * @param $option_id
     * @return mixed
     */
    public function get_option($option_id, $default = []):mixed
    {
        $options = $this->options;

        $filter_option = array_filter($options, function ($value, $option) use ($option_id) {
            return $option === $option_id;
        },ARRAY_FILTER_USE_BOTH);

        return isset($filter_option[$option_id]) ? $filter_option[$option_id] : $default;

    }

    /**
     * WHMCS Fetched Data
     *
     * @since 2.3.6
     * @return mixed
     */
    public function get_whmcs_fetched_data():mixed
    {
        return get_option( Fetch_WHMCS_Data::WHMCS_FETCH_DATA_OPTION_NAME, '' );
    }

    /**
     * Update Options
     *
     * @since 2.3.6
     * @param array $options
     * @return void
     */
    public function update_options(array $options):void
    {
        update_option(DB_Proxy::PANEL_COLUMN_NAME, $options);
    }

    /**
     * Get Options For DB
     *
     * @return array
     */
    public function get_options(): array
    {
        return get_option(self::PANEL_COLUMN_NAME, []);
    }

    public function set_db_options():void
    {
        $this->set_panel_options($this->get_options());
    }

}