<?php
/**
 * Load all Theme files
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */


if( is_admin() || ( defined('WP_CLI') && WP_CLI ) ){

	/* Import Demo */
	Phox\import\Demo_Import::instance();

}

/* Wdes Admin */
require_once WDES_INC_DIR . '/core/admin/wdes-admin.php';

//Load Menu
Phox\core\menu\Wdes_Menu_Register_Fields::instance();
Phox\core\menu\Wdes_Nav_Menu::instance();


//Load Elementor
require_once (WDES_INC_DIR .'/elementor/elementor.php');


/* Head Function */
Phox\core\WDES_Head::instance();


/* Helpers */
function x_wdes () {
	return Phox\helpers::instance();
}

/**
 * Instantiate Upgrade classes
 */

\Phox\core\Upgrade::getInstance();


/* Init */
Phox\core\WDES_Init::instance();

/* Header Function */
function wdes_header(){
	return new Phox\core\Wdes_Header();
}

/* Footer Function */
function wdes_footer(){
	return new Phox\core\Wdes_Footer();
}

/* Archive Function */
function wdes_archive(){
	return new Phox\core\Wdes_Archive();
}


/* Social Details */
new Phox\core\Wdes_Social_Detail();


/* Category options */
Phox\core\Wdes_Category_Options::instance();

/* Hooks */
new Phox\core\Wdes_Hooks;


/* WooCommerce */
if( class_exists( 'WooCommerce' ) ){

	new Phox\woocommerce\Wdes_WooCommerce();
	new Phox\woocommerce\Wdes_WooCommerce_Template_Hooks();

}

/* Reseller Store */
if( class_exists( 'Reseller_Store\Plugin' ) ){

	new Phox\reseller_store\Wdes_Reseller_Store();
	new \Phox\reseller_store\Wdes_Reseller_Store_Template_Hooks();

}
