<?php
/**
* Custom Sanitize Functions
**/
function photography_sanitize_checkbox( $input ) {
	if(is_bool($input))
	{
		return $input;
	}
	else
	{
		return false;
	}

}

function photography_sanitize_slider( $input ) {	if(is_numeric($input))
	{
		return $input;
	}
	else
	{
		return 0;

	}
}

function photography_sanitize_html( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}

/*** Configuration to disable default Wordpress customizer tabs
**/

add_action( 'customize_register', 'photography_customize_register' );
function photography_customize_register( $wp_customize ) {
	$wp_customize->remove_section( 'colors' );
	$wp_customize->remove_section( 'background_image' );
}

/**
 * Configuration sample for the Kirki Customizer
 */
function photography_demo_configuration_sample() {

    /**
     * If you need to include Kirki in your theme,
     * then you may want to consider adding the translations here
     * using your textdomain.
     * 
     * If you're using Kirki as a plugin then you can remove these.
     */

    $strings = array(
        'background-color' => esc_html__('Background Color', 'photography' ),
        'background-image' => esc_html__('Background Image', 'photography' ),
        'no-repeat' => esc_html__('No Repeat', 'photography' ),
        'repeat-all' => esc_html__('Repeat All', 'photography' ),
        'repeat-x' => esc_html__('Repeat Horizontally', 'photography' ),
        'repeat-y' => esc_html__('Repeat Vertically', 'photography' ),
        'inherit' => esc_html__('Inherit', 'photography' ),
        'background-repeat' => esc_html__('Background Repeat', 'photography' ),
        'cover' => esc_html__('Cover', 'photography' ),
        'contain' => esc_html__('Contain', 'photography' ),
        'background-size' => esc_html__('Background Size', 'photography' ),
        'fixed' => esc_html__('Fixed', 'photography' ),
        'scroll' => esc_html__('Scroll', 'photography' ),
        'background-attachment' => esc_html__('Background Attachment', 'photography' ),
        'left-top' => esc_html__('Left Top', 'photography' ),
        'left-center' => esc_html__('Left Center', 'photography' ),
        'left-bottom' => esc_html__('Left Bottom', 'photography' ),
        'right-top' => esc_html__('Right Top', 'photography' ),
        'right-center' => esc_html__('Right Center', 'photography' ),
        'right-bottom' => esc_html__('Right Bottom', 'photography' ),
        'center-top' => esc_html__('Center Top', 'photography' ),
        'center-center' => esc_html__('Center Center', 'photography' ),
        'center-bottom' => esc_html__('Center Bottom', 'photography' ),
        'background-position' => esc_html__('Background Position', 'photography' ),
        'background-opacity' => esc_html__('Background Opacity', 'photography' ),
        'ON' => esc_html__('ON', 'photography' ),
        'OFF' => esc_html__('OFF', 'photography' ),
        'all' => esc_html__('All', 'photography' ),
        'cyrillic' => esc_html__('Cyrillic', 'photography' ),
        'cyrillic-ext' => esc_html__('Cyrillic Extended', 'photography' ),
        'devanagari' => esc_html__('Devanagari', 'photography' ),
        'greek' => esc_html__('Greek', 'photography' ),
        'greek-ext' => esc_html__('Greek Extended', 'photography' ),
        'khmer' => esc_html__('Khmer', 'photography' ),
        'latin' => esc_html__('Latin', 'photography' ),
        'latin-ext' => esc_html__('Latin Extended', 'photography' ),
        'vietnamese' => esc_html__('Vietnamese', 'photography' ),
    );

    $args = array(
        'textdomain'   => 'photography',
    );

    return $args;

}
add_filter( 'kirki/config', 'photography_demo_configuration_sample' );

/**
 * Create the customizer panels and sections
 */
function photography_add_panels_and_sections( $wp_customize ) {

	/**
     * Add panels
     */
     
    $wp_customize->add_section( 'logo_favicon', array(
         'title'       => esc_html__('Site Logo', 'photography' ),
         'priority'    => 34,
     
     ) );
     
    $wp_customize->add_panel( 'general', array(
        'priority'    => 35,
        'title'       => esc_html__('General', 'photography' ),
    ) ); 
    
    $wp_customize->add_panel( 'menu', array(
        'priority'    => 35,
        'title'       => esc_html__('Navigation', 'photography' ),
    ) );
    
    $wp_customize->add_panel( 'header', array(
        'priority'    => 39,
        'title'       => esc_html__('Header', 'photography' ),
    ) );
    
    $wp_customize->add_panel( 'sidebar', array(
        'priority'    => 43,
        'title'       => esc_html__('Sidebar', 'photography' ),
    ) );
    
    $wp_customize->add_panel( 'footer', array(
        'priority'    => 44,
        'title'       => esc_html__('Footer', 'photography' ),
    ) );
    
    $wp_customize->add_panel( 'gallery', array(
        'priority'    => 45,
        'title'       => esc_html__('Gallery', 'photography' ),
    ) );
    
    $wp_customize->add_panel( 'portfolio', array(
        'priority'    => 46,
        'title'       => esc_html__('Portfolio', 'photography' ),
    ) );
    
    $wp_customize->add_panel( 'blog', array(
        'priority'    => 47,
        'title'       => esc_html__('Blog', 'photography' ),
    ) );
    
    $wp_customize->add_panel( 'pages', array(
        'priority'    => 49,
        'title'       => esc_html__('Pages', 'photography' ),
    ) );
    
    //Check if Woocommerce is installed	
	if(class_exists('Woocommerce'))
	{
		$wp_customize->add_panel( 'shop', array(
	        'priority'    => 48,
	        'title'       => esc_html__('Shop', 'photography' ),
	    ) );
	}

    /**
     * Add sections
     */
    
    $wp_customize->add_section( 'general_image', array(
        'title'       => esc_html__('Image', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 46,

    ) );
    
    $wp_customize->add_section( 'general_fonts', array(
        'title'       => esc_html__('Fonts', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 46,
    
    ) );
    
    $wp_customize->add_section( 'general_typography', array(
        'title'       => esc_html__('Typography', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 47,

    ) );
    
    $wp_customize->add_section( 'general_color', array(
        'title'       => esc_html__('Background & Colors', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 48,

    ) );
    
    $wp_customize->add_section( 'general_input', array(
        'title'       => esc_html__('Input and Button Elements', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 49,

    ) );
    
    $wp_customize->add_section( 'general_sharing', array(
        'title'       => esc_html__('Sharing', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 50,

    ) );
    
    $wp_customize->add_section( 'general_mobile', array(
        'title'       => esc_html__('Mobile', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 50,

    ) );
    
    $wp_customize->add_section( 'general_frame', array(
        'title'       => esc_html__('Frame', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 51,

    ) );
    
    $wp_customize->add_section( 'general_boxed', array(
        'title'       => esc_html__('Boxed Layout', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 52,

    ) );
    
    $wp_customize->add_section( 'general_sharing', array(
        'title'       => esc_html__('Sharing', 'photography' ),
        'panel'		  => 'general',
        'priority'    => 53,

    ) );

    $wp_customize->add_section( 'menu_general', array(
        'title'       => esc_html__('General', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 36,

    ) );
    
    $wp_customize->add_section( 'menu_typography', array(
        'title'       => esc_html__('Typography', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 36,

    ) );
    
    $wp_customize->add_section( 'menu_color', array(
        'title'       => esc_html__('Colors', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 37,

    ) );
    
    $wp_customize->add_section( 'menu_background', array(
        'title'       => esc_html__('Background', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 38,

    ) );
    
    $wp_customize->add_section( 'menu_submenu', array(
        'title'       => esc_html__('Sub Menu', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 38,

    ) );
    
    $wp_customize->add_section( 'menu_megamenu', array(
        'title'       => esc_html__('Mega Menu', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 38,

    ) );
    
    $wp_customize->add_section( 'menu_topbar', array(
        'title'       => esc_html__('Top Bar', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 38,

    ) );
    
    $wp_customize->add_section( 'menu_contact', array(
        'title'       => esc_html__('Contact Info', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 39,

    ) );
    
    $wp_customize->add_section( 'menu_sidemenu', array(
        'title'       => esc_html__('Side Menu', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 39,

    ) );
    
    $wp_customize->add_section( 'menu_search', array(
        'title'       => esc_html__('Side Menu Search', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 40,

    ) );
    
    $wp_customize->add_section( 'menu_fullmenu', array(
        'title'       => esc_html__('Fullscreen Menu', 'photography' ),
        'panel'		  => 'menu',
        'priority'    => 40,
    
    ) );
    
    $wp_customize->add_section( 'header_background', array(
        'title'       => esc_html__('Background', 'photography' ),
        'panel'		  => 'header',
        'priority'    => 40,

    ) );
    
    $wp_customize->add_section( 'header_title', array(
        'title'       => esc_html__('Page Title', 'photography' ),
        'panel'		  => 'header',
        'priority'    => 41,

    ) );
    
    $wp_customize->add_section( 'header_title_bg', array(
        'title'       => esc_html__('Page Title With Background Image', 'photography' ),
        'panel'		  => 'header',
        'priority'    => 41,

    ) );
    
    $wp_customize->add_section( 'header_builder_title', array(
        'title'       => esc_html__('Content Builder Header', 'photography' ),
        'panel'		  => 'header',
        'priority'    => 41,

    ) );
    
    $wp_customize->add_section( 'header_tagline', array(
        'title'       => esc_html__('Page Tagline & Sub Title', 'photography' ),
        'panel'		  => 'header',
        'priority'    => 42,

    ) );
    
    $wp_customize->add_section( 'sidebar_general', array(
        'title'       => esc_html__('General', 'photography' ),
        'panel'		  => 'sidebar',
        'priority'    => 42,

    ) );
    
    $wp_customize->add_section( 'sidebar_typography', array(
        'title'       => esc_html__('Typography', 'photography' ),
        'panel'		  => 'sidebar',
        'priority'    => 43,

    ) );
    
    $wp_customize->add_section( 'sidebar_color', array(
        'title'       => esc_html__('Colors', 'photography' ),
        'panel'		  => 'sidebar',
        'priority'    => 44,

    ) );
    
    $wp_customize->add_section( 'footer_general', array(
        'title'       => esc_html__('General', 'photography' ),
        'panel'		  => 'footer',
        'priority'    => 45,

    ) );
    
    $wp_customize->add_section( 'footer_color', array(
        'title'       => esc_html__('Colors', 'photography' ),
        'panel'		  => 'footer',
        'priority'    => 46,

    ) );
    
    $wp_customize->add_section( 'footer_copyright', array(
        'title'       => esc_html__('Copyright', 'photography' ),
        'panel'		  => 'footer',
        'priority'    => 47,

    ) );
    
    $wp_customize->add_section( 'gallery_general', array(
        'title'       => esc_html__('General', 'photography' ),
        'panel'		  => 'gallery',
        'priority'    => 48,

    ) );
    
    $wp_customize->add_section( 'gallery_typography', array(
        'title'       => esc_html__('Typography', 'photography' ),
        'panel'		  => 'gallery',
        'priority'    => 48,

    ) );
    
    $wp_customize->add_section( 'gallery_lightbox', array(
        'title'       => esc_html__('Lightbox', 'photography' ),
        'panel'		  => 'gallery',
        'priority'    => 49,

    ) );
    
    $wp_customize->add_section( 'gallery_archive', array(
        'title'       => esc_html__('Archive', 'photography' ),
        'panel'		  => 'gallery',
        'priority'    => 49,

    ) );
    
    $wp_customize->add_section( 'gallery_fullscreen', array(
        'title'       => esc_html__('Fullscreen', 'photography' ),
        'panel'		  => 'gallery',
        'priority'    => 49,

    ) );
    
    $wp_customize->add_section( 'gallery_kenburns', array(
        'title'       => esc_html__('Kenburns', 'photography' ),
        'panel'		  => 'gallery',
        'priority'    => 50,

    ) );
    
    $wp_customize->add_section( 'gallery_flow', array(
        'title'       => esc_html__('Flow', 'photography' ),
        'panel'		  => 'gallery',
        'priority'    => 51,

    ) );
    
    $wp_customize->add_section( 'portfolio_page', array(
        'title'       => esc_html__('General', 'photography' ),
        'panel'		  => 'portfolio',
        'priority'    => 50,

    ) );
    
    $wp_customize->add_section( 'portfolio_typography', array(
        'title'       => esc_html__('Typography', 'photography' ),
        'panel'		  => 'portfolio',
        'priority'    => 50,

    ) );
    
    $wp_customize->add_section( 'portfolio_filterable', array(
        'title'       => esc_html__('Filterable', 'photography' ),
        'panel'		  => 'portfolio',
        'priority'    => 51,

    ) );
    
    $wp_customize->add_section( 'portfolio_single', array(
        'title'       => esc_html__('Single Portfolio Page', 'photography' ),
        'panel'		  => 'portfolio',
        'priority'    => 52,

    ) );
    
    $wp_customize->add_section( 'blog_general', array(
        'title'       => esc_html__('General', 'photography' ),
        'panel'		  => 'blog',
        'priority'    => 53,

    ) );
    
    $wp_customize->add_section( 'blog_typography', array(
        'title'       => esc_html__('Typography', 'photography' ),
        'panel'		  => 'blog',
        'priority'    => 54,

    ) );
    
    $wp_customize->add_section( 'blog_slider', array(
        'title'       => esc_html__('Slider', 'photography' ),
        'panel'		  => 'blog',
        'priority'    => 54,

    ) );
    
    $wp_customize->add_section( 'blog_single', array(
        'title'       => esc_html__('Single Post', 'photography' ),
        'panel'		  => 'blog',
        'priority'    => 55,

    ) );
    
    $wp_customize->add_section( 'pages_templates', array(
        'title'       => esc_html__('Templates', 'photography' ),
        'panel'		  => 'pages',
        'priority'    => 57,
    
    ) );
    
    //Check if Woocommerce is installed	
	if(class_exists('Woocommerce'))
	{
		$wp_customize->add_section( 'shop_layout', array(
	        'title'       => esc_html__('Layout', 'photography' ),
	        'panel'		  => 'shop',
	        'priority'    => 55,
	
	    ) );
	    
	    $wp_customize->add_section( 'shop_typography', array(
	        'title'       => esc_html__('Typography', 'photography' ),
	        'panel'		  => 'shop',
	        'priority'    => 55,
	
	    ) );
	    
	    $wp_customize->add_section( 'shop_single', array(
	        'title'       => esc_html__('Single Product', 'photography' ),
	        'panel'		  => 'shop',
	        'priority'    => 56,
	
	    ) );
	}

}
add_action( 'customize_register', 'photography_add_panels_and_sections' );

/**
 * Register and setting to header section
 */
function photography_header_setting( $wp_customize ) {

	//Register Logo Tab Settings
	$wp_customize->add_setting( 'tg_favicon', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ) );
	
    $wp_customize->add_setting( 'tg_retina_logo', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_setting( 'tg_retina_transparent_logo', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_setting( 'tg_retina_logo_for_admin', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ) );

    //End Logo Tab Settings
    
    //Register General Tab Settings
    $wp_customize->add_setting( 'tg_enable_right_click', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_enable_dragging', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_disable_hover_kenburns', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_body_font', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_body_font_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
	$wp_customize->add_setting( 'tg_header_font', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_header_font_weight', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_h1_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_h2_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_h3_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_h4_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_h5_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_h6_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_content_bg_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_link_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_hover_link_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_h1_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_hr_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_input_bg_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_input_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_input_border_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_input_focus_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_button_font', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_button_bg_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_button_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_button_border_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    //End General Tab Settings
    

    //Register Menu Tab Settings
    $wp_customize->add_setting( 'tg_menu_layout', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_fixed_menu', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_fixed_menu_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_font', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_font_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_padding', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_weight', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_font_spacing', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_transform', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_hover_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_active_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_border_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_bg', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_font_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_weight', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_font_spacing', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_transform', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_hover_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_hover_bg_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_bg', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_submenu_border_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_megamenu_header_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_megamenu_border_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_topbar', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_topbar_bg', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_topbar_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_topbar_social_link', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_contact_hours', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_contact_number', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_search', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_search_instant', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_search_input_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_menu_search_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_sidemenu_bg', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_sidemenu_font', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_sidemenu_font_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_sidemenu_font_transform', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_sidemenu_font_spacing', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_sidemenu_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_sidemenu_font_hover_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    //End Menu Tab Settings
    
    //Register Header Tab Settings
	$wp_customize->add_setting( 'tg_page_header_bg_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_page_header_padding_top', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_page_header_padding_bottom', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_page_title_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_page_title_font_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_page_title_font_weight', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_page_title_font_spacing', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_page_title_bg_height', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_header_builder_font_size', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_header_builder_font_transform', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    //End Header Tab Settings
    
    //Register Copyright Tab Settings
    
    $wp_customize->add_setting( 'tg_footer_sidebar', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
	
	$wp_customize->add_setting( 'tg_footer_social_link', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_bg', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
	$wp_customize->add_setting( 'tg_footer_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_link_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_hover_link_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_border_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_social_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_copyright_text', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_html',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_copyright_right_area', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_footer_copyright_totop', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    //End Copyright Tab Settings
    
    
    //Begin Gallery Tab Settings
    $wp_customize->add_setting( 'tg_gallery_sort', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_lightbox_skin', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_lightbox_enable_caption', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_lightbox_thumbnails', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_lightbox_opacity', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_gallery_hover_slide', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_full_autoplay', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_full_slideshow_timer', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_full_slideshow_trans', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_full_slideshow_trans_speed', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_full_image_caption', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_full_nocover', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_full_arrow', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_kenburns_timer', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_kenburns_zoom', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_kenburns_trans', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    //End Gallery Tab Settings
    
    
    //Begin Portfolio Tab Settings
    $wp_customize->add_setting( 'tg_portfolio_filterable', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_portfolio_filterable_link', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_portfolio_filterable_sort', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_portfolio_items', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_portfolio_next_prev', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_portfolio_recent', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_portfolio_url', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    //End Portfolio Tab Settings
    
    
    //Begin Blog Tab Settings
    $wp_customize->add_setting( 'tg_blog_display_full', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_archive_layout', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_category_layout', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_tag_layout', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_cat_font_color', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_slider', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_slider_layout', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_slider_cat', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_html',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_slider_items', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_slider',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_header_bg', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_feat_content', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_display_tags', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_display_author', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    
    $wp_customize->add_setting( 'tg_blog_display_related', array(
        'type'           => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'photography_sanitize_checkbox',
    ) );
    //End Blog Tab Settings
    
    
    //Check if Woocommerce is installed	
	if(class_exists('Woocommerce'))
	{
		//Begin Shop Tab Settings
		$wp_customize->add_setting( 'tg_shop_layout', array(
	        'type'           => 'theme_mod',
	        'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'esc_html',
	    ) );
	    
	    $wp_customize->add_setting( 'tg_shop_items', array(
	        'type'           => 'theme_mod',
	        'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'photography_sanitize_slider',
	    ) );
	    
	    $wp_customize->add_setting( 'tg_shop_price_font_color', array(
	        'type'           => 'theme_mod',
	        'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_hex_color',
	    ) );
	    
	    $wp_customize->add_setting( 'tg_shop_related_products', array(
	        'type'           => 'theme_mod',
	        'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'photography_sanitize_checkbox',
	    ) );
		//End Shop Tab Settings
	}
    
    
    //Add Live preview
    if ( $wp_customize->is_preview() && ! is_admin() ) {
	    add_action( 'wp_footer', 'photography_customize_preview', 21);
	}
}
add_action( 'customize_register', 'photography_header_setting' );

/**
 * Create the setting
 */
function photography_custom_setting( $controls ) {

	//Default control choices
	$tg_text_transform = array(
	    'none' => 'None',
	    'capitalize' => 'Capitalize',
	    'uppercase' => 'Uppercase',
	    'lowercase' => 'Lowercase',
	);
	
	$tg_font_style = array(
	    'normal' => 'Normal',
	    'italic' => 'Italic',
	    'oblique' => 'Oblique',
	);
	
	$tg_text_alignment = array(
	    'left' => 'Left',
	    'center' => 'Center',
	    'right' => 'Right',
	);
    
    $tg_input_style = array(
        'classic' => 'Classic Style',
        'paper' => 'Paper Style',
    );
	
	$tg_copyright_content = array(
	    'social' => 'Social Icons',
	    'menu' => 'Footer Menu',
	);
	
	$tg_copyright_column = array(
	    '' => 'Hide Footer Sidebar',
	    1 => '1 Column',
	    2 => '2 Columns',
	    3 => '3 Columns',
	    4 => '4 Columns',
	);
    
    $tg_shop_column = array(
        2 => '2 Columns',
        3 => '3 Columns',
        4 => '4 Columns',
    );
	
	$tg_gallery_sort = array(
		'drag' => 'By Drag&drop',
		'post_date' => 'By Newest',
		'post_date_old' => 'By Oldest',
		'rand' => 'By Random',
		//'title' => 'By Title',
	);
	
	$tg_portfolio_filterable_sort = array(
		'name' => 'By Name',
		'slug' => 'By Slug',
		'id' => 'By ID',
		'count' => 'By Number of Portfolio',
	);
	
	$tg_hover_effect = array(
		'kenburns' => 'Kenburns',
		'zoomin' => 'Zoom In',
		'zoomout' => 'Zoom Out',
		'slide' => 'Slide',
		'rotate' => 'Rotate',
		'blur' => 'Blur',
		'grayscale' => 'Gray Scale',
		'sepia' => 'Sepia',
		'blur_grayscale' => 'Blur + Gray Scale',
		'opacity' => 'Opacity',
		'flashing' => 'Flashing',
		'shine' => 'Shine',
	);
	
	$tg_blog_layout = array(
		'blog_g' => 'Grid',
		'blog_gs' => 'Grid + Right Siebar',
		'blog_gls' => 'Grid + Left Siebar',
		'blog_r' => 'Right Sidebar',
		'blog_l' => 'Left Sidebar',
		'blog_f' => 'Fullwidth',
	);
	
	$tg_shop_layout = array(
		'fullwidth' => 'Fullwidth',
		'sidebar' => 'With Sidebar',
	);
	
	$tg_slideshow_trans = array(
	    1 => 'Fade',
	    2 => 'Slide Top',
	    3 => 'Slide Right',
	    4 => 'Slide Bottom',
	    5 => 'Slide Left',
	    6 => 'Carousel Right',
	    7 => 'Carousel Left',
	);
	
	$tg_menu_layout = array(
	    'leftalign' => 'Left Align',
	    'centeralign' => 'Center Align',
	    'centeralogo' => 'Center Logo + 2 Menus',
	    'leftmenu' => 'Left Vertical',
	    'hammenuside' => 'Hamburger Menu + Open Side Menu',
	    'hammenufull' => 'Hamburger Menu + Open Fullscreen Menu',
	);
	
	$tg_fixed_menu_color = array(
	    'dark' => 'Dark',
	    'light' => 'Light',
	);
	
	$tg_slider_layout = array(
		'slider' => 'Fullwidth',
		'3cols-slider' => '3 Columns',
	);
	
	$tg_lightbox_skin = array(
		'metro-white' => 'White',
		'metro-black' => 'Black',
	);
	
	$tg_lightbox_thumbnails = array(
		'no_thumbnail' => 'No Thumbnail',
		'horizontal' => 'Horizontal Align',
		'vertical' => 'Vertical Align',
	);
	
	$tg_modulo_thumbnails = array(
		'no_thumbnail' => 'No Thumbnail',
		'thumbnail' => 'Show Thumbnail',
	);
	
	//Get all categories
	$categories_arr = get_categories();
	$tg_categories_select = array();
	$tg_categories_select[''] = '';
	
	foreach ($categories_arr as $cat) {
		$tg_categories_select[$cat->cat_ID] = $cat->cat_name;
	}
    
    $photography_footer_content = array(
        'content' => 'Footer Content',
        'sidebar' => 'Footer Sidebar',
        'hide' => 'Hide Footer',
    );
    
    $photography_header_content = array(
        'content' => 'Header Content',
        'menu' => 'General Menu Layout',
    );
    
    //Get all footer posts
    $args = array(
         'post_type'     => 'footer',
         'post_status'   => array( 'publish' ),
         'numberposts'   => -1,
         'orderby'       => 'title',
         'order'         => 'ASC',
         'suppress_filters'   => false
    );
    $footers = get_posts($args);
    $photography_footers_select = array();
    $photography_footers_select[''] = '';
    
    if(!empty($footers))
    {
        foreach ($footers as $footer)
        {
            $photography_footers_select[$footer->ID] = $footer->post_title;
        }
    }
    
    //Get all header posts
    $args = array(
         'post_type'     => 'header',
         'post_status'   => array( 'publish' ),
         'numberposts'   => -1,
         'orderby'       => 'title',
         'order'         => 'ASC',
         'suppress_filters'   => false
    );
    $headers = get_posts($args);
    $photography_headers_select = array();
    $photography_headers_select[''] = '';
    
    if(!empty($headers))
    {
        foreach ($headers as $header)
        {
            $photography_headers_select[$header->ID] = $header->post_title;
        }
    }
    
    //Get all fullscreen menus
    $args = array(
        'numberposts' => -1,
        'post_type' => array('fullmenu'),
        'post_status'   => array( 'publish' ),
        'orderby'   => 'post_title',
        'order'     => 'ASC',
        'suppress_filters'   => false
    );
    
    $photography_fullmenu_arr = get_posts($args);
    $photography_footer_contentfullmenu_select = array();
    $photography_fullmenu_select[''] = '';
    
    foreach($photography_fullmenu_arr as $photography_fullmenu)
    {
        $photography_fullmenu_select[$photography_fullmenu->ID] = $photography_fullmenu->post_title;
    }
    
    $photography_fullmenu_effect_select = array(
        ''              => esc_html__('Scale Up', 'photography' ),
        'scale-down'    => esc_html__('Scale Down', 'photography' ),
        'move-down'     => esc_html__('Move Down', 'photography' ),
        'move-up'       => esc_html__('Move Up', 'photography' ),
        'slide-left'    => esc_html__('Slide Left', 'photography' ),
        'slide-right'   => esc_html__('Slide Right', 'photography' ),
        'fade'          => esc_html__('Fade In', 'photography' ),
    );
	
	//Register Logo Tab Settings
	$controls[] = array(
        'type'     => 'image',
        'settings'  => 'tg_retina_logo',
        'label'    => esc_html__('Retina Logo', 'photography' ),
        'description' => esc_html__('Retina Ready Image logo. It should be 2x size of normal logo. For example 200x60px logo will displays at 100x30px', 'photography' ),
        'section'  => 'logo_favicon',
	    'default'  => get_template_directory_uri().'/images/logo@2x.png',
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'image',
        'settings'  => 'tg_retina_transparent_logo',
        'label'    => esc_html__('Retina Transparent Logo', 'photography' ),
        'description' => esc_html__('Retina Ready Image logo for menu transparent page. It should be 2x size of normal logo. For example 200x60px logo will displays at 100x30px. Recommend logo color is white or bright color', 'photography' ),
        'section'  => 'logo_favicon',
	    'default'  => get_template_directory_uri().'/images/logo@2x_white.png',
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_retina_logo_for_admin',
        'label'    => esc_html__('Display Retina Logo in Theme Setting', 'photography' ),
        'description' => esc_html__('Check this to replace theme setting to your logo. It helps branding your site', 'photography' ),
        'section'  => 'logo_favicon',
        'default'  => '',
	    'priority' => 4,
    );
    //End Logo Tab Settings
    
    //Register General Tab Settings
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_enable_right_click',
        'label'    => esc_html__('Enable Right Click Protection', 'photography' ),
        'description' => esc_html__('Check this to disable right click.', 'photography' ),
        'section'  => 'general_image',
        'default'  => '',
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_enable_dragging',
        'label'    => esc_html__('Enable Image Dragging Protection', 'photography' ),
        'description' => esc_html__('Check this to disable dragging on all images.', 'photography' ),
        'section'  => 'general_image',
        'default'  => '',
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_image_border_radius',
        'label'    => esc_html__('Default Image Border Radius', 'photography' ),
        'section'  => 'general_image',
        'default'  => 0,
        'choices' => array( 'min' => 0, 'max' => 25, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => '#page_content_wrapper img, .ppb_wrapper img, .portfolio_post_previous a, .portfolio_post_next a, #page_content_wrapper .inner .sidebar_wrapper .sidebar .content img, .page_content_wrapper .inner .sidebar_wrapper .sidebar .content img, .overlay_gallery_wrapper, #menu_wrapper .nav ul li ul, #menu_wrapper div .nav li ul',
	            'property' => 'border-radius',
	            'units'    => 'px',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#page_content_wrapper img, .ppb_wrapper img, .portfolio_post_previous a, .portfolio_post_next a, #page_content_wrapper .inner .sidebar_wrapper .sidebar .content img, .page_content_wrapper .inner .sidebar_wrapper .sidebar .content img, .overlay_gallery_wrapper, #menu_wrapper .nav ul li ul, #menu_wrapper div .nav li ul',
				'function' => 'css',
				'property' => 'border-radius',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 20,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_disable_hover_kenburns',
        'label'    => esc_html__('Enable Kenburns Effect For Gallery and Portfolio Pages', 'photography' ),
        'description' => esc_html__('Check this to enable kenburns effect when mouse over gallery and portfolio images.', 'photography' ),
        'section'  => 'general_image',
        'default'  => 1,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_enable_lazy_loading',
        'label'    => esc_html__('Enable Lazy Loading Progressive Image', 'photography' ),
        'description' => esc_html__('Check this to enable loading a very small, blurred image is replaced with the full-resolution equivalent when the element is scrolled into view. After activating these setting you may need to regenerate your thumbnails', 'photography' ),
        'section'  => 'general_image',
        'default'  => '',
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_body_typography_title',
        'label'    => esc_html__('Body and Content Settings', 'photography' ),
        'section'  => 'general_typography',
	    'priority' => 0,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_body_typography',
        'label'    => esc_html__('Main Content Typography', 'photography' ),
        'section'  => 'general_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => 'regular',
            'font-size'      => '16px',
            'line-height'    => '1.6',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => 'body, input[type=text], input[type=password], input[type=email], input[type=url], input[type=date], input[type=tel], input.wpcf7-text, .woocommerce table.cart td.actions .coupon .input-text, .woocommerce-page table.cart td.actions .coupon .input-text, .woocommerce #content table.cart td.actions .coupon .input-text, .woocommerce-page #content table.cart td.actions .coupon .input-text, select, textarea, .ui-widget input, .ui-widget select, .ui-widget textarea, .ui-widget button, .ui-widget label, .ui-widget-header, .zm_alr_ul_container, .woocommerce .woocommerce-result-count, .woocommerce .woocommerce-ordering select',
            ),
        ),
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_header_typography_title',
        'label'    => esc_html__('Header Settings', 'photography' ),
        'section'  => 'general_typography',
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_header_typography',
        'label'    => esc_html__('Header Typography', 'photography' ),
        'section'  => 'general_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'line-height'    => '1.8',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => 'h1, h2, h3, h4, h5, h6, h7, .post_quote_title, strong[itemprop="author"], #page_content_wrapper .posts.blog li a, .page_content_wrapper .posts.blog li a, #filter_selected, blockquote, .sidebar_widget li.widget_products, #footer ul.sidebar_widget li ul.posts.blog li a, .woocommerce-page table.cart th, table.shop_table thead tr th, .testimonial_slider_content, .pagination, .pagination_detail, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-payment .mpa-shortcode-title, #respond.comment-respond .comment-reply-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-cart .item-header .cell-service .mpa-service-name, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .mpa-cart .item-header .cell-service .mpa-service-name',
            ),
        ),
        'priority' => 2
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_h1_size',
        'label'    => esc_html__('H1 Font Size', 'photography' ),
        'section'  => 'general_typography',
        'default'  => 34,
        'choices' => array( 'min' => 13, 'max' => 60, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => 'h1',
	            'property' => 'font-size',
	            'units'    => 'px',
	        ),
	    ),
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_h2_size',
        'label'    => esc_html__('H2 Font Size', 'photography' ),
        'section'  => 'general_typography',
        'default'  => 30,
        'choices' => array( 'min' => 13, 'max' => 60, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => 'h2',
	            'property' => 'font-size',
	            'units'    => 'px',
	        ),
	    ),
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_h3_size',
        'label'    => esc_html__('H3 Font Size', 'photography' ),
        'section'  => 'general_typography',
        'default'  => 26,
        'choices' => array( 'min' => 13, 'max' => 60, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => 'h3',
	            'property' => 'font-size',
	            'units'    => 'px',
	        ),
	    ),
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_h4_size',
        'label'    => esc_html__('H4 Font Size', 'photography' ),
        'section'  => 'general_typography',
        'default'  => 22,
        'choices' => array( 'min' => 13, 'max' => 60, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => 'h4',
	            'property' => 'font-size',
	            'units'    => 'px',
	        ),
	    ),
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_h5_size',
        'label'    => esc_html__('H5 Font Size', 'photography' ),
        'section'  => 'general_typography',
        'default'  => 18,
        'choices' => array( 'min' => 13, 'max' => 60, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => 'h5',
	            'property' => 'font-size',
	            'units'    => 'px',
	        ),
	    ),
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_h6_size',
        'label'    => esc_html__('H6 Font Size', 'photography' ),
        'section'  => 'general_typography',
        'default'  => 16,
        'choices' => array( 'min' => 13, 'max' => 60, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => 'h6',
	            'property' => 'font-size',
	            'units'    => 'px',
	        ),
	    ),
	    'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_other_typography_title',
        'label'    => esc_html__('Other Settings', 'photography' ),
        'section'  => 'general_typography',
        'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_blockquote_typography',
        'label'    => esc_html__('Blockquote Typography', 'photography' ),
        'section'  => 'general_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'font-size'      => '24px',
            'variant'        => '600',
            'line-height'    => '1.8',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => 'blockquote',
            ),
        ),
        'priority' => 10
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_content_bg_color',
        'label'    => esc_html__('Main Content Background Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => 'body, #wrapper, #page_content_wrapper.fixed, #gallery_lightbox h2, .slider_wrapper .gallery_image_caption h2, #body_loading_screen, h3#reply-title span, .overlay_gallery_wrapper, .progress_bar_holder, .pricing_wrapper_border, .pagination a, .pagination span, #captcha-wrap .text-box input, #page_caption.split, #page_caption .bg_frame_split',
	            'property' => 'background-color',
	        ),
	        array(
	            'element'  => '#page_caption.hasbg.split',
	            'property' => 'border-color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'body, #wrapper, #page_content_wrapper.fixed, #gallery_lightbox h2, .slider_wrapper .gallery_image_caption h2, #body_loading_screen, h3#reply-title span, .overlay_gallery_wrapper, .progress_bar_holder, .pricing_wrapper_border, .pagination a, .pagination span, #captcha-wrap .text-box input, #page_caption.split, #page_caption .bg_frame_split',
				'function' => 'css',
				'property' => 'background-color',
			),
			array(
				'element'  => '#page_caption.hasbg.split',
				'function' => 'css',
				'property' => 'border-color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_font_color',
        'label'    => esc_html__('Page Content Font Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => 'body, .pagination a, #gallery_lightbox h2, .slider_wrapper .gallery_image_caption h2, .post_info a, #page_content_wrapper.split #copyright, .page_content_wrapper.split #copyright, .ui-state-default a, .ui-state-default a:link, .ui-state-default a:visited',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '::selection',
	            'property' => 'background-color',
	        ),
	        array(
	            'element'  => '::-webkit-input-placeholder',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '::-moz-placeholder',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => ':-ms-input-placeholder',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 11,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_link_color',
        'label'    => esc_html__('Page Content Link Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => 'a',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '.filter li a.active, #portfolio_wall_filters li a.active, #portfolio_wall_filters li a:hover, .filter li a:hover',
	            'property' => 'border-color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'a',
				'function' => 'css',
				'property' => 'color',
			),
			array(
				'element'  => '.filter li a.active, #portfolio_wall_filters li a.active, #portfolio_wall_filters li a:hover, .filter li a:hover',
				'function' => 'css',
				'property' => 'border-color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 12,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_hover_link_color',
        'label'    => esc_html__('Page Content Hover Link Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#999999',
        'output' => array(
	        array(
	            'element'  => 'a:hover, a:active, .post_info_comment a i',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 13,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_h1_font_color',
        'label'    => esc_html__('H1, H2, H3, H4, H5, H6 Font Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => 'h1, h2, h3, h4, h5, h6, h7, pre, code, tt, blockquote, .post_header h5 a, .post_header h3 a, .post_header.grid h6 a, .post_header.fullwidth h4 a, .post_header h5 a, blockquote, .site_loading_logo_item i, .ppb_subtitle, .woocommerce .woocommerce-ordering select, .woocommerce #page_content_wrapper a.button, .woocommerce.columns-4 ul.products li.product a.add_to_cart_button, .woocommerce.columns-4 ul.products li.product a.add_to_cart_button:hover, .ui-accordion .ui-accordion-header a, .tabs .ui-state-active a, body.woocommerce div.product .woocommerce-tabs ul.tabs li.active a, body.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active a, body.woocommerce #content div.product .woocommerce-tabs ul.tabs li.active a, body.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .post_header h5 a, .post_header h6 a',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => 'body.page.page-template-gallery-archive-split-screen-php #fp-nav li .active span, body.tax-gallerycat #fp-nav li .active span, body.page.page-template-portfolio-fullscreen-split-screen-php #fp-nav li .active span, body.page.tax-portfolioset #fp-nav li .active span, body.page.page-template-gallery-archive-split-screen-php #fp-nav ul li a span, body.tax-gallerycat #fp-nav ul li a span, body.page.page-template-portfolio-fullscreen-split-screen-php #fp-nav ul li a span, body.page.tax-portfolioset #fp-nav ul li a span',
	            'property' => 'background-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 14,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_hr_color',
        'label'    => esc_html__('Horizontal Line Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#social_share_wrapper, hr, #social_share_wrapper, .post.type-post, #page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle, .comment .right, .widget_tag_cloud div a, .meta-tags a, .tag_cloud a, #footer, #post_more_wrapper, .woocommerce ul.products li.product, .woocommerce-page ul.products li.product, .woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price, #page_content_wrapper .inner .sidebar_content, #page_content_wrapper .inner .sidebar_content.left_sidebar, .ajax_close, .ajax_next, .ajax_prev, .portfolio_next, .portfolio_prev, .portfolio_next_prev_wrapper.video .portfolio_prev, .portfolio_next_prev_wrapper.video .portfolio_next, .separated, .blog_next_prev_wrapper, #post_more_wrapper h5, #ajax_portfolio_wrapper.hidding, #ajax_portfolio_wrapper.visible, .tabs.vertical .ui-tabs-panel, .ui-tabs.vertical.right .ui-tabs-nav li, .woocommerce div.product .woocommerce-tabs ul.tabs li, .woocommerce #content div.product .woocommerce-tabs ul.tabs li, .woocommerce-page div.product .woocommerce-tabs ul.tabs li, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li, .woocommerce div.product .woocommerce-tabs .panel, .woocommerce-page div.product .woocommerce-tabs .panel, .woocommerce #content div.product .woocommerce-tabs .panel, .woocommerce-page #content div.product .woocommerce-tabs .panel, .woocommerce table.shop_table, .woocommerce-page table.shop_table, table tr td, .woocommerce .cart-collaterals .cart_totals, .woocommerce-page .cart-collaterals .cart_totals, .woocommerce .cart-collaterals .shipping_calculator, .woocommerce-page .cart-collaterals .shipping_calculator, .woocommerce .cart-collaterals .cart_totals tr td, .woocommerce .cart-collaterals .cart_totals tr th, .woocommerce-page .cart-collaterals .cart_totals tr td, .woocommerce-page .cart-collaterals .cart_totals tr th, table tr th, .woocommerce #payment, .woocommerce-page #payment, .woocommerce #payment ul.payment_methods li, .woocommerce-page #payment ul.payment_methods li, .woocommerce #payment div.form-row, .woocommerce-page #payment div.form-row, .ui-tabs li:first-child, .ui-tabs .ui-tabs-nav li, .ui-tabs.vertical .ui-tabs-nav li, .ui-tabs.vertical.right .ui-tabs-nav li.ui-state-active, .ui-tabs.vertical .ui-tabs-nav li:last-child, #page_content_wrapper .inner .sidebar_wrapper ul.sidebar_widget li.widget_nav_menu ul.menu li.current-menu-item a, .page_content_wrapper .inner .sidebar_wrapper ul.sidebar_widget li.widget_nav_menu ul.menu li.current-menu-item a, .pricing_wrapper, .pricing_wrapper li, .ui-accordion .ui-accordion-header, .ui-accordion .ui-accordion-content, #page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle:before, h2.widgettitle:before, #autocomplete, .ppb_blog_minimal .one_third_bg, #page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.event_title, .tabs .ui-tabs-panel, .ui-tabs .ui-tabs-nav li, .ui-tabs li:first-child, .ui-tabs.vertical .ui-tabs-nav li:last-child, .woocommerce .woocommerce-ordering select, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page div.product .woocommerce-tabs ul.tabs li.active, .woocommerce #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page table.cart th, table.shop_table thead tr th, hr.title_break, .overlay_gallery_border, #page_content_wrapper.split #copyright, .page_content_wrapper.split #copyright, .post.type-post, .events.type-events, h5.event_title, .post_header h5.event_title, .client_archive_wrapper, .woocommerce-info, .woocommerce-info::before',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 15,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_appointment_color_title',
        'label'    => esc_html__('Appointment Color Settings', 'photography' ),
        'section'  => 'general_color',
        'priority' => 16,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_appointment_font_color',
        'label'    => esc_html__('Appointment Font Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#000000',
        'output' => array(
            array(
                'element'  => '.appointment-form-shortcode label, .appointment-form-widget>.widget-body label',
                'property' => 'color',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 17,
        'js_vars'   => array(
            array(
                'element'  => '.appointment-form-shortcode label, .appointment-form-widget>.widget-body label',
                'function' => 'css',
                'property' => 'color',
            ),
        )
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_appointment_calendar_font_color',
        'label'    => esc_html__('Appointment Calendar Font Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#000000',
        'output' => array(
            array(
                'element'  => '.flatpickr-current-month, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-service-form .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-payment .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-checkout .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-service-form .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-payment .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-weekdays .flatpickr-weekday, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-weekdays .flatpickr-weekday, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-cart, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .mpa-cart, p.mpa-cart-total, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .mpa-order-details .mpa-order',
                'property' => 'color',
            ),
            array(
                'element'  => '.appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-next-month:hover svg, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-prev-month:hover svg, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-next-month:hover svg, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-prev-month:hover svg',
                'property' => 'fill',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 17,
        'js_vars'   => array(
            array(
                'element'  => '.flatpickr-current-month, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-service-form .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-payment .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-checkout .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-service-form .mpa-shortcode-title, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-payment .mpa-shortcode-title, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-weekdays .flatpickr-weekday, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-weekdays .flatpickr-weekday, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-cart, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .mpa-cart, p.mpa-cart-total, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .mpa-order-details .mpa-order',
                'function' => 'css',
                'property' => 'color',
            ),
            array(
                'element'  => '.appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-next-month:hover svg, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-prev-month:hover svg, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-next-month:hover svg, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months .flatpickr-prev-month:hover svg',
                'property' => 'fill',
            ),
        )
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_appointment_date_month_bg_color',
        'label'    => esc_html__('Appointment Date/Month Background Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#f9f9f9',
        'output' => array(
            array(
                'element'  => '.appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day:before, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day:before, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-cart .mpa-cart-item',
                'property' => 'background',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 17,
        'js_vars'   => array(
            array(
                'element'  => '.appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day:before, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-day:before',
                'function' => 'css',
                'property' => 'background',
            ),
        )
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_appointment_reservation_bg_color',
        'label'    => esc_html__('Appointment Reservation Color', 'photography' ),
        'section'  => 'general_color',
        'default'  => '#f9f9f9',
        'output' => array(
            array(
                'element'  => '.appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-cart .mpa-cart-item, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .mpa-cart .mpa-cart-item, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-booking, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-booking',
                'property' => 'background',
            ),
            array(
                'element'  => '.flatpickr-months .flatpickr-prev-month svg, .flatpickr-months .flatpickr-next-month svg',
                'property' => 'fill',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 17,
        'js_vars'   => array(
            array(
                'element'  => '.appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .mpa-cart .mpa-cart-item, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .mpa-cart .mpa-cart-item, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-booking, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-booking',
                'function' => 'css',
                'property' => 'background',
            ),
        )
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_input_title',
        'label'    => esc_html__('Input and Textarea Settings', 'photography' ),
        'section'  => 'general_input',
	    'priority' => 14,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_input_style',
        'label'    => esc_html__('Input and Textarea Style', 'photography' ),
        'description' => esc_html__('Select style for input and textarea elements', 'photography' ),
        'section'  => 'general_input',
        'default'  => 'paper',
        'choices'  => $tg_input_style,
        'transport' 	 => 'postMessage',
        'priority' => 15,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_input_typography',
        'label'    => esc_html__('Input and Textarea Typography', 'photography' ),
        'section'  => 'general_input',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => 'regular',
            'font-size'      => '16px',
            'line-height'    => '1.8',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => 'input[type=submit], input[type=button], a.button, .button, .woocommerce .page_slider a.button, a.button.fullwidth, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, body .ui-dialog[aria-describedby="ajax-login-register-login-dialog"] .form-wrapper input[type="submit"], body .ui-dialog[aria-describedby="ajax-login-register-dialog"] .form-wrapper input[type="submit"], input[type=search], select, .woocommerce #content .quantity input.qty, .woocommerce .quantity input.qty, .woocommerce-page #content .quantity input.qty, .woocommerce-page .quantity input.qty',
            ),
        ),
        'priority' => 15,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_input_bg_color',
        'label'    => esc_html__('Input and Textarea Background Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => 'input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea, select, .woocommerce #content .quantity input.qty, .woocommerce .quantity input.qty, .woocommerce-page #content .quantity input.qty, .woocommerce-page .quantity input.qty',
	            'property' => 'background-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 16,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_input_font_color',
        'label'    => esc_html__('Input and Textarea Font Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => 'input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea, select, .woocommerce #content .quantity input.qty, .woocommerce .quantity input.qty, .woocommerce-page #content .quantity input.qty, .woocommerce-page .quantity input.qty,.select2-container--default .select2-selection--single',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 17,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_input_border_color',
        'label'    => esc_html__('Input and Textarea Border Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => 'input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea, select, .woocommerce #content .quantity input.qty, .woocommerce .quantity input.qty, .woocommerce-page #content .quantity input.qty, .woocommerce-page .quantity input.qty, .select2-container--default .select2-selection--single, .select2-container--default .select2-search--dropdown .select2-search__field, .select2-dropdown, .woocommerce form.checkout_coupon, .woocommerce form.login, .woocommerce form.register',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 18,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_input_focus_color',
        'label'    => esc_html__('Input and Textarea Focus State Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#999999',
        'output' => array(
	        array(
	            'element'  => 'input[type=text]:focus, input[type=password]:focus, input[type=email]:focus, input[type=url]:focus, textarea:focus, #commentform input[type=text]:focus, #commentform input[type=email]:focus, #commentform input[type=url]:focus, #commentform textarea:focus, select:focus',
	            'property' => 'border-color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'input[type=text]:focus, input[type=password]:focus, input[type=email]:focus, input[type=url]:focus, textarea:focus, #commentform input[type=text]:focus, #commentform input[type=email]:focus, #commentform input[type=url]:focus, #commentform textarea:focus, select:focus',
				'function' => 'css',
				'property' => 'border-color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 19,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_input_border_radius',
        'label'    => esc_html__('Input and Textarea Border Radius', 'photography' ),
        'section'  => 'general_input',
        'default'  => 0,
        'choices' => array( 'min' => 0, 'max' => 25, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => 'input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea, .woocommerce .quantity .qty, select',
	            'property' => 'border-radius',
	            'units'    => 'px',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea, .woocommerce .quantity .qty, select',
				'function' => 'css',
				'property' => 'border-radius',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 19,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_label_typography',
        'label'    => esc_html__('Label Typography', 'photography' ),
        'section'  => 'general_input',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '13px',
            'line-height'    => '1.8',
            'letter-spacing' => '0',
            'text-transform' => 'uppercase',
        ),
        'output' => array(
            array(
                'element'  => 'label',
            ),
        ),
        'priority' => 19,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_label_font_color',
        'label'    => esc_html__('Label Font Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#222222',
        'output' => array(
            array(
                'element'  => 'label',
                'property' => 'color',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 19,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_button_title',
        'label'    => esc_html__('Button Settings', 'photography' ),
        'section'  => 'general_input',
	    'priority' => 20,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_button_typography',
        'label'    => esc_html__('Button Typography', 'photography' ),
        'section'  => 'general_input',
        'default'  => 'Montserrat',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '16px',
            'line-height'    => '1.7',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => 'input[type=submit], input[type=button], a.button, .button, .woocommerce .page_slider a.button, a.button.fullwidth, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, body .ui-dialog[aria-describedby="ajax-login-register-login-dialog"] .form-wrapper input[type="submit"], body .ui-dialog[aria-describedby="ajax-login-register-dialog"] .form-wrapper input[type="submit"], button[type=submit], .wp-block-search .wp-block-search__button, #woocommerce-mini-cart-flyout .woocommerce-mini-cart__buttons a, .woocommerce #page_content_wrapper a.button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button',
            ),
        ),
        'priority' => 21,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_button_border_radius',
        'label'    => esc_html__('Button Border Radius', 'photography' ),
        'section'  => 'general_input',
        'default'  => 0,
        'choices' => array( 'min' => 0, 'max' => 25, 'step' => 1 ),
        'output' => array(
            array(
                'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination a:hover, .woocommerce .footer_bar .button , .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, #bg_regular .post_info_cat a, .post_excerpt.post_tag a, .social_share_button_wrapper ul li a, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period',
                'property' => 'border-radius',
                'units'    => 'px',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination a:hover, .woocommerce .footer_bar .button , .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, #bg_regular .post_info_cat a, .post_excerpt.post_tag a, .social_share_button_wrapper ul li a, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .flatpickr-calendar .flatpickr-months, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period',
                'function' => 'css',
                'property' => 'border-radius',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 23,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_button_bg_color',
        'label'    => esc_html__('Button Background Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#000000',
        'output' => array(
	        array(
	            'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination span, .pagination a:hover, .woocommerce .footer_bar .button, .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .post_type_icon, .header_cart_wrapper .cart_count, :where(.wp-block-search__button), .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button',
	            'property' => 'background-color',
	        ),
	        array(
	            'element'  => '.pagination span, .pagination a:hover',
	            'property' => 'border-color',
	        ),
	        array(
	            'element'  => '.button.ghost, .button.ghost:hover, .button.ghost:active',
	            'property' => 'color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination span, .pagination a:hover, .woocommerce .footer_bar .button, .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .post_type_icon, .header_cart_wrapper .cart_count, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button',
				'function' => 'css',
				'property' => 'background-color',
			),
			array(
				'element'  => '.pagination span, .pagination a:hover',
				'function' => 'css',
				'property' => 'border-color',
			),
			array(
				'element'  => '.button.ghost, .button.ghost:hover, .button.ghost:active',
				'function' => 'css',
				'property' => 'color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 27,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_button_font_color',
        'label'    => esc_html__('Button Font Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination a:hover, .woocommerce .footer_bar .button , .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .post_type_icon, .woocommerce input.button.alt, .post_type_icon, .header_cart_wrapper .cart_count, :where(.wp-block-search__button), .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button',
	            'property' => 'color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination a:hover, .woocommerce .footer_bar .button , .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .post_type_icon, .woocommerce input.button.alt, .post_type_icon, .header_cart_wrapper .cart_count, :where(.wp-block-search__button), .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button',
				'function' => 'css',
				'property' => 'color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 28,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_button_border_color',
        'label'    => esc_html__('Button Border Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#000000',
        'output' => array(
	        array(
	            'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination a:hover, .woocommerce .footer_bar .button , .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .button.ghost, .button.ghost:hover, .button.ghost:active, :where(.wp-block-search__button), .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button',
	            'property' => 'border-color',
	        ),
	        array(
	            'element'  => '.button.ghost, .button.ghost:hover, .button.ghost:active',
	            'property' => 'color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'input[type=submit], input[type=button], a.button, .button, .pagination a:hover, .woocommerce .footer_bar .button , .woocommerce .footer_bar .button:hover, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .button.ghost, .button.ghost:hover, .button.ghost:active, :where(.wp-block-search__button), .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) a.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) button.button, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) input.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce #respond input#submit, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce a.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button, :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce input.button',
				'function' => 'css',
				'property' => 'border-color',
			),
			array(
				'element'  => '.button.ghost, .button.ghost:hover, .button.ghost:active',
				'function' => 'css',
				'property' => 'color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 29,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_button_hover_bg_color',
        'label'    => esc_html__('Button Hover Background Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#ffffff',
        'output' => array(
            array(
                'element'  => 'input[type=button]:hover, input[type=submit]:hover, a.button:hover, .button:hover, .button.submit, a.button.white:hover, .button.white:hover, a.button.white:active, .button.white:active, .black_bg input[type=submit], .learnpress-page #page_content_wrapper .lp-button:hover, .learnpress-page #learn-press-profile-basic-information button:hover, .learnpress-page #profile-content-settings form button[type=submit]:hover, body #checkout-payment #checkout-order-action button:hover, button[type=submit]:hover, .wp-block-search .wp-block-search__button:hover, #learn-press-course .course-summary-sidebar .course-sidebar-preview .lp-course-buttons button:hover, body .comment-respond .comment-form input[type=submit]:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-service-form .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-payment .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-checkout .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-service-form .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-payment .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, #woocommerce-mini-cart-flyout .woocommerce-mini-cart__buttons a:hover, .woocommerce #page_content_wrapper a.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, :where(.wp-block-search__button):hover, #bg_regular .post_info_cat a:hover, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit:hover',
                'property' => 'background-color',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => 'input[type=button]:hover, input[type=submit]:hover, a.button:hover, .button:hover, .button.submit, a.button.white:hover, .button.white:hover, a.button.white:active, .button.white:active, .black_bg input[type=submit], .learnpress-page #page_content_wrapper .lp-button:hover, .learnpress-page #learn-press-profile-basic-information button:hover, .learnpress-page #profile-content-settings form button[type=submit]:hover, body #checkout-payment #checkout-order-action button:hover, button[type=submit]:hover, .wp-block-search .wp-block-search__button:hover, #learn-press-course .course-summary-sidebar .course-sidebar-preview .lp-course-buttons button:hover, body .comment-respond .comment-form input[type=submit]:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-cart .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-service-form .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-payment .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-cart .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-checkout .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-service-form .button-secondary:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-payment .button-secondary:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, #woocommerce-mini-cart-flyout .woocommerce-mini-cart__buttons a:hover, .woocommerce #page_content_wrapper a.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, :where(.wp-block-search__button):hover, #bg_regular .post_info_cat a:hover, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit:hover',
                'function' => 'css',
                'property' => 'background-color',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 30,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_button_hover_font_color',
        'label'    => esc_html__('Button Hover Font Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#000000',
        'output' => array(
            array(
                'element'  => 'input[type=button]:hover, input[type=submit]:hover, a.button:hover, .button:hover, .button.submit, a.button.white:hover, .button.white:hover, a.button.white:active, .button.white:active, .black_bg input[type=submit], body.learnpress-page #page_content_wrapper .lp-button:hover, .learnpress-page #learn-press-profile-basic-information button:hover, .learnpress-page #profile-content-settings form button[type=submit]:hover, body #checkout-payment #checkout-order-action button:hover, button[type=submit]:hover, .wp-block-search .wp-block-search__button:hover, #learn-press-course .course-summary-sidebar .course-sidebar-preview .lp-course-buttons button:hover, body .comment-respond .comment-form input[type=submit]:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, #woocommerce-mini-cart-flyout .woocommerce-mini-cart__buttons a:hover, .woocommerce #page_content_wrapper a.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, :where(.wp-block-search__button):hover, #bg_regular .post_info_cat a:hover, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .button-secondary:hover',
                'property' => 'color',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => 'input[type=button]:hover, input[type=submit]:hover, a.button:hover, .button:hover, .button.submit, a.button.white:hover, .button.white:hover, a.button.white:active, .button.white:active, .black_bg input[type=submit], body.learnpress-page #page_content_wrapper .lp-button:hover, .learnpress-page #learn-press-profile-basic-information button:hover, .learnpress-page #profile-content-settings form button[type=submit]:hover, button[type=submit]:hover, .wp-block-search .wp-block-search__button:hover, #learn-press-course .course-summary-sidebar .course-sidebar-preview .lp-course-buttons button:hover, body .comment-respond .comment-form input[type=submit]:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period:hover, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, #woocommerce-mini-cart-flyout .woocommerce-mini-cart__buttons a:hover, .woocommerce #page_content_wrapper a.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, :where(.wp-block-search__button):hover, #bg_regular .post_info_cat a:hover, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-checkout .button-secondary:hover',
                'function' => 'css',
                'property' => 'color',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 31,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_button_hover_border_color',
        'label'    => esc_html__('Button Hover Border Color', 'photography' ),
        'section'  => 'general_input',
        'default'  => '#000000',
        'output' => array(
            array(
                'element'  => 'input[type=button]:hover, input[type=submit]:hover, a.button:hover, .button:hover, .button.submit, a.button.white:hover, .button.white:hover, a.button.white:active, .button.white:active, .black_bg input[type=submit], .learnpress-page #learn-press-profile-basic-information button:hover, .learnpress-page #profile-content-settings form button[type=submit]:hover, button[type=submit]:hover, .wp-block-search .wp-block-search__button:hover, #learn-press-course .course-summary-sidebar .course-sidebar-preview .lp-course-buttons button:hover, body .comment-respond .comment-form input[type=submit]:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, #woocommerce-mini-cart-flyout .woocommerce-mini-cart__buttons a:hover, .woocommerce #page_content_wrapper a.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, :where(.wp-block-search__button):hover, #bg_regular .post_info_cat a:hover, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit:hover',
                'property' => 'border-color',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => 'input[type=button]:hover, input[type=submit]:hover, a.button:hover, .button:hover, .button.submit, a.button.white:hover, .button.white:hover, a.button.white:active, .button.white:active, .black_bg input[type=submit], .learnpress-page #learn-press-profile-basic-information button:hover, .learnpress-page #profile-content-settings form button[type=submit]:hover, button[type=submit]:hover, .wp-block-search .wp-block-search__button:hover, #learn-press-course .course-summary-sidebar .course-sidebar-preview .lp-course-buttons button:hover, body .comment-respond .comment-form input[type=submit]:hover, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-widget > .widget-body .mpa-booking-step.mpa-booking-step-period .mpa-time-wrapper .mpa-times .mpa-time-period.mpa-time-period-selected, .appointment-form-shortcode .mpa-booking-step.mpa-booking-step-period .button-secondary:hover, #woocommerce-mini-cart-flyout .woocommerce-mini-cart__buttons a:hover, .woocommerce #page_content_wrapper a.button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, :where(.wp-block-search__button):hover, #bg_regular .post_info_cat a:hover, .woocommerce:where(body:not(.woocommerce-block-theme-has-button-styles)) #respond input#submit:hover',
                'function' => 'css',
                'property' => 'border-color',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 32,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_frame',
        'label'    => esc_html__('Enable Frame', 'photography' ),
        'description' => esc_html__('Check this to enable frame for site layout', 'photography' ),
        'section'  => 'general_frame',
        'default'  => 0,
	    'priority' => 26,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_frame_color',
        'label'    => esc_html__('Frame Color', 'photography' ),
        'section'  => 'general_frame',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '.frame_top, .frame_bottom, .frame_left, .frame_right',
	            'property' => 'background',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 27,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_boxed',
        'label'    => esc_html__('Enable Boxed Layout', 'photography' ),
        'description' => esc_html__('Check this to enable boxed layout for site layout', 'photography' ),
        'section'  => 'general_boxed',
        'default'  => 0,
	    'priority' => 28,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_boxed_bg_color',
        'label'    => esc_html__('Background Color', 'photography' ),
        'section'  => 'general_boxed',
        'default'  => '#f0f0f0',
        'output' => array(
	        array(
	            'element'  => 'body.tg_boxed',
	            'property' => 'background-color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => 'body.tg_boxed',
				'function' => 'css',
				'property' => 'background-color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 28,
    );
    $controls[] = array(
        'type'     => 'image',
        'settings'  => 'tg_boxed_bg_image',
        'label'    => esc_html__('Background Image', 'photography' ),
        'description' => esc_html__('Upload background image for boxed layout', 'photography' ),
        'section'  => 'general_boxed',
	    'default'  => '',
	    'priority' => 28,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_global_sharing',
        'label'    => esc_html__('Enable Sharing Button To All Pages', 'photography' ),
        'description' => esc_html__('Check this to enable sharing button on main menu for pages', 'photography' ),
        'section'  => 'general_sharing',
        'default'  => 0,
	    'priority' => 28,
    );
    //End General Tab Settings

	//Register Menu Tab Settings
	$controls[] = array(
        'type'     => 'title',
        'settings'  => 'photography_header_content_title',
        'label'    => esc_html__('Header Content Settings', 'photography' ),
        'section'  => 'menu_general',
        'priority' => 0,
    );
    
	$controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_fixed_menu',
        'label'    => esc_html__('Enable Sticky Menu', 'photography' ),
        'description' => esc_html__('Enable this to display main menu fixed when scrolling.', 'photography' ),
        'section'  => 'menu_general',
        'default'  => '',
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'photography_header_content',
        'label'    => esc_html__('Display Header Content From', 'photography' ),
        'description' => esc_html__('Select how theme get main header & navigation content', 'photography' ),
        'section'  => 'menu_general',
        'default'  => 'menu',
        'choices'  => $photography_header_content,
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'photography_default_header_content_title',
        'label'    => esc_html__('Default Header Content Settings', 'photography' ),
        'section'  => 'menu_general',
        'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'photography_header_content_default',
        'label'    => esc_html__('Default Header Content', 'photography' ),
        'description' => esc_html__('Select default header content for general pages & posts', 'photography' ),
        'section'  => 'menu_general',
        'default'  => '',
        'choices'  => $photography_headers_select,
        'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'photography_sticky_header_content_default',
        'label'    => esc_html__('Default Sticky Header Content', 'photography' ),
        'description' => esc_html__('Select default sticky header content for general pages & posts', 'photography' ),
        'section'  => 'menu_general',
        'default'  => '',
        'choices'  => $photography_headers_select,
        'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'photography_transparent_header_content_default',
        'label'    => esc_html__('Default Transparent Header Content', 'photography' ),
        'description' => esc_html__('Select default transparent header content for general pages & posts', 'photography' ),
        'section'  => 'menu_general',
        'default'  => '',
        'choices'  => $photography_headers_select,
        'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'photography_menu_title',
        'label'    => esc_html__('General Menu Settings', 'photography' ),
        'section'  => 'menu_general',
        'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_menu_layout',
        'label'    => esc_html__('Menu Layout', 'photography' ),
        'section'  => 'menu_general',
        'default'  => 'leftalign',
        'choices'  => $tg_menu_layout,
        'priority' => 10,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_fixed_menu_color',
        'label'    => esc_html__('Sticky Menu Color Scheme', 'photography' ),
        'section'  => 'menu_general',
        'default'  => 'dark',
        'choices'  => $tg_fixed_menu_color,
        'priority' => 11,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_menu_typography',
        'label'    => esc_html__('Menu Font Typography', 'photography' ),
        'section'  => 'menu_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '14px',
            'line-height'    => '1.7',
            'letter-spacing' => '0px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_menu_padding',
        'label'    => esc_html__('Menu Padding', 'photography' ),
        'section'  => 'menu_typography',
        'default'  => 22,
        'choices' => array( 'min' => 0, 'max' => 150, 'step' => 1 ),
        'output' => array(
            array(
                'element'  => '#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a',
                'property' => 'padding-top',
                'units'    => 'px',
            ),
            array(
                'element'  => '#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a',
                'property' => 'padding-bottom',
                'units'    => 'px',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_menu_font_color',
        'label'    => esc_html__('Menu Font Color', 'photography' ),
        'section'  => 'menu_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a, .header_cart_wrapper a, #page_share, .portfolio_post_previous a, .portfolio_post_next a',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '#mobile_nav_icon',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_menu_hover_font_color',
        'label'    => esc_html__('Menu Hover State Font Color', 'photography' ),
        'section'  => 'menu_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper .nav ul li a.hover, #menu_wrapper .nav ul li a:hover, #menu_wrapper div .nav li a.hover, #menu_wrapper div .nav li a:hover, .header_cart_wrapper a:hover, #page_share:hover',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '#menu_wrapper .nav ul li a.hover, #menu_wrapper .nav ul li a:hover, #menu_wrapper div .nav li a.hover, #menu_wrapper div .nav li a:hover',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_menu_active_font_color',
        'label'    => esc_html__('Menu Active State Font Color', 'photography' ),
        'section'  => 'menu_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper div .nav > li.current-menu-item > a, #menu_wrapper div .nav > li.current-menu-parent > a, #menu_wrapper div .nav > li.current-menu-ancestor > a, #menu_wrapper div .nav li ul li.current-menu-item a, #menu_wrapper div .nav li.current-menu-parent  ul li.current-menu-item a, .header_cart_wrapper a:active, #page_share:active',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '#menu_wrapper div .nav > li.current-menu-item > a, #menu_wrapper div .nav > li.current-menu-parent > a, #menu_wrapper div .nav > li.current-menu-ancestor > a, #menu_wrapper div .nav li ul li.current-menu-item a, #menu_wrapper div .nav li.current-menu-parent  ul li.current-menu-item a',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_menu_border_color',
        'label'    => esc_html__('Menu Bar Border Color', 'photography' ),
        'section'  => 'menu_color',
        'default'  => '#e1e1e1',
        'output' => array(
	        array(
	            'element'  => '.top_bar, #page_caption, #nav_wrapper',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_transparent_menu_border',
        'label'    => esc_html__('Display Border for Transparent Menu', 'photography' ),
        'description' => esc_html__('Enable this option to display border for transparent main menu', 'photography' ),
        'section'  => 'menu_color',
        'default'  => 1,
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_transparent_menu_bg_opacity',
        'label'    => esc_html__('Transparent Menu Background Opacity', 'photography' ),
        'section'  => 'menu_color',
        'default'  => 10,
        'choices' => array( 'min' => 0, 'max' => 100, 'step' => 5 ),
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_menu_bg',
        'label'    => esc_html__('Menu Background', 'photography' ),
        'section'  => 'menu_color',
	    'default'     => '#ffffff',
	    'output' => array(
	        array(
	            'element'  => '.top_bar, .portfolio_post_previous a, .portfolio_post_next a',
	            'property' => 'background-color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.top_bar, .portfolio_post_previous a, .portfolio_post_next a',
				'function' => 'css',
				'property' => 'background-color',
			),
		),
		'transport' 	 => 'postMessage',
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_submenu_font_title',
        'label'    => esc_html__('Typography Settings', 'photography' ),
        'section'  => 'menu_submenu',
	    'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_submenu_typography',
        'label'    => esc_html__('Sub Menu Typography', 'photography' ),
        'section'  => 'menu_submenu',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => 'regular',
            'font-size'      => '16px',
            'letter-spacing' => '0',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '#menu_wrapper .nav ul li ul li a, #menu_wrapper div .nav li ul li a, #menu_wrapper div .nav li.current-menu-parent ul li a',
            ),
        ),
        'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_submenu_color_title',
        'label'    => esc_html__('Color Settings', 'photography' ),
        'section'  => 'menu_submenu',
	    'priority' => 12,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_submenu_font_color',
        'label'    => esc_html__('Sub Menu Font Color', 'photography' ),
        'section'  => 'menu_submenu',
        'default'  => '#999999',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper .nav ul li ul li a, #menu_wrapper div .nav li ul li a, #menu_wrapper div .nav li.current-menu-parent ul li a, #menu_wrapper div .nav li.current-menu-parent ul li.current-menu-item a, #menu_wrapper .nav ul li.megamenu ul li ul li a, #menu_wrapper div .nav li.megamenu ul li ul li a',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 13,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_submenu_hover_font_color',
        'label'    => esc_html__('Sub Menu Hover State Font Color', 'photography' ),
        'section'  => 'menu_submenu',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper .nav ul li ul li a:hover, #menu_wrapper div .nav li ul li a:hover, #menu_wrapper div .nav li.current-menu-parent ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:hover, #menu_wrapper div .nav li.megamenu ul li ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:active, #menu_wrapper div .nav li.megamenu ul li ul li a:active, #menu_wrapper div .nav li.current-menu-parent ul li.current-menu-item  a:hover',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 14,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_submenu_hover_bg_color',
        'label'    => esc_html__('Sub Menu Hover State Background Color', 'photography' ),
        'section'  => 'menu_submenu',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper .nav ul li ul li a:hover, #menu_wrapper div .nav li ul li a:hover, #menu_wrapper div .nav li.current-menu-parent ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:hover, #menu_wrapper div .nav li.megamenu ul li ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:active, #menu_wrapper div .nav li.megamenu ul li ul li a:active',
	            'property' => 'background',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 15,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_submenu_bg_color',
        'label'    => esc_html__('Sub Menu Background Color', 'photography' ),
        'section'  => 'menu_submenu',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper .nav ul li ul, #menu_wrapper div .nav li ul',
	            'property' => 'background',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 16,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_submenu_border_color',
        'label'    => esc_html__('Sub Menu Border Color', 'photography' ),
        'section'  => 'menu_submenu',
        'default'  => '#333333',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper .nav ul li ul, #menu_wrapper div .nav li ul',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 17,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_megamenu_header_color',
        'label'    => esc_html__('Mega Menu Header Font Color', 'photography' ),
        'section'  => 'menu_megamenu',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper div .nav li.megamenu ul li > a, #menu_wrapper div .nav li.megamenu ul li > a:hover, #menu_wrapper div .nav li.megamenu ul li > a:active, #menu_wrapper div .nav li.megamenu ul li.current-menu-item > a',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 18,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_megamenu_border_color',
        'label'    => esc_html__('Mega Menu Border Color', 'photography' ),
        'section'  => 'menu_megamenu',
        'default'  => '#333333',
        'output' => array(
	        array(
	            'element'  => '#menu_wrapper div .nav li.megamenu ul li',
	            'property' => 'border-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 20,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_megamenu_border_radius',
        'label'    => esc_html__('Mega Menu Border Radius', 'photography' ),
        'section'  => 'menu_megamenu',
        'default'  => 0,
        'choices' => array( 'min' => 0, 'max' => 50, 'step' => 1 ),
        'output' => array(
            array(
                'element'  => '.themegoods-navigation-wrapper .nav li.megamenu > ul, .themegoods-navigation-wrapper .nav li.megamenu > .elementor-megamenu-wrapper, #menu_wrapper .nav ul li.megamenu>ul, #menu_wrapper div .nav li.megamenu>ul',
                'property' => 'border-radius',
                'units'    => 'px',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => '.themegoods-navigation-wrapper .nav li.megamenu > ul, .themegoods-navigation-wrapper .nav li.megamenu > .elementor-megamenu-wrapper, #menu_wrapper .nav ul li.megamenu>ul, #menu_wrapper div .nav li.megamenu>ul',
                'function' => 'css',
                'property' => 'border-radius',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 21,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_topbar',
        'label'    => esc_html__('Display Top Bar', 'photography' ),
        'description' => esc_html__('Enable this option to display top bar above main menu', 'photography' ),
        'section'  => 'menu_topbar',
        'default'  => 0,
	    'priority' => 21,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_topbar_bg_color',
        'label'    => esc_html__('Top Bar Background Color', 'photography' ),
        'section'  => 'menu_topbar',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '.above_top_bar',
	            'property' => 'background',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 22,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_topbar_font_color',
        'label'    => esc_html__('Top Bar Menu Font Color', 'photography' ),
        'section'  => 'menu_topbar',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '#top_menu li a, .top_contact_info, .top_contact_info i, .top_contact_info a, .top_contact_info a:hover, .top_contact_info a:active',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 23,
    );
    
    $controls[] = array(
        'type'     => 'text',
        'settings'  => 'tg_menu_contact_hours',
        'label'    => esc_html__('Contact Hours (Optional)', 'photography' ),
        'description' => esc_html__('Enter your company contact hours.', 'photography' ),
        'section'  => 'menu_contact',
        'default'  => 'Mon-Fri 09.00 - 17.00',
        'transport' 	 => 'postMessage',
	    'priority' => 26,
    );
    
    $controls[] = array(
        'type'     => 'text',
        'settings'  => 'tg_menu_contact_number',
        'label'    => esc_html__('Contact Phone Number (Optional)', 'photography' ),
        'description' => esc_html__('Enter your company contact phone number.', 'photography' ),
        'section'  => 'menu_contact',
        'default'  => '1.800.456.6743',
        'transport' => 'postMessage',
	    'priority' => 27,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_topbar_social_link',
        'label'    => __( 'Open Top Bar Social Icons link in new window', 'photome' ),
        'description' => __('Check this to open top bar social icons link in new window', 'photography' ),
        'section'  => 'menu_contact',
        'default'  => 1,
        'priority' => 28,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_menu_search',
        'label'    => esc_html__('Enable Search', 'photography' ),
        'description' => esc_html__('Select to display search form in header of side menu', 'photography' ),
        'section'  => 'menu_search',
        'default'  => 1,
	    'priority' => 28,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_menu_search_instant',
        'label'    => esc_html__('Enable Instant Search', 'photography' ),
        'description' => esc_html__('Select to display search result instantly while typing', 'photography' ),
        'section'  => 'menu_search',
        'default'  => 1,
	    'priority' => 29,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_menu_search_input_color',
        'label'    => esc_html__('Search Input Background Color', 'photography' ),
        'section'  => 'menu_search',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '.mobile_menu_wrapper #searchform input[type=text]',
	            'property' => 'background',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 30,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_menu_search_font_color',
        'label'    => esc_html__('Search Input Font Color', 'photography' ),
        'section'  => 'menu_search',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '.mobile_menu_wrapper #searchform input[type=text], .mobile_menu_wrapper #searchform button i',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '.mobile_menu_wrapper #searchform ::-webkit-input-placeholder',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '.mobile_menu_wrapper #searchform ::-moz-placeholder',
	            'property' => 'color',
	        ),
	        array(
	            'element'  => '.mobile_menu_wrapper #searchform :-ms-input-placeholder',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 31,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_fullmenu_default',
        'label'    => esc_html__('Default Fullscreen Menu (Optional)', 'photography' ),
        'description' => esc_html__('Select default fullscreen menu for all pages', 'photography' ),
        'section'  => 'menu_fullmenu',
        'default'  => '',
        'choices'  => $photography_fullmenu_select,
        'priority' => 32,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_fullmenu_effect',
        'label'    => esc_html__('Fullscreen Menu Effect', 'photography' ),
        'description' => esc_html__('Select transition effect for fullscreen menu', 'photography' ),
        'section'  => 'menu_fullmenu',
        'default'  => '',
        'choices'  => $photography_fullmenu_effect_select,
        'priority' => 33,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_fullmenu_bg',
        'label'    => esc_html__('Default Fullscreen Menu Background Color', 'photography' ),
        'section'  => 'menu_fullmenu',
        'default'  => '#000000',
        'output' => array(
           array(
                'element'  => 'div.fullmenu-wrapper',
                'property' => 'background',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => 'div.fullmenu-wrapper',
                'function' => 'css',
                'property' => 'background',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 34,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_sidemenu_general_title',
        'label'    => esc_html__('General Settings', 'photography' ),
        'section'  => 'menu_sidemenu',
        'priority' => 30,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_sidemenu',
        'label'    => esc_html__('Enable Side Menu on Desktop', 'photography' ),
        'description' => 'Check this option to enable side menu on desktop',
        'section'  => 'menu_sidemenu',
        'default'  => 1,
	    'priority' => 31,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_sidemenu_logo',
        'label'    => esc_html__('Display Logo Image on Side Menu', 'photography' ),
        'description' => 'Check this option to display logo image on side menu',
        'section'  => 'menu_sidemenu',
        'default'  => 0,
        'priority' => 31,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_sidemenu_font_title',
        'label'    => esc_html__('Typography Settings', 'photography' ),
        'section'  => 'menu_sidemenu',
        'priority' => 32,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_sidemenu_typography',
        'label'    => esc_html__('Side Menu Typography', 'photography' ),
        'section'  => 'menu_sidemenu',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '24px',
            'line-height'    => '2',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '.mobile_main_nav li a, #sub_menu li a',
            ),
        ),
        'priority' => 33
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_sidemenu_icon_size',
        'label'    => esc_html__('Side Menu Icon Size', 'photography' ),
        'section'  => 'menu_sidemenu',
        'default'  => 12,
        'choices' => array( 'min' => 11, 'max' => 40, 'step' => 1 ),
        'output' => array(
            array(
                'element'  => '.mobile_main_nav li.menu-item-has-link.menu-item-has-children > a.menu-item-icon-link',
                'property' => 'font-size',
                'units'    => 'px',
            ),
        ),
        'priority' => 42,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_sidemenu_bg_title',
        'label'    => esc_html__('Color Settings', 'photography' ),
        'section'  => 'menu_sidemenu',
        'priority' => 43,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_sidemenu_bg',
        'label'    => esc_html__('Side Menu Background', 'photography' ),
        'section'  => 'menu_sidemenu',
        'default' => '#ffffff',
        'output' => array(
            array(
                'element'  => '.mobile_menu_wrapper',
                'property' => 'background-color',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => '.mobile_menu_wrapper',
                'function' => 'css',
            ),
        ),
        'transport' => 'auto',
        'priority' => 44,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_sidemenu_font_color',
        'label'    => esc_html__('Side Menu Font Color', 'photography' ),
        'section'  => 'menu_sidemenu',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '.mobile_main_nav li a, #sub_menu li a, .mobile_menu_wrapper .sidebar_wrapper a, .mobile_menu_wrapper .sidebar_wrapper, #close_mobile_menu i',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 45,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_sidemenu_font_hover_color',
        'label'    => esc_html__('Side Menu Hover State Font Color', 'photography' ),
        'section'  => 'menu_sidemenu',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '.mobile_main_nav li a:hover, .mobile_main_nav li a:active, #sub_menu li a:hover, #sub_menu li a:active, .mobile_menu_wrapper .sidebar_wrapper h2.widgettitle',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 46,
    );
    //End Menu Tab Settings
    
    //Register Header Tab Settings
    /*$controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_page_title_img_blur',
        'label'    => esc_html__('Add Blur Effect When Scroll', 'photography' ),
        'description' => esc_html__('Enable this option to add blur effect to header background image when scrolling pass it', 'photography' ),
        'section'  => 'header_background',
        'default'  => '1',
	    'priority' => 1,
    );*/
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_page_header_bg_color',
        'label'    => esc_html__('Page Header Background Color', 'photography' ),
        'section'  => 'header_background',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '#page_caption',
	            'property' => 'background-color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 18,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_page_header_overlay_bg_color',
        'label'    => esc_html__('Single Page/Post Overlay Background Color', 'photography' ),
        'section'  => 'header_background',
        'default'  => 'rgba(0,0,0,0.2)',
        'output' => array(
            array(
                'element'  => '#page_caption.hasbg #bg_regular:after',
                'property' => 'background',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 18,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_page_title_img_gradient',
        'label'    => esc_html__('Add Gradient Effect After Header Background Image', 'photography' ),
        'description' => esc_html__('Enable this option to add gradient effect after header background image', 'photography' ),
        'section'  => 'header_background',
        'default'  => 0,
	    'priority' => 18,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_page_title_layout_title',
        'label'    => esc_html__('Layout Settings', 'photography' ),
        'section'  => 'header_title',
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_page_title_font_alignment',
        'label'    => esc_html__('Page Title Alignment', 'photography' ),
        'description' => esc_html__('Select alignment for page title', 'photography' ),
        'section'  => 'header_title',
        'default'  => 'center',
        'choices'  => $tg_text_alignment,
        'output' => array(
	        array(
	            'element'  => '#page_caption .page_title_wrapper, #portfolio_wall_filters, .portfolio_wall_filters, .page_tagline, #page_caption.hasbg .page_tagline, #page_caption.hasbg h1, h1.hasbg',
	            'property' => 'text-align',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#page_caption .page_title_wrapper, #portfolio_wall_filters, .portfolio_wall_filters, .page_tagline, #page_caption.hasbg .page_tagline, #page_caption.hasbg h1, h1.hasbg',
				'function' => 'css',
				'property' => 'text-align',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_page_header_width',
        'label'    => esc_html__('Page Header Width (%)', 'photography' ),
        'section'  => 'header_title',
        'default'  => 100,
        'choices' => array( 'min' => 10, 'max' => 100, 'step' => 5 ),
        'output' => array(
	        array(
	            'element'  => '#page_caption .page_title_wrapper, #page_caption.hasbg.middle .page_title_wrapper',
	            'property' => 'width',
	            'units'    => '%',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#page_caption .page_title_wrapper, #page_caption.hasbg.middle .page_title_wrapper',
				'function' => 'css',
				'property' => 'width',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_page_header_padding_top',
        'label'    => esc_html__('Page Header Padding Top', 'photography' ),
        'section'  => 'header_title',
        'default'  => 80,
        'choices' => array( 'min' => 0, 'max' => 200, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => '#page_caption',
	            'property' => 'padding-top',
	            'units'    => 'px',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_page_header_padding_bottom',
        'label'    => esc_html__('Page Header Padding Bottom', 'photography' ),
        'section'  => 'header_title',
        'default'  => 80,
        'choices' => array( 'min' => 0, 'max' => 200, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => '#page_caption',
	            'property' => 'padding-bottom',
	            'units'    => 'px',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_page_title_typography_title',
        'label'    => esc_html__('Typography Settings', 'photography' ),
        'section'  => 'header_title',
        'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_page_title_typography',
        'label'    => esc_html__('Page Title Typography', 'photography' ),
        'section'  => 'header_title',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '50px',
            'line-height'    => '1.2',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
            'color'			 => '#000000',
        ),
        'output' => array(
            array(
                'element'  => '#page_caption h1, .ppb_title',
            ),
        ),
        'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_page_title_bg_height',
        'label'    => esc_html__('Page Title Background Image Height (in %)', 'photography' ),
        'section'  => 'header_title_bg',
        'default'  => 70,
        'choices' => array( 'min' => 10, 'max' => 100, 'step' => 5 ),
        'output' => array(
	        array(
	            'element'  => '#page_caption.hasbg',
	            'property' => 'height',
	            'units'    => 'vh',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_page_title_bg_vertical_alignment',
        'label'    => esc_html__('Page Title Background Image Vertical Alignment', 'photography' ),
        'section'  => 'header_title_bg',
        'default'  => 'baseline',
        'choices'  => array(
        	'baseline'	=> 'Baseline',
        	'middle'	=> 'Middle',
        ),
	    'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_page_title_bg_typography',
        'label'    => esc_html__('Page Title Background Typography', 'photography' ),
        'section'  => 'header_title_bg',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '50px',
            'line-height'    => '1.2',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
            'color'			 => '#000000',
        ),
        'output' => array(
            array(
                'element'  => '#page_caption.hasbg h1, h1.hasbg',
            ),
        ),
        'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_page_title_bg_opacity',
        'label'    => esc_html__('Page Title Background Image Overlay Opacity', 'photography' ),
        'section'  => 'header_title_bg',
        'default'  => 70,
        'choices' => array( 'min' => 0, 'max' => 100, 'step' => 5 ),
	    'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_page_tagline_alignment',
        'label'    => esc_html__('Page Tagline Alignment (With Background Image)', 'photography' ),
        'section'  => 'header_title_bg',
        'default'  => 'side',
        'choices'  => array(
        	'side'	=> 'On Right Side of Page Title',
        	'below'	=> 'Below Page Title',
        ),
	    'priority' => 13,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_header_builder_typography',
        'label'    => esc_html__('Content Builder Header Typography', 'photography' ),
        'section'  => 'header_builder_title',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '50px',
            'line-height'    => '1.2',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => 'h2.ppb_title',
            ),
        ),
        'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_page_tagline_typography',
        'label'    => esc_html__('Page Tagline Typography', 'photography' ),
        'section'  => 'header_tagline',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => 'regular',
            'font-size'      => '14px',
            'line-height'    => '1.8',
            'letter-spacing' => '0px',
            'text-transform' => 'none',
            'color'			 => '#000000',
        ),
        'output' => array(
            array(
                'element'  => '.page_tagline, .post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company, .page_tagline, #page_caption.hasbg .page_tagline, .post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company, .page_tagline, #page_caption.hasbg .page_tagline',
            ),
        ),
        'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_page_tagline_font_style',
        'label'    => esc_html__('Page Tagline Font Style', 'photography' ),
        'section'  => 'header_tagline',
        'default'  => 'italic',
        'choices'  => $tg_font_style,
        'output' => array(
            array(
                'element'  => '.page_tagline, .ppb_header_content, .page_tagline, #page_caption.hasbg .page_tagline, .post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company, .page_tagline, #page_caption.hasbg .page_tagline',
                'property' => 'font-style',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => '.page_tagline, .ppb_header_content, .page_tagline, #page_caption.hasbg .page_tagline, .post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company, .page_tagline, #page_caption.hasbg .page_tagline',
                'function' => 'css',
                'property' => 'font-style',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 7,
    );
    //End Header Tab Settings
    
    //Register Sidebar Tab Settings
     $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_sidebar_sticky',
        'label'    => esc_html__('Enable Sticky Sidebar', 'photography' ),
        'description' => esc_html__('Check this to displays sidebar fixed when scrolling.', 'photography' ),
        'section'  => 'sidebar_general',
        'default'  => 0,
	    'priority' => 11,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_widget_title_typography',
        'label'    => esc_html__('Widget Title Typography', 'photography' ),
        'section'  => 'sidebar_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '20px',
            'line-height'    => '1.8',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle, h5.related_post, .fullwidth_comment_wrapper h5.comment_header, .author_label, #respond h3, .about_author, .related.products h2, .cart_totals h2, .shipping_calcuLator h2, .upsells.products h2, .cross-sells h2, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .sidebar .content .sidebar_widget li.widget_block h2',
            ),
        ),
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_sidebar_title_font_alignment',
        'label'    => esc_html__('Widget Title Alignment', 'photography' ),
        'description' => esc_html__('Select alignment for widget title', 'photography' ),
        'section'  => 'sidebar_typography',
        'default'  => 'center',
        'choices'  => $tg_text_alignment,
        'output' => array(
	        array(
	            'element'  => '#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle, #page_content_wrapper .sidebar .content .sidebar_widget li.widget_archive, .page_content_wrapper .sidebar .content .sidebar_widget li.widget_archive, #page_content_wrapper .sidebar .content .sidebar_widget li.widget_categories, .page_content_wrapper .sidebar .content .sidebar_widget, #page_content_wrapper .sidebar .content .sidebar_widget li.widget_product_categories, .page_content_wrapper .sidebar .content .sidebar_widget li.widget_product_categories',
	            'property' => 'text-align',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle, #page_content_wrapper .sidebar .content .sidebar_widget li.widget_archive, .page_content_wrapper .sidebar .content .sidebar_widget li.widget_archive, #page_content_wrapper .sidebar .content .sidebar_widget li.widget_categories, .page_content_wrapper .sidebar .content .sidebar_widget, #page_content_wrapper .sidebar .content .sidebar_widget li.widget_product_categories, .page_content_wrapper .sidebar .content .sidebar_widget li.widget_product_categories',
				'function' => 'css',
				'property' => 'text-align',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_sidebar_title_border',
        'label'    => esc_html__('Enable Sidebar Title Border Box', 'photography' ),
        'section'  => 'sidebar_typography',
        'default'  => 1,
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_sidebar_font_color',
        'label'    => esc_html__('Sidebar Font Color', 'photography' ),
        'section'  => 'sidebar_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#page_content_wrapper .inner .sidebar_wrapper .sidebar .content, .page_content_wrapper .inner .sidebar_wrapper .sidebar .content',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_sidebar_link_color',
        'label'    => esc_html__('Sidebar Link Color', 'photography' ),
        'section'  => 'sidebar_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#page_content_wrapper .inner .sidebar_wrapper a, .page_content_wrapper .inner .sidebar_wrapper a',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_sidebar_hover_link_color',
        'label'    => esc_html__('Sidebar Hover Link Color', 'photography' ),
        'section'  => 'sidebar_color',
        'default'  => '#999999',
        'output' => array(
	        array(
	            'element'  => '#page_content_wrapper .inner .sidebar_wrapper a:hover, #page_content_wrapper .inner .sidebar_wrapper a:active, .page_content_wrapper .inner .sidebar_wrapper a:hover, .page_content_wrapper .inner .sidebar_wrapper a:active',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_sidebar_title_color',
        'label'    => esc_html__('Sidebar Widget Title Font Color', 'photography' ),
        'section'  => 'sidebar_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 9,
    );
    //End Sidebar Tab Settings
    
    //Register Footer Tab Settings
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'photography_footer_content_title',
        'label'    => esc_html__('Footer Content Settings', 'photography' ),
        'section'  => 'footer_general',
        'priority' => 0,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'photography_footer_content',
        'label'    => esc_html__('Display Footer Content From', 'photography' ),
        'description' => esc_html__('Select how theme get main footer content', 'photography' ),
        'section'  => 'footer_general',
        'default'  => 'sidebar',
        'choices'  => $photography_footer_content,
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'photography_footer_content_default',
        'label'    => esc_html__('Default Footer Content', 'photography' ),
        'description' => esc_html__('Select default footer content for general pages & posts', 'photography' ),
        'section'  => 'footer_general',
        'default'  => '',
        'choices'  => $photography_footers_select,
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'photography_footer_default_title',
        'label'    => esc_html__('Footer Sidebar Settings', 'photography' ),
        'section'  => 'footer_general',
        'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_footer_sidebar',
        'label'    => esc_html__('Footer Sidebar Columns', 'photography' ),
        'section'  => 'footer_general',
        'default'  => '',
        'choices'  => $tg_copyright_column,
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_footer_sidebar_padding_top',
        'label'    => esc_html__('Footer Sidebar Padding Top', 'photography' ),
        'section'  => 'footer_general',
        'default'  => 50,
        'choices' => array( 'min' => 0, 'max' => 200, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => '#footer',
	            'property' => 'padding-top',
	            'units'    => 'px',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#footer',
				'function' => 'css',
				'property' => 'padding-top',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_footer_sidebar_padding_bottom',
        'label'    => esc_html__('Footer Sidebar Padding Bottom', 'photography' ),
        'section'  => 'footer_general',
        'default'  => 50,
        'choices' => array( 'min' => 0, 'max' => 200, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => '#footer',
	            'property' => 'padding-bottom',
	            'units'    => 'px',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#footer',
				'function' => 'css',
				'property' => 'padding-bottom',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_footer_social_link',
        'label'    => esc_html__('Open Footer Social Icons link in new window', 'photography' ),
        'description' => esc_html__('Check this to open footer social icons link in new window', 'photography' ),
        'section'  => 'footer_general',
        'default'  => 1,
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_footer_sidebar_color_title',
        'label'    => esc_html__('Footer Sidebar Color Settings', 'photography' ),
        'section'  => 'footer_color',
	    'priority' => 0,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_bg',
        'label'    	=> esc_html__('Footer Background', 'photography' ),
        'section'  	=> 'footer_color',
	    'default' 	=> '#ffffff',
	    'output' => array(
	        array(
	            'element'  => '.footer_bar',
	            'property' => 'background-color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.footer_bar',
				'function' => 'css',
				'property' => 'background-color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_font_color',
        'label'    => esc_html__('Footer Font Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#footer',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 10,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_link_color',
        'label'    => esc_html__('Footer Link Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#footer a, #footer a:active',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 11,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_hover_link_color',
        'label'    => esc_html__('Footer Hover Link Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#footer a:hover',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 12,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_border_color',
        'label'    => esc_html__('Footer Border Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '.footer_bar, .footer_bar_wrapper',
	            'property' => 'border-color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.footer_bar, .footer_bar_wrapper',
				'function' => 'css',
				'property' => 'border-color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 13,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_footer_copyright_color_title',
        'label'    => esc_html__('Copyright Color Settings', 'photography' ),
        'section'  => 'footer_color',
	    'priority' => 14,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_copyright_bg_color',
        'label'    => esc_html__('Copyright Background Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#ffffff',
        'output' => array(
	        array(
	            'element'  => '.footer_bar_wrapper',
	            'property' => 'background',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.footer_bar_wrapper',
				'function' => 'css',
				'property' => 'background',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 15,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_copyright_font_color',
        'label'    => esc_html__('Copyright Font Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#copyright',
	            'property' => 'color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#copyright',
				'function' => 'css',
				'property' => 'color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 15,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_copyright_link_color',
        'label'    => esc_html__('Copyright Link Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#copyright a, #copyright a:active, #footer_menu li a, .footer_bar_wrapper .social_wrapper ul li a',
	            'property' => 'color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#copyright a, #copyright a:active, #footer_menu li a, .footer_bar_wrapper .social_wrapper ul li a',
				'function' => 'css',
				'property' => 'color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 16,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_copyright_hover_link_color',
        'label'    => esc_html__('Copyright Hover Link Color', 'photography' ),
        'section'  => 'footer_color',
        'default'  => '#222222',
        'output' => array(
	        array(
	            'element'  => '#copyright a:hover, .social_wrapper ul li a:hover, #footer_menu li a:hover',
	            'property' => 'color',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '#copyright a:hover, .social_wrapper ul li a:hover, #footer_menu li a:hover',
				'function' => 'css',
				'property' => 'color',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 17,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_footer_copyright_title',
        'label'    => esc_html__('Copyright Content Settings', 'photography' ),
        'section'  => 'footer_copyright',
        'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'textarea',
        'settings'  => 'tg_footer_copyright_text',
        'label'    => esc_html__('Copyright Text', 'photography' ),
        'description' => esc_html__('Enter your copyright text.', 'photography' ),
        'section'  => 'footer_copyright',
        'default'  => '© Copyright Photography Theme Demo - Theme by ThemeGoods',
        'transport' 	 => 'postMessage',
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_footer_copyright_typography',
        'label'    => esc_html__('Copyright Typography', 'photography' ),
        'section'  => 'footer_copyright',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '400',
            'font-size'      => '14px',
            'line-height'    => '1.8',
            'letter-spacing' => '0px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '#copyright, #footer_menu li a',
            ),
        ),
        'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_footer_copyright_right_area',
        'label'    => esc_html__('Copyright Right Area Content', 'photography' ),
        'section'  => 'footer_copyright',
        'default'  => 'social',
        'choices'  => $tg_copyright_content,
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_footer_copyright_totop_title',
        'label'    => esc_html__('Go To Top Settings', 'photography' ),
        'section'  => 'footer_copyright',
        'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_footer_copyright_totop',
        'label'    => esc_html__('Go To Top Button', 'photography' ),
        'description' => 'Check this option to enable go to top button at the bottom of page when scrolling',
        'section'  => 'footer_copyright',
        'default'  => 1,
	    'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_copyright_totop_bg',
        'label'    => esc_html__('Go To Top Button Background', 'photography' ),
        'section'  => 'footer_copyright',
        'priority' => 10,
        'default'  => 'rgba(0,0,0,0.1)',
        'output' => array(
            array(
                'element'  => 'a#toTop',
                'property' => 'background',
            ),
        ),
        'js_vars'   => array(
            array(
                'element'  => 'a#toTop',
                'function' => 'css',
                'property' => 'background',
            ),
        ),
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_footer_copyright_totop_font_color',
        'label'    => esc_html__('Go To Top Button Font Color', 'photography' ),
        'section'  => 'footer_copyright',
        'default'  => '#ffffff',
        'output' => array(
            array(
                'element'  => 'a#toTop',
                'property' => 'color',
            ),
        ),
        'transport' 	 => 'postMessage',
        'priority' => 10,
        'js_vars'   => array(
            array(
                'element'  => 'a#toTop',
                'function' => 'css',
                'property' => 'color',
            ),
        ),
    );
    //End Footer Tab Settings
    
    
    //Begin Gallery Tab Settings
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_gallery_general_title',
        'label'    => esc_html__('General Settings', 'photography' ),
        'section'  => 'gallery_general',
	    'priority' => 0,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_gallery_sort',
        'label'    => esc_html__('Gallery Images Sorting', 'photography' ),
        'description' => 'Select global gallery images sorting options',
        'section'  => 'gallery_general',
        'default'  => 'drag',
        'choices'  => $tg_gallery_sort,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_gallery_hover_effect',
        'label'    => esc_html__('Gallery Thumbnails Hover Effect', 'photography' ),
        'description' => 'Select global gallery columns layout\'s thumbnails hover effect',
        'section'  => 'gallery_general',
        'default'  => 'kenburns',
        'choices'  => $tg_hover_effect,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_gallery_feat_content',
        'label'    => esc_html__('Display Gallery Featured Image as Header', 'photography' ),
        'description' => esc_html__('Check this to display featured image as background header in single gallery page', 'photography' ),
        'section'  => 'gallery_general',
        'default'  => 0,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_gallery_proofing_title',
        'label'    => esc_html__('Gallery Proofing Settings', 'photography' ),
        'section'  => 'gallery_general',
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_gallery_proofing_info',
        'label'    => esc_html__('Gallery Proofing Display Info', 'photography' ),
        'description' => 'Select option to display image information for photo proofing pages',
        'section'  => 'gallery_general',
        'default'  => 'wordpress_id',
        'choices'  => array(
        	'wordpress_id' 	=> 'WordPress Media ID',
        	'filename'		=> 'File Name',
        	'title'		=> 'Image Title',
        ),
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_gallery_proofing_download',
        'label'    => esc_html__('Enable download option for gallery proofing', 'photography' ),
        'description' => esc_html__('Check this to enable download image option in gallery proofing page', 'photography' ),
        'section'  => 'gallery_general',
        'default'  => 1,
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_gallery_proofing_columns',
        'label'    => esc_html__('Gallery Proofing Layout', 'photography' ),
        'description' => 'Select layout columns option for photo proofing pages',
        'section'  => 'gallery_general',
        'default'  => '3',
        'choices'  => array(
        	'2'			=> '2 Columns Contained',
        	'3'			=> '3 Columns Contained',
        	'4'			=> '4 Columns Contained',
        	'2_wide'	=> '2 Columns Wide',
        	'3_wide'	=> '3 Columns Wide',
        	'4_wide'	=> '4 Columns Wide',
        ),
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_gallery_client_title',
        'label'    => esc_html__('Client Gallery Settings', 'photography' ),
        'section'  => 'gallery_general',
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_gallery_client_columns',
        'label'    => esc_html__('Client Gallery Layout', 'photography' ),
        'description' => 'Select layout columns option for client gallery pages',
        'section'  => 'gallery_general',
        'default'  => '3',
        'choices'  => array(
        	'2'			=> '2 Columns Contained',
        	'3'			=> '3 Columns Contained',
        	'4'			=> '4 Columns Contained',
        	'2_wide'	=> '2 Columns Wide',
        	'3_wide'	=> '3 Columns Wide',
        	'4_wide'	=> '4 Columns Wide',
        ),
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_gallery_title_typography',
        'label'    => esc_html__('Gallery Title Typography', 'grandrestaurant' ),
        'section'  => 'gallery_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => 'regular',
            'font-size'      => '12px',
            'line-height'    => '1.8',
            'letter-spacing' => '0px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '.gallery_archive_desc h4, #fullpage .section.gallery_archive.center_display .gallery_archive_desc h2',
            ),
        ),
        'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_lightbox_general_title',
        'label'    => esc_html__('General Settings', 'photography' ),
        'section'  => 'gallery_lightbox',
	    'priority' => 0,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_lightbox_enable',
        'label'    => esc_html__('Enable theme lightbox', 'photography' ),
        'description' => esc_html__('Check if you want to enable theme default lightbox for gallery images', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 1,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_lightbox_plugin',
        'label'    => esc_html__('Lightbox Plugin', 'photography' ),
        'description' => 'Select theme\'s lightbox plugin you want to use',
        'section'  => 'gallery_lightbox',
        'default'  => 'modulobox',
        'choices'  => array(
        	'ilightbox'	=> 'iLightbox',
        	'modulobox'	=> 'ModuloBox',
        ),
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_lightbox_skin',
        'label'    => esc_html__('Select lightbox skin color', 'photography' ),
        'description' => esc_html__('Select which skin you want to use for lightbox', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 'metro-white',
        'choices'  => $tg_lightbox_skin,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_lightbox_enable_caption',
        'label'    => esc_html__('Display image caption in lightbox', 'photography' ),
        'description' => esc_html__('Check if you want to display image caption under the image in lightbox mode', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 1,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_lightbox_enable_horizontal_gallery',
        'label'    => esc_html__('Enable image lightbox in horizontal gallery template', 'photography' ),
        'description' => esc_html__('Check if you want to display image caption under the image in lightbox mode', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 1,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_lightbox_opacity',
        'label'    => esc_html__('Lightbox Overlay Opacity', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 95,
        'choices' => array( 'min' => 0, 'max' => 100, 'step' => 5 ),
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_lightbox_timer',
        'label'    => esc_html__('Lightbox slideshow timer', 'photography' ),
        'description' => esc_html__('Select number of seconds for lightbox slideshow timer', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 7,
        'choices' => array( 'min' => 1, 'max' => 20, 'step' => 1 ),
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_ilightbox_title',
        'label'    => esc_html__('iLightbox Plugin Settings', 'photography' ),
        'section'  => 'gallery_lightbox',
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_lightbox_thumbnails',
        'label'    => esc_html__('Select iLightbox thumbnails alignment', 'photography' ),
        'description' => esc_html__('Select which alignment you want to use for iLightbox thumbnails', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 'horizontal',
        'choices'  => $tg_lightbox_thumbnails,
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_modulobox_title',
        'label'    => esc_html__('ModuloBox Plugin Settings', 'photography' ),
        'section'  => 'gallery_lightbox',
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_modulobox_thumbnails',
        'label'    => esc_html__('Select ModuloBox thumbnails', 'photography' ),
        'description' => esc_html__('Select if you want to display ModuloBox thumbnails', 'photography' ),
        'section'  => 'gallery_lightbox',
        'default'  => 'thumbnail',
        'choices'  => $tg_modulo_thumbnails,
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_gallery_archive_info_style',
        'label'    => esc_html__('Gallery Archive Title Style', 'photography' ),
        'description' => 'Select gallery title style for gallery archive pages',
        'section'  => 'gallery_archive',
        'default'  => 'hover_display',
        'choices'  => array(
        	'hover_display'			=> 'Display Gallery Name When Hover',
        	'center_display'		=> 'Display Gallery Name Center',
        ),
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_gallery_hover_slide',
        'label'    => esc_html__('Enable slideshow on hover effect', 'photography' ),
        'description' => esc_html__('Check this option to enable slideshow effect when move mouse over gallery thumbnail', 'photography' ),
        'section'  => 'gallery_archive',
        'default'  => 1,
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_full_autoplay',
        'label'    => esc_html__('Enable autoplay slideshow', 'photography' ),
        'description' => esc_html__('Check this option to let fullscreen slideshow starts playing automatically', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 1,
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_full_random',
        'label'    => esc_html__('Enable random slideshow', 'photography' ),
        'description' => esc_html__('Check this option to let fullscreen slideshow displays images randomly', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 0,
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_full_slideshow_timer',
        'label'    => esc_html__('Slideshow Timer', 'photography' ),
        'description' => esc_html__('Select number of seconds for Full Screen Slideshow timer', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 9,
        'choices' => array( 'min' => 1, 'max' => 20, 'step' => 1 ),
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_full_slideshow_trans',
        'label'    => esc_html__('Slideshow Transition Effect', 'photography' ),
        'description' => esc_html__('Select transition type for contents in Full Screen slideshow', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => '1',
        'choices'  => $tg_slideshow_trans,
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_full_slideshow_trans_speed',
        'label'    => esc_html__('Slideshow Transition Timer', 'photography' ),
        'description' => esc_html__('Select number of milliseconds for transition between each image', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 800,
        'choices' => array( 'min' => 100, 'max' => 10000, 'step' => 100 ),
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_full_image_caption',
        'label'    => esc_html__('Display slideshow image info', 'photography' ),
        'description' => esc_html__('Check this option if you want to display fullscreen slideshow image information', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 1,
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_full_image_caption_style',
        'label'    => esc_html__('Image info display options', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 'caption',
        'choices'  => array(
        	'caption'	=> 'Image Caption Only',
        	'caption_alt'	=> 'Image Caption + Alternative Text',
        ),
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_full_nocover',
        'label'    => esc_html__('Display image proportion size', 'photography' ),
        'description' => esc_html__('Check this option if you want to display slide image proportion size without covering screen', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 0,
	    'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_full_arrow',
        'label'    => esc_html__('Display slideshow arrows', 'photography' ),
        'description' => esc_html__('Check this option if you want to display slide navigation arrow', 'photography' ),
        'section'  => 'gallery_fullscreen',
        'default'  => 0,
	    'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_kenburns_timer',
        'label'    => esc_html__('Kenburns Slideshow timer', 'photography' ),
        'description' => esc_html__('Select number of seconds for Kenburns Slideshow timer', 'photography' ),
        'section'  => 'gallery_kenburns',
        'default'  => 7,
        'choices' => array( 'min' => 1, 'max' => 20, 'step' => 1 ),
	    'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_kenburns_zoom',
        'label'    => esc_html__('Kenburns Zoom Level', 'photography' ),
        'description' => esc_html__('Select zoom level for Kenburns slideshow', 'photography' ),
        'section'  => 'gallery_kenburns',
        'default'  => 2,
        'choices' => array( 'min' => 1, 'max' => 10, 'step' => 1 ),
	    'priority' => 9,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_kenburns_trans',
        'label'    => esc_html__('Kenburns Transition Timer', 'photography' ),
        'description' => esc_html__('Select number of seconds for transition between each image', 'photography' ),
        'section'  => 'gallery_kenburns',
        'default'  => 1000,
        'choices' => array( 'min' => 100, 'max' => 1000, 'step' => 100),
	    'priority' => 10,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_flow_enable_reflection',
        'label'    => esc_html__('Display Image Reflection', 'photography' ),
        'description' => esc_html__('Check this option if you want to display mirror reflection effect in flow gallery', 'photography' ),
        'section'  => 'gallery_flow',
        'default'  => 0,
	    'priority' => 11,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_flow_enable_lightbox',
        'label'    => esc_html__('Link flow gallery image to lightbox', 'photography' ),
        'description' => esc_html__('Check this option if you want to link flow gallery to full size image in lightbox mode', 'photography' ),
        'section'  => 'gallery_flow',
        'default'  => 1,
	    'priority' => 12,
    );
    
    //End Gallery Tab Settings
    
    
    //Begin Portfolio Tab Settings
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_portfolio_filterable',
        'label'    => esc_html__('Enable Portfolio Filterable Feature', 'photography' ),
        'description' => esc_html__('Check this option to enable filterable feature in portfolio pages', 'photography' ),
        'section'  => 'portfolio_filterable',
        'default'  => 1,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_portfolio_filterable_link',
        'label'    => esc_html__('Link Portfolio Filterable', 'photography' ),
        'description' => esc_html__('Check this option to enable linking filterable to its page.', 'photography' ),
        'section'  => 'portfolio_filterable',
        'default'  => 0,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_portfolio_filterable_sort',
        'label'    => esc_html__('Portfolio Filterable Options Sorting', 'photography' ),
        'section'  => 'portfolio_filterable',
        'default'  => 'name',
        'choices'  => $tg_portfolio_filterable_sort,
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_portfolio_hover_effect',
        'label'    => esc_html__('Portfolio Thumbnails Hover Effect', 'photography' ),
        'description' => 'Select global portfolio columns layout\'s thumbnails hover effect',
        'section'  => 'portfolio_page',
        'default'  => 'kenburns',
        'choices'  => $tg_hover_effect,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_portfolio_items',
        'label'    => esc_html__('Portfolio Page Show At Most', 'photography' ),
        'description' => esc_html__('Select number of portfolio items you want to display per page', 'photography' ),
        'section'  => 'portfolio_page',
        'default'  => 24,
        'choices' => array( 'min' => 1, 'max' => 50, 'step' => 1 ),
	    'priority' => 4,
    );
    
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_portfolio_title_font_weight',
        'label'    => esc_html__('Portfolio Title Font Weight', 'photography' ),
        'section'  => 'portfolio_typography',
        'default'  => 400,
        'choices' => array( 'min' => 100, 'max' => 900, 'step' => 100 ),
        'output' => array(
	        array(
	            'element'  => '.two_cols.gallery .element .portfolio_title h5, .three_cols.gallery .element .portfolio_title h5, .four_cols.gallery .element .center_display .portfolio_title .table .cell h5, .five_cols.gallery .element .center_display .portfolio_title .table .cell h5, .portfolio_desc.portfolio2 h5, .portfolio_desc.portfolio3 h5, .portfolio_desc.portfolio4 h5, #fullpage .section.gallery_archive.center_display.fullpage_portfolio .gallery_archive_desc h2',
	            'property' => 'font-weight',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.two_cols.gallery .element .portfolio_title h5, .three_cols.gallery .element .portfolio_title h5, .four_cols.gallery .element .center_display .portfolio_title .table .cell h5, .five_cols.gallery .element .center_display .portfolio_title .table .cell h5, .portfolio_desc.portfolio2 h5, .portfolio_desc.portfolio3 h5, .portfolio_desc.portfolio4 h5, #fullpage .section.gallery_archive.center_display.fullpage_portfolio .gallery_archive_desc h2',
				'function' => 'css',
				'property' => 'font-weight',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_portfolio_title_font_spacing',
        'label'    => esc_html__('Portfolio Title Font Spacing', 'photography' ),
        'section'  => 'portfolio_typography',
        'default'  => 1,
        'choices' => array( 'min' => -2, 'max' => 5, 'step' => 1 ),
        'output' => array(
	        array(
	            'element'  => '.two_cols.gallery .element .portfolio_title h5, .three_cols.gallery .element .portfolio_title h5, .four_cols.gallery .element .center_display .portfolio_title .table .cell h5, .five_cols.gallery .element .center_display .portfolio_title .table .cell h5, .portfolio_desc.portfolio2 h5, .portfolio_desc.portfolio3 h5, .portfolio_desc.portfolio4 h5, #fullpage .section.gallery_archive.center_display.fullpage_portfolio .gallery_archive_desc h2',
	            'property' => 'letter-spacing',
	            'units'    => 'px',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.two_cols.gallery .element .portfolio_title h5, .three_cols.gallery .element .portfolio_title h5, .four_cols.gallery .element .center_display .portfolio_title .table .cell h5, .five_cols.gallery .element .center_display .portfolio_title .table .cell h5, .portfolio_desc.portfolio2 h5, .portfolio_desc.portfolio3 h5, .portfolio_desc.portfolio4 h5, #fullpage .section.gallery_archive.center_display.fullpage_portfolio .gallery_archive_desc h2',
				'function' => 'css',
				'property' => 'letter-spacing',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_portfolio_title_font_transform',
        'label'    => esc_html__('Portfolio Title Font Text Transform', 'photography' ),
        'section'  => 'portfolio_typography',
        'default'  => 'none',
        'choices'  => $tg_text_transform,
        'output' => array(
	        array(
	            'element'  => '.two_cols.gallery .element .portfolio_title h5, .three_cols.gallery .element .portfolio_title h5, .four_cols.gallery .element .center_display .portfolio_title .table .cell h5, .five_cols.gallery .element .center_display .portfolio_title .table .cell h5, .portfolio_desc.portfolio2 h5, .portfolio_desc.portfolio3 h5, .portfolio_desc.portfolio4 h5, #fullpage .section.gallery_archive.center_display.fullpage_portfolio .gallery_archive_desc h2',
	            'property' => 'text-transform',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.two_cols.gallery .element .portfolio_title h5, .three_cols.gallery .element .portfolio_title h5, .four_cols.gallery .element .center_display .portfolio_title .table .cell h5, .five_cols.gallery .element .center_display .portfolio_title .table .cell h5, .portfolio_desc.portfolio2 h5, .portfolio_desc.portfolio3 h5, .portfolio_desc.portfolio4 h5, #fullpage .section.gallery_archive.center_display.fullpage_portfolio .gallery_archive_desc h2',
				'function' => 'css',
				'property' => 'text-transform',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_portfolio_grid_info_style',
        'label'    => esc_html__('Portfolio Grid Title Style', 'photography' ),
        'description' => 'Select portfolio title style for portfolio grid pages',
        'section'  => 'portfolio_page',
        'default'  => 'hover_display',
        'choices'  => array(
        	'hover_display'			=> 'Display Gallery Name When Hover',
        	'center_display'		=> 'Display Gallery Name Center',
        ),
	    'priority' => 24,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_portfolio_target_blank',
        'label'    => esc_html__('Open Portfolio External link to the new window', 'photography' ),
        'description' => esc_html__('Check this option to open portfolio external link to the new browser window', 'photography' ),
        'section'  => 'portfolio_page',
        'default'  => 1,
        'priority' => 25,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_portfolio_next_prev',
        'label'    => esc_html__('Display Next and Previous Portfolios', 'photography' ),
        'description' => esc_html__('Check this option to display next and previous portfolios in single portfolio page', 'photography' ),
        'section'  => 'portfolio_single',
        'default'  => 0,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_portfolio_recent',
        'label'    => esc_html__('Display Recent Portfolios', 'photography' ),
        'description' => esc_html__('Check this option to display recent portfolios in single portfolio page', 'photography' ),
        'section'  => 'portfolio_single',
        'default'  => 1,
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_portfolio_recent_random',
        'label'    => esc_html__('Randomly Select Recent Portfolios', 'photography' ),
        'description' => esc_html__('Check this option to sort recent portfolios by random', 'photography' ),
        'section'  => 'portfolio_single',
        'default'  => 0,
        'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'text',
        'settings'  => 'tg_portfolio_url',
        'label'    => esc_html__('Portfolio Page (Optional)', 'photography' ),
        'description' => esc_html__('Enter your portfolio page URL so it displays portfolio page link in recent portfolio module.', 'photography' ),
        'section'  => 'portfolio_single',
        'default'  => '',
	    'priority' => 7,
    );
    //End Portfolio Tab Settings
    
    
    //Begin Blog Tab Settings
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_display_full',
        'label'    => esc_html__('Display Full Blog Post Content on Blog Classic Layouts', 'photography' ),
        'description' => esc_html__('Check this option to display post full content in blog classic pages', 'photography' ),
        'section'  => 'blog_general',
        'default'  => 0,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_grid_display_excerpt',
        'label'    => esc_html__('Display Post Excerpt on Blog Grid Layouts', 'photography' ),
        'description' => esc_html__('Check this option to display post excerpt in blog grid pages', 'photography' ),
        'section'  => 'blog_general',
        'default'  => 1,
	    'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_blog_archive_layout',
        'label'    => esc_html__('Archive Page Layout', 'photography' ),
        'description' => esc_html__('Select page layout for displaying archive page', 'photography' ),
        'section'  => 'blog_general',
        'default'  => 'blog_r',
        'choices'  => $tg_blog_layout,
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_blog_category_layout',
        'label'    => esc_html__('Category Page Layout', 'photography' ),
        'description' => esc_html__('Select page layout for displaying category page', 'photography' ),
        'section'  => 'blog_general',
        'default'  => 'blog_r',
        'choices'  => $tg_blog_layout,
	    'priority' => 2,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_blog_tag_layout',
        'label'    => esc_html__('Tag Page Layout', 'photography' ),
        'description' => esc_html__('Select page layout for displaying tag page', 'photography' ),
        'section'  => 'blog_general',
        'default'  => 'blog_r',
        'choices'  => $tg_blog_layout,
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'color',
        'settings'  => 'tg_blog_cat_font_color',
        'label'    => esc_html__('Post Category Link Font Color', 'photography' ),
        'section'  => 'blog_general',
        'default'  => '#ca9f5c',
        'output' => array(
	        array(
	            'element'  => '.post_info_cat, .post_info_cat a',
	            'property' => 'color',
	        ),
	    ),
	    'transport' 	 => 'postMessage',
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_blog_general_title',
        'label'    => esc_html__('General Post Title Settings', 'photography' ),
        'section'  => 'blog_typography',
	    'priority' => 0,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_blog_title_typography',
        'label'    => esc_html__('Post Title Typography', 'grandrestaurant' ),
        'section'  => 'blog_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'line-height'    => '1.8',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '.post_header h5, .post_button_wrapper, h6.subtitle, .post_caption h1, #page_content_wrapper .posts.blog li a, .page_content_wrapper .posts.blog li a, #post_featured_slider li .slider_image .slide_post h2, .post_header.grid h6, .blog_minimal_wrapper .content h4',
            ),
        ),
        'priority' => 1,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_blog_content_font_alignment',
        'label'    => esc_html__('Post Title Alignment', 'photography' ),
        'description' => esc_html__('Select alignment for blog posts title', 'photography' ),
        'section'  => 'blog_typography',
        'default'  => 'center',
        'choices'  => $tg_text_alignment,
        'output' => array(
	        array(
	            'element'  => '.post_header h5, .post_button_wrapper, h6.subtitle, .post_caption, #page_content_wrapper .posts.blog li a, .page_content_wrapper .posts.blog li a, .post_header_title, #respond h3, #respond .comment-notes, .post_header.grid',
	            'property' => 'text-align',
	        ),
	    ),
	    'js_vars'   => array(
			array(
				'element'  => '.post_header h5, .post_button_wrapper, h6.subtitle, .post_caption, #page_content_wrapper .posts.blog li a, .page_content_wrapper .posts.blog li a, .post_header_title, #respond h3, #respond .comment-notes, .post_header.grid',
				'function' => 'css',
				'property' => 'text-align',
			),
		),
	    'transport' 	 => 'postMessage',
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'title',
        'settings'  => 'tg_blog_single_post_title',
        'label'    => esc_html__('Single Post Title Settings', 'photography' ),
        'section'  => 'blog_typography',
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'typography',
        'settings'  => 'tg_blog_single_post_title_typography',
        'label'    => esc_html__('Single Post Title Typography', 'grandrestaurant' ),
        'section'  => 'blog_typography',
        'default'  => array(
            'font-family'    => 'Montserrat',
            'variant'        => '600',
            'font-size'      => '34px',
            'line-height'    => '1.6',
            'letter-spacing' => '-1px',
            'text-transform' => 'none',
        ),
        'output' => array(
            array(
                'element'  => '.post_caption h1',
            ),
        ),
        'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_slider',
        'label'    => esc_html__('Display Slider', 'photography' ),
        'description' => esc_html__('Check this option to display slider in blog pages', 'photography' ),
        'section'  => 'blog_slider',
        'default'  => 1,
	    'priority' => 3,
    );
    
    $controls[] = array(
        'type'     => 'radio',
        'settings'  => 'tg_blog_slider_layout',
        'label'    => esc_html__('Slider Layout', 'photography' ),
        'description' => esc_html__('Select layout for slider posts', 'photography' ),
        'section'  => 'blog_slider',
        'default'  => '3cols-slider',
        'choices'  => $tg_slider_layout,
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_blog_slider_cat',
        'label'    => esc_html__('Slider Post Category', 'photography' ),
        'description' => esc_html__('Select post category filter for slider posts', 'photography' ),
        'section'  => 'blog_slider',
        'default'  => '',
        'choices'  => $tg_categories_select,
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'slider',
        'settings'  => 'tg_blog_slider_items',
        'label'    => esc_html__('Slider Post Items', 'photography' ),
        'section'  => 'blog_slider',
        'default'  => 5,
        'choices' => array( 'min' => 1, 'max' => 30, 'step' => 1 ),
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_header_bg',
        'label'    => esc_html__('Display Post Header', 'photography' ),
        'description' => esc_html__('Check this to display featured image as post header background', 'photography' ),
        'section'  => 'blog_single',
        'default'  => 1,
	    'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_title_in_content',
        'label'    => esc_html__('Display Post Title in Content', 'photography' ),
        'description' => esc_html__('Check this to display post title within post content area', 'photography' ),
        'section'  => 'blog_single',
        'default'  => 0,
        'priority' => 4,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_feat_content',
        'label'    => esc_html__('Display Post Featured Content', 'photography' ),
        'description' => esc_html__('Check this to display featured content (image or gallery) in single post page', 'photography' ),
        'section'  => 'blog_single',
        'default'  => 0,
	    'priority' => 5,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_display_tags',
        'label'    => esc_html__('Display Post Tags', 'photography' ),
        'description' => esc_html__('Check this option to display post tags on single post page', 'photography' ),
        'section'  => 'blog_single',
        'default'  => 0,
	    'priority' => 6,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_display_author',
        'label'    => esc_html__('Display About Author', 'photography' ),
        'description' => esc_html__('Check this option to display about author on single post page', 'photography' ),
        'section'  => 'blog_single',
        'default'  => 1,
	    'priority' => 7,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_display_related',
        'label'    => esc_html__('Display Related Posts', 'photography' ),
        'description' => esc_html__('Check this option to display related posts on single post page', 'photography' ),
        'section'  => 'blog_single',
        'default'  => 1,
	    'priority' => 8,
    );
    
    $controls[] = array(
        'type'     => 'toggle',
        'settings'  => 'tg_blog_content_sharing',
        'label'    => esc_html__('Display Sharing Buttons on Single Post Page Content', 'photography' ),
        'description' => esc_html__('Check this to display sharing buttons on single post page content', 'photography' ),
        'section'  => 'blog_single',
        'default'  => 0,
	    'priority' => 9,
    );
    //End Blog Tab Settings
    
    $controls[] = array(
        'type'     => 'select',
        'settings'  => 'tg_pages_template_404',
        'label'    => esc_html__('Default 404 Page', 'photography' ),
        'description' => esc_html__('Select a page template for 404 not found page', 'photography' ),
        'section'  => 'pages_templates',
        'default'  => '',
        'choices'  => photography_get_published_pages(),
        'priority' => 1,
    );
    
    //Check if Woocommerce is installed	
	if(class_exists('Woocommerce'))
	{
		//Begin Shop Tab Settings
		$controls[] = array(
	        'type'     => 'radio',
	        'settings'  => 'tg_shop_layout',
	        'label'    => esc_html__('Shop Main Page Layout', 'photography' ),
	        'description' => esc_html__('Select page layout for displaying shop\'s products page', 'photography' ),
	        'section'  => 'shop_layout',
	        'default'  => 'fullwidth',
	        'choices'  => $tg_shop_layout,
		    'priority' => 1,
	    );
        
        $controls[] = array(
            'type'     => 'radio',
            'settings'  => 'tg_shop_columns',
            'label'    => esc_html__('Shop Layout Columns', 'photography' ),
            'section'  => 'shop_layout',
            'default'  => '3',
            'choices'  => $tg_shop_column,
            'priority' => 2,
        );
        
        $controls[] = array(
            'type'     => 'toggle',
            'settings'  => 'tg_shop_product_image_swap',
            'label'    => esc_html__('Image Swap', 'photography' ),
            'description' => esc_html__('Check this option to display product gallery image when move mouse over product thumbnail', 'photography' ),
            'section'  => 'shop_layout',
            'default'  => 1,
            'priority' => 2,
        );
        
        $controls[] = array(
            'type'     => 'toggle',
            'settings'  => 'tg_shop_product_add_cart',
            'label'    => esc_html__('Display Add to Cart', 'photography' ),
            'description' => esc_html__('Check this option to display Add to Cart button', 'photography' ),
            'section'  => 'shop_layout',
            'default'  => 1,
            'priority' => 3,
        );
	    
	    $controls[] = array(
	        'type'     => 'slider',
	        'settings'  => 'tg_shop_items',
	        'label'    => esc_html__('Products Page Show At Most', 'photography' ),
	        'description' => esc_html__('Select number of product items you want to display per page', 'photography' ),
	        'section'  => 'shop_layout',
	        'default'  => 15,
	        'choices' => array( 'min' => 1, 'max' => 100, 'step' => 1 ),
		    'priority' => 4,
	    );
        
        $controls[] = array(
            'type'     => 'typography',
            'settings'  => 'tg_product_title_typography',
            'label'    => esc_html__('Widget Title Typography', 'grandrestaurant' ),
            'section'  => 'shop_typography',
            'default'  => array(
                'font-family'    => 'Montserrat',
                'variant'        => '600',
                'font-size'      => '30px',
                'line-height'    => '1.8',
                'letter-spacing' => '-1px',
                'text-transform' => 'none',
            ),
            'output' => array(
                array(
                    'element'  => '.woocommerce ul.products li.product h2.woocommerce-loop-product__title, .woocommerce-page ul.products li.product h2.woocommerce-loop-product__title, .woocommerce div.product .product_title',
                ),
            ),
            'priority' => 3,
        );
	    
	    $controls[] = array(
	        'type'     => 'color',
	        'settings'  => 'tg_shop_price_font_color',
	        'label'    => esc_html__('Product Price Font Color', 'photography' ),
	        'section'  => 'shop_single',
	        'default'  => '#222222',
	        'output' => array(
		        array(
		            'element'  => '.woocommerce ul.products li.product .price ins, .woocommerce-page ul.products li.product .price ins, .woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price, p.price ins span.amount, p.price span.amount, .woocommerce #content div.product p.price, .woocommerce #content div.product span.price, .woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce-page #content div.product p.price, .woocommerce-page #content div.product span.price, .woocommerce-page div.product p.price, .woocommerce-page div.product span.price',
		            'property' => 'color',
		        ),
		    ),
		    'transport' 	 => 'postMessage',
		    'priority' => 2,
	    );
	    
	    $controls[] = array(
	        'type'     => 'toggle',
	        'settings'  => 'tg_shop_related_products',
	        'label'    => esc_html__('Display Related Products', 'photography' ),
	        'description' => esc_html__('Check this option to display related products on single product page', 'photography' ),
	        'section'  => 'shop_single',
	        'default'  => 1,
		    'priority' => 3,
	    );
		//End Shop Tab Settings
	}

    return $controls;
}
add_filter( 'kirki/controls', 'photography_custom_setting' );


function photography_customize_preview()
{
?>
    <script type="text/javascript">
        ( function( $ ) {
        	//Register Logo Tab Settings
        	wp.customize('tg_retina_logo',function( value ) {
                value.bind(function(to) {
                    jQuery('#custom_logo img').attr('src', to );
                });
            });
        	//End Logo Tab Settings
        
			//Register General Tab Settings
            wp.customize('tg_body_font',function( value ) {
                value.bind(function(to) {
                	var ppGGFont = 'https://fonts.googleapis.com/css?family='+to;
                	if(jQuery('#google_fonts_'+to).length==0)
                	{
			    		jQuery('head').append('<link rel="stylesheet" id="google_fonts_'+to+'" href="'+ppGGFont+'" type="text/css" media="all">');
			    	}
                    jQuery('body, input[type=text], input[type=email], input[type=url], input[type=password], textarea').css('fontFamily', to );
                });
            });
            
            wp.customize('tg_body_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('body').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_header_font',function( value ) {
                value.bind(function(to) {
                	var ppGGFont = 'https://fonts.googleapis.com/css?family='+to;
                	if(jQuery('#google_fonts_'+to).length==0)
                	{
			    		jQuery('head').append('<link rel="stylesheet" id="google_fonts_'+to+'" href="'+ppGGFont+'" type="text/css" media="all">');
			    	}
                    jQuery('h1, h2, h3, h4, h5, h6, h7, blockquote, .post_quote_title, label, strong[itemprop="author"], .post_info_cat, .readmore').css('fontFamily', to );
                });
            });
            
            wp.customize('tg_h1_size',function( value ) {
                value.bind(function(to) {
                    jQuery('h1').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_h2_size',function( value ) {
                value.bind(function(to) {
                    jQuery('h2').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_h3_size',function( value ) {
                value.bind(function(to) {
                    jQuery('h3').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_h4_size',function( value ) {
                value.bind(function(to) {
                    jQuery('h4').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_h5_size',function( value ) {
                value.bind(function(to) {
                    jQuery('h5').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_h6_size',function( value ) {
                value.bind(function(to) {
                    jQuery('h6').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('body, .pagination a, #gallery_lightbox h2, .slider_wrapper .gallery_image_caption h2, .post_info a, #page_content_wrapper.split #copyright, .page_content_wrapper.split #copyright, .ui-state-default a, .ui-state-default a:link, .ui-state-default a:visited').css('color', to );
                    jQuery('::selection').css('background-color', to );
                    jQuery('::-webkit-input-placeholder').css('color', to );
                    jQuery('::-moz-placeholder').css('color', to );
                    jQuery(':-ms-input-placeholder').css('color', to );
                });
            });
            
            wp.customize('tg_hover_link_color',function( value ) {
                value.bind(function(to) {
                    jQuery('a:hover, a:active, .post_info_comment a i').css('color', to );
                });
            });
            
            wp.customize('tg_h1_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('h1, h2, h3, h4, h5, pre, code, tt, blockquote, .post_header h5 a, .post_header h3 a, .post_header.grid h6 a, .post_header.fullwidth h4 a, .post_header h5 a, blockquote, .site_loading_logo_item i, .woocommerce .woocommerce-ordering select, .woocommerce #page_content_wrapper a.button, .woocommerce.columns-4 ul.products li.product a.add_to_cart_button, .woocommerce.columns-4 ul.products li.product a.add_to_cart_button:hover, .tabs .ui-state-active a, body.woocommerce div.product .woocommerce-tabs ul.tabs li.active a, body.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active a, body.woocommerce #content div.product .woocommerce-tabs ul.tabs li.active a, body.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .post_header h5 a, .post_header h6 a').css('color', to );
                    
                    jQuery('body.page.page-template-gallery-archive-split-screen-php #fp-nav li .active span, body.tax-gallerycat #fp-nav li .active span, body.page.page-template-portfolio-fullscreen-split-screen-php #fp-nav li .active span, body.page.tax-portfolioset #fp-nav li .active span, body.page.page-template-gallery-archive-split-screen-php #fp-nav ul li a span, body.tax-gallerycat #fp-nav ul li a span, body.page.page-template-portfolio-fullscreen-split-screen-php #fp-nav ul li a span, body.page.tax-portfolioset #fp-nav ul li a span').css('backgroundColor', to );
                });
            });
            
            wp.customize('tg_hr_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#social_share_wrapper, hr, #social_share_wrapper, .post.type-post, #page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle, .comment .right, .widget_tag_cloud div a, .meta-tags a, .tag_cloud a, #footer, #post_more_wrapper, .woocommerce ul.products li.product, .woocommerce-page ul.products li.product, .woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price, #page_content_wrapper .inner .sidebar_content, #page_content_wrapper .inner .sidebar_content.left_sidebar, .ajax_close, .ajax_next, .ajax_prev, .portfolio_next, .portfolio_prev, .portfolio_next_prev_wrapper.video .portfolio_prev, .portfolio_next_prev_wrapper.video .portfolio_next, .separated, .blog_next_prev_wrapper, #post_more_wrapper h5, #ajax_portfolio_wrapper.hidding, #ajax_portfolio_wrapper.visible, .tabs.vertical .ui-tabs-panel, .ui-tabs.vertical.right .ui-tabs-nav li, .woocommerce div.product .woocommerce-tabs ul.tabs li, .woocommerce #content div.product .woocommerce-tabs ul.tabs li, .woocommerce-page div.product .woocommerce-tabs ul.tabs li, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li, .woocommerce div.product .woocommerce-tabs .panel, .woocommerce-page div.product .woocommerce-tabs .panel, .woocommerce #content div.product .woocommerce-tabs .panel, .woocommerce-page #content div.product .woocommerce-tabs .panel, .woocommerce table.shop_table, .woocommerce-page table.shop_table, table tr td, .woocommerce .cart-collaterals .cart_totals, .woocommerce-page .cart-collaterals .cart_totals, .woocommerce .cart-collaterals .shipping_calculator, .woocommerce-page .cart-collaterals .shipping_calculator, .woocommerce .cart-collaterals .cart_totals tr td, .woocommerce .cart-collaterals .cart_totals tr th, .woocommerce-page .cart-collaterals .cart_totals tr td, .woocommerce-page .cart-collaterals .cart_totals tr th, table tr th, .woocommerce #payment, .woocommerce-page #payment, .woocommerce #payment ul.payment_methods li, .woocommerce-page #payment ul.payment_methods li, .woocommerce #payment div.form-row, .woocommerce-page #payment div.form-row, .ui-tabs li:first-child, .ui-tabs .ui-tabs-nav li, .ui-tabs.vertical .ui-tabs-nav li, .ui-tabs.vertical.right .ui-tabs-nav li.ui-state-active, .ui-tabs.vertical .ui-tabs-nav li:last-child, #page_content_wrapper .inner .sidebar_wrapper ul.sidebar_widget li.widget_nav_menu ul.menu li.current-menu-item a, .page_content_wrapper .inner .sidebar_wrapper ul.sidebar_widget li.widget_nav_menu ul.menu li.current-menu-item a, .pricing_wrapper, .pricing_wrapper li, .ui-accordion .ui-accordion-header, .ui-accordion .ui-accordion-content, #page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle:before, h2.widgettitle:before, #autocomplete, .ppb_blog_minimal .one_third_bg, #page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.event_title, .tabs .ui-tabs-panel, .ui-tabs .ui-tabs-nav li, .ui-tabs li:first-child, .ui-tabs.vertical .ui-tabs-nav li:last-child, .woocommerce .woocommerce-ordering select, .woocommerce div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page div.product .woocommerce-tabs ul.tabs li.active, .woocommerce #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active, .woocommerce-page table.cart th, table.shop_table thead tr th, hr.title_break, .overlay_gallery_border, #page_content_wrapper.split #copyright, .page_content_wrapper.split #copyright, .post.type-post, .events.type-events, h5.event_title, .post_header h5.event_title, .client_archive_wrapper').css('border-color', to );
                });
            });
            
            wp.customize('tg_input_bg_color',function( value ) {
                value.bind(function(to) {
                    jQuery('input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea').css('background-color', to );
                });
            });
            
            wp.customize('tg_input_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea').css('color', to );
                });
            });
            
            wp.customize('tg_input_border_color',function( value ) {
                value.bind(function(to) {
                    jQuery('input[type=text], input[type=password], input[type=email], input[type=url], input[type=tel], textarea').css('border-color', to );
                });
            });
            
            wp.customize('tg_button_font',function( value ) {
                value.bind(function(to) {
                	var ppGGFont = 'https://fonts.googleapis.com/css?family='+to;
                	if(jQuery('#google_fonts_'+to).length==0)
                	{
			    		jQuery('head').append('<link rel="stylesheet" id="google_fonts_'+to+'" href="'+ppGGFont+'" type="text/css" media="all">');
			    	}
                    jQuery('input[type=submit], input[type=button], a.button, .button, .woocommerce .page_slider a.button, a.button.fullwidth, .woocommerce-page div.product form.cart .button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt').css('fontFamily', to );
                });
            });
            //End General Tab Settings
        
        	//Register Menu Tab Settings
        	wp.customize('tg_menu_font',function( value ) {
                value.bind(function(to) {
                	var ppGGFont = 'https://fonts.googleapis.com/css?family='+to;
                	if(jQuery('#google_fonts_'+to).length==0)
                	{
			    		jQuery('head').append('<link rel="stylesheet" id="google_fonts_'+to+'" href="'+ppGGFont+'" type="text/css" media="all">');
			    	}
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a').css('fontFamily', to );
                });
            });
            
            wp.customize('tg_menu_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_menu_padding',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a').css('paddingTop', to+'px' );
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a').css('paddingBottom', to+'px' );
                });
            });
            
            wp.customize('tg_menu_weight',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a').css('fontWeight', to );
                });
            });
            
            wp.customize('tg_menu_font_spacing',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a').css('letterSpacing', to+'px' );
                });
            });
            
            wp.customize('tg_menu_transform',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a').css('textTransform', to );
                });
            });
            
            wp.customize('tg_menu_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li a, #menu_wrapper div .nav li > a, .header_cart_wrapper a, #page_share').css('color', to );
                    jQuery('#mobile_nav_icon').css('borderColor', to );
                });
            });
            
            wp.customize('tg_menu_hover_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li a.hover, #menu_wrapper .nav ul li a:hover, #menu_wrapper div .nav li a.hover, #menu_wrapper div .nav li a:hover, .header_cart_wrapper a:hover, #page_share:hover').css('color', to );
                    jQuery('#menu_wrapper .nav ul li a.hover, #menu_wrapper .nav ul li a:hover, #menu_wrapper div .nav li a.hover, #menu_wrapper div .nav li a:hover').css('borderColor', to );
                });
            });
            
            wp.customize('tg_menu_active_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper div .nav > li.current-menu-item > a, #menu_wrapper div .nav > li.current-menu-parent > a, #menu_wrapper div .nav > li.current-menu-ancestor > a, #menu_wrapper div .nav li ul li.current-menu-item a, #menu_wrapper div .nav li.current-menu-parent  ul li.current-menu-item a, .header_cart_wrapper a:active, #page_share:active').css('color', to );
                    jQuery('#menu_wrapper div .nav > li.current-menu-item > a, #menu_wrapper div .nav > li.current-menu-parent > a, #menu_wrapper div .nav > li.current-menu-ancestor > a, #menu_wrapper div .nav li ul li.current-menu-item a, #menu_wrapper div .nav li.current-menu-parent  ul li.current-menu-item a').css('borderColor', to );
                });
            });
            
            wp.customize('tg_menu_border_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.top_bar, #page_caption, #nav_wrapper').css('borderColor', to );
                });
            });
            
            wp.customize('tg_submenu_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul li a, #menu_wrapper div .nav li ul li a, #menu_wrapper div .nav li.current-menu-parent ul li a').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_submenu_weight',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul li a, #menu_wrapper div .nav li ul li a, #menu_wrapper div .nav li.current-menu-parent ul li a').css('fontWeight', to );
                });
            });
            
            wp.customize('tg_submenu_font_spacing',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul li a, #menu_wrapper div .nav li ul li a, #menu_wrapper div .nav li.current-menu-parent ul li a').css('letterSpacing', to+'px' );
                });
            });
            
            wp.customize('tg_submenu_transform',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul li a, #menu_wrapper div .nav li ul li a, #menu_wrapper div .nav li.current-menu-parent ul li a').css('textTransform', to );
                });
            });
            
            wp.customize('tg_submenu_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul li a, #menu_wrapper div .nav li ul li a, #menu_wrapper div .nav li.current-menu-parent ul li a').css('color', to );
                });
            });
            
            wp.customize('tg_submenu_hover_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul li a:hover, #menu_wrapper div .nav li ul li a:hover, #menu_wrapper div .nav li.current-menu-parent ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:hover, #menu_wrapper div .nav li.megamenu ul li ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:active, #menu_wrapper div .nav li.megamenu ul li ul li a:active').css('color', to );
                });
            });
            
            wp.customize('tg_submenu_hover_bg_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul li a:hover, #menu_wrapper div .nav li ul li a:hover, #menu_wrapper div .nav li.current-menu-parent ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:hover, #menu_wrapper div .nav li.megamenu ul li ul li a:hover, #menu_wrapper .nav ul li.megamenu ul li ul li a:active, #menu_wrapper div .nav li.megamenu ul li ul li a:active').css('background', to );
                });
            });
            
            wp.customize('tg_submenu_bg_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul, #menu_wrapper div .nav li ul').css('background', to );
                });
            });
            
            wp.customize('tg_submenu_border_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper .nav ul li ul, #menu_wrapper div .nav li ul').css('borderColor', to );
                });
            });
            
            wp.customize('tg_megamenu_header_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper div .nav li.megamenu ul li > a, #menu_wrapper div .nav li.megamenu ul li > a:hover, #menu_wrapper div .nav li.megamenu ul li > a:active, #menu_wrapper div .nav li.megamenu ul li.current-menu-item > a').css('color', to );
                });
            });
            
            wp.customize('tg_megamenu_border_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#menu_wrapper div .nav li.megamenu ul li').css('borderColor', to );
                });
            });
            
            wp.customize('tg_topbar_bg_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.above_top_bar').css('background', to );
                });
            });
            
            wp.customize('tg_topbar_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#top_menu li a, .top_contact_info, .top_contact_info i, .top_contact_info a, .top_contact_info a:hover, .top_contact_info a:active').css('color', to );
                });
            });
            
            wp.customize('tg_menu_contact_hours',function( value ) {
                value.bind(function(to) {
                    jQuery('#top_contact_hours').html('<i class="fa fa-clock-o"></i>'+to);
                });
            });
            
            wp.customize('tg_menu_contact_number',function( value ) {
                value.bind(function(to) {
                    jQuery('#top_contact_number').html('<i class="fa fa-phone"></i>'+to);
                });
            });
            
            wp.customize('tg_menu_search_input_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.mobile_menu_wrapper #searchform').css('background', to );
                });
            });
            
            wp.customize('tg_menu_search_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.mobile_menu_wrapper #searchform input[type=text], .mobile_menu_wrapper #searchform button i, #close_mobile_menu i').css('color', to );
                    jQuery('.mobile_menu_wrapper #searchform ::-webkit-input-placeholder').css('color', to );
                    jQuery('.mobile_menu_wrapper #searchform ::-moz-placeholder').css('color', to );
                    jQuery('.mobile_menu_wrapper #searchform :-ms-input-placeholder').css('color', to );
                });
            });
            
            wp.customize('tg_sidemenu_font',function( value ) {
                value.bind(function(to) {
                	var ppGGFont = 'https://fonts.googleapis.com/css?family='+to;
                	if(jQuery('#google_fonts_'+to).length==0)
                	{
			    		jQuery('head').append('<link rel="stylesheet" id="google_fonts_'+to+'" href="'+ppGGFont+'" type="text/css" media="all">');
			    	}
                    jQuery('.mobile_main_nav li a, #sub_menu li a').css('fontFamily', to );
                });
            });
            
            wp.customize('tg_sidemenu_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('.mobile_main_nav li a, #sub_menu li a').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_sidemenu_font_transform',function( value ) {
                value.bind(function(to) {
                    jQuery('.mobile_main_nav li a, #sub_menu li a').css('textTransform', to );
                });
            });
            
            wp.customize('tg_sidemenu_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.mobile_main_nav li a, #sub_menu li a, .mobile_menu_wrapper .sidebar_wrapper a, #close_mobile_menu').css('color', to );
                });
            });
            
            wp.customize('tg_submenu_hover_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.mobile_main_nav li a:hover, .mobile_main_nav li a:active, #sub_menu li a:active, .mobile_menu_wrapper .sidebar_wrapper h2.widgettitle').css('color', to );
                });
            });
            //End Menu Tab Settings
            
            
            //Register Header Tab Settings 
        	wp.customize('tg_page_header_bg_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption, .page_caption_bg_content, .overlay_gallery_content').css('background-color', to );
                    jQuery('.page_caption_bg_border, .overlay_gallery_border').css('border-color', to );
                });
            });
            
            wp.customize('tg_page_header_padding_top',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption').css('paddingTop', to+'px' );
                });
            });
            
            wp.customize('tg_page_header_padding_bottom',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption').css('paddingBottom', to+'px' );
                });
            });
            
            wp.customize('tg_page_title_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption h1, .ppb_title, .post_caption h1').css('color', to );
                });
            });
            
            wp.customize('tg_page_title_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption h1, .ppb_title, .post_caption h1').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_page_title_font_weight',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption h1, .ppb_title, .post_caption h1').css('fontWeight', to );
                });
            });
            
            wp.customize('tg_page_title_transform',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption h1, .ppb_title, .post_caption h1').css('textTransform', to );
                });
            });
            
            wp.customize('tg_page_title_bg_height',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_caption.hasbg').css('height', to+'vh' );
                });
            });
            
            wp.customize('tg_header_builder_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('h2.ppb_title').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_header_builder_font_transform',function( value ) {
                value.bind(function(to) {
                    jQuery('h2.ppb_title').css('textTransform', to );
                });
            });
            
            wp.customize('tg_page_tagline_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company').css('color', to );
                });
            });
            
            wp.customize('tg_page_tagline_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('.post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_page_tagline_font_weight',function( value ) {
                value.bind(function(to) {
                    jQuery('.post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company').css('fontWeight', to );
                });
            });
            
            wp.customize('tg_page_tagline_transform',function( value ) {
                value.bind(function(to) {
                    jQuery('.post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company').css('textTransform', to );
                });
            });
            
            wp.customize('tg_page_tagline_font_spacing',function( value ) {
                value.bind(function(to) {
                    jQuery('.post_header .post_detail, .recent_post_detail, .post_detail, .thumb_content span, .portfolio_desc .portfolio_excerpt, .testimonial_customer_position, .testimonial_customer_company').css('letterSpacing', to+'px' );
                });
            });
        	//End Logo Header Settings
        	
        	//Register Sidebar Tab Settings
            wp.customize('tg_sidebar_title_font',function( value ) {
                value.bind(function(to) {
                	var ppGGFont = 'https://fonts.googleapis.com/css?family='+to;
                	if(jQuery('#google_fonts_'+to).length==0)
                	{
			    		jQuery('head').append('<link rel="stylesheet" id="google_fonts_'+to+'" href="'+ppGGFont+'" type="text/css" media="all">');
			    	}
                    jQuery('#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle').css('fontFamily', to );
                });
            });
            
            wp.customize('tg_sidebar_title_font_size',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle').css('fontSize', to+'px' );
                });
            });
            
            wp.customize('tg_sidebar_title_font_weight',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle').css('fontWeight', to );
                });
            });
            
            wp.customize('tg_sidebar_title_transform',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle').css('textTransform', to );
                });
            });
            
            wp.customize('tg_sidebar_title_font_spacing',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle').css('letterSpacing', to+'px' );
                });
            });
            
            wp.customize('tg_sidebar_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .inner .sidebar_wrapper .sidebar .content, .page_content_wrapper .inner .sidebar_wrapper .sidebar .content').css('color', to );
                });
            });
            
            wp.customize('tg_sidebar_link_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .inner .sidebar_wrapper a, .page_content_wrapper .inner .sidebar_wrapper a').css('color', to );
                });
            });
            
            wp.customize('tg_sidebar_hover_link_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .inner .sidebar_wrapper a:hover, #page_content_wrapper .inner .sidebar_wrapper a:active, .page_content_wrapper .inner .sidebar_wrapper a:hover, .page_content_wrapper .inner .sidebar_wrapper a:active').css('color', to );
                });
            });
            
            wp.customize('tg_sidebar_title_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#page_content_wrapper .sidebar .content .sidebar_widget li h2.widgettitle, h2.widgettitle, h5.widgettitle').css('color', to );
                });
            });
            //End Sidebar Tab Settings
            
            //Register Footer Tab Settings
            
            wp.customize('tg_footer_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#footer, #copyright').css('color', to );
                });
            });
            
            wp.customize('tg_footer_link_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#copyright a, #copyright a:active, #footer a, #footer a:active').css('color', to );
                });
            });
            
            wp.customize('tg_footer_hover_link_color',function( value ) {
                value.bind(function(to) {
                    jQuery('#copyright a:hover, #footer a:hover, .social_wrapper ul li a:hover').css('color', to );
                });
            });
            
            wp.customize('tg_footer_social_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.footer_bar_wrapper .social_wrapper ul li a').css('color', to );
                });
            });
            
            wp.customize('tg_footer_copyright_text',function( value ) {
                value.bind(function(to) {
                    jQuery('#copyright').html( to );
                });
            });
            //End Footer Tab Settings
            
            wp.customize('tg_blog_cat_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.post_info_cat, .post_info_cat a').css('color', to );
                });
            });
            
            
            //Register Shop Tab Settings
             wp.customize('tg_shop_price_font_color',function( value ) {
                value.bind(function(to) {
                    jQuery('.woocommerce ul.products li.product .price ins, .woocommerce-page ul.products li.product .price ins, .woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price, p.price ins span.amount, p.price span.amount, .woocommerce #content div.product p.price, .woocommerce #content div.product span.price, .woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce-page #content div.product p.price, .woocommerce-page #content div.product span.price, .woocommerce-page div.product p.price, .woocommerce-page div.product span.price').css( 'color', to );
                });
            });
            //End Shop Tab Settings
        } )( jQuery )
    </script>
<?php	
}

add_action( 'customize_register', function( $wp_customize ) {
	/**
	 * The custom control class
	 */
	class Kirki_Controls_Title_Control extends WP_Customize_Control {
		public $type = 'title';
		public function render_content() { 
			echo $this->label;
		}
	}
	// Register our custom control with Kirki
	add_filter( 'kirki/control_types', function( $controls ) {
		$controls['title'] = 'Kirki_Controls_Title_Control';
		return $controls;
	} );

} );