<?php

return [
	'title'      => esc_html__( 'Testimonials', 'mb-testimonials' ),
	'post_types' => 'mb-testimonials',
	'fields'     => [
		[
			'id'            => 'mb_testimonials_group',
			'type'          => 'group',
			'clone'         => true,
			'sort_clone'    => true,
			'collapsible'   => true,
			'default_state' => 'collapsible',
			'save_state'    => true,
			'group_title'   => '{author_name}',
			'fields'        => [
				[
					'name'     => esc_html__( 'Content', 'mb-testimonials' ),
					'type'     => 'wysiwyg',
					'id'       => 'content',
					'options'  => [
						'media_buttons' => false,
						'quicktags'     => false,
						'teeny'         => true,
						'textarea_rows' => 4,
					],
					'required' => true,
				],
				[
					'name'     => esc_html__( 'Author Name', 'mb-testimonials' ),
					'type'     => 'text',
					'id'       => 'author_name',
					'required' => true,
				],
				[
					'name' => esc_html__( 'Author Image', 'mb-testimonials' ),
					'type' => 'single_image',
					'id'   => 'author_image',
				],
				[
					'name' => esc_html__( 'Author Position', 'mb-testimonials' ),
					'type' => 'text',
					'id'   => 'author_position',
				],
				[
					'name' => esc_html__( 'Subject', 'mb-testimonials' ),
					'type' => 'text',
					'id'   => 'subject',
				],
				[
					'name'    => esc_html__( 'Rating', 'mb-testimonials' ),
					'type'    => 'select',
					'id'      => 'rating',
					'options' => [
						'' => 0,
						1  => 1,
						2  => 2,
						3  => 3,
						4  => 4,
						5  => 5,
					],
				],
				[
					'name' => esc_html__( 'Review Link Text', 'mb-testimonials' ),
					'type' => 'text',
					'id'   => 'review_link_text',
				],
				[
					'name' => esc_html__( 'Review Link URL', 'mb-testimonials' ),
					'type' => 'text',
					'id'   => 'review_link_url',
				],
			],
		],
	],
];
