<?php
$post_id = rwmb_request()->filter_get( 'post', FILTER_SANITIZE_NUMBER_INT );
if ( ! $post_id ) {
	return [];
}
$shortcode    = '[mbt id="' . $post_id . '"]';

return [
	'title'      => esc_html__( 'Shortcode', 'mb-testimonials' ),
	'id'         => 'mb-testimonials-shortcode',
	'context'    => 'side',
	'priority'   => 'low',
	'post_types' => 'mb-testimonials',
	'fields'     => [
		[
			'type' => 'custom_html',
			'std'  => '<input type="text" class="regular-text" value="' . esc_attr( $shortcode ) . '" onclick="this.select()">',
		]
	]
];
