<?php
$tab = 'styling';
$suffix = esc_html__( 'px', 'mb-testimonials' );
return [
	[
		'name' => esc_html__( 'Columns', 'mb-testimonials' ),
		'id'   => $prefix . 'columns',
		'type' => 'select',
		'options' => [
			1 => 1,
			2 => 2,
			3 => 3,
		],
		'tab' => $tab,
	],
	[
		'name'   => esc_html__( 'Image Width', 'mb-testimonials' ),
		'id'     => $prefix . 'image_width',
		'type'   => 'number',
		'tab'    => $tab,
		'append' => $suffix,
	],
	[
		'name'   => esc_html__( 'Image Height', 'mb-testimonials' ),
		'id'     => $prefix . 'image_height',
		'type'   => 'number',
		'tab'    => $tab,
		'append' => $suffix,
	],
	[
		'name' => esc_html__( 'Enable Slider', 'mb-testimonials' ),
		'id'   => $prefix . 'enable_slider',
		'type' => 'switch',
		'tab'  => $tab,
	],
	[
		'name'    => esc_html__( 'Number Slider Items', 'mb-testimonials' ),
		'id'      => $prefix . 'number_slider_items',
		'type'    => 'group',
		'tab'     => $tab,
		'visible' => [  $prefix . 'enable_slider', '=', true ],
		'fields'  => [
			[
				'name' => esc_html__( 'Desktop', 'mb-testimonials' ),
				'id'   => 'desktop',
				'type' => 'number',
			],
			[
				'name'   => esc_html__( 'Mobile', 'mb-testimonials' ),
				'id'     => 'mobile',
				'type'   => 'number',
				'desc'   => esc_html__( 'Set maximum number of slider items on mobile.', 'mb-testimonials' )
			],
		],
	],

	[
		'name'    => esc_html__( 'Effect', 'mb-testimonials' ),
		'id'      => $prefix . 'transition',
		'type'    => 'radio',
		'options' => [
			'slide' => esc_html__( 'Slide', 'mb-testimonials' ),
			'fade'  => esc_html__( 'Fade', 'mb-testimonials' ),
		],
		'std'     => 'slide',
		'tab'     => $tab,
		'visible' => [ $prefix . 'enable_slider', '=', true ],
	],
	[
		'name'    => esc_html__( 'Transition speed', 'mb-testimonials' ),
		'id'      => $prefix . 'speed',
		'type'    => 'number',
		'append'  => 'ms',
		'tab'     => $tab,
		'visible' => [ $prefix . 'enable_slider', '=', true ],
	],
	[
		'name' => esc_html__( 'Display Arrows', 'mb-testimonials' ),
		'id'   => $prefix . 'display_arrows',
		'type' => 'switch',
		'std'  => true,
		'tab'  => $tab,
		'visible' => [ $prefix . 'enable_slider', '=', true ],
	],
	[
		'name'    => esc_html__( 'Arrows', 'mb-testimonials' ),
		'id'      => $prefix . 'arrows',
		'type'    => 'group',
		'tab'     => $tab,
		'visible' => [ $prefix . 'display_arrows', '=', true ],
		'fields'  => [
			[
				'name' => esc_html__( 'Previous Arrow', 'mb-testimonials' ),
				'id'   => 'prev_arrow',
				'type' => 'text',
				'desc'   => esc_html__( 'Enter SVG markup for the custom previous arrow icon.', 'mb-testimonials' ),
			],
			[
				'name' => esc_html__( 'Next Arrow', 'mb-testimonials' ),
				'id'   => 'next_arrow',
				'type' => 'text',
				'desc'   => esc_html__( 'Enter SVG markup for the custom next arrow icon.', 'mb-testimonials' ),
			],
			[
				'name' => esc_html__( 'Color', 'mb-testimonials' ),
				'id'   => 'color',
				'type' => 'color',
			],
			[
				'name'   => esc_html__( 'Size', 'mb-testimonials' ),
				'id'     => 'size',
				'type'   => 'number',
				'append' => $suffix,
			],
		],
	],
	[
		'name' => esc_html__( 'Display Dots', 'mb-testimonials' ),
		'id'   => $prefix . 'display_dots',
		'type' => 'switch',
		'std'  => true,
		'tab'  => $tab,
		'visible' => [ $prefix . 'enable_slider', '=', true ],
	],
	[
		'name'    => esc_html__( 'Dots', 'mb-testimonials' ),
		'id'      => $prefix . 'dots',
		'type'    => 'group',
		'tab'     => $tab,
		'visible' => [  $prefix . 'display_dots', '=', true ],
		'fields'  => [
			[
				'name' => esc_html__( 'Color', 'mb-testimonials' ),
				'id'   => 'background',
				'type' => 'color',
			],
			[
				'name' => esc_html__( 'Active Color', 'mb-testimonials' ),
				'id'   => 'active_background',
				'type' => 'color',
			],
			[
				'name'   => esc_html__( 'Size', 'mb-testimonials' ),
				'id'     => 'size',
				'type'   => 'number',
				'append' => $suffix,
			],
		],
	],
	[
		'name'    => esc_html__( 'Autoplay', 'mb-testimonials' ),
		'id'      => $prefix . 'autoplay',
		'type'    => 'switch',
		'std'     => true,
		'tab'     => $tab,
		'visible' => [ $prefix . 'enable_slider', '=', true ],
	],
	[
		'name'    => esc_html__( 'Autoplay speed', 'mb-testimonials' ),
		'id'      => $prefix . 'autoplay_speed',
		'type'    => 'number',
		'append'  => 'ms',
		'tab'     => $tab,
		'visible' => [
			[ $prefix . 'enable_slider', '=', true ],
			[ $prefix . 'autoplay', '=', true ],
		],
	],
];
