<?php
namespace MBTestimonials;

class Shortcode {
	public function __construct() {
		add_shortcode( 'mbt', [ $this, 'render' ] );
	}

	public function render( $atts ) {
		if ( is_admin() ) {
			return '';
		}

		$atts = shortcode_atts(
			[
				'id' => '',
			],
			$atts
		);

		$id = $atts['id'];
		unset( $atts['id'] );

		if ( empty( $id ) ) {
			return '';
		}

		$post = get_post( $id );
		if ( ! $post ) {
			return;
		}
		$testimonials = get_post_meta( $id, 'mb_testimonials_group', true );
		$testimonials = array_map( function( $testimonial ) {
			unset( $testimonial['_state'] );
			return $testimonial;
		}, $testimonials );

		$testimonials = array_filter( $testimonials );
		if ( ! $testimonials ) {
			return;
		}
		$style  = get_post_meta( $id, 'mb_testimonials_style', true );
		$column = get_post_meta( $id, 'mb_testimonials_columns',true );
		$layout = get_post_meta( $id, 'mb_testimonials_enable_slider', true ) ? 'mbt-slider' : 'mbt-grid mbt-grid--col-' . $column;

		if ( $layout !== 'mbt-slider' ) {
			$slider_data = [];
		} else {
			$slider_data = [
				'transition'    => get_post_meta( $id, 'mb_testimonials_transition', true ),
				'arrows'        => get_post_meta( $id, 'mb_testimonials_display_arrows', true ) ? true : false,
				'dots'          => get_post_meta( $id, 'mb_testimonials_display_dots', true ) ? true : false,
				'column'        => $column,
				'speed'         => get_post_meta( $id, 'mb_testimonials_speed', true ) ?: 300,
				'autoplay'      => get_post_meta( $id, 'mb_testimonials_autoplay', true ) ? true : false,
				'autoplaySpeed' => get_post_meta( $id, 'mb_testimonials_autoplay_speed', true ) ?: 3000,
			];

			$arrows = get_post_meta( $id, 'mb_testimonials_arrows', true );
			if ( ! empty( $arrows ) && ! empty( $arrows['prev_arrow'] ) ) {
				$slider_data['prevArrow'] = $arrows['prev_arrow'];
			}
			if ( ! empty( $arrows ) && ! empty( $arrows['next_arrow'] ) ) {
				$slider_data['nextArrow'] = $arrows['next_arrow'];
			}

			$slider_items = get_post_meta( $id, 'mb_testimonials_number_slider_items', true );
			if ( ! empty( $slider_items ) && ! empty( $slider_items['desktop'] ) ) {
				$slider_data['sliderItemsDesktop'] = $slider_items['desktop'];
			}
			if ( ! empty( $slider_items ) && ! empty( $slider_items['mobile'] ) ) {
				$slider_data['sliderItemsMobile'] = $slider_items['mobile'];
			}
		}

		$this->enqueue( $layout );
		$this->add_inline_style( $id );
		ob_start();
		?>
		<div
			class="mbt-testimonials mbt-testimonials--<?= esc_attr( $id ); ?> <?= esc_attr( "{$layout} mbt-testimonials--{$style}" ) ?>"
			data-slider="<?= esc_attr( json_encode( $slider_data ) ); ?>">

			<?php
			$default = [
				'subject'          => '',
				'content'          => '',
				'author_image'     => '',
				'author_name'      => '',
				'author_position'  => '',
				'rating'           => '',
				'review_link_text' => '',
				'review_link_url'  => '',
			];
			$custom_template = trim( $post->post_content );
			foreach( $testimonials as $testimonial ) {
				$data     = wp_parse_args( $testimonial, $default );
				$template = $custom_template ? $custom_template : file_get_contents( MB_TESTIMONIALS_DIR . '/views/' . $style . '.php' );
				Helper::render_template( $template, $data );
			}
			?>
		</div>
		<?php
		return ob_get_clean();
	}

	public function add_inline_style( $id ) {
		$custom_css = new CustomCSS( $id );
		if ( empty( $custom_css->css ) ) {
			return;
		}
		$css = $custom_css->custom_css_field();
		foreach( $custom_css->css as $selector => $styles ) {
			foreach ( $styles as $style ) {
				$css .= sprintf( '.mbt-testimonials--%s %s %s', $id, $selector, $style );
			}
		}
		wp_add_inline_style( 'mb-testimonials', $css );
	}

	public function enqueue( $layout ) {
		if ( $layout === 'mbt-slider' ) {
			wp_enqueue_style( 'slick', MB_TESTIMONIALS_URL . 'assets/css/slick.min.css', '', '1.8.1' );
			wp_enqueue_script( 'slick', MB_TESTIMONIALS_URL . 'assets/js/slick.min.js', ['jquery'], '1.8.1', true );
			wp_enqueue_script( 'mb-testimonials', MB_TESTIMONIALS_URL . 'assets/js/mb-testimonials.js', ['slick'], MB_TESTIMONIALS_VER, true );
		}
		wp_enqueue_style( 'mb-testimonials', MB_TESTIMONIALS_URL . 'assets/css/mb-testimonials.css', '', MB_TESTIMONIALS_VER );
	}
}
