<?php
namespace MBTestimonials;

class PostType {
    public function __construct() {
        add_action( 'init', [ $this, 'register_post_type' ] );
		add_filter( 'use_block_editor_for_post_type', [ $this, 'disable_block_editor' ], 10, 2 );
    }

    public function register_post_type() {
		$labels = [
			'name'                  => esc_html_x( 'Testimonials', 'post type name', 'mb-testimonials' ),
			'singular_name'         => esc_html_x( 'Testimonials', 'singular post type name', 'mb-testimonials' ),
			'add_new'               => esc_html__( 'Add New', 'mb-testimonials' ),
			'add_new_item'          => esc_html__( 'Add New', 'mb-testimonials' ),
			'edit_item'             => esc_html__( 'Edit Testimonials', 'mb-testimonials' ),
			'new_item'              => esc_html__( 'New Testimonials', 'mb-testimonials' ),
			'all_items'             => esc_html__( 'Testimonials', 'mb-testimonials' ),
			'view_item'             => esc_html__( 'View Testimonials', 'mb-testimonials' ),
			'search_items'          => esc_html__( 'Search Testimonials', 'mb-testimonials' ),
			'not_found'             => esc_html__( 'No Testimonials found', 'mb-testimonials' ),
			'not_found_in_trash'    => esc_html__( 'No Testimonials found in Trash', 'mb-testimonials' ),
			'parent_item_colon'     => '',
			'menu_name'             => esc_html_x( 'Testimonials', 'post type menu name', 'mb-testimonials' ),
			'filter_items_list'     => esc_html__( 'Filter Testimonials list', 'mb-testimonials' ),
			'items_list_navigation' => esc_html__( 'Testimonials list navigation', 'mb-testimonials' ),
			'items_list'            => esc_html__( 'Testimonials list', 'mb-testimonials' ),
		];

		$args = [
			'labels'          => $labels,
			'public'          => false,
			'show_ui'         => true,
			'show_in_menu'    => true,
			'query_var'       => false,
			'rewrite'         => [ 'slug' => 'testimonials', 'with_front' => false ],
			'capability_type' => 'post',
			'map_meta_cap'    => true,
			'has_archive'     => false,
			'hierarchical'    => false,
			'show_in_rest'    => false,
			'menu_icon'       => 'dashicons-testimonial',
			'supports'        => [
				'title',
			],
		];
		register_post_type( 'mb-testimonials', $args );
    }

    public function disable_block_editor( $enabled, $post_type ) {
		return 'mb-testimonials' === $post_type ? false : $enabled;
	}
}
