<?php
namespace MBTestimonials;

class Helper {
	public static function get_template_part( $part, $data = [], $echo = true ) {
		$data = (array) $data;
		$data = array_filter( $data );
		if ( empty( $data ) ) {
			return null;
		}
		static $template_loader = null;
		if ( null === $template_loader ) {
			$template_loader = new TemplateLoader;
		}
		ob_start();
		$template_loader->set_template_data( $data )->get_template_part( $part );
		if ( ! $echo ) {
			return ob_get_clean();
		}
		echo ob_get_clean();
	}

	public static function render_template( $template, $data ) {
		$template = '<div class="mbt-testimonial">' . $template . '</div>';
		$loader = new \MetaBox\Dependencies\Twig\Loader\ArrayLoader( [
			'template' => $template,
		] );
		$twig = new \MetaBox\Dependencies\Twig\Environment( $loader, [ 'autoescape' => false ] );
		$template_data = [
			'subject_rating' => self::get_template_part( 'testimonial/subject-rating', [ 'subject' => $data['subject'], 'rating' => $data['rating'] ], false ),
			'subject'        => self::get_template_part( 'testimonial/subject', [ 'subject' => $data['subject'] ], false ),
			'rating'         => self::get_template_part( 'testimonial/rating', [ 'rating' => $data['rating'] ], false ),
			'content'        => self::get_template_part( 'testimonial/content', [ 'content' => $data['content'] ], false ),
			'image'          => self::get_template_part( 'testimonial/image', [ 'author_image' => $data['author_image'] ], false ),
			'name'           => self::get_template_part( 'testimonial/name', [ 'author_name' => $data['author_name'] ], false ),
			'position'       => self::get_template_part( 'testimonial/position', [ 'author_position' => $data['author_position'] ], false ),
		];
		if( ! empty( $data['review_link_text'] ) && ! empty( $data['review_link_url'] ) ) {
			$template_data['review_link'] = self::get_template_part( 'testimonial/review-link', [ 'text' => $data['review_link_text'], 'url' => $data['review_link_url'] ], false );
		}
		$template = $twig->render( 'template', $template_data );

		echo wp_kses_post( $template );
	}
}
