<?php
namespace MBTestimonials;

class Fields {
	public function __construct() {
		add_filter( 'rwmb_meta_boxes', [ $this, 'register_meta_boxes' ] );
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue' ] );
	}

	public function register_meta_boxes( $meta_boxes ) {
		$meta_boxes[] = include __DIR__ . '/fields/testimonials.php';
		$meta_boxes[] = include __DIR__ . '/fields/settings.php';
		$meta_boxes[] = include __DIR__ . '/fields/shortcode.php';

		return $meta_boxes;
	}

	public function render_editors() {
		return '
		<div id="mb-testimonials-template-editor" class="mbt-is-hidden">'
			. $this->render( 'components' )
			. '<div class="mbt-editor-header">'
				. $this->render( 'tabs' )
				. $this->render( 'buttons' )
			. '</div>'
			. $this->render( 'editors' )
		. '</div>';
	}

	private function render( $name ) {
		ob_start();
		require MB_TESTIMONIALS_DIR . "/views/admin/$name.php";
		return ob_get_clean();
	}

	public function admin_enqueue() {
		if ( ! $this->is_screen() ) {
			return;
		}
		wp_enqueue_code_editor( [ 'type' => 'application/x-httpd-php' ] );

		wp_enqueue_style( 'mbt-custom-template', MB_TESTIMONIALS_URL . 'assets/admin/css/custom-template.css', MB_TESTIMONIALS_VER );
		wp_enqueue_script( 'mbt-custom-template', MB_TESTIMONIALS_URL . 'assets/admin/js/custom-template.js', [ 'code-editor', 'underscore', 'wp-element' ], MB_TESTIMONIALS_VER, true );

		wp_localize_script( 'mbt-custom-template', 'MBTAdmin', [
			'confirmReset'        => esc_html__( 'Are you sure to reset the template to the default?', 'mb-testimonials' ),
			'confirmCancel'       => esc_html__( 'Are you sure to cancel customizing the template? You\'ll loose all the custom changes and will use the default template.', 'mb-testimonials' ),
			'clickOnDisabledText' => esc_html__( 'You have already customized the template. Please cancel the customization before selecting another style.', 'mb-testimonials' ),
			'components'          => [
				'content'        => esc_html__( 'Content', 'mb-testimonials' ),
				'name'           => esc_html__( 'Author Name', 'mb-testimonials' ),
				'image'          => esc_html__( 'Author Image', 'mb-testimonials' ),
				'position'       => esc_html__( 'Author Position', 'mb-testimonials' ),
				'subject_rating' => esc_html__( 'Subject and Rating', 'mb-testimonials' ),
				'subject'        => esc_html__( 'Subject', 'mb-testimonials' ),
				'rating'         => esc_html__( 'Rating', 'mb-testimonials' ),
				'review_link'    => esc_html__( 'Review Link', 'mb-testimonials' ),
			],
		] );
	}

	private function is_screen() {
		return 'mb-testimonials' === get_current_screen()->id;
	}
}
