<?php
namespace MBTestimonials;

class CustomCSS {
	private $id;
	public $css;

	public function __construct( $id ) {
		$this->id  = $id;
		$this->css = [];
		$this->arrows();
		$this->dots();
		$this->image();
		$this->custom_css_field();
	}

	private function arrows() {
		$arrows = get_post_meta( $this->id, 'mb_testimonials_arrows', true );
		if ( ! $arrows ) {
			return;
		}
		if ( ! empty( $arrows['size'] ) ) {
			$this->css['.mbt-slider__nav'][] = sprintf( '{ width: %1$s; height: %1$s }', $arrows['size'] . 'px' );
		}
		if ( ! empty( $arrows['color'] ) ) {
			$this->css['.mbt-slider__nav'][] = sprintf( '{ background: %s }', $arrows['color'] );
			$this->css['.mbt-slider__nav.custom-nav svg'][] = sprintf( '{ stroke: %s }', $arrows['color'] );
		}
	}

	private function dots() {
		$dots = get_post_meta( $this->id, 'mb_testimonials_dots', true );
		if ( ! $dots ) {
			return;
		}
		if ( ! empty( $dots['size'] ) ) {
			$this->css['.slick-dots li button'][] = sprintf( '{ width: %1$s; height: %1$s }', $dots['size'] . 'px' );
		}
		if ( ! empty( $dots['background'] ) ) {
			$this->css['.slick-dots li button'][] = sprintf( '{ background: %s }', $dots['background'] );
		}
		if ( ! empty( $dots['active_background'] ) ) {
			$this->css['.slick-dots li.slick-active button'][] = sprintf( '{ background: %s }', $dots['active_background'] );
		}
	}

	private function image() {
		$width = get_post_meta( $this->id, 'mb_testimonials_image_width', true );
		$height = get_post_meta( $this->id, 'mb_testimonials_image_height', true );

		if ( ! empty( $width ) ) {
			$this->css['.mbt-testimonial .mbt-image'][] = sprintf( '{ width: %s }', $width . 'px' );
		}
		if ( ! empty( $height ) ) {
			$this->css['.mbt-testimonial .mbt-image'][] = sprintf( '{ height: %s }', $height . 'px' );
		}
	}

	public function custom_css_field() {
		$custom_css = get_post_field( 'post_excerpt', $this->id );
		return $custom_css;
	}
}
