<?php
/**
 * Plugin Name: MB Testimonials
 * Description: Easily create and add testimonials to your site.
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * Plugin URI:  https://metabox.io/plugins/mb-testimonials/
 * Version:     1.1.0
 * Text Domain: mb-testimonials
 * Domain Path: languages
 *
 * @package MB Testimonials
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || die;

if ( ! function_exists( 'mb_testimonials_load' ) ) {
	add_action( 'init', 'mb_testimonials_load', 1 );

	function mb_testimonials_load() {
		if ( ! defined( 'RWMB_VER' ) ) {
			return;
		}

		if ( file_exists( __DIR__ . '/vendor' ) ) {
			require __DIR__ . '/vendor/autoload.php';
			require __DIR__ . '/vendor/meta-box/meta-box-conditional-logic/meta-box-conditional-logic.php';
			require __DIR__ . '/vendor/meta-box/meta-box-group/meta-box-group.php';
			require __DIR__ . '/vendor/meta-box/meta-box-tabs/meta-box-tabs.php';
		} else {
			require dirname( __DIR__ ) . '/meta-box-conditional-logic/meta-box-conditional-logic.php';
			require dirname( __DIR__ ) . '/meta-box-group/meta-box-group.php';
			require dirname( __DIR__ ) . '/meta-box-tabs/meta-box-tabs.php';
		}

		define( 'MB_TESTIMONIALS_DIR', __DIR__ );
		list( , $url ) = RWMB_Loader::get_path( __DIR__ );
		define( 'MB_TESTIMONIALS_URL', $url );
		define( 'MB_TESTIMONIALS_VER', '1.1.0' );

		new MBTestimonials\PostType;
		new MBTestimonials\Fields;
		new MBTestimonials\Shortcode;
	}
}
