( function( $ ) {
	'use strict';

	$( '.mbt-testimonials' ).each( function() {
		const $this = $( this );
		if ( ! $this.hasClass( 'mbt-slider' ) ) {
			return;
		}
		const data = $this.data( 'slider' );

		const prevArrow = data.prevArrow ? '<button class="mbt-slider__nav custom-nav mbt-slider__nav--prev">' + data.prevArrow + '</button>' : '<button class="mbt-slider__nav mbt-slider__nav--prev"></button>';
		const nextArrow = data.nextArrow ? '<button class="mbt-slider__nav custom-nav mbt-slider__nav--next">' + data.nextArrow + '</button>' : '<button class="mbt-slider__nav mbt-slider__nav--next"></button>';
		const slidesToShowDesktop = data.sliderItemsDesktop || data.column;
		const slidesToShowMobile = data.sliderItemsMobile || data.column;

		$this.slick( {
			slidesToShow: slidesToShowDesktop,
			arrows: data.arrows,
			dots: data.dots,
			prevArrow,
			nextArrow,
			infinite: true,
			speed: data.speed,
			autoplay: data.autoplay,
			autoplaySpeed: data.autoplaySpeed,
			responsive: [
				{
					breakpoint: 1024,
					settings: {
						slidesToShow: slidesToShowDesktop,
					}
				},
				{
					breakpoint: 576,
					settings: {
						slidesToShow: slidesToShowMobile,
					}
				},
				{
					breakpoint: 376,
					settings: {
						slidesToShow: 1,
					}
				}
			]
		} );
	} );
} )( jQuery );
