<h2><?php esc_html_e( 'Favorite Posts', 'mb-favorite-posts' ); ?></h2>

<?php $favorites = MetaBox\FavoritePosts\Helper::get_favorites(); ?>

<?php
if ( empty( $favorites ) ) {
	echo '<div colspan="4" class="mbfp-notice">' . __( 'You haven\'t added any posts yet', 'mb-favorite-posts' ) . '</div>';
	return;
}
?>

<table class="mbfp-posts">
	<colgroup>
		<col>
		<col>
		<col>
		<col class="mbfp-col-delete">
	</colgroup>
	<thead>
		<tr>
			<th><?php esc_html_e( 'Title', 'mb-favorite-posts' ) ?></th>
			<th><?php esc_html_e( 'Date', 'mb-favorite-posts' ) ?></th>
			<th><?php esc_html_e( 'Status', 'mb-favorite-posts' ) ?></th>
			<th></th>
		</tr>
	</thead>

	<tbody>
		<?php foreach( $favorites as $post_id ) : ?>

			<tr data-id="<?= esc_attr( $post_id ) ?>">
				<td>
					<a href="<?= get_the_permalink( $post_id ) ?>">
						<?= esc_html( get_the_title( $post_id ) ) ?>
					</a>
				</td>
				<td>
					<?= esc_html( get_the_date( '', $post_id ) ) ?>
				</td>
				<td>
					<?= esc_html( get_post_status( $post_id ) ) ?>
				</td>
				<td>
					<button class="mbfp-table__delete" data-id="<?= esc_attr( $post_id ) ?>" data-action="delete"></button>
				</td>
			</tr>
		<?php endforeach; ?>
	</tbody>

</table>
