<?php
namespace MetaBox\FavoritePosts;

class UserFields {
	public function __construct() {
		add_filter( 'rwmb_meta_boxes', [ $this, 'register_meta_boxes' ] );
	}

	public function register_meta_boxes( $meta_boxes ) {
		$post_types   = Settings::get( 'post_types' );
		$meta_boxes[] = [
			'title'  => ' ',
			'type'   => 'user',
			'fields' => [
				[
					'name'       => __( 'Favorite posts', 'mb-favorite-posts' ),
					'id'         => 'mbfp_posts',
					'type'       => 'post',
					'post_type'  => $post_types,
					'clone'      => true,
					'query_args' => [
						'post_status' => [ 'any', 'inherit', 'trash', 'auto-draft' ],
					],
				],
			],
		];

		return $meta_boxes;
	}
}
