<?php
namespace MetaBox\FavoritePosts;

class Shortcodes {
	private $button;
	private $assets;

	public function __construct( Button $button, Assets $assets ) {
		$this->button = $button;
		$this->assets = $assets;
		add_shortcode( 'mbfp-button', [ $this, 'button' ] );
		add_shortcode( 'mbfp-posts', [ $this, 'posts' ] );
		add_shortcode( 'mbfp-count', [ $this, 'get_count' ] );
	}

	public function button( $atts ) : string {
		$this->assets->enqueue();
		return $this->button->get_html( (array) $atts );
	}

	public function posts() : string {
		$this->assets->enqueue();

		ob_start();
		$template_loader = new TemplateLoader;
		$template_loader->get_template_part( 'posts' );
		return ob_get_clean();
	}

	public function get_count( $atts ) : string {
		$atts = shortcode_atts( [
			'id' => get_the_ID(),
		], $atts );
		return '<span class="mbfp-count" id="' . esc_attr( $atts['id'] ) . '">' . Helper::get_count( $atts['id'] ) . '</span>';
	}
}
