<?php
namespace MetaBox\FavoritePosts;

class Settings {
	public function __construct() {
		add_action( 'admin_enqueue_scripts', [ $this, 'enqueue' ] );
		add_filter( 'mb_settings_pages', [ $this, 'register_settings_page' ] );
		add_filter( 'rwmb_meta_boxes', [ $this, 'register_meta_boxes' ] );
	}
	public function enqueue() {
		$screen = get_current_screen();
		if ( $screen->id !== 'settings_page_mb-favorite-posts' ) {
			return;
		}

		wp_enqueue_style( 'mbfp-style', MBFP_URL . 'assets/favorite-posts-admin.css', [ 'wp-components' ], '1.1.0' );
		wp_enqueue_script( 'mbfp-script', MBFP_URL . 'assets/favorite-posts-admin.js', [ 'jquery', 'wp-color-picker', 'wp-color-picker-alpha' ], '1.1.0', true );
	}

	public function register_settings_page( $settings_pages ) {
		$settings_pages[] = [
			'id'          => 'mb-favorite-posts',
			'option_name' => 'mb_favorite_posts',
			'menu_title'  => __( 'Favorite Posts', 'mb-favorite-posts' ),
			'class'       => 'mbfp-settings',
			'style'       => 'no-boxes',
			'column'      => 1,
			'parent'      => 'options-general.php',
			'tabs'        => [
				'mbfp_general' => 'General',
				'mbfp_button'  => 'Button',
				'mbfp_icon'    => 'Icon',
			],
		];
		return $settings_pages;
	}

	public function register_meta_boxes( $meta_boxes ) {
		$meta_boxes[] = [
			'title'          => ' ',
			'settings_pages' => 'mb-favorite-posts',
			'id'             => 'mbfp-preview-section',
			'context'        => 'side',
			'fields'         => [
				[
					'name'  => __( 'Preview', 'mb-favorite-posts' ),
					'id'    => 'style_preview',
					'type'  => 'custom_html',
					'class' => 'style-preview',
					'std'   => '<div class="mbfp-block">
									<div class="mbfp-review-icon"></div>
									<div class="mbfp-review-text"></div>
									<div class="mbfp-review-count"></div>
								</div>',
				],
			],
		];
		$meta_boxes[] = [
			'title'          => __( 'General', 'mb-favorite-posts' ),
			'settings_pages' => 'mb-favorite-posts',
			'tab'            => 'mbfp_general',
			'fields'         => [
				[
					'name'    => __( 'Pre built styles', 'mb-favorite-posts' ),
					'id'      => 'pre_built_style',
					'type'    => 'radio',
					'class'   => 'pre-built-styles',
					'options' => [
						'default' => __( 'Default', 'mb-favorite-posts' ),
						'like'    => __( 'Like', 'mb-favorite-posts' ),
						'rounded' => __( 'Rounded', 'mb-favorite-posts' ),
					],
					'std'     => 'default',
				],
				[
					'type' => 'divider',
				],
				[
					'name' => __( 'Enable for non-logged in users', 'mb-favorite-posts' ),
					'id'   => 'non_logged_in',
					'type' => 'checkbox',
					'std'  => true,
				],
				[
					'name'    => __( 'Position', 'mb-favorite-posts' ),
					'id'      => 'position',
					'type'    => 'select',
					'options' => [
						'before' => __( 'Before Content', 'mb-favorite-posts' ),
						'after'  => __( 'After Content', 'mb-favorite-posts' ),
						'both'   => __( 'Both', 'mb-favorite-posts' ),
					],
					'std'     => 'after',
				],
				[
					'name'      => __( 'Dashboard Page', 'mb-favorite-posts' ),
					'id'        => 'dashboard_page',
					'type'      => 'post',
					'post_type' => 'page',
				],
				[
					'name'      => __( 'Register Page', 'mb-favorite-posts' ),
					'id'        => 'register_page',
					'type'      => 'post',
					'post_type' => 'page',
				],
				[
					'name'    => __( 'Post Types', 'mb-favorite-posts' ),
					'id'      => 'post_types',
					'type'    => 'checkbox_list',
					'options' => $this->get_post_types(),
					'std'     => [ 'post' ],
				],
				[
					'name'   => __( 'Limit', 'mb-favorite-posts' ),
					'id'     => 'limit',
					'min'    => 0,
					'type'   => 'number',
					'append' => __( 'posts', 'mb-favorite-posts' ),
					'desc'   => __( 'Maximum number of favorite posts. Enter 0 or leave empty to set it unlimited.', 'mb-favorite-posts' ),
				],
				[
					'type' => 'divider',
				],
				[
					'name' => __( 'Shortcodes', 'mb-favorite-posts' ),
					'type' => 'custom_html',
					'std'  => '<p><code>[mbfp-button]</code>: ' . __( 'Display add to favorite button', 'mb-favorite-posts' ) . '</p><p><code>[mbfp-posts]</code>: ' . __( 'Display list of favorite posts', 'mb-favorite-posts' ) . '</p><p><code>[mbfp-count]</code>: ' . __( 'Display total users favorite a post', 'mb-favorite-posts' ) . '</p>',
				],
				[
					'name'   => __( 'Cookie expiration', 'mb-favorite-posts' ),
					'id'     => 'cookie_expiration',
					'type'   => 'number',
					'min'    => 1,
					'std'    => 30,
					'append' => __( 'days', 'mb-favorite-posts' ),
				],
			],
		];
		$meta_boxes[] = [
			'title'          => __( 'Button', 'mb-favorite-posts' ),
			'settings_pages' => 'mb-favorite-posts',
			'tab'            => 'mbfp_button',
			'fields'         => [
				[
					'name' => __( 'Button Text', 'mb-favorite-posts' ),
					'id'   => 'button_text',
					'type' => 'text',
				],
				[
					'name' => __( 'Button Added Text', 'mb-favorite-posts' ),
					'id'   => 'button_added_text',
					'type' => 'text',
				],
				[
					'name'          => __( 'Hook color', 'mb-favorite-posts' ),
					'id'            => 'hook_color',
					'type'          => 'color',
					'alpha_channel' => true,
					'std'           => '#2ABA66',
					'class'         => 'hidden',
				],
				[
					'name' => __( 'Button color', 'mb-favorite-posts' ),
					'id'   => 'btn_color',
					'type' => 'text',
					'std'  => '#2ABA66',
				],
				[
					'name' => __( 'Text color', 'mb-favorite-posts' ),
					'id'   => 'text_color',
					'type' => 'text',
					'std'  => '#ffffff',
				],
				[
					'type' => 'divider',
				],
				[
					'name' => __( 'Show count', 'mb-favorite-posts' ),
					'id'   => 'show_count',
					'type' => 'checkbox',
					'std'  => true,
				],
				[
					'name'   => __( 'Font size', 'mb-favorite-posts' ),
					'id'     => 'font_size',
					'type'   => 'number',
					'min'    => 1,
					'append' => 'px',
				],
				[
					'name'   => __( 'Button radius', 'mb-favorite-posts' ),
					'id'     => 'btn_radius',
					'type'   => 'number',
					'min'    => 1,
					'append' => 'px',
				],
				[
					'name'   => __( 'Button horizontal padding', 'mb-favorite-posts' ),
					'id'     => 'btn_horizontal_padding',
					'type'   => 'number',
					'min'    => 1,
					'std'    => 12,
					'append' => 'px',
				],
				[
					'name'   => __( 'Button vertical padding', 'mb-favorite-posts' ),
					'id'     => 'btn_vertical_padding',
					'type'   => 'number',
					'min'    => 1,
					'std'    => 6,
					'append' => 'px',
				],
			],
		];
		$meta_boxes[] = [
			'title'          => __( 'Icon', 'mb-favorite-posts' ),
			'settings_pages' => 'mb-favorite-posts',
			'tab'            => 'mbfp_icon',
			'fields'         => [
				[
					'name' => __( 'Show icon', 'mb-favorite-posts' ),
					'id'   => 'show_icon',
					'type' => 'checkbox',
					'std'  => true,
				],
				[
					'name' => __( 'Show icon only', 'mb-favorite-posts' ),
					'id'   => 'icon_only',
					'type' => 'checkbox',
					'std'  => false,
				],
				[
					'name'    => __( 'Icon', 'mb-favorite-posts' ),
					'id'      => 'icon',
					'type'    => 'radio',
					'class'   => 'list-icons',
					'options' => $this->list_icons(),
					'std'     => 'heart',
				],
				[
					'name' => __( 'Icon color', 'mb-favorite-posts' ),
					'id'   => 'icon_color',
					'type' => 'text',
					'std'  => '#ffffff',
				],
				[
					'name'   => __( 'Icon size', 'mb-favorite-posts' ),
					'id'     => 'icon_size',
					'type'   => 'number',
					'min'    => 1,
					'std'    => 16,
					'append' => 'px',
				],
			],
		];

		return $meta_boxes;
	}

	public static function get( $name, $default = null ) {
		$option         = get_option( 'mb_favorite_posts' );
		$default_values = [
			'non_logged_in'          => true,
			'button_text'            => __( 'Add to favorites', 'mb-favorite-posts' ),
			'button_added_text'      => __( 'Added to favorites', 'mb-favorite-posts' ),
			'font_size'              => 14,
			'position'               => 'after',
			'post_types'             => empty( $option ) ? [ 'post' ] : [], // If option is saved, default post_types is [].
			'cookie_expiration'      => 30,
			'show_count'             => true,
			'show_icon'              => true,
			'icon'                   => 'heart',
			'icon_only'              => false,
			'icon_size'              => 16,
			'btn_color'              => '#2ABA66',
			'text_color'             => '#fff',
			'icon_color'             => '#fff',
			'btn_radius'             => 5,
			'btn_horizontal_padding' => 12,
			'btn_vertical_padding'   => 6,
		];
		return $option[ $name ] ?? $default_values[ $name ] ?? $default;
	}

	public function get_post_types() {
		$post_types = get_post_types( [ 'public' => true ], 'objects' );
		unset( $post_types['attachment'] );
		$options = [];
		foreach ( $post_types as $slug => $post_type ) {
			$options[ $slug ] = $post_type->labels->singular_name;
		}

		return $options;
	}

	public function list_icons() {
		return [
			'heart' => '<svg class="mbfp-icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
				<path d="M12,4.595c-1.104-1.006-2.512-1.558-3.996-1.558c-1.578,0-3.072,0.623-4.213,1.758c-2.353,2.363-2.352,6.059,0.002,8.412 l7.332,7.332c0.17,0.299,0.498,0.492,0.875,0.492c0.322,0,0.609-0.163,0.792-0.409l7.415-7.415 c2.354-2.354,2.354-6.049-0.002-8.416c-1.137-1.131-2.631-1.754-4.209-1.754C14.513,3.037,13.104,3.589,12,4.595z M18.791,6.205 c1.563,1.571,1.564,4.025,0.002,5.588L12,18.586l-6.793-6.793C3.645,10.23,3.646,7.776,5.205,6.209 c0.76-0.756,1.754-1.172,2.799-1.172s2.035,0.416,2.789,1.17l0.5,0.5c0.391,0.391,1.023,0.391,1.414,0l0.5-0.5 C14.719,4.698,17.281,4.702,18.791,6.205z"/>
			</svg>',
			'star'  => '<svg class="mbfp-icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
				<path d="M6.516,14.323l-1.49,6.452c-0.092,0.399,0.068,0.814,0.406,1.047C5.603,21.94,5.801,22,6,22 c0.193,0,0.387-0.056,0.555-0.168L12,18.202l5.445,3.63c0.348,0.232,0.805,0.223,1.145-0.024c0.338-0.247,0.487-0.68,0.372-1.082 l-1.829-6.4l4.536-4.082c0.297-0.268,0.406-0.686,0.278-1.064c-0.129-0.378-0.47-0.644-0.868-0.676L15.378,8.05l-2.467-5.461 C12.75,2.23,12.393,2,12,2s-0.75,0.23-0.911,0.589L8.622,8.05L2.921,8.503C2.529,8.534,2.192,8.791,2.06,9.16 c-0.134,0.369-0.038,0.782,0.242,1.056L6.516,14.323z M9.369,9.997c0.363-0.029,0.683-0.253,0.832-0.586L12,5.43l1.799,3.981 c0.149,0.333,0.469,0.557,0.832,0.586l3.972,0.315l-3.271,2.944c-0.284,0.256-0.397,0.65-0.293,1.018l1.253,4.385l-3.736-2.491 c-0.336-0.225-0.773-0.225-1.109,0l-3.904,2.603l1.05-4.546c0.078-0.34-0.026-0.697-0.276-0.94l-3.038-2.962L9.369,9.997z"/>
			</svg>',
			'pin'   => '<svg class="mbfp-icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
				<path d="M12,22l1-2v-3h5c0.553,0,1-0.447,1-1v-1.586c0-0.526-0.214-1.042-0.586-1.414L17,11.586V8c0.553,0,1-0.447,1-1V4 c0-1.103-0.897-2-2-2H8C6.897,2,6,2.897,6,4v3c0,0.553,0.448,1,1,1v3.586L5.586,13C5.213,13.372,5,13.888,5,14.414V16 c0,0.553,0.448,1,1,1h5v3L12,22z M8,4h8v2H8V4z M7,14.414l1.707-1.707C8.895,12.52,9,12.266,9,12V8h6v4 c0,0.266,0.105,0.52,0.293,0.707L17,14.414V15H7V14.414z"/>
			</svg>',
			'like'  => '<svg class="mbfp-icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
				<path d="M20,8h-5.612l1.123-3.367c0.202-0.608,0.1-1.282-0.275-1.802S14.253,2,13.612,2H12c-0.297,0-0.578,0.132-0.769,0.36 L6.531,8H4c-1.103,0-2,0.897-2,2v9c0,1.103,0.897,2,2,2h3h10.307c0.829,0,1.581-0.521,1.873-1.298l2.757-7.351 C21.979,12.239,22,12.12,22,12v-2C22,8.897,21.103,8,20,8z M4,10h2v9H4V10z M20,11.819L17.307,19H8V9.362L12.468,4l1.146,0 l-1.562,4.683c-0.103,0.305-0.051,0.64,0.137,0.901C12.377,9.846,12.679,10,13,10h7V11.819z"/>
			</svg>',
			'award' => '<svg class="mbfp-icon" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
				<path d="M5,8.999c0,1.902,0.765,3.627,2,4.89V21c0,0.347,0.18,0.668,0.474,0.851c0.295,0.184,0.664,0.198,0.973,0.044L12,20.118 l3.553,1.776C15.694,21.965,15.847,22,16,22c0.183,0,0.365-0.05,0.525-0.149C16.82,21.668,17,21.347,17,21v-7.11 c1.235-1.263,2-2.988,2-4.891C19,5.14,15.86,2,12,2S5,5.14,5,8.999z M12.447,18.105c-0.281-0.141-0.613-0.141-0.895,0L9,19.382 v-4.067C9.911,15.749,10.926,16,12,16s2.089-0.25,3-0.685v4.066L12.447,18.105z M12,4c2.756,0,5,2.242,5,4.999 C17,11.757,14.757,14,12,14c-2.757,0-5-2.243-5-5.001C7,6.242,9.243,4,12,4z"/>
			</svg>',
		];
	}
	public static function get_svg( $name ) {
		$list = [
			'heart'  => '<path d="M12,4.595c-1.104-1.006-2.512-1.558-3.996-1.558c-1.578,0-3.072,0.623-4.213,1.758c-2.353,2.363-2.352,6.059,0.002,8.412 l7.332,7.332c0.17,0.299,0.498,0.492,0.875,0.492c0.322,0,0.609-0.163,0.792-0.409l7.415-7.415 c2.354-2.354,2.354-6.049-0.002-8.416c-1.137-1.131-2.631-1.754-4.209-1.754C14.513,3.037,13.104,3.589,12,4.595z M18.791,6.205 c1.563,1.571,1.564,4.025,0.002,5.588L12,18.586l-6.793-6.793C3.645,10.23,3.646,7.776,5.205,6.209 c0.76-0.756,1.754-1.172,2.799-1.172s2.035,0.416,2.789,1.17l0.5,0.5c0.391,0.391,1.023,0.391,1.414,0l0.5-0.5 C14.719,4.698,17.281,4.702,18.791,6.205z"/>',
			'star'   => '<path d="M6.516,14.323l-1.49,6.452c-0.092,0.399,0.068,0.814,0.406,1.047C5.603,21.94,5.801,22,6,22 c0.193,0,0.387-0.056,0.555-0.168L12,18.202l5.445,3.63c0.348,0.232,0.805,0.223,1.145-0.024c0.338-0.247,0.487-0.68,0.372-1.082 l-1.829-6.4l4.536-4.082c0.297-0.268,0.406-0.686,0.278-1.064c-0.129-0.378-0.47-0.644-0.868-0.676L15.378,8.05l-2.467-5.461 C12.75,2.23,12.393,2,12,2s-0.75,0.23-0.911,0.589L8.622,8.05L2.921,8.503C2.529,8.534,2.192,8.791,2.06,9.16 c-0.134,0.369-0.038,0.782,0.242,1.056L6.516,14.323z M9.369,9.997c0.363-0.029,0.683-0.253,0.832-0.586L12,5.43l1.799,3.981 c0.149,0.333,0.469,0.557,0.832,0.586l3.972,0.315l-3.271,2.944c-0.284,0.256-0.397,0.65-0.293,1.018l1.253,4.385l-3.736-2.491 c-0.336-0.225-0.773-0.225-1.109,0l-3.904,2.603l1.05-4.546c0.078-0.34-0.026-0.697-0.276-0.94l-3.038-2.962L9.369,9.997z"/>',
			'pin'    => '<path d="M12,22l1-2v-3h5c0.553,0,1-0.447,1-1v-1.586c0-0.526-0.214-1.042-0.586-1.414L17,11.586V8c0.553,0,1-0.447,1-1V4 c0-1.103-0.897-2-2-2H8C6.897,2,6,2.897,6,4v3c0,0.553,0.448,1,1,1v3.586L5.586,13C5.213,13.372,5,13.888,5,14.414V16 c0,0.553,0.448,1,1,1h5v3L12,22z M8,4h8v2H8V4z M7,14.414l1.707-1.707C8.895,12.52,9,12.266,9,12V8h6v4 c0,0.266,0.105,0.52,0.293,0.707L17,14.414V15H7V14.414z"/>',
			'like'   => '<path d="M20,8h-5.612l1.123-3.367c0.202-0.608,0.1-1.282-0.275-1.802S14.253,2,13.612,2H12c-0.297,0-0.578,0.132-0.769,0.36 L6.531,8H4c-1.103,0-2,0.897-2,2v9c0,1.103,0.897,2,2,2h3h10.307c0.829,0,1.581-0.521,1.873-1.298l2.757-7.351 C21.979,12.239,22,12.12,22,12v-2C22,8.897,21.103,8,20,8z M4,10h2v9H4V10z M20,11.819L17.307,19H8V9.362L12.468,4l1.146,0 l-1.562,4.683c-0.103,0.305-0.051,0.64,0.137,0.901C12.377,9.846,12.679,10,13,10h7V11.819z"/>',
			'award'  => '<path d="M5,8.999c0,1.902,0.765,3.627,2,4.89V21c0,0.347,0.18,0.668,0.474,0.851c0.295,0.184,0.664,0.198,0.973,0.044L12,20.118 l3.553,1.776C15.694,21.965,15.847,22,16,22c0.183,0,0.365-0.05,0.525-0.149C16.82,21.668,17,21.347,17,21v-7.11 c1.235-1.263,2-2.988,2-4.891C19,5.14,15.86,2,12,2S5,5.14,5,8.999z M12.447,18.105c-0.281-0.141-0.613-0.141-0.895,0L9,19.382 v-4.067C9.911,15.749,10.926,16,12,16s2.089-0.25,3-0.685v4.066L12.447,18.105z M12,4c2.756,0,5,2.242,5,4.999 C17,11.757,14.757,14,12,14c-2.757,0-5-2.243-5-5.001C7,6.242,9.243,4,12,4z"/>',
			'hearts' => '<path d="M20.205,4.791c-1.137-1.131-2.631-1.754-4.209-1.754c-1.483,0-2.892,0.552-3.996,1.558 c-1.104-1.006-2.512-1.558-3.996-1.558c-1.578,0-3.072,0.623-4.213,1.758c-2.353,2.363-2.352,6.059,0.002,8.412L12,21.414 l8.207-8.207C22.561,10.854,22.562,7.158,20.205,4.791z"/>',
			'stars'  => '<path d="M21.947,9.179c-0.129-0.378-0.47-0.645-0.868-0.676L15.378,8.05l-2.467-5.461C12.75,2.23,12.393,2,12,2	s-0.75,0.23-0.911,0.588L8.622,8.05L2.921,8.503C2.53,8.534,2.193,8.791,2.06,9.16s-0.039,0.782,0.242,1.056l4.213,4.107	l-1.49,6.452c-0.092,0.399,0.069,0.814,0.406,1.047C5.603,21.94,5.801,22,6,22c0.193,0,0.387-0.056,0.555-0.168L12,18.202	l5.445,3.63c0.348,0.232,0.805,0.223,1.145-0.024c0.338-0.247,0.487-0.68,0.372-1.082l-1.829-6.4l4.536-4.082	C21.966,9.976,22.075,9.558,21.947,9.179z"/>',
			'pins'   => '<path d="M15,11.586V6h2V4c0-1.104-0.896-2-2-2H9C7.896,2,7,2.896,7,4v2h2v5.586l-2.707,1.707C6.105,13.48,6,13.734,6,14v2 c0,0.553,0.448,1,1,1h2h2v3l1,2l1-2v-3h4c0.553,0,1-0.447,1-1v-2c0-0.266-0.105-0.52-0.293-0.707L15,11.586z"/>',
			'likes'  => '<path d="M4 21h1V8H4c-1.104 0-2 .896-2 2v9C2 20.104 2.896 21 4 21zM20 8h-7l1.122-3.368C14.554 3.337 13.59 2 12.225 2H12L7 7.438V21h11l3.912-8.596C21.937 12.291 21.976 12.114 22 12v-2C22 8.896 21.104 8 20 8z"/>',
			'awards' => '<path d="M5 8.999c0 2.318 1.138 4.371 2.879 5.646l.001.001c.569.416 1.201.749 1.881.979.017.006.034.013.051.019.316.104.643.185.977.243.062.011.124.02.186.028C11.311 15.966 11.65 16 11.999 16 12 16 12 16 12 16c0 0 0 0 0 0 .35 0 .69-.034 1.027-.084.061-.009.121-.018.182-.028.336-.059.664-.139.981-.243.015-.005.028-.011.042-.016C17 14.693 19 12.078 19 8.999 19 5.14 15.86 2 12 2S5 5.14 5 8.999zM12 4c2.756 0 5 2.242 5 4.999h-2C15 7.346 13.654 6 12 6V4zM7.521 16.795l0 5.205L12 20.5l4.479 1.5.001-5.205C15.158 17.557 13.632 18 12 18 10.369 18 8.841 17.557 7.521 16.795z"/>',
		];
		return $list[ $name ];
	}
}
