<?php
namespace MetaBox\FavoritePosts;

class Renderer {
	private $assets;

	public function __construct( Assets $assets ) {
		$this->assets = $assets;
		add_filter( 'the_content', [ $this, 'render' ] );
	}

	public function render( $content ) {
		$part = '';

		$dashboard_page      = Settings::get( 'dashboard_page' );
		$register_page       = Settings::get( 'register_page' );
		$allow_non_logged_in = Settings::get( 'non_logged_in' );

		if ( $dashboard_page && is_page( $dashboard_page ) ) {
			$part = is_user_logged_in() || $allow_non_logged_in ? 'posts' : 'login';
		}
		if ( $register_page && is_page( $register_page ) ) {
			$part = 'register';
		}

		if ( ! $part ) {
			return $content;
		}

		$this->assets->enqueue();

		ob_start();
		$template_loader = new TemplateLoader;
		$template_loader->get_template_part( $part );
		return $content . ob_get_clean();
	}
}
