<?php
namespace MetaBox\FavoritePosts\Migrate;

class Count {
	public function migrate() {
		$mbfp_posts = $this->get_meta_values();
		if ( empty( $mbfp_posts ) ) {
			return;
		}

		foreach ( $mbfp_posts as $value ) {
			$favorited = unserialize( $value->meta_value );
			foreach ( $favorited as $post_id ) {
				$post_count[ $post_id ][] = $value->user_id;
			}
		}

		foreach ( $post_count as $post_id => $count ) {
			update_post_meta( $post_id, 'mbfp_count', $count );
		}
	}

	public function get_meta_values() {
		global $wpdb;

		$result = $wpdb->get_results( "SELECT * FROM {$wpdb->usermeta} WHERE meta_key = 'mbfp_posts'" );
		return $result;
	}
}
