<?php
namespace MetaBox\FavoritePosts;

class Helper {
	public static function get_favorites() {
		$favorites = ! empty( $_COOKIE['mbfp_posts'] ) ? json_decode( $_COOKIE['mbfp_posts'] ) : [];
		if ( is_user_logged_in() ) {
			$favorites = get_user_meta( get_current_user_id(), 'mbfp_posts', true );
		}

		$favorites = (array) $favorites;

		$favorites = self::remove_deleted_posts( $favorites );
		if ( is_user_logged_in() ) {
			update_user_meta( get_current_user_id(), 'mbfp_posts', $favorites );
		} else {
			ob_start();
			$expired = apply_filters( 'mbfp_cookie_expiration', Settings::get( 'cookie_expiration' ) . ' days' ) ?: '+1 month';
			setcookie( 'mbfp_posts', json_encode( $favorites ), strtotime( $expired ), COOKIEPATH, COOKIE_DOMAIN );
			ob_get_clean();
		}

		return $favorites;
	}

	private static function remove_deleted_posts( $favorites ) {
		return array_filter( $favorites, function( $post_id ) {
			return $post_id && get_post_status( $post_id );
		} );
	}

	public static function get_count( $post_id ) {
		$count = get_post_meta( $post_id, 'mbfp_count', true );
		return ! empty( $count ) ? count( $count ) : 0;
	}
}
