<?php
namespace MetaBox\FavoritePosts;

class Content {
	private $button;
	private $assets;

	public function __construct( Button $button, Assets $assets ) {
		$this->button = $button;
		$this->assets = $assets;
		add_filter( 'the_content', [ $this, 'render' ] );
	}

	public function render( $content ) {
		if ( ! $this->is_enabled() ) {
			return $content;
		}

		$html = $this->button->get_html();
		if ( ! $html ) {
			return $content;
		}
		$this->assets->enqueue();

		$position = Settings::get( 'position' );

		if ( 'before' === $position ) {
			$content = $html . $content;
		} elseif ( 'after' === $position ) {
			$content .= $html;
		} elseif ( 'both' === $position ) {
			$content = $html . $content . $html;
		}

		return $content;
	}

	private function is_enabled() {
		$dashboard_page = Settings::get( 'dashboard_page' );
		$register_page  = Settings::get( 'register_page' );
		$post_types     = Settings::get( 'post_types' );
		if ( empty( $post_types ) || is_page( [ $dashboard_page, $register_page ] ) ) {
			return false;
		}
		return is_singular( $post_types );
	}
}
