<?php
namespace MetaBox\FavoritePosts;

class Button {
	public function get_html( $atts = [] ) {
		$id = $atts['id'] ?? get_the_ID();

		$icon        = $atts['icon'] ?? Settings::get( 'icon' );
		$icon_suffix = $this->is_added( $id ) ? 's' : '';
		$icon_size   = $atts['icon_size'] ?? Settings::get( 'icon_size' );

		$add       = $atts['add'] ?? Settings::get( 'button_text' );
		$added     = $atts['added'] ?? Settings::get( 'button_added_text' );
		$font_size = $atts['font_size'] ?? Settings::get( 'font_size' );
		$class     = $this->is_added( $id ) ? 'mbfp-btn--added' : '';
		$class    .= ' ' . ( $atts['class'] ?? '' );

		$btn_color              = Settings::get( 'btn_color' );
		$text_color             = Settings::get( 'text_color' );
		$icon_color             = Settings::get( 'icon_color' );
		$btn_radius             = Settings::get( 'btn_radius' );
		$btn_horizontal_padding = Settings::get( 'btn_horizontal_padding' );
		$btn_vertical_padding   = Settings::get( 'btn_vertical_padding' );
		$btn_padding            = $btn_vertical_padding . 'px ' . $btn_horizontal_padding . 'px ';

		if ( isset( $atts['show_icon'] ) ) {
			$show_icon = $atts['show_icon'] === 'true';
		} else {
			$show_icon = Settings::get( 'show_icon' );
		}

		if ( isset( $atts['icon_only'] ) ) {
			$icon_only = $atts['icon_only'] === 'true';
		} else {
			$icon_only = Settings::get( 'icon_only' );
		}

		if ( isset( $atts['show_count'] ) ) {
			$show_count = $atts['show_count'] === 'true';
		} else {
			$show_count = Settings::get( 'show_count' );
		}

		ob_start();
		?>
		<div
			class="mbfp-btn <?= esc_attr( $class ) ?>"
			data-id="<?= esc_attr( $id ) ?>"
			data-added="<?= esc_attr( $added ) ?>"
			data-add="<?= esc_attr( $add ) ?>"
			data-icon="<?= esc_attr( $icon ) ?>"
			data-iconsize="<?= esc_attr( $icon_size ) ?>"
			style="background: <?= esc_attr( $btn_color ) ?>; border-radius: <?= esc_attr( $btn_radius ) ?>px; padding: <?= esc_attr( $btn_padding ) ?>; font-size: <?= esc_attr( $font_size ) ?>px "
		>
			<?= $show_icon ?
				'<svg class="mbfp-icon" xmlns="http://www.w3.org/2000/svg" width="' . $icon_size . '" height="' . $icon_size . '" viewBox="0 0 24 24" style="fill: ' . esc_attr( $icon_color ) . '">
					' . Settings::get_svg( $icon . $icon_suffix ) . '
				</svg>'
			 : '' ?>

			<div class="mbfp-text" style="color: <?= esc_attr( $text_color ) ?>">
				<?= $icon_only ? '' : '<span class="mbfp-text-detail margin-left">' . wp_kses_post( $this->is_added( $id ) ? $added : $add ) . '</span>' ?>
				<?= $show_count ? '<span class="mbfp-count margin-left">' . Helper::get_count( $id ) . '</span>' : '' ?>
			</div>
		</div>
		<?php
		return ob_get_clean();
	}

	private function is_added( $id ) {
		$favorites = Helper::get_favorites();
		if ( empty( $favorites ) ) {
			return false;
		}

		return in_array( $id, $favorites );
	}
}
