<?php
namespace MetaBox\FavoritePosts;

class Ajax {
	public function __construct() {
		add_action( 'wp_ajax_mbfp_add', [ $this, 'add' ] );
		add_action( 'wp_ajax_nopriv_mbfp_add', [ $this, 'add' ] );
		add_action( 'wp_ajax_mbfp_delete', [ $this, 'delete' ] );
		add_action( 'wp_ajax_nopriv_mbfp_delete', [ $this, 'delete' ] );
	}

	public function add() {
		check_ajax_referer( 'add_to_favorites' );

		$post_id = rwmb_request()->filter_post( 'id', FILTER_VALIDATE_INT );

		if ( empty( $post_id ) ) {
			wp_send_json_error( __( 'No post is added', 'mb-favorite-posts' ) );
		}

		$favorites = Helper::get_favorites();

		$limit = (int) apply_filters( 'mbfp_limit', Settings::get( 'limit' ) );
		if ( $limit && count( $favorites ) >= $limit ) {
			wp_send_json_error( __( 'You have reached the maximum number of favorite posts', 'mb-favorite-posts' ) );
		}

		$favorites[] = $post_id;

		$this->update( $favorites );
		$this->update_postmeta( $post_id, 'add' );
		$data               = [];
		$data['count']      = Helper::get_count( $post_id );
		$data['icon_color'] = Settings::get( 'icon_color' );
		wp_send_json_success( $data );
	}

	public function delete() {
		check_ajax_referer( 'delete_from_favorites' );
		$post_id = isset( $_POST['id'] ) ? intval( $_POST['id'] ) : '';
		if ( empty( $post_id ) ) {
			wp_send_json_error( __( 'No post to delete', 'mb-favorite-posts' ) );
		}
		$deleted_post = [ $post_id ];
		$favorites    = Helper::get_favorites();
		$favorites    = array_diff( $favorites, $deleted_post );
		$favorites    = array_values( $favorites );

		$this->update( $favorites );
		$this->update_postmeta( $post_id, 'delete' );

		$data               = [];
		$data['count']      = Helper::get_count( $post_id );
		$data['icon_color'] = Settings::get( 'icon_color' );
		if ( empty( $favorites ) ) {
			$data['empty_notice'] = __( 'You haven\'t added any posts yet', 'mb-favorite-posts' );
		}
		wp_send_json_success( $data );
	}

	public function update( $favorites ) {
		if ( is_user_logged_in() ) {
			update_user_meta( get_current_user_id(), 'mbfp_posts', $favorites );
		} else {
			setcookie( 'mbfp_posts', json_encode( $favorites ), strtotime( '+1 month' ), COOKIEPATH, COOKIE_DOMAIN );
		}
	}

	public function update_postmeta( $post_id, $action ) {
		$count = get_post_meta( $post_id, 'mbfp_count', true );

		if ( empty( $count ) ) {
			$count = [];
		}

		if ( 'add' === $action ) {
			$count[] = get_current_user_id();
			update_post_meta( $post_id, 'mbfp_count', $count );
		}

		if ( 'delete' === $action ) {
			update_post_meta( $post_id, 'mbfp_count', array_diff( $count, [ get_current_user_id() ] ) );
		}
	}
}
