<?php
namespace MetaBox\FavoritePosts;

class AdminColumn {
	public function __construct() {
		$post_types = Settings::get( 'post_types' );

		foreach ( $post_types as $type ) {
			add_filter( "manage_{$type}_posts_columns", [ $this, 'register_admin_column' ] );
			add_action( "manage_{$type}_posts_custom_column", [ $this, 'customize_admin_column' ], 10, 2 );
		}
	}

	public function register_admin_column( $columns ) {
		return array_merge( $columns, [ 'mbfp_count' => __( 'Total favorites', 'mb-favorite-posts' ) ] );
	}
	public function customize_admin_column( $column_key, $post_id ) {
		if ( 'mbfp_count' === $column_key ) {
			echo Helper::get_count( $post_id );
		}
	}

}
