<?php
/**
 * Plugin Name: MB Favorite Posts
 * Description: Easily create list of your favorite posts, pages or any post types.
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * Plugin URI:  https://metabox.io/plugins/mb-favorite-posts/
 * Version:     2.0.8
 * Text Domain: mb-favorite-posts
 * Domain Path: languages
 *
 * @package MB Favorite Posts
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || die;

if ( ! function_exists( 'mbfp_load' ) ) {
	// Hook priority 1 to load MB User Profile with priority 5.
	add_action( 'init', 'mbfp_load', 1 );

	function mbfp_load() {
		if ( ! defined( 'RWMB_VER' ) ) {
			return;
		}

		if ( file_exists( __DIR__ . '/vendor' ) ) {
			require __DIR__ . '/vendor/autoload.php';
			require __DIR__ . '/vendor/meta-box/mb-settings-page/mb-settings-page.php';
			require __DIR__ . '/vendor/meta-box/mb-user-profile/mb-user-profile.php';
		} else {
			require dirname( __DIR__ ) . '/mb-settings-page/mb-settings-page.php';
			require dirname( __DIR__ ) . '/mb-user-profile/mb-user-profile.php';
		}

		define( 'MBFP_PATH', __DIR__ );
		list( , $url ) = RWMB_Loader::get_path( __DIR__ );
		define( 'MBFP_URL', $url );

		new MetaBox\FavoritePosts\Migrate\Manager;

		load_plugin_textdomain( 'mb-favorite-posts', false, basename( __DIR__ ) . '/languages' );

		$button = new MetaBox\FavoritePosts\Button;
		$assets = new MetaBox\FavoritePosts\Assets;

		new MetaBox\FavoritePosts\Settings;
		new MetaBox\FavoritePosts\UserFields;
		new MetaBox\FavoritePosts\Shortcodes( $button, $assets );
		new MetaBox\FavoritePosts\Content( $button, $assets );
		new MetaBox\FavoritePosts\Renderer( $assets );
		new MetaBox\FavoritePosts\Ajax;
	}
}
