( function( $ ) {
	'use strict';

	const base = '.mbfp-settings ';

	const settings = {
		btnText: $( '#button_text' ),
		btnAddedText: $( '#button_added_text' ),
		btnColor: $( '#btn_color' ),
		textColor: $( '#text_color' ),

		showCount: $( '#show_count' ),
		fontSize: $( '#font_size' ),
		btnRadius: $( '#btn_radius' ),
		horiPadding: $( '#btn_horizontal_padding' ),
		vertiPadding: $( '#btn_vertical_padding' ),

		showIcon: $( '#show_icon' ),
		iconOnly: $( '#icon_only' ),
		icon: $( 'input[name="icon"]' ),
		iconColor: $( '#icon_color' ),
		iconSize: $( '#icon_size' ),
	};
	const preview = {
		block: $( '.style-preview .mbfp-block' ),
		text: $( '.style-preview .mbfp-review-text' ),
		icon: $( '.style-preview .mbfp-review-icon' ),
		count: $( '.style-preview .mbfp-review-count' )
	};

	function getIcon( iconName, iconSize ) {
		let listIcons = {
			'heart': '<path d="M12,4.595c-1.104-1.006-2.512-1.558-3.996-1.558c-1.578,0-3.072,0.623-4.213,1.758c-2.353,2.363-2.352,6.059,0.002,8.412 l7.332,7.332c0.17,0.299,0.498,0.492,0.875,0.492c0.322,0,0.609-0.163,0.792-0.409l7.415-7.415 c2.354-2.354,2.354-6.049-0.002-8.416c-1.137-1.131-2.631-1.754-4.209-1.754C14.513,3.037,13.104,3.589,12,4.595z M18.791,6.205 c1.563,1.571,1.564,4.025,0.002,5.588L12,18.586l-6.793-6.793C3.645,10.23,3.646,7.776,5.205,6.209 c0.76-0.756,1.754-1.172,2.799-1.172s2.035,0.416,2.789,1.17l0.5,0.5c0.391,0.391,1.023,0.391,1.414,0l0.5-0.5 C14.719,4.698,17.281,4.702,18.791,6.205z"/>',
			'star': '<path d="M6.516,14.323l-1.49,6.452c-0.092,0.399,0.068,0.814,0.406,1.047C5.603,21.94,5.801,22,6,22 c0.193,0,0.387-0.056,0.555-0.168L12,18.202l5.445,3.63c0.348,0.232,0.805,0.223,1.145-0.024c0.338-0.247,0.487-0.68,0.372-1.082 l-1.829-6.4l4.536-4.082c0.297-0.268,0.406-0.686,0.278-1.064c-0.129-0.378-0.47-0.644-0.868-0.676L15.378,8.05l-2.467-5.461 C12.75,2.23,12.393,2,12,2s-0.75,0.23-0.911,0.589L8.622,8.05L2.921,8.503C2.529,8.534,2.192,8.791,2.06,9.16 c-0.134,0.369-0.038,0.782,0.242,1.056L6.516,14.323z M9.369,9.997c0.363-0.029,0.683-0.253,0.832-0.586L12,5.43l1.799,3.981 c0.149,0.333,0.469,0.557,0.832,0.586l3.972,0.315l-3.271,2.944c-0.284,0.256-0.397,0.65-0.293,1.018l1.253,4.385l-3.736-2.491 c-0.336-0.225-0.773-0.225-1.109,0l-3.904,2.603l1.05-4.546c0.078-0.34-0.026-0.697-0.276-0.94l-3.038-2.962L9.369,9.997z"/>',
			'like': '<path d="M20,8h-5.612l1.123-3.367c0.202-0.608,0.1-1.282-0.275-1.802S14.253,2,13.612,2H12c-0.297,0-0.578,0.132-0.769,0.36 L6.531,8H4c-1.103,0-2,0.897-2,2v9c0,1.103,0.897,2,2,2h3h10.307c0.829,0,1.581-0.521,1.873-1.298l2.757-7.351 C21.979,12.239,22,12.12,22,12v-2C22,8.897,21.103,8,20,8z M4,10h2v9H4V10z M20,11.819L17.307,19H8V9.362L12.468,4l1.146,0 l-1.562,4.683c-0.103,0.305-0.051,0.64,0.137,0.901C12.377,9.846,12.679,10,13,10h7V11.819z"/>',
			'pin': '<path d="M12,22l1-2v-3h5c0.553,0,1-0.447,1-1v-1.586c0-0.526-0.214-1.042-0.586-1.414L17,11.586V8c0.553,0,1-0.447,1-1V4 c0-1.103-0.897-2-2-2H8C6.897,2,6,2.897,6,4v3c0,0.553,0.448,1,1,1v3.586L5.586,13C5.213,13.372,5,13.888,5,14.414V16 c0,0.553,0.448,1,1,1h5v3L12,22z M8,4h8v2H8V4z M7,14.414l1.707-1.707C8.895,12.52,9,12.266,9,12V8h6v4 c0,0.266,0.105,0.52,0.293,0.707L17,14.414V15H7V14.414z"></path>',
			'award': '<path d="M5,8.999c0,1.902,0.765,3.627,2,4.89V21c0,0.347,0.18,0.668,0.474,0.851c0.295,0.184,0.664,0.198,0.973,0.044L12,20.118 l3.553,1.776C15.694,21.965,15.847,22,16,22c0.183,0,0.365-0.05,0.525-0.149C16.82,21.668,17,21.347,17,21v-7.11 c1.235-1.263,2-2.988,2-4.891C19,5.14,15.86,2,12,2S5,5.14,5,8.999z M12.447,18.105c-0.281-0.141-0.613-0.141-0.895,0L9,19.382 v-4.067C9.911,15.749,10.926,16,12,16s2.089-0.25,3-0.685v4.066L12.447,18.105z M12,4c2.756,0,5,2.242,5,4.999 C17,11.757,14.757,14,12,14c-2.757,0-5-2.243-5-5.001C7,6.242,9.243,4,12,4z"></path>',
		};

		return '<svg class="mbfp-icon" xmlns="http://www.w3.org/2000/svg" width="' + iconSize + '" height="' + iconSize + '" viewBox="0 0 24 24">' + listIcons[ iconName ] + '</svg>';
	}
	let chosenStyle = $( base + '.pre-built-styles ul li input[name=pre_built_style]:checked' ).val();

	if ( chosenStyle ) {
		stylePreview( chosenStyle );
	}

	$( base + '.pre-built-styles ul li' ).on( 'click', function() {
		let style = $( this ).find( 'input[name=pre_built_style]' ).val();
		setStyle( style );
		stylePreview( style );

	} );
	function stylePreview( style ) {
		preview.text.removeClass( 'margin-left margin-right' );

		if ( 'default' == style ) {
			preview.block.css( { 'background': '#2ABA66', 'color': '#fff', 'border-radius': '4px', 'padding': '6px 12px' } );
			preview.text.addClass( 'margin-left margin-right' );
			preview.icon.html( getIcon( 'heart', 16 ) );
			preview.icon.css( { 'fill': '#fff' } );
			preview.count.html( '(1)' );

			if ( settings.btnText.val().length === 0 ) {
				settings.btnText.val( 'Add to Favorites' );
			}

			if ( settings.btnAddedText.val().length === 0 ) {
				settings.btnAddedText.val( 'Add to Favorites' );
			}
		}
		if ( 'like' == style ) {
			preview.block.css( { 'background': 'transparent', 'color': '', 'border-radius': '', 'padding': '' } );
			preview.text.addClass( 'margin-left' );
			preview.icon.html( getIcon( 'like', 16 ) );
			preview.icon.css( { 'fill': '#2ABA66' } );
			preview.count.html( '' );

			if ( settings.btnText.val().length === 0 ) {
				settings.btnText.val( 'Like' );
			}

			if ( settings.btnAddedText.val().length === 0 ) {
				settings.btnAddedText.val( 'Like' );
			}
			
		}
		if ( 'rounded' == style ) {
			preview.block.css( { 'background': '', 'color': '', 'border-radius': '', 'padding': '12px' } );
			preview.icon.html( getIcon( 'star', 16 ) );
			preview.icon.css( { 'fill': '#fff' } );
			preview.count.html( '' );

			if ( settings.btnText.val().length === 0 ) {
				settings.btnText.val( '' );
			}

			if ( settings.btnAddedText.val().length === 0 ) {
				settings.btnAddedText.val( '' );
			}
			
		}

		// get set value
		let btnText 	= settings.btnText.val();
		let btnColor	= settings.btnColor.val();
		let textColor	= settings.textColor.val();
		let showCount	= settings.showCount.prop( 'checked' );
		let btnRadius	= settings.btnRadius.val();
		let fontSize	= settings.fontSize.val();
		let horiPadding	= settings.horiPadding.val();
		let vertiPadding = settings.vertiPadding.val();

		let showIcon	= settings.showIcon.prop( 'checked' );
		let iconOnly	= settings.iconOnly.prop( 'checked' );
		let icon 		= settings.icon.filter( ':checked' ).val();
		let iconColor	= settings.iconColor.val();
		let iconSize	= settings.iconSize.val();

		if ( 0 === iconSize.length ) {
			iconSize = 16;
		}

		preview.block.css( { 'background': btnColor, 'color': textColor, 'border-radius': btnRadius + 'px', 'padding': vertiPadding + 'px ' + horiPadding + 'px ', 'font-size': fontSize + 'px' } );
		preview.icon.css( { 'fill': iconColor } );
		if ( showCount ) {
			preview.count.html( '(1)' );
		}
		if ( showIcon ) {
			preview.icon.html( getIcon( icon, iconSize ) );
		}
		if ( btnText && !iconOnly && ( 'rounded' != style ) ) {
			preview.text.html( btnText );
		}

		// live preview
		settings.btnText.on( 'change', function() {
			if ( 0 === $( this ).val().length ) {
				return;
			}
			btnText = $( this ).val();
			if ( 'rounded' != style ) {
				preview.text.html( $( this ).val() );
			}
		} );
		settings.btnColor.on( 'change', function() {
			btnColor = $( this ).val();
			preview.block.css( { 'background': $( this ).val() } );
		} );
		if ( ! $( base + '#show_count' ).prop( 'checked' ) ) {
			preview.count.html( '' );
		}
		settings.showCount.on( 'change', function() {
			if ( ! $( base + '#show_count' ).prop( 'checked' ) ) {
				preview.count.html( '' );
			} else {
				preview.count.html( '(1)' );
			}
		} );
		settings.fontSize.on( 'change', function() {
			if ( 0 === $( this ).val().length ) {
				return;
			}
			fontSize = $( this ).val();
			preview.block.css( { 'font-size': $( this ).val() + 'px' } );
		} );
		settings.btnRadius.on( 'change', function() {
			if ( 0 === $( this ).val().length ) {
				return;
			}
			btnRadius = $( this ).val();
			preview.block.css( { 'border-radius': $( this ).val() + 'px' } );
		} );
		settings.horiPadding.on( 'change', function() {
			if ( 0 === $( this ).val().length ) {
				return;
			}
			horiPadding = $( this ).val();
			preview.block.css( { 'padding': vertiPadding + 'px ' + horiPadding + 'px ' } );
		} );
		settings.vertiPadding.on( 'change', function() {
			if ( 0 === $( this ).val().length ) {
				return;
			}
			vertiPadding = $( this ).val();
			preview.block.css( { 'padding': vertiPadding + 'px ' + horiPadding + 'px ' } );
		} );

		if ( ! settings.showIcon.prop( 'checked' ) ) {
			preview.icon.html( '' );
		}
		settings.showIcon.on( 'change', function() {
			if ( ! settings.showIcon.prop( 'checked' ) ) {
				preview.icon.html( '' );
			} else {
				preview.icon.html( getIcon( icon, iconSize ) );
			}
		} );
		if ( settings.iconOnly.prop( 'checked' ) ) {
			preview.text.html( '' );
		}
		settings.iconOnly.on( 'change', function() {
			if ( settings.iconOnly.prop( 'checked' ) ) {
				preview.text.html( '' );
			} else {
				preview.text.html( btnText );
			}
		} );
		settings.icon.on( 'click', function() {
			icon = $( this ).val();
			preview.icon.html( getIcon( icon, iconSize ) );
		} );
		settings.iconSize.on( 'change', function() {
			if ( 0 === $( this ).val().length ) {
				return;
			}
			iconSize = $( this ).val();

			if ( ! settings.showIcon.prop( 'checked' ) ) {
				preview.icon.html( '' );
			} else {
				preview.icon.html( getIcon( icon, iconSize ) );
			}
		} );
	}
	function setStyle( style ) {
		//reset style
		settings.btnText.val( '' );
		settings.btnAddedText.val( '' );
		settings.btnColor.val( '#2ABA66' );
		settings.textColor.val( '#fff' );
		settings.btnColor.wpColorPicker( 'color', '#2ABA66' );
		settings.textColor.wpColorPicker( 'color', '#ffffff' );
		settings.showCount.prop( 'checked', false );
		settings.btnRadius.val( '' );
		settings.horiPadding.val( '' );
		settings.vertiPadding.val( '' );
		settings.iconOnly.prop( 'checked', false );
		settings.iconColor.wpColorPicker( 'color', '#ffffff' );

		if ( 'default' == style ) {
			settings.btnText.val( 'Add to Favorites' );
			settings.btnAddedText.val( 'Added to Favorites' );
			settings.btnColor.val( '#2ABA66' );
			settings.textColor.val( '#ffffff' );
			settings.showCount.prop( 'checked', true );
			settings.btnRadius.val( 4 );
			settings.horiPadding.val( 12 );
			settings.vertiPadding.val( 6 );

			settings.iconOnly.prop( 'checked', false );
			settings.icon.filter( '[value=heart]' ).prop( 'checked', true );

		}
		if ( 'like' == style ) {
			settings.btnText.val( 'Like' );
			settings.btnAddedText.val( 'Liked' );

			settings.btnColor.val( 'rgba(255,255,255,0)' );
			settings.btnColor.wpColorPicker( 'color', 'rgba(255,255,255,0)' );
			settings.textColor.val( '#000000' );
			settings.textColor.wpColorPicker( 'color', '#000000' );
			settings.showCount.prop( 'checked', false );

			settings.iconOnly.prop( 'checked', false );
			$( base + '.list-icons .rwmb-radio' ).filter( '[value=like]' ).prop( 'checked', true );
			settings.iconColor.val( '#2ABA66' );
			settings.iconColor.wpColorPicker( 'color', '#2ABA66' );
		}
		if ( 'rounded' == style ) {
			settings.showCount.prop( 'checked', false );
			settings.btnRadius.val( 50 );
			settings.horiPadding.val( 12 );
			settings.vertiPadding.val( 12 );

			settings.iconOnly.prop( 'checked', true );
			$( base + '.list-icons .rwmb-radio' ).filter( '[value=like]' ).prop( 'checked', true );
		}
	}

	// preview color when user change
	settings.btnColor.data( 'alpha-enabled', true );
	settings.btnColor.wpColorPicker( {
		change: function( event, ui ) {
			let color = ui.color.toCSS( 'rgb', ui.color.a() );
			preview.block.css( { 'background': color } );
		}
	} );
	settings.textColor.wpColorPicker( {
		change: function( event, ui ) {
			let color = ui.color.toString();
			preview.block.css( { 'color': color } );
		}
	} );
	settings.iconColor.wpColorPicker( {
		change: function( event, ui ) {
			let color = ui.color.toString();
			preview.icon.css( { 'fill': color } );
		}
	} );
}( jQuery ) );