<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$style            = isset( $mart_list_data['style'] ) ? $mart_list_data['style'] : 'sml-s1';
$sort             = isset( $mart_list_data['sort'] ) ? $mart_list_data['sort'] : 'asc';
$msl_items        = isset( $mart_list_data['msl_items'] ) ? $mart_list_data['msl_items'] : array();
$msl_items_number = isset( $mart_list_data['msl_items_number'] ) ? $mart_list_data['msl_items_number'] : 0;

Penci_Smart_Lists_Helper::render_start_sml_div( $mart_list_data, $mart_list_style );
Penci_Smart_Lists_Helper::render_before_sml_wrap_slider( $style, $sort, true );

$current_number = 0;
foreach ( $msl_items as $item_key => $msl_item ) {
	echo '<div class="penci-sml-item">';
	$current_number = Penci_Smart_Lists_Helper::add_number_order( $current_number, $msl_items_number, $sort );
	Penci_Smart_Lists_Helper::render_image_item( $msl_item );

	echo '<div class="penci-sml-title-content">';

	$xofy = get_theme_mod( 'penci_tran_sml_pagexofy' );
	$xofy = $xofy ? $xofy : 'Page %1$s of %2$s';

	echo '<span class="penci-sml-xofy">' . sprintf( $xofy,  number_format_i18n( $current_number ) , $msl_items_number  ) . '</span>';
	Penci_Smart_Lists_Helper::render_title_item( $msl_item, $current_number );
	if( ! empty( $msl_item['content'] ) ){
		echo '<div class="penci-sml-content">' . $msl_item['content'] . '</div>';
	}
	echo '</div>';
	echo '</div>';
}
?>
<?php
Penci_Smart_Lists_Helper::render_after_sml_wrap(  true );

