<?php
/*
Plugin Name: Penci Smart Lists
Plugin URI: http://pencidesign.com/
Description: Show lists and paged posts.
Version: 1.0
Author: PenciDesign
Author URI: http://pencidesign.com/
License: GPLv2 or later
Text Domain: penci-smart-lists
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


define( 'PENCI_SMLIST_VERSION', '1.0' );
define( 'PENCI_SMLIST_DIR', plugin_dir_path( __FILE__ ) );
define( 'PENCI_SMLIST_URL', plugin_dir_url( __FILE__ ) );

if( ! class_exists( 'Penci_Smart_Lists' ) ):
class Penci_Smart_Lists{

	/**
	 * Supported post types
	 *
	 * @var array
	 */
	public static $post_types = array( 'post', 'page' );

	function __construct() {

		// Function has already run.
		static $initialized;
		if ( $initialized ) {
			return;
		}
		$initialized = true;

		self::$post_types = apply_filters( 'penci-smart-list/post_types', self::$post_types );

		$this->load_file();

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_css_js' ) );
		add_action( 'wp_head', array( $this, 'hook_wp_head' ), 9999 );
	}

	public function load_file(){

		require_once dirname( __FILE__ ) . '/lib/meta-box/meta-box.php';
		require_once dirname( __FILE__ ) . '/lib/mb-settings-page/mb-settings-page.php';
		require_once dirname(__FILE__) . '/inc/metabox.php';
		new Penci_Smart_Lists_MTB;

		require_once dirname(__FILE__) . '/inc/helper.php';
		require_once dirname(__FILE__) . '/inc/shortcode.php';

		require_once dirname(__FILE__) . '/inc/pre-content.php';
	}

	public function hook_wp_head(){
		add_filter( 'the_content', array( $this, 'the_content' ), 12 );
	}

	public function enqueue_css_js(){
		wp_enqueue_style( 'penci-smart-lists', PENCI_SMLIST_URL . 'assets/css/smart-lists.css', '' );
		 wp_add_inline_style( 'penci-smart-lists', $this->get_css() );

		if( defined( 'PENCI_PENNEWS_VERSION' ) ){
			wp_enqueue_script( 'penci-smart-lists', PENCI_SMLIST_URL . 'assets/js/smart-lists.js', array( 'jquery','penci' ), '1.0', true );
		}else{
			wp_enqueue_script( 'owl.carousel', PENCI_SMLIST_URL . 'assets/js/owl.carousel.min.js', array( 'jquery' ), '1.0', true );
			wp_enqueue_script( 'penci-smart-lists', PENCI_SMLIST_URL . 'assets/js/smart-lists.js', array( 'jquery','owl.carousel' ), '1.0', true );
		}

		$sml_next = get_theme_mod( 'penci_tran_sml_next' );
		$sml_prev = get_theme_mod( 'penci_tran_sml_prev' );
		wp_localize_script( 'penci-smart-lists', 'PENCISML', array(
			'sml_next' => $sml_next ? do_shortcode( $sml_next ) : esc_html__( 'Next', 'penci-smart-lists' ),
			'sml_prev' => $sml_prev ? do_shortcode( $sml_prev ) : esc_html__( 'Prev', 'penci-smart-lists' ),
		) );


	}

	public function the_content( $content ){

		// Skip if isset facebook instant articles for WP
		$is_fb_instant_articles = $this->is_fb_instant_articles();
		if( $is_fb_instant_articles ){
			return $content;
		}

		$post_id = get_the_ID();

		// Only run with list of post types plugin support
		$post_type_by_id = get_post_type( $post_id );
		$sp_posttype     = self::$post_types;
		if ( ! in_array( $post_type_by_id, $sp_posttype ) ) {
			return $content;
		}

		// Only run with single post and page
		if ( ! is_single( $post_id ) ) {
			return $content;
		}

		// Smart list is not enable on this post
		$enable_smlists = get_post_meta( $post_id,'penci_enable_smlists', true );
		if( ! $enable_smlists ){
			return $content;
		}

		$mart_list_data = Penci_Smart_Lists_Pre_Content::get_data( $content, $post_id );

		if ( ! isset( $mart_list_data['msl_items'] ) || ( isset( $mart_list_data['msl_items'] ) && ! $mart_list_data['msl_items'] ) ) {
			return $content;
		}

		$mart_list_style = isset( $mart_list_data['style'] ) ? $mart_list_data['style'] : 'sml-s1';

		ob_start();



		if( isset( $mart_list_data['before'] ) ){
			echo $mart_list_data['before'];
		}

		Penci_Smart_Lists_Helper::render_google_adsense( 'penci_sml_ads_before' );

		include dirname( __FILE__ ) . "/templates/{$mart_list_style}.php";

		if( isset( $mart_list_data['after'] ) ) {
			echo '<span class="penci-sml-end penci-end-' . esc_attr( $mart_list_style ) . '"></span>';
		}
		Penci_Smart_Lists_Helper::render_google_adsense( 'penci_sml_ads_after' );

		if( isset( $mart_list_data['after'] ) ){
			echo $mart_list_data['after'];
		}

		$content_sml = ob_get_clean();

		return $content_sml;
	}

	function is_fb_instant_articles() {

		// Function has already run.
		static $result;
		if ( ! is_null( $result ) ) {
			return $result;
		}else{
			$result = defined( 'IA_PLUGIN_VERSION' ) && function_exists( 'is_transforming_instant_article' ) && is_transforming_instant_article();
		}

		return $result;
	}

	public function get_css() {

		$css = '';
		$color_heading = get_theme_mod( 'penci_color_heading' );
		$color_border = get_theme_mod( 'penci_color_border' );
		$color_accent = get_theme_mod( 'penci_color_accent' );
		$color_links = get_theme_mod( 'penci_color_links' );
		
		if( $color_accent ){
			$css = '.penci-smart-list .penci-owl-carousel-style .owl-nav .owl-prev:hover,';
			$css .= '.penci-smart-list .penci-sml-nav a:hover,';
			$css .= '.penci-smart-list .penci-owl-carousel-style .owl-nav .owl-next:hover';
			$css .= '{ background-color: ' . esc_attr( $color_accent ) . ';}';
		}

		if( $color_heading ){
			$css .= '.penci-smart-list .penci-sml-nav .penci-sml-select select,';
			$css .= '.penci-sml-s16 .penci-sml-nav .penci-sml-next,';
			$css .= '.penci-sml-s16 .penci-sml-nav .penci-sml-prev';
			$css .= '{ color: ' . esc_attr( $color_heading ) . ';}';

			$css .= '.penci-smart-list .penci-sml-nav .penci-sml-select:before';
			$css .= '{ border-color: ' . esc_attr( $color_heading ) . ';}';
		}

		if( $color_border ){
			$css .= '.penci-sml-s5 .penci-sml-number-title,';
			$css .= '.penci-sml-s6 .penci-sml-item,';
			$css .= '.penci-sml-s7 .penci-sml-item,';
			$css .= '.penci-sml-s8 .penci-sml-item,';

			$css .= '.penci-sml-s9 .penci-sml-number-title,';
			$css .= '.penci-sml-s10 .penci-sml-number-title,';
			$css .= '.penci-sml-s11 .penci-sml-number-title,';
			$css .= '.penci-sml-s15 .penci-sml-item-number,';
			$css .= '.penci-sml-s16 .penci-sml-nav,';
			$css .= '.penci-smart-list + .penci-sml-end,';
			$css .= '.penci-smart-list .penci-owl-carousel-style .owl-nav .owl-next:hover';
			$css .= ' { border-color: ' . esc_attr( $color_border ) . ';}';

			$css .= '.penci-sml-box-nb .penci-sml-item-number { background-color: ' . esc_attr( $color_border ) . ';}';
		}

		return $css;
	}

}

new Penci_Smart_Lists;
endif;;