<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Penci_Smart_Lists_Shortcode' ) ):
	class Penci_Smart_Lists_Shortcode {
		private static $instance = null;

		// Function has already run.
		public static function get_instance() {
			if ( ! self::$instance ) {
				self::$instance = new self;
			}

			return self::$instance;
		}

		public function init() {
			add_action( 'admin_init', array( $this, 'init_plugin' ), 20 );
			add_action( 'after_setup_theme', array( $this, 'after_setup_theme_callback' ) );

			add_shortcode( 'penci_sml_start', array( $this, 'sml_start_callback' ) );
			add_shortcode( 'penci_sml_end', array( $this, 'sml_end_callback' ) );
		}

		public function init_plugin() {
			if ( current_user_can( 'edit_posts' ) || current_user_can( 'edit_pages' ) ) {
				add_action( 'print_media_templates', array( $this, 'print_media_templates' ) );
				add_action( 'admin_head', array( $this, 'admin_head' ) );
				add_action( 'wp_ajax_penci_sml_mce_button', array( $this, 'wp_ajax_penci_sml_mce_button' ) );
				add_filter( "mce_external_plugins", array( $this, 'mce_plugin' ) );
				add_filter( "mce_buttons", array( $this, 'mce_button' ) );
			}
		}

		public function after_setup_theme_callback(){
			add_editor_style( array( PENCI_SMLIST_URL . '/assets/css/editor-style.css' ) );
		}


		public function sml_start_callback( $atts = array(), $innercontent = '', $code = '' ) {
			return '<u class="penci-sml-start"></u>';
		}
		public function sml_end_callback( $atts = array(), $innercontent = '', $code = '' ) {
			return '<u class="penci-sml-end"></u>';
		}

		public function mce_plugin( $plugin_array ) {
			$plugin_array['penci_sml_mce'] = PENCI_SMLIST_URL.  'assets/js/mce-button-inline.js';

			return $plugin_array;
		}

		public function mce_button( $buttons ) {
			array_push( $buttons, 'penci_sml_mce_button' );

			return $buttons;
		}

		public function print_media_templates() {
			if ( ! isset( get_current_screen()->id ) || get_current_screen()->base != 'post' ) {
				return;
			}
			?>
			<script type="text/html" id="tmpl-editor-penci-sml-start">
				<div class="penci-sml-break penci-sml-break-start"><div class="title"><i class="fa fa-arrow-circle-o-down"></i><?php esc_html_e( 'Smart List Start Break','penci' ); ?></div></div>
			</script>
			<script type="text/html" id="tmpl-editor-penci-sml-end">
				<div class="penci-sml-break penci-sml-break-end"><div class="title"><i class="fa fa-arrow-circle-o-up"></i><?php esc_html_e( 'Smart List End Break','penci' ); ?></div></div>
			</script>
			<?php
		}

		public function admin_head() {
			$current_screen = get_current_screen();
			if ( ! isset( $current_screen->id ) || $current_screen->base !== 'post' ) {
				return;
			}

			wp_enqueue_script( 'penci-sml-editor-view', PENCI_SMLIST_URL.  'assets/js/editor-view.js', array( 'shortcode', 'wp-util', 'jquery' ), false, true );
		}
	}

	Penci_Smart_Lists_Shortcode::get_instance()->init();

endif;

