<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'Penci_Smart_Lists_Pre_Content' ) ):
	class Penci_Smart_Lists_Pre_Content {

		public static $config_default = array(
			'msl_items'        => array(),
			'msl_items_number' => 0,
			'enable'           => false,
			'style'            => 'sml-s1',
			'title_tag'        => 'h3',
			'sort'             => 'asc',
		);

		public static function get_data( $content = '', $post_id = null ){

			if ( ! $post_id ) {
				$post_id = get_the_ID();
			}

			$config = self::set_config( $post_id );
			$output = $config;
			self::$config_default = $config;

			// Check Smart List Start Break
			$content = explode( '<u class="penci-sml-start"></u>', $content );
			if ( isset( $content[1] ) && $content[1] ) {
				$output['before'] = isset( $content[0] ) ? $content[0] : '';
				$content          = $content[1];
			} elseif( isset( $content[0] ) && $content[0] ) {
				$content = $content[0];
			}

			// Check Smart List End Break
			$content = explode( '<u class="penci-sml-end"></u>', $content );
			if ( isset( $content[1] ) && $content[1] ) {
				$output['after'] = $content[1];
			}
			if ( isset( $content[0] ) && $content[0] ) {
				$content = $content[0];
			}

			$msl_items = array();
			$title_tag = $config['title_tag'];
			$pattern = "'( .*? )<\s*" . $title_tag . " .*? >( .*? )< \s* / \s* " . $title_tag . " .*? >\s* (.*?)\s*(?= < \s* " . $title_tag . " .*? >)'isx";

			if ( preg_match_all( $pattern, $content . "<$title_tag>", $matches ) ) {

				$total_items = count( $matches[0] );

				for ( $i = 0; $i < $total_items; $i ++ ) {

					$image_info = array( 'el' => '', 'src' => '', 'link' => '', 'alt' => '', 'cap' => '','height' => '','width' => '' );

					$pattern_img = "'(?:< \s*figure.*? >)? (?: <\s* a \s+ href\s*=\s* ([\"\\'])? (?(1) (.*?)\\1 | ([^\s\>]+)) .*? )? <\s* img \s+ (.*?)class\s*=\s* .*?  \b  wp\-image\-(\d+) \b .*? ([^\>]+)> (?: < \s* / \s* a .*? > )? (?:< \s*figcaption .*? > ( .*? ) < \s* / \s* figcaption .*? >)?(?:< \s* / \s* figure .*? >)? 'isx";

					if ( preg_match( $pattern_img, $matches[3][ $i ], $match ) ) {

						$match_0 = isset( $match[0] ) ? $match[0] : '';
						$match_2 = isset( $match[2] ) ? $match[2] : '';
						$match_7 = isset( $match[7] ) ? $match[7] : '';

						$src_img = $alt_img = $width_img = $height_img = '';
						if ( isset( $match[6] ) && $match[6] ) {
							$src_img    = self::get_attr_img( $match[6], 'src' );
							$alt_img    = self::get_attr_img( $match[6], 'alt' );
							$width_img  = self::get_attr_img( $match[6], 'width' );
							$height_img = self::get_attr_img( $match[6], 'height' );
						}

						$image_info['el']     = $match_0;
						$image_info['src']    = $src_img;
						$image_info['alt']    = $alt_img;
						$image_info['width']  = $width_img;
						$image_info['height'] = $height_img;
						$image_info['link']   = $match_2;
						$image_info['cap']    = $match_7;
					}

					$content = '';
					if( isset( $matches[3][ $i ] ) && $matches[3][ $i ] ){
						$content = preg_replace( '/(&nbsp;)+$/', '', $matches[3][ $i ] );
					}
					if ( ! empty( $image_info['el'] ) ) {
						$content = str_replace( $image_info['el'], '', $content );
					}

					$item = array(
						'title'         => $matches[2][ $i ],
						'content'       => trim( $content ),
						'image_src'     => $image_info['src'],
						'image_link'    => $image_info['link'],
						'image_caption' => $image_info['cap'],
						'image_alt'     => $image_info['alt'],
						'image_width'   => $image_info['width'],
						'image_height'  => $image_info['height'],
					);

					$msl_items[] = $item;
				}

				if ( ! empty( $matches[1][0] ) ) {
					if ( isset( $output['before'] ) ) {
						$output['before'] .= $matches[1][0];
					} else {
						$output['before'] = $matches[1][0];
					}
				}
			}

			if( $msl_items ){

				if( 'desc' == $config['sort'] ){
					$msl_items = array_reverse( $msl_items );
				}
				$output['msl_items'] = $msl_items;
				$output['msl_items_number'] = count( (array)$msl_items );
			}

			return $output;
		}

		public static function set_config( $post_id ){
			$style = get_post_meta( $post_id, 'penci_smlists_style', true );
			if ( ! $style ) {
				$style = get_theme_mod( 'penci_smlists_style' );
			}

			$args =  array(
				'enable'    => get_post_meta( $post_id,'penci_enable_smlists', true ),
				'style'     => $style,
				'title_tag' => get_post_meta( $post_id,'penci_smlists_title_tag', true ),
				'sort'      => get_post_meta( $post_id,'penci_smlists_sort', true ),
			);

			return wp_parse_args( $args, self::$config_default );
		}

		public static function get_attr_img( $string, $attr ) {
			$output = '';
			if ( preg_match( '/' . $attr . ' \s* = \s*([\"\'])?(?(1) (.*?)\\1 | ([^\s\>]+))/isx', $string, $match ) ) {
				$output = isset( $match[2] ) ? $match[2] : '';
			}
			return $output;
		}
	}
endif;