<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if( ! class_exists( 'Penci_Smart_Lists_MTB' ) ):
	class Penci_Smart_Lists_MTB{
		function __construct() {

			// Function has already run.
			static $initialized;
			if ( $initialized ) {
				return;
			}
			$initialized = true;

			add_filter( 'mb_settings_pages', array( $this, 'options_page' ),999 );
			add_filter( 'rwmb_meta_boxes', array( $this,'options_settings_page' ) ,999 );
			add_filter( 'rwmb_meta_boxes', array( $this,'single_post_fields' ) ,999 );
		}

		public function options_page( $settings_pages ) {
			$new = ' <span class="update-plugins"><span class="plugin-count">' . __( 'New', 'penci-smart-lists' ) . '</span></span>';

			$settings_pages[] = array(
				'id'          => 'pennews_smart_lists',
				'option_name' => 'theme_mods_' . get_stylesheet(),
				'page_title'  => esc_html__( 'Smart Lists ', 'penci-smart-lists' ),
				'menu_title'  => esc_html__( 'Smart Lists ', 'penci-smart-lists' ) . $new,
				'parent'      => 'pennews_dashboard_welcome',
			);
			return $settings_pages;
		}

		public function options_settings_page( $meta_boxes ){

			$meta_boxes[] = array(
				'id'             => 'smart_lists_general',
				'title'          => 'Smart Lists',
				'settings_pages' => 'pennews_smart_lists',
				'fields'         => array(
					array(
						'name'    => esc_html__( 'Smart Lists Style', 'penci-smart-lists' ),
						'id'      => 'penci_smlists_style',
						'type'    => 'image_select',
						'options' => array(
							'sml-s1'  => PENCI_SMLIST_URL . 'images/sml-s1.png',
							'sml-s2'  => PENCI_SMLIST_URL . 'images/sml-s2.png',
							'sml-s3'  => PENCI_SMLIST_URL . 'images/sml-s3.png',
							'sml-s4'  => PENCI_SMLIST_URL . 'images/sml-s4.png',
							'sml-s5'  => PENCI_SMLIST_URL . 'images/sml-s5.png',
							'sml-s6'  => PENCI_SMLIST_URL . 'images/sml-s6.png',
							'sml-s7'  => PENCI_SMLIST_URL . 'images/sml-s7.png',
							'sml-s8'  => PENCI_SMLIST_URL . 'images/sml-s8.png',
							'sml-s9'  => PENCI_SMLIST_URL . 'images/sml-s9.png',
							'sml-s10' => PENCI_SMLIST_URL . 'images/sml-s10.png',
							'sml-s11' => PENCI_SMLIST_URL . 'images/sml-s11.png',
							'sml-s12' => PENCI_SMLIST_URL . 'images/sml-s12.png',
							'sml-s13' => PENCI_SMLIST_URL . 'images/sml-s13.png',
							'sml-s14' => PENCI_SMLIST_URL . 'images/sml-s14.png',
							'sml-s15' => PENCI_SMLIST_URL . 'images/sml-s15.png',
							'sml-s16' => PENCI_SMLIST_URL . 'images/sml-s16.png',
							'sml-s17' => PENCI_SMLIST_URL . 'images/sml-s17.png',
							'sml-s18' => PENCI_SMLIST_URL . 'images/sml-s18.png',
							'sml-s19' => PENCI_SMLIST_URL . 'images/sml-s19.png',
							'sml-s20' => PENCI_SMLIST_URL . 'images/sml-s20.png',
						),
						'std' => 'sml-s1',
					),
					array(
						'id' => 'penci_smlists_divider',
						'type' => 'heading',
						'name' => esc_html__( 'Translation', 'penci-smart-lists' ),
					),
					array(
						'id' => 'penci_tran_sml_next',
						'type' => 'text',
						'name' => esc_html__( 'Next', 'penci-smart-lists' ),
						'std' =>  esc_html__( 'Next', 'penci-smart-lists' ),
						'size' => 100,
					),
					array(
						'id' => 'penci_tran_sml_prev',
						'type' => 'text',
						'name' => esc_html__( 'Prev', 'penci-smart-lists' ),
						'std' =>  esc_html__( 'Prev', 'penci-smart-lists' ),
						'size' => 100,
					),
					array(
						'id' => 'penci_tran_sml_pagexofy',
						'type' => 'text',
						'name' => esc_html__( 'Page X of N', 'penci-smart-lists' ),
						'std' =>  'Page %1$s of %2$s',
						'size' => 100,
					),
					array(
						'id' => 'penci_tran_sml_xofy',
						'type' => 'text',
						'name' => esc_html__( 'X of N', 'penci-smart-lists' ),
						'std' =>  '<b>%1$s</b> of %2$s',
						'size' => 100,
					),
				),
			);

			$penci_sml_info1 = 'Using Penci smart lists you can change your post in a list of items. Every item in smart list consists of 3 parts:';
			$penci_sml_info1 .= '<ul style="list-style: square; padding-left: 20px;"><li>Title</li><li>Image</li><li>Description</li></ul>';
			$penci_sml_info1 .= '<hr>';
			$penci_sml_info1 .= '<ul style="list-style: square; padding-left: 20px;">';
			$penci_sml_info1 .= '<li>Enable Smart List</li>';
			$penci_sml_info1 .= '<li><strong>Add a text wrapped in H3 tag or another heading tag</strong>. - this will be the title of the item</li>';
			$penci_sml_info1 .= '<li><strong>Add any image</strong> from the media library</li>';
			$penci_sml_info1 .= '<li>In a new paragraph below the picture,<strong> add some text</strong></li>';
			$penci_sml_info1 .= '<li>Repeat the last 3 steps for each item that you want to add</li>';
			$penci_sml_info1 .= '</ul>';
			$penci_sml_info1 .= 'The system will use the H3 ( or another heading tag )from the tiles to split your article and make each individual slide or numbered item';

			$meta_boxes[] = array(
				'id'             => 'penci_sml_info',
				'title'          => esc_html__( 'What is Smart List?', 'penci-smart-lists' ),
				'context'        => 'side',
				'settings_pages' => 'pennews_smart_lists',
				'fields'         => array(
					array(
						'type' => 'custom_html',
						'std'  => $penci_sml_info1,
					)
				),
			);

			$meta_boxes[] = array(
				'id'             => 'pennews_sml_ads',
				'title'          => 'Ads Manager',
				'settings_pages' => 'pennews_smart_lists',
				'fields'         => array(
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Before & After', 'penci-smart-lists' ),
						'desc' => esc_html__( 'Following ads will be shown before and after of all smart listing styles.', 'penci-smart-lists' ),
					),
					array(
						'id'   => 'penci_sml_ads_before',
						'type' => 'textarea',
						'name' => esc_html__( 'Your Ad code Before Smart List', 'penci-smart-lists' ),
						'rows' => 7,
					),
					array(
						'id'   => 'penci_sml_ads_after',
						'type' => 'textarea',
						'name' => esc_html__( 'Your Ad code After Smart List', 'penci-smart-lists' ),
						'rows' => 7,
					),
					array(
						'type' => 'heading',
						'name' => esc_html__( 'Style Base Ad Location', 'penci-smart-lists' )
					),
					array(
						'id'   => 'penci_sml_ads_xs6_12',
						'type' => 'text',
						'name' => esc_html__( 'Each X Item for style 6,7,8,9,10,11 and 12', 'penci-smart-lists' ),
						'std'  => '3',
						'size' => 10,
					),
					array(
						'id'   => 'penci_sml_ads_s6_12',
						'type' => 'textarea',
						'name' => esc_html__( 'Your Ad code for style 6,7,8,9,10,11 and 12', 'penci-smart-lists' ),
						'rows' => 7,
					),
					array(
						'id'   => 'penci_sml_ads_s13_17',
						'type' => 'textarea',
						'name' => esc_html__( 'Your Ad code for style 13,14,15,16, and 17', 'penci-smart-lists' ),
						'rows' => 7,
					),
				),
			);


			return $meta_boxes;
		}

		public function single_post_fields( $meta_boxes ){
			$penci_sml_info = '<ul style="list-style: square; padding-left: 20px;">';
			$penci_sml_info .= '<li>Enable Smart List</li>';
			$penci_sml_info .= '<li><strong>Add a text wrapped in H3 tag or another heading tag</strong>. - this will be the title of the item</li>';
			$penci_sml_info .= '<li><strong>Add any image</strong> from the media library</li>';
			$penci_sml_info .= '<li>In a new paragraph below the picture,<strong> add some text</strong></li>';
			$penci_sml_info .= '<li>Repeat the last 3 steps for each item that you want to add</li>';
			$penci_sml_info .= '</ul>';
			$penci_sml_info .= 'The system will use the H3 ( or another heading tag )from the tiles to split your article and make each individual slide or numbered item';

			$sml_fields = array(
				array(
					'id'      => 'penci_enable_smlists',
					'name'    => esc_html__( 'Enable Smart List', 'penci-framework' ),
					'type'    => 'checkbox',
					'std'     => '',
					'desc'        => '<p id="penci_smlists_title_tag-description" class="description">' . esc_html__( 'Using Penci smart lists you can change your post in a list of items. Every item in smart list consists a title, a image and a description', 'penci-smart-lists' ) . '<p>',
				),
				array(
					'name'    => esc_html__( 'Smart Lists Style', 'penci-smart-lists' ),
					'id'      => 'penci_smlists_style',
					'type'    => 'image_select',
					'options' => array(
						''        => PENCI_SMLIST_URL . 'images/sml-default.png',
						'sml-s1'  => PENCI_SMLIST_URL . 'images/sml-s1.png',
						'sml-s2'  => PENCI_SMLIST_URL . 'images/sml-s2.png',
						'sml-s3'  => PENCI_SMLIST_URL . 'images/sml-s3.png',
						'sml-s4'  => PENCI_SMLIST_URL . 'images/sml-s4.png',
						'sml-s5'  => PENCI_SMLIST_URL . 'images/sml-s5.png',
						'sml-s6'  => PENCI_SMLIST_URL . 'images/sml-s6.png',
						'sml-s7'  => PENCI_SMLIST_URL . 'images/sml-s7.png',
						'sml-s8'  => PENCI_SMLIST_URL . 'images/sml-s8.png',
						'sml-s9'  => PENCI_SMLIST_URL . 'images/sml-s9.png',
						'sml-s10' => PENCI_SMLIST_URL . 'images/sml-s10.png',
						'sml-s11' => PENCI_SMLIST_URL . 'images/sml-s11.png',
						'sml-s12' => PENCI_SMLIST_URL . 'images/sml-s12.png',
						'sml-s13' => PENCI_SMLIST_URL . 'images/sml-s13.png',
						'sml-s14' => PENCI_SMLIST_URL . 'images/sml-s14.png',
						'sml-s15' => PENCI_SMLIST_URL . 'images/sml-s15.png',
						'sml-s16' => PENCI_SMLIST_URL . 'images/sml-s16.png',
						'sml-s17' => PENCI_SMLIST_URL . 'images/sml-s17.png',
						'sml-s18' => PENCI_SMLIST_URL . 'images/sml-s18.png',
						'sml-s19' => PENCI_SMLIST_URL . 'images/sml-s19.png',
						'sml-s20' => PENCI_SMLIST_URL . 'images/sml-s20.png',
					),
					'std' => '',
				),
				array(
					'name'        => esc_html__( 'Split based on', 'penci-smart-lists' ),
					'id'          => 'penci_smlists_title_tag',
					'type'        => 'select',
					'options'     => array(
						'h1' => esc_html__( 'Heading 1 (H1 Tag)', 'penci-smart-lists' ),
						'h2' => esc_html__( 'Heading 2 (H2 Tag)', 'penci-smart-lists' ),
						'h3' => esc_html__( 'Heading 3 (H3 Tag)', 'penci-smart-lists' ),
						'h4' => esc_html__( 'Heading 4 (H4 Tag)', 'penci-smart-lists' ),
						'h5' => esc_html__( 'Heading 5 (H5 Tag)', 'penci-smart-lists' ),
						'h6' => esc_html__( 'Heading 6 (H6 Tag)', 'penci-smart-lists' ),
					),
					'std'         => 'h3',
					'desc'        => esc_html__( 'The tags that wrap the title of each Smart List item.', 'penci-smart-lists' ),
				),
				array(
					'name'        => esc_html__( 'List Sorting', 'penci-smart-lists' ),
					'id'          => 'penci_smlists_sort',
					'type'        => 'select',
					'options'     => array(
						'desc' => esc_html__( 'Descending (ex: 3, 2, 1)', 'penci-smart-lists' ),
						'asc'  => esc_html__( 'Asc (ex: 1, 2, 3)', 'penci-smart-lists' ),
					),
					'desc'     => esc_html__( 'The smart lists put a number on each item, select the counting method.', 'penci-smart-lists' ),
					'std'         => 'asc',
				),
				array(
					'type' => 'heading',
					'name' => esc_html__( 'How to create a smart list?', 'penci-smart-lists' ),
					'desc'  => $penci_sml_info,
				),
			);

			$meta_boxes[] = array(
				'post_types' => Penci_Smart_Lists::$post_types,
				'title'     => esc_html__( 'Smart List', 'penci-smart-lists' ),
				'fields'    => $sml_fields,
			);

			return $meta_boxes;
		}
	}
endif;;