<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'Penci_Smart_Lists_Helper' ) ):
class Penci_Smart_Lists_Helper {

	public static function markup_pagination_2( $page, $total_page, $items, $class = '', $style = '' ) {
		$sml_next = get_theme_mod( 'penci_tran_sml_next' );
		$sml_prev = get_theme_mod( 'penci_tran_sml_prev' );
		$sml_next = $sml_next ? $sml_next : esc_html__( 'Next', 'penci-smart-lists' );
		$sml_prev = $sml_prev ? $sml_prev : esc_html__( 'Prev', 'penci-smart-lists' );

		$prev_id = $page - 1;
		if ( ! isset( $items[ $prev_id - 1 ] ) ) {
			$prev_id = $total_page;
		}
		$prev_link = add_query_arg( 'page', $prev_id, get_permalink() );

		$next_id = $page + 1;

		if ( ! isset( $items[ $next_id - 1 ] ) ) {
			$next_id = 1;
		}
		$next_link = add_query_arg( 'page', $next_id, get_permalink() );

		if( 'style-17' == $style ):?>
			<div class="penci-sml-nav<?php echo( $class ? ' ' . $class : '' ); ?>">
				<div class="penci-sml-select">
					<span class="penci-sml-pagexofy">
					<?php
					$xofy = get_theme_mod( 'penci_tran_sml_pagexofy' );
					$xofy = $xofy ? $xofy : 'Page %1$s of %2$s';
					printf( $xofy . ' : ',  number_format_i18n( $page ) , $total_page  );
					?>
					</span>
					<ul>
						<li>
							<span><?php echo ( isset( $items[$page]['title'] ) ? $items[$page]['title'] : '' ) ?></span>
							<ul>
								<?php
								$i = 0;
								foreach ( $items as $msl_item ) {

									$title = isset( $msl_item['title'] ) && $msl_item['title'] ? $msl_item['title'] : '';
									if ( ! $title ) {
										continue;
									}

									printf( '<li %s><a href="%s">%s</a></li>',
										$i == $page ? 'class="active"' : '',
										add_query_arg( 'page', $i, get_permalink() ),
										( $i + 1 ) . '. '. $title
									);
									$i ++;
								}
								?>
							</ul>
						</li>
					</ul>
				</div>
				<a class="penci-sml-next" href="<?php echo esc_url( $next_link ); ?>"><?php echo $sml_next; ?><i class="fa fa-angle-<?php echo( is_rtl() ? 'left' : 'right' ); ?>"></i></a>
				<a class="penci-sml-prev" href="<?php echo esc_url( $prev_link ); ?>"><i class="fa fa-angle-<?php echo( is_rtl() ? 'right' : 'left' ); ?>"></i><?php echo $sml_prev; ?></a>

			</div>
		<?php else: ?>
			<div class="penci-sml-nav<?php echo( $class ? ' ' . $class : '' ); ?>">

				<a class="penci-sml-prev" href="<?php echo esc_url( $prev_link ); ?>"><?php echo $sml_prev; ?></a>
				<div class="penci-sml-select">
					<select>
						<?php
						$i = 0;
						foreach ( $items as $msl_item ) {

							$title = isset( $msl_item['title'] ) && $msl_item['title'] ? $msl_item['title'] : '';
							if ( ! $title ) {
								continue;
							}

							printf( '<option %s value="%s">%s - %s</option>',
								$i == $page ? 'selected' : '',
								add_query_arg( 'page', $i, get_permalink() ),
								number_format_i18n( $i ),
								$title
							);
							$i ++;
						}
						?>
					</select>
				</div>
				<a class="penci-sml-next" href="<?php echo esc_url( $next_link ); ?>"><?php echo $sml_next; ?></a>
			</div>
		<?php endif;
	}

	public static function markup_pagination( $page, $total_page, $items, $class = '' ) {
		$sml_next = get_theme_mod( 'penci_tran_sml_next' );
		$sml_prev = get_theme_mod( 'penci_tran_sml_prev' );
		$sml_next = $sml_next ? $sml_next : esc_html__( 'Next', 'penci-smart-lists' );
		$sml_prev = $sml_prev ? $sml_prev : esc_html__( 'Prev', 'penci-smart-lists' );

		$prev_id = $page - 1;
		if ( ! isset( $items[ $prev_id - 1 ] ) ) {
			$prev_id = $total_page;
		}
		$prev_link = add_query_arg( 'page', $prev_id, get_permalink() );

		$next_id = $page + 1;

		if ( ! isset( $items[ $next_id - 1 ] ) ) {
			$next_id = 1;
		}
		$next_link = add_query_arg( 'page', $next_id, get_permalink() );

		?>
		<div class="penci-sml-nav<?php echo ( $class ? ' ' . $class : '' ); ?>">
			<a class="penci-sml-prev" href="<?php echo esc_url( $prev_link ); ?>"><i class="fa fa-angle-<?php echo( is_rtl() ? 'right' : 'left' ); ?>"></i><?php echo $sml_prev; ?></a>
			<a class="penci-sml-next" href="<?php echo esc_url( $next_link ); ?>"><?php echo $sml_next; ?><i class="fa fa-angle-<?php echo( is_rtl() ? 'left' : 'right' ); ?>"></i></a>
		</div>
		<?php
	}
	public static  function render_before_sml_wrap_slider( $style, $sort, $echo = true ){

		$class = "penci-smart-list";
		$class .= ' penci-' . $style;
		$class .= ' penci-sml-' . $sort;

		$data = 'data-style="penci-sml"';
		$data .= ' data-items="1"';
		$data .= ' data-autowidth="0"';
		$data .= ' data-autoheight="1"';
		$data .= ' data-auto="0"';
		$data .= ' data-autotime="4000"';
		$data .= ' data-speed="800"';
		$data .= ' data-loop="0"';
		$data .= ' data-dots="0"';
		$data .= ' data-nav="1"';
		$data .= ' data-magrin="0"';
		$data .= ' data-center="0"';
		$data .= ' data-dismousedrag="1"';
		$data .= ' data-distouchdrag="1"';

		$output = '<div class="' . esc_attr( $class ) . '">';
		$output .= '<div class="penci-sml-inner penci-sml-slider penci-owl-carousel-style" ' . $data . '>';


		if ( ! $echo ) {
			return $output;
		}

		echo $output;
	}

	public static  function render_before_sml_wrap( $style, $sort, $echo = true ){

		$class = "penci-smart-list";
		$class .= ' penci-' . $style;
		$class .= ' penci-sml-' . $sort;

		$output = '<div class="' . esc_attr( $class ) . '">';
		$output .= '<div class="penci-sml-inner">';


		if ( ! $echo ) {
			return $output;
		}

		echo $output;
	}

	public static  function render_after_sml_wrap( $echo = true ){
		$output = '</div>';
		$output .= '</div>';

		if( ! $echo ){
			return $output;
		}
		echo $output;
	}

	public static  function render_start_sml_div( $mart_list_data, $mart_list_style, $border = true ){
		if( isset( $mart_list_data['before'] ) ) {
			echo '<span class="penci-sml-start penci-start-' . esc_attr( $mart_list_style ) . ( $border ?  ' penci-start-border' : '' ) . '"></span>';
		}
	}


	public static  function render_title_item(  $item, $current_number, $box_number = false ){

		$title = isset( $item['title'] ) && $item['title'] ? $item['title'] : get_the_title();

		$output =  '<div class="penci-sml-number-title' . ( $box_number ? ' penci-sml-box-nb' : '' ) . '">';
		$output .=  '<h2 class="penci-sml-item-title">';
		$output .= '<span class="penci-sml-item-number">' . number_format_i18n( $current_number ) . '</span>';
		$output .= ! $box_number ? '. ' : '';
		$output .= $title ;
		$output .='</h2>';
		$output .='</div>';

		echo $output;
	}

	public static function render_image_item( $item, $show_count = false ){
		$default = array(
			'title'          => '',
			'content'        => '',
			'image_src'      => '',
			'image_link'     => '',
			'image_cap'      => '',
			'image_alt'      => '',
			'image_width'    => '',
			'image_height'   => '',
			'current_number' => ''
		);
		$item = wp_parse_args( $item, $default );

		if ( ! $item['image_src'] ) {
			return;
		}

		$before_a = $after_a = '';

		if( $item['image_link'] ) {
			$before_a = '<a href="' . esc_url( $item['image_link'] ) . '">';
			$after_a  = '</a>';
		}

		$output = '<figure class="penci-sml-figure' . (  $item['image_caption'] ?  ' wp-caption' : '' ) . '">';
		$output .= $before_a;

		if( $item['current_number'] ){
			$output .= '<span class="penci-sml-box-nb"><span class="penci-sml-item-number">' . number_format_i18n( $item['current_number'] ) . '</span></span>';
		}

		$output .= '<img class="penci-sml-image" src="' . esc_attr( $item['image_src'] ) . '" alt="' . esc_attr( $item['image_alt'] ) . '"/>';
		$output .= $after_a;

		if(  $item['image_caption'] ){
			$output .= '<figcaption class="penci-sml-caption wp-caption-text">' . $item['image_caption'] . '</figcaption>';
		}

		$output .= '</figure>';

		echo $output;
	}

	public static  function add_number_order( $current, $total, $sort ){
		if( 'asc' == $sort ){
			if ( $current < $total ) {
				$current ++;
			}
		}else{
			if ( 0 === $current ) {
				$current = $total;
			} else {
				$current --;
			}
		}
		return $current;
	}

	public static function  render_google_adsense( $option, $echo = true ) {
		if( ! get_theme_mod( $option ) ){
			return '';
		}

		$ad = '<div class="penci-google-adsense '. $option .'">'. do_shortcode( get_theme_mod( $option ) ) .'</div>';
		if( ! $echo  ) {
			return $ad;
		}

		echo ( $ad );
	}
}
endif;