jQuery( function ( $ ) {
	'use strict';
	$( document ).ready( function () {
		$( '.penci-sml-slider' ).each( function () {
			var $this = $( this ),
				$smlWrap = $this.closest( '.penci-smart-list' ),
				$customNext = $smlWrap.find( '.penci-slider-next' ),
				$customPrev = $smlWrap.find( '.penci-slider-prev' ),
				$dataItems = $this.data( 'items' ),
				$dataAutoWidth = $this.data( 'autowidth' ),
				$dataAutoHeight = $this.data( 'autoheight' ),
				$dataAuto = $this.data( 'auto' ),
				$dataAutoTime = $this.data( 'autotime' ),
				$dataSpeed = $this.data( 'speed' ),
				$dataLoop = $this.data( 'loop' ),
				$dataDots = $this.data( 'dots' ),
				$dataNav = $this.data( 'nav' ),
				$dataCenter = $this.data( 'center' ),
				$dataVideo = $this.data( 'video' ),
				$dataMagrin = $this.data( 'magrin' ),
				$lazyLoad = true,
				$rtl = false,
				$dataReponsive = {};

			if( $('html').attr('dir') === 'rtl' ) {
				$rtl = true;
			}

			var owl_args = {
				rtl: $rtl,
				loop: 1 === $dataLoop ? false : true,
				margin: $dataMagrin,
				items: $dataItems ? $dataItems : 3,
				navSpeed: $dataSpeed,
				dotsSpeed: $dataSpeed,
				nav: 1 === $dataNav ? true : false,
				dots: 1 === $dataDots ? true : false,
				navText: [ '<i class="fa fa-angle-left"></i><span>' + PENCISML.sml_prev + '</span>' , '<span>' + PENCISML.sml_next + '</span><i class="fa fa-angle-right"></i>' ],
				autoplay: 1 === $dataAuto ? true : false,
				autoplayTimeout: $dataAutoTime,
				autoHeight: 1 === $dataAutoHeight ? true : false,
				center: 1 === $dataCenter ? true : false,
				autoWidth: 1 === $dataAutoWidth ? true : false,
				autoplayHoverPause: true,
				autoplaySpeed: $dataSpeed,
				video: 1 === $dataVideo ? true : false,
				animateOut: false,
				animateIn: false,
				lazyLoad: $lazyLoad,
				mouseDrag: false,
				touchDrag: false,
				responsive: $dataReponsive,
			};

			$this.owlCarousel( owl_args );

			// Go to the next item
			$customNext.click( function ( ev ) {
				ev.preventDefault();
				$this.trigger( 'next.owl.carousel' );
				return false;
			} );

			// Go to the previous item
			$customPrev.click( function ( ev ) {
				ev.preventDefault();
				$this.trigger( 'prev.owl.carousel' );
				return false;
			} );


		} );

		$('.penci-sml-select select').on('change', function () {
			window.location = $(this).val();
		});
	} );
} );