/* global tinyMCE */
(
	function ( $ ) {
		var media = wp.media;

		wp.mce = wp.mce || {};

		wp.mce.penci_sml_start = {
			shortcode_data: {},
			template: media.template( 'editor-penci-sml-start' ),
			getContent: function () {
				var options = this.shortcode.attrs.named;
				options.innercontent = this.shortcode.content;
				return this.template( options );
			},
			View: { // before WP 4.2:
				template: media.template( 'editor-penci-sml-start' ),
				postID: $( '#post_ID' ).val(),
				initialize: function ( options ) {
					this.shortcode = options.shortcode;
					wp.mce.penci_sml_start.shortcode_data = this.shortcode;
				},
				getHtml: function () {
					var options = this.shortcode.attrs.named;
					options.innercontent = this.shortcode.content;
					return this.template( options );
				}
			},
			edit: function ( data ) {
				var shortcode_data = wp.shortcode.next( 'penci_sml_start', data );
				var values = shortcode_data.shortcode.attrs.named;
				values.innercontent = shortcode_data.shortcode.content;
				wp.mce.penci_sml_start.popupwindow( tinyMCE.activeEditor, values );
			},

			popupwindow: function ( editor, values, onsubmit_callback ) {
				values = values || [];
				if ( typeof onsubmit_callback !== 'function' ) {
					onsubmit_callback = function ( e ) {
						editor.insertContent( wp.shortcode.string( {tag: 'penci_sml_start'} ) );
					};
				}
				editor.windowManager.open( {
					title: 'Note:',
					body: [
						{
							type: 'label',
							label: 'This element just use for breaking smart lists only',
						}
					],
					onsubmit: onsubmit_callback
				} );
			},
			rendershortcode: function ( editor ) {
				editor.insertContent( wp.shortcode.string( {tag: 'penci_sml_start' } ) );
			}
		};

		wp.mce.penci_sml_end = {
			shortcode_data: {},
			template: media.template( 'editor-penci-sml-end' ),
			getContent: function () {
				var options = this.shortcode.attrs.named;
				options.innercontent = this.shortcode.content;
				return this.template( options );
			},
			View: { // before WP 4.2:
				template: media.template( 'editor-penci-sml-end' ),
				postID: $( '#post_ID' ).val(),
				initialize: function ( options ) {
					this.shortcode = options.shortcode;
					wp.mce.penci_sml_end.shortcode_data = this.shortcode;
				},
				getHtml: function () {
					var options = this.shortcode.attrs.named;
					options.innercontent = this.shortcode.content;
					return this.template( options );
				}
			},
			edit: function ( data ) {
				var shortcode_data = wp.shortcode.next( 'penci_sml_end', data );
				var values = shortcode_data.shortcode.attrs.named;
				values.innercontent = shortcode_data.shortcode.content;
				wp.mce.penci_sml_end.popupwindow( tinyMCE.activeEditor, values );
			},

			popupwindow: function ( editor, values, onsubmit_callback ) {
				values = values || [];
				if ( typeof onsubmit_callback !== 'function' ) {
					onsubmit_callback = function ( e ) {
						editor.insertContent( wp.shortcode.string( {tag: 'penci_sml_end'} ) );
					};
				}
				editor.windowManager.open( {
					title: 'Note:',
					body: [
						{
							type: 'label',
							label: 'This element just use for breaking smart lists only',
						}
					],
					onsubmit: onsubmit_callback
				} );
			},
			rendershortcode: function ( editor ) {
				editor.insertContent( wp.shortcode.string( {tag: 'penci_sml_end' } ) );
			}
		};

		wp.mce.views.register( 'penci_sml_start', wp.mce.penci_sml_start );
		wp.mce.views.register( 'penci_sml_end', wp.mce.penci_sml_end );

	}( jQuery )
);
