<?php ! defined( 'ABSPATH' ) && exit(); ?><div id="totalpoll-upgrade-to-pro" class="wrap totalpoll-page">
    <h1><?php esc_html_e( 'Upgrade to TotalPoll Pro', 'totalpoll' ); ?></h1>
    <p><?php esc_html_e( 'Enjoy TotalPoll features without limits!', 'totalpoll' ); ?></p>

    <div class="totalpoll-pro-benefits">
        <div class="totalpoll-pro-benefits-body">
            <div class="totalpoll-row">
                <div class="totalpoll-column">
                    <img height="64" src="<?php echo esc_attr( $this->env['url'] ); ?>assets/dist/images/editor/customization.svg">
                    <h3>Unlock All Features</h3>
                    <p>Upgrade to pro version and enjoy TotalPoll features without any limits.</p>
                </div>
                <div class="totalpoll-column">
                    <img height="64" src="<?php echo esc_attr( $this->env['url'] ); ?>assets/dist/images/activation/updates-on.svg">
                    <h3>Priority Updates</h3>
                    <p>Get new features and improvements regularly and exclusively.</p>
                </div>
                <div class="totalpoll-column">
                    <img height="64" src="<?php echo esc_attr( $this->env['url'] ); ?>assets/dist/images/support/customer-support.svg">
                    <h3>Premium Support</h3>
                    <p>Get access to our five-stars customer support with guaranteed satisfaction.</p>
                </div>
            </div>
        </div>
        <div class="totalpoll-pro-features-comparison">
            <table>
                <thead>
                <tr>
                    <th>Feature</th>
                    <th>Lite</th>
                    <th>Pro</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>Unlimited polls</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Unlimited questions</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Unlimited choices</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Unlimited custom fields</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Supported choice types</td>
                    <td>1</td>
                    <td>5+</td>
                </tr>
                <tr>
                    <td>Supported custom field types</td>
                    <td>1</td>
                    <td>5+</td>
                </tr>
                <tr>
                    <td>Poll presets</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Vote limitations</td>
                    <td>Time</td>
                    <td>Time, Membership, Quota and Region</td>
                </tr>
                <tr>
                    <td>Vote frequency controllers</td>
                    <td>Cookies</td>
                    <td>Cookies, IP, Logged in user</td>
                </tr>
                <tr>
                    <td>Sort choices & results</td>
                    <td>Position, Votes</td>
                    <td>Position, Votes, Label and Random</td>
                </tr>
                <tr>
                    <td>Custom field preset</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Choice bulk insertion</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Custom user choice</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Custom field bulk insertion</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Hide results</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Structured data</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Full checks on page load</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Recaptcha by google</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Render poll in archive</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Email notification</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Push notification</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Webhook notification</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Insights</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>One click vote</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Questions slider</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Priority updates</td>
                    <td>&mdash;</td>
                    <td><span class="dashicons dashicons-yes"></span></td>
                </tr>
                <tr>
                    <td>Customer support</td>
                    <td>Community</td>
                    <td>Premium</td>
                </tr>
                </tbody>
            </table>

            <div class="totalpoll-pro-features-comparison-expand" onclick="jQuery(this).parent().addClass('expanded')">
                <span>Expand</span>
                <span class="dashicons dashicons-arrow-down-alt2"></span>
            </div>
        </div>
        <div class="totalpoll-pro-benefits-footer">
            <img src="<?php echo esc_attr( $this->env['url'] ); ?>assets/dist/images/general/upgrade.svg" alt="Upgrade">
            <div class="totalpoll-pro-offer">
                <h3>Get TotalPoll Pro</h3>
                <p>Plus 12 months of premium support.</p>
            </div>
			<?php
			$url = add_query_arg(
				[
					'utm_source'   => 'in-app',
					'utm_medium'   => 'upgrade-to-pro-page',
					'utm_campaign' => 'totalpoll-lite-to-pro',
				],
				$this->env['links.website']
			);
			?>
            <a href="<?php echo esc_attr( $url ) ?>" target="_blank" class="totalpoll-pro-upgrade-cta">Upgrade Now!</a>
        </div>
    </div>

</div>
