<?php
! defined( 'ABSPATH' ) && exit();


add_action('totalsuite/in-app-assets', function () {
	if (did_action('totalsuite/in-app-assets')) {
		return '';
	}
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const element = jQuery(`
<style>
    #in-app-survey {
        position: fixed;
        bottom: 20px;
        right: 20px;
        left: auto;
        border: 0;
        width: 400px;
        border-radius: 5px;
        padding: 30px 30px 30px 120px;
        box-shadow: rgb(15 15 15 / 5%) 0px 0px 0px 1px, rgb(15 15 15 / 10%) 0px 3px 6px, rgb(15 15 15 / 20%) 0px 9px 24px;
    }

    #in-app-survey .in-app-survey-image {
        position: absolute;
        width: 150px;
        left: -40px;

        margin: auto;
    }

    #in-app-survey .in-app-survey-title {
        font-size: 18px;
        margin: 0;
        line-height: 1.5;
    }

    #in-app-survey .in-app-survey-buttons {
        display: flex;
        gap: 10px;
        padding-top: 15px;
    }

    #in-app-survey .in-app-survey-button {
        background: #0288D1;
        color: #fff;
        padding: 10px 15px;
        font-size: 15px;
        border-radius: 5px;
        line-height: 1;
        border: 0;
        cursor: pointer;
        box-shadow: rgba(0, 0, 0, 0.05) 0px 1px 2px;
        text-decoration: none;
    }

    #in-app-survey .in-app-survey-button.skip-for-now {
        background: #ffffff;
        border: 1px solid #DDDDDD;
        color: #000;
    }
</style>
    <dialog id="in-app-survey" open>
        <img class="in-app-survey-image" src="data:image/png;base64,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">
        <h3 class="in-app-survey-title">Got 10 mins? Help us improve our product and win up to $100 gift card</h3>
        <div class="in-app-survey-buttons">
            <?php
            $surveyLink = add_query_arg(
                [
                    'product' => 'totalpoll',
                    'uid' => \TotalPollVendors\TotalCore\Application::getInstance()->uid(),
                    'firstUsage' => \TotalPollVendors\TotalCore\Application::getInstance()->firstUsage(),
                ],
                'https://marketing.totalsuite.net/survey'
            );

            ?>
            <a href="<?php echo esc_attr($surveyLink); ?>" rel="noopener" target="_blank" class="in-app-survey-button">Take the survey</a>
            <button class="in-app-survey-button skip-for-now">Not now</button>
        </div>
    </dialog>
    `);

            const STATE_KEY = 'in-app-survey';
            const persistentState = JSON.parse(localStorage.getItem(STATE_KEY)) || {};
            const state = {
                collected: false,
                lastRequestAt: Date.now(),
                ...persistentState
            };

            const persist = () => localStorage.setItem(STATE_KEY, JSON.stringify(state));
            const shouldDisplayFeedbackForm = !state.collected && (Date.now() - state.lastRequestAt) > (2 * 24 * 60 * 60 * 1000);

            const markAsCollected = () => {
                state.collected = true;
                state.lastRequestAt = Date.now();
                persist();
                element.remove();
            };
            const postpone = () => {
                state.lastRequestAt = Date.now();
                persist();
                element.remove();
            };

            element.find('a').on('click', () => markAsCollected());
            element.find('button').on('click', () => postpone());

            if (shouldDisplayFeedbackForm) {
                jQuery('body').append(element);
            } else {
                persist();
            }
        });
    </script>
    <?php
})
?>
