<?php
namespace MBUA;

class Avatar {
	public function __construct () {
		add_filter( 'pre_get_avatar', [ $this, 'get_avatar' ], 10, 5 );
	}

	public function get_avatar( $avatar = '', $id_or_email, $args ) {
		if ( is_numeric( $id_or_email ) ) {
			$user_id = $id_or_email;
		} elseif ( is_string( $id_or_email ) && ( $user = get_user_by( 'email', $id_or_email ) ) ) {
			$user_id = $user->ID;
		} elseif ( is_object( $id_or_email ) && ! empty( $id_or_email->user_id ) ) {
			$user_id = (int) $id_or_email->user_id;
		}

		if ( empty( $user_id ) ) {
			return $avatar;
		}

		$custom_avatar = rwmb_meta( 'mbua_avatar', [ 'object_type' => 'user' ], $user_id );

		if ( ! $custom_avatar ) {
			return $avatar;
		}

		$alt = ! empty( $args['alt'] ) ? $args['alt'] : $custom_avatar['alt'] ;
		$url = $custom_avatar['full_url'];

		$class = array( 'avatar', 'avatar-' . (int) $args['size'], 'photo' );
		if ( $args['class'] ) {
			if ( is_array( $args['class'] ) ) {
				$class = array_merge( $class, $args['class'] );
			} else {
				$class[] = $args['class'];
			}
		}

		return sprintf( '<img alt="%s" src="%s" class="%s" width="%d" height="%d" />', esc_attr( $alt ), esc_url( $url ), esc_attr( join( ' ', $class ) ), (int) $args['width'], (int) $args['height'] );
	}
}
