<?php
/**
 * Plugin Name: MB User Avatar
 * Description: Easily add custom avatars for users.
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * Plugin URI:  https://metabox.io/plugins/mb-user-avatar/
 * Version:     1.0.1
 * Text Domain: mb-user-avatar
 * Domain Path: languages
 *
 * @package MB User Avatar
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || die;

if ( ! function_exists( 'mbua_load' ) ) {
	// Hook priority 1 to load MB User Meta with priority 5.
	add_action( 'init', 'mbua_load', 1 );

	function mbua_load() {
		if ( ! defined( 'RWMB_VER' ) ) {
			return;
		}

		if ( file_exists( __DIR__ . '/vendor' ) ) {
			require __DIR__ . '/vendor/autoload.php';
			require __DIR__ . '/vendor/meta-box/mb-user-meta/mb-user-meta.php';
		} else {
			require dirname( __DIR__ ) . '/mb-user-meta/mb-user-meta.php';
		}

		list( , $url ) = RWMB_Loader::get_path( __DIR__ );
		define( 'MBUA_URL', $url );

		new MBUA\Assets;
		new MBUA\Fields;
		new MBUA\Avatar;
	}
}
