<?php

namespace WPFEPP\Element_Containers;

if ( ! defined( 'WPINC' ) ) {
	die;
}

use WPFEPP\Constants\Assets;
use WPFEPP\Constants\Permalinks_Settings;
use WPGurus\Forms\Constants\Elements;
use WPGurus\Forms\Element;
use WPGurus\Forms\Elements\Select;
use WPGurus\Forms\Factories\Element_Factory;

class Permalinks_Settings_Container extends Backend_Element_Container {
	function __construct( $current_values = array() ) {
		parent::__construct( $current_values );
		$this->build_form_elements();
	}

	private function build_form_elements() {
		$this->add_element(
			Element_Factory::make_element(
				Elements::SELECT,
				array(
					Element::KEY     => Permalinks_Settings::PERMALINK_STRUCTURE,
					Element::LABEL   => __( 'Permalink Structure', 'frontend-publishing-pro' ),
					Element::POSTFIX => __( 'Select permalink structure', 'frontend-publishing-pro' ),
					Select::CHOICES  => array(
						'plain'   => __( 'Plain', 'frontend-publishing-pro' ),
						'default' => __( 'Default Structure', 'frontend-publishing-pro' ),
						'custom'  => __( 'Custom Structure', 'frontend-publishing-pro' ),
					),
					Element::VALUE   => 'default',
				)
			), Permalinks_Settings::PERMALINK_STRUCTURE
		);
		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXT,
				array(
					Element::KEY     => Permalinks_Settings::CUSTOM_STRUCTURE,
					Element::LABEL   => __( 'Custom', 'frontend-publishing-pro' ),
					Element::POSTFIX => __( 'Enter your custom structure here.', 'frontend-publishing-pro' ),
					Element::VALUE   => 'frontend-publishing',
				)
			), Permalinks_Settings::CUSTOM_STRUCTURE
		);
	}

	public function render() {
		$permalink_structure = $this->get_element( Permalinks_Settings::PERMALINK_STRUCTURE );
		$custom_structure = $this->get_element( Permalinks_Settings::CUSTOM_STRUCTURE );
		if ( empty( get_option( 'permalink_structure' ) ) ) {
			$this->print_message();

			$permalink_structure->set_value( 'plain' );
			$permalink_structure->set_attribute( 'disabled', 'disabled' );

			$custom_structure->set_value( '' );
			$custom_structure->set_attribute( 'disabled', 'disabled' );
		} else {
			$permalink_structure_value = $permalink_structure->get_value();
			if ( $permalink_structure_value === 'default' || $permalink_structure_value === 'plain' ) {
				$custom_structure->set_attribute( 'readonly', 'readonly' );
			}
		}
		parent::render();
		wp_enqueue_script( Assets::PERMALINKS_SETTINGS );
	}

	public function print_message() {
		$settings_link = sprintf( '<a href="%s">%s</a>', get_admin_url() . 'options-permalink.php', __( 'update your permalink structure', 'frontend-publishing-pro' ) );
		$message_text = sprintf(
			__( '%s You must %s to something other than the default for permalink settings to work.', 'frontend-publishing-pro' ),
			sprintf( '<b>%s</b>', __( 'Frontend Publishing Pro:', 'frontend-publishing-pro' ) ),
			$settings_link
		);
		$message = sprintf( '<p>%s</p>', $message_text );
		?>
		<div class='fade error notice is-dismissible'>
			<?php echo wp_kses_post( $message ) ?>
		</div>
		<?php
	}
}