<?php

namespace WPFEPP\Components;

if ( ! defined( 'WPINC' ) ) {
	die;
}

use WPFEPP\Constants\Option_Ids;
use WPFEPP\Constants\Permalinks_Settings;
use WPFEPP\Element_Containers\Permalinks_Settings_Container;
use WPGurus\Components\Component;

/**
 * Creates rewrite rules for fancy URLs on the post list page.
 * @package WPFEPP\Components
 */
class Rewrites extends Component {
	private static $permalinks_settings;

	/**
	 * Rewrites constructor.
	 */
	function __construct() {
		parent::__construct();
		$this->register_action( 'init', array( $this, 'add_rewrite_rules' ) );
		self::$permalinks_settings = self::get_permalink_settings();
	}

	/**
	 * Adds rewrite endpoints and flushes the rules if required.
	 */
	function add_rewrite_rules() {
		if ( self::get_permalink_structure() === '' ) {
			return;
		}
		add_rewrite_endpoint( self::get_edit_endpoint(), EP_PERMALINK | EP_PAGES );
		add_rewrite_endpoint( self::get_tab_endpoint(), EP_PERMALINK | EP_PAGES );
		add_rewrite_endpoint( self::get_delete_endpoint(), EP_PERMALINK | EP_PAGES );

		if ( $this->needs_flushing() ) {
			$this->flush();
		}
	}

	/**
	 * Returns a boolean indicating whether rewrite rules need to be flushed.
	 * @return boolean
	 */
	private function needs_flushing() {
		return ( version_compare( $this->get_version(), get_site_option( Option_Ids::OPTION_REWRITE_RULES_FLUSHED, '0' ), '>' ) || $this->debug )
		       || get_site_option( Option_Ids::PREVIOUS_PERMALINKS_STRUCTURE ) !== self::get_permalink_structure();
	}

	/**
	 * Updates the option containing the flag which indicates whether or not rules have been flushed.
	 */
	private function updated_flushed_flag() {
		update_site_option( Option_Ids::OPTION_REWRITE_RULES_FLUSHED, $this->plugin_version );
		update_site_option( Option_Ids::PREVIOUS_PERMALINKS_STRUCTURE, self::get_permalink_structure() );
	}

	/**
	 * Uses WP' flush_rewrite_rules to flush rules.
	 * @see flush_rewrite_rules
	 */
	private function flush() {
		flush_rewrite_rules( true );
		$this->updated_flushed_flag();
	}

	private static function get_permalink_structure() {
		$selected_permalink_struct = self::$permalinks_settings[ Permalinks_Settings::PERMALINK_STRUCTURE ];
		if ( $selected_permalink_struct === 'default' ) {
			return 'frontend-publishing';
		} else if ( $selected_permalink_struct === 'custom' ) {
			return trim( self::$permalinks_settings[ Permalinks_Settings::CUSTOM_STRUCTURE ] );
		} else {
			return '';
		}
	}

	public static function get_tab_endpoint() {
		return self::get_permalink_structure() . '/status';
	}

	public static function get_edit_endpoint() {
		return self::get_permalink_structure() . '/edit';
	}

	public static function get_delete_endpoint() {
		return self::get_permalink_structure() . '/delete';
	}

	private static function get_permalink_settings() {
		$permalinks_settings_container = new Permalinks_Settings_Container();
		return $permalinks_settings_container->parse_values( get_option( Option_Ids::OPTION_PERMALINKS_SETTINGS ) );
	}

	public static function is_permalink_disabled() {
		if ( empty( get_option( 'permalink_structure' ) ) ) {
			return true;
		}
		$selected_permalink_struct = self::$permalinks_settings[ Permalinks_Settings::PERMALINK_STRUCTURE ];
		$custom_structure = trim( self::$permalinks_settings[ Permalinks_Settings::CUSTOM_STRUCTURE ] );
		if (
			$selected_permalink_struct === 'plain' ||
			( $selected_permalink_struct === 'custom' && $custom_structure === '' )
		) {
			return true;
		}
		return false;
	}
}