<?php

namespace WPFEPP\Components;

if ( ! defined( 'WPINC' ) ) {
	die;
}

use WPFEPP\Constants\Query_Vars;
use WPFEPP\Tabs\Frontend_Tab;
use WPGurus\Components\Component;
use WPGurus\Utils\Array_Utils;

/**
 * Deletes posts.
 * @package WPFEPP\Components
 */
class Post_Deleter extends Component {
	/**
	 * Post_Deleter constructor.
	 */
	function __construct() {
		parent::__construct();

		$this->register_action( 'wp', array( $this, 'handle_deletion_request' ) );
	}

	/**
	 * Deletes posts and sends the user back to the page from where the request came.
	 */
	public function handle_deletion_request() {
		$post_id = $this->get_post_id();
		$nonce = Array_Utils::get( $_GET, Query_Vars::POST_DELETER_NONCE );
		$tab = Array_Utils::get( $_GET, Query_Vars::FRONTEND_TAB );

		if (
			$post_id
			&& is_numeric( $post_id )
			&& wp_verify_nonce( $nonce, sprintf( Frontend_Tab::DELETION_NONCE_ACTION, $tab, $post_id ) )
			&& \WPFEPP\current_user_can_delete( $post_id )
		) {
			if ( Rewrites::is_permalink_disabled() ) {
				$page_url = esc_url_raw( remove_query_arg( array(
					Query_Vars::FRONTEND_TAB_POST_ID,
					Query_Vars::FRONTEND_TAB_ACTION,
					Query_Vars::POST_DELETER_NONCE,
				) ) );
			} else {
				$request_uri = esc_url_raw( add_query_arg( array() ) );
				$page_url = substr(
					$request_uri,
					0,
					strpos( $request_uri, Rewrites::get_delete_endpoint() )
				);
				$page_url .= Rewrites::get_tab_endpoint() . '/' . $tab . '/';
			}
			$deleted = wp_delete_post( $post_id, true );
			$redirect_url = esc_url_raw(
				add_query_arg(
					array(
						Query_Vars::POST_DELETED => $deleted ? 1 : 0,
					),
					$page_url
				)
			);
			wp_safe_redirect( $redirect_url );
			die();
		}
	}

	function get_post_id() {
		$id_from_query = Array_Utils::get( $_GET, Query_Vars::FRONTEND_TAB_POST_ID );
		if ( $id_from_query ) {
			return $id_from_query;
		}

		return \WPFEPP\get_query_var_part( Rewrites::get_delete_endpoint(), 0 );
	}
}