<?php

namespace WPFEPP\Components;

if ( ! defined( 'WPINC' ) ) {
	die;
}

use WPFEPP\Constants\Edit_Link_Settings;
use WPFEPP\Constants\Option_Ids;
use WPFEPP\Constants\Post_Meta_Keys;
use WPFEPP\Constants\Query_Vars;
use WPFEPP\Element_Containers\Edit_Link_Settings_Container;
use WPFEPP\Shortcodes\Post_Table;
use WPGurus\Components\Component;
use WPGurus\Utils\Array_Utils;

class Edit_Post_Link extends Component {
	function __construct() {
		parent::__construct();

		$this->register_filter( 'get_edit_post_link', array( $this, 'override_edit_link' ), 10, 2 );
		$this->register_filter( 'the_content', array( $this, 'replace_content_with_edit_shortcode' ) );
	}

	/**
	 * Replaces the default edit link our link.
	 */
	public function override_edit_link( $link, $post_id ) {
		if ( is_admin() ) {
			return $link;
		}

		$form_id = get_post_meta( $post_id, Post_Meta_Keys::FORM_ID, true );
		$options = $this->get_options();
		$post_types = $options[ Edit_Link_Settings::SETTING_POST_TYPES ];
		$edit_page = $options[ Edit_Link_Settings::SETTING_EDIT_PAGE ];

		if ( ! $form_id || ! $edit_page ) {
			return $link;
		}

		$current_post = get_post( $post_id );

		if ( ! in_array( $current_post->post_type, $post_types ) ) {
			return $link;
		}

		$post_permalink = get_permalink( $edit_page );
		if ( Rewrites::is_permalink_disabled() ) {
			return add_query_arg( array(
				Query_Vars::FRONTEND_TAB_ACTION  => 'edit',
				Query_Vars::FRONTEND_TAB_POST_ID => $post_id,
			), $post_permalink );
		} else {
			return trailingslashit( $post_permalink ) . Rewrites::get_edit_endpoint() . '/' . $post_id . '/';
		}
	}

	/**
	 * When the user clicks on our link and starts to edit a post, this function replaces the content with a shortcode. This shortcode displays the form for editing.
	 *
	 * @param $content string The post content to replace.
	 *
	 * @return string Modified content.
	 */
	public function replace_content_with_edit_shortcode( $content ) {
		global $post;

		$options = $this->get_options();
		$edit_page = $options[ Edit_Link_Settings::SETTING_EDIT_PAGE ];

		if ( $post && $post->ID == $edit_page && $edit_post_id = $this->get_post_id() ) {
			$form_id = get_post_meta( $edit_post_id, Post_Meta_Keys::FORM_ID, true );
			return sprintf( '[%s form="%s"]', Post_Table::SHORTCODE, $form_id );
		}

		return $content;
	}

	private function get_options() {
		$element_container = new Edit_Link_Settings_Container();
		$options = get_option( Option_Ids::OPTION_EDIT_LINK_SETTINGS );
		return $element_container->parse_values( $options );
	}

	private function get_post_id() {
		$id_from_query = Array_Utils::get( $_GET, Query_Vars::FRONTEND_TAB_POST_ID );
		if ( $id_from_query ) {
			return $id_from_query;
		}

		return get_query_var( Rewrites::get_edit_endpoint() );
	}
}