<?php

// Get content width
$content_max_width       = absint( $this->get( 'content_max_width' ) );

// Get template colors
$theme_color             = $this->get_customizer_setting( 'theme_color' );
$text_color              = $this->get_customizer_setting( 'text_color' );
$muted_text_color        = $this->get_customizer_setting( 'muted_text_color' );
$border_color            = $this->get_customizer_setting( 'border_color' );
$link_color              = $this->get_customizer_setting( 'link_color' );
$header_background_color = $this->get_customizer_setting( 'header_background_color' );
$header_color            = $this->get_customizer_setting( 'header_color' );
$title_color            = $this->get_customizer_setting( 'title_color' );

// Button
$button_color    = $this->get_customizer_setting( 'button_color' );
$button_bgcolor  = $this->get_customizer_setting( 'button_bgcolor' );
$button_hcolor   = $this->get_customizer_setting( 'button_hcolor' );
$button_hbgcolor = $this->get_customizer_setting( 'button_hbgcolor' );

$font_OpenSans = "'Open Sans', sans-serif;";
$font_Roboto   = "'Roboto', sans-serif;";
$font_Teko     = "'Teko', sans-serif;";

$custom_typo_body  = penci_amp_customize_typo_body();
$custom_typo_title = penci_amp_customize_typo_title();

if( class_exists( 'Pemag_Customizer_CSS' ) ){
	$pennews_customizer_css = new Pemag_Customizer_CSS;
	$add_custom_fonts = $pennews_customizer_css->add_custom_fonts();

	if( $add_custom_fonts ){
		echo $add_custom_fonts;
	}
}
echo '.swp_social_panel{display: none; }';
echo 'pre { display: block; font-size: 14px; word-break: break-all; word-wrap: break-word; white-space: pre-wrap; background-color: #f4f4f4; border: 1px solid rgba(0, 0, 0, 0.1); margin: 0 0 20px; line-height: 1.4; padding: 15px; letter-spacing: 0; color: inherit; border-radius: 0; color:#000; }';
echo '*{ outline: none; text-decoration: none; box-sizing: border-box; }';
echo '.penci-google-adsense { margin: 0 0 30px; text-align: center; overflow: hidden; display: block; width: 100%; }';
echo 'strong, b { font-weight: ' . penci_amp_get_setting( 'penci_amp_font_weight_title' ) . '; }';
echo 'h1{ font-size: 24px; } h2{ font-size: 20px; } h3{ font-size: 18px; } h4{ font-size: 16px; } h5{ font-size: 14px; } h6{ font-size: 12px; }';
echo '.screen-reader-text { clip: rect(1px, 1px, 1px, 1px); position: absolute ; height: 1px; width: 1px; overflow: hidden; } .screen-reader-text:focus { background-color: #f1f1f1; border-radius: 3px; box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.6); clip: auto; color: #21759b; display: block; font-size: 14px; font-weight: 700; height: auto; left: 5px; line-height: normal; padding: 15px 23px 14px; text-decoration: none; top: 5px; width: auto; z-index: 100000;  }';
echo 'h1, h2, h3, h4, h5, h6 { clear: both; line-height: 1.3; font-family: ' . $font_Roboto . '; font-style: normal; font-weight: 600; }';
echo 'a{ background-color: transparent; transition: color 0.3s; text-decoration: none; vertical-align: baseline; }';
echo '.byline, .updated:not(.published) { display: none; }';
echo '.alignright { float: right; } .alignleft { float: left; } .aligncenter { display: block; margin-left: auto; margin-right: auto; }';
echo '.amp-wp-enforced-sizes { max-width: 100%; margin: 0 auto; } .amp-wp-unknown-size img { object-fit: contain; }';


if ( $content_max_width > 0 ){
	echo '.amp-wp-content,.amp-wp-title-bar div {margin: 0 auto;max-width:' . sprintf( '%dpx', $content_max_width ) . '; }';
}

echo 'body { background: #fff; color: ' . sanitize_hex_color( $text_color ) . '; font-size: 15px; line-height: 1.5; text-rendering: optimizeLegibility; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; word-wrap: break-word; margin: 0; overflow-x: hidden; }';
echo 'body, button, input, select, textarea {' . $custom_typo_body . '}';
echo '.penci-amp-wrapper { background: ' . sanitize_hex_color( $theme_color ) . '; max-width: 780px; margin: 0 auto; }';
echo '.penci-amp-wrapper .amp-slider { background: ' . sanitize_hex_color( $theme_color )  . '; }';

echo 'p, ol, ul, figure { margin: 0 0 1em; padding: 0; }';
echo 'a, a:visited { color: ' . sanitize_hex_color( $link_color ) . '; }';
echo 'a:hover, a:active, a:focus { color: ' . sanitize_hex_color( $text_color ) . '; }';
echo 'button, .button, input[type="button"], input[type="reset"], input[type="submit"] { border: 1px solid '. $button_bgcolor .'; border-radius: 0; background-color: '. $button_bgcolor .'; color: '. $button_color .'; line-height: 36px; padding: 2px 15px 0; text-align: center; transition: all 0.25s; font-size: 14px; text-transform: uppercase; cursor: pointer; }';
echo 'button:hover, .button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover { opacity: 0.8; border-color: '. $button_hbgcolor .'; background-color: '. $button_hbgcolor .'; color:'. $button_hcolor .'; }';

// Quotes
echo 'blockquote { color: '. sanitize_hex_color( $text_color ) .'; background: rgba(127,127,127,.125); border-left: 2px solid '. sanitize_hex_color( $link_color ) .'; margin: 8px 0 24px 0; padding: 16px; }';
echo 'blockquote p:last-child { margin-bottom: 0; } blockquote.alignleft { margin: 5px 10px 10px 0; } blockquote.alignright { margin: 5px 0 10px 10px; }';

echo '.amp-wp-meta, .penci-amp-wp-header div, .wp-caption-text, .amp-wp-tax-category, .amp-wp-tax-tag, .amp-wp-comments-link, .penci-amp-footer p, .back-to-top { font-family:'. penci_amp_google_fonts_parse_attributes( penci_amp_get_setting( 'penci_amp_font_for_body' ) ) .'; }';

echo '.penci-amp-wp-header { background-color: '. sanitize_hex_color( $header_background_color ) .'; }';
echo 'body.sticky-header { padding-top: 54px; } .sticky-header .penci-amp-wp-header { position: fixed; left: 0; right: 0; top: 0; z-index: 999; display: block; }';
echo '.site-header .navbar-toggle { font-size: 21px; left: 0; }';
echo '.penci-amp-wp-header .navbar-search, .penci-amp-wp-header .navbar-toggle, .penci-amp-wp-header .branding { color: '. sanitize_hex_color( $header_color ) .'; }';
echo '.penci-amp-wp-header .navbar-search .fa { top: 2px; position: relative; }';
echo '.penci-amp-wp-header .branding { display: block; text-align: center; font-size: 30px; font-weight: 600; text-decoration: none; font-family: '. $font_Teko .'; width: 100%; padding: 5px 55px; z-index: 9; height: 54px; line-height: 50px; box-sizing: border-box; }';
echo '.penci-amp-wp-header .navbar-search, .penci-amp-wp-header .navbar-toggle { font-weight: normal; font-size: 18px; position: absolute; top: 0; z-index: 99; border: none; background: transparent; height: 54px; line-height: 52px; margin: 0; padding: 0; width: 52px; text-align: center; outline: 0; cursor: pointer; -webkit-transition: all .6s ease; -moz-transition: all .6s ease; -o-transition: all .6s ease; transition: all .6s ease; } .penci-amp-wp-header .navbar-toggle { font-size: 21px; left: 0; } .penci-amp-wp-header .navbar-search { font-size: 18px; right: 0; line-height: 48px; }';
echo '.penci-amp-wp-header div { color: '. sanitize_hex_color( $header_color ) .'; font-size: 1em; font-weight: 400; margin: 0 auto; padding: 0; position: relative; box-sizing: border-box; height:54px; }';
echo '.penci-amp-wp-header a { color: '. sanitize_hex_color( $header_color ) .'; text-decoration: none; }';
echo '.penci-amp-error-404 {text-align: center;padding-bottom:10px;}#comments_pagination{margin-top:10px;margin-bottom: 10px;}';

// Site Icon
echo '.penci-amp-wp-header .penci-amp-site-icon { padding: 2px 60px; box-sizing: border-box; max-height: 54px; display: flex; align-items: center; justify-content: center; overflow: hidden; } .penci-amp-wp-header .penci-amp-site-icon amp-img{  margin-left: auto; margin-right: auto; display:block; } .wrap { padding: 15px 15px 0; height: 100%; } .img-holder { position: relative; width: 100%; background: #ccc url(images/no-image.jpg); display: inline-block; vertical-align: top; background-repeat: no-repeat; background-position: center center; background-size: cover; -webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; height: 100%; transition: transform .3s ease, opacity .3s; transition-timing-function: cubic-bezier(0.39, 0.76, 0.51, 0.56); } .penci-amp-wrapper .img-holder:before{ display: block; content: ""; width: 100%; padding-top: 66.6667%; background: none; box-shadow: none; }';

// Featured slider
if ( is_front_page() || is_home() ){
	echo '.amp-slider{ background: #eee; direction: ltr; } .amp-slider a{ text-decoration: none; } .homepage-slider{ margin: 0 0 0; width: 100%; position: relative; max-width: 100%; } .homepage-slider amp-carousel { margin-top: 3px; } .rtl .amp-featured-slider .content-holder{ direction: rtl; } .amp-featured-slider .img-holder:after{ content: ""; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: #000; z-index: 1; bottom: 0; right: 0; background: linear-gradient(to bottom, transparent 50%, #000 90%); opacity: 0.9; transition: opacity 0.3s; } .penci-owl-featured-area .penci-slider__text { text-align: left; position: absolute; bottom: 0; padding: 20px 20px 9px; z-index: 99; } .amp-featured-slider .content-holder{ text-align: center; position: absolute; bottom: 0; padding: 0px 0 15px; z-index: 99; } .amp-featured-slider .content-holder a{ color: #fff; } .amp-featured-slider .content-holder h3{ margin: 20px 0 0; font-size: 22px; }';
}

// Article
echo '.penci-inline-related-posts .penci_post-meta { display: none; }';
echo '.amp-wp-article { color: '. sanitize_hex_color( $text_color ).'; font-weight: 400; margin: 1.5em auto; max-width: 840px; overflow-wrap: break-word; word-wrap: break-word; overflow-x: hidden; } .amp-wp-article > p:last-child{ margin-bottom: 0; }';
echo '.amp-wp-article-header { align-items: center; align-content: stretch; display: flex; flex-wrap: wrap; justify-content: space-between; margin: 1.5em 0 1.5em; } .amp-wp-title { color: '. sanitize_hex_color( $title_color ).'; display: block; flex: 1 0 100%; width: 100%; line-height: 1.2; margin-top: 9px; margin-bottom: 6px; } .amp-wp-meta { color: '. sanitize_hex_color( $muted_text_color ) .'; display: inline-block; flex: 2 1 50%; font-size: .875em; line-height: 1.5em; margin: 0; padding: 0; } .amp-wp-article-header .amp-wp-meta:last-of-type { text-align: right; } .amp-wp-article-header .amp-wp-meta:first-of-type { text-align: left; } .amp-wp-byline amp-img, .amp-wp-byline .amp-wp-author { display: inline-block; vertical-align: middle; } .amp-wp-byline amp-img { border: 1px solid '. sanitize_hex_color( $link_color ).'; border-radius: 50%; position: relative; margin-right: 6px; } .amp-wp-posted-on { text-align: right; } .penci-amp-entry-meta{ color: #888888; line-height: 2.5; font-size: 12px; } .penci-amp-entry-meta .entry-meta-item { padding-left: 17px; display: inline-block; } .penci-amp-entry-meta a, .penci-amp-entry-meta span, .penci-amp-entry-meta i { font-size: inherit; color: inherit; text-decoration: none; } .penci-amp-entry-meta i { margin-right: 5px; } .penci-amp-entry-meta .entry-meta-item:first-child { padding-left: 1px; }';

// Featured image
echo '.amp-wp-article-featured-image { margin: 0 0 1em; } .amp-wp-article-featured-image amp-img { margin: 0 auto; } .amp-wp-article-featured-image.wp-caption .wp-caption-text { margin: 0 18px; }';

// Article Content
echo '.amp-wp-article-content { margin: 0; } .amp-wp-article-content h1, .amp-wp-article-content h2, .amp-wp-article-content h3, .amp-wp-article-content h4, .amp-wp-article-content h5, .amp-wp-article-content h6{ clear: none; } .amp-wp-article-content ul, .amp-wp-article-content ol { margin-left: 19px; } .amp-wp-article-content amp-img { margin: 0 auto 20px; } .amp-wp-article-content amp-img.alignright, .amp-wp-article-content amp-img.alignleft { margin: 0 0 1em 20px; } .amp-wp-article-content amp-img.alignright { display: inline; float: right; margin-left: 1.5em; } .amp-wp-article-content amp-img.alignleft { display: inline; float: left; margin-right: 1.5em; }';
echo '.wp-caption { padding: 0; } .wp-caption.alignleft { margin-right: 16px; } .wp-caption.alignright { margin-left: 16px; } .wp-caption .wp-caption-text { border-bottom: 1px solid '. sanitize_hex_color( $border_color ) .'; color: '. sanitize_hex_color( $muted_text_color ) .'; font-size: .875em; line-height: 1.5em; margin: 0; padding: .66em 10px .75em; }';

// AMP Media
echo 'amp-carousel { background: '. sanitize_hex_color( $border_color ) .'; margin: 20px 0 0; } amp-iframe, amp-youtube, amp-instagram, amp-vine { background: '. sanitize_hex_color( $border_color ) .'; margin: 0 -16px 1.5em; } .amp-wp-article-content amp-carousel amp-img { border: none; } amp-carousel > amp-img > img { object-fit: contain; } .amp-wp-iframe-placeholder { background: '. sanitize_hex_color( $border_color ).' url( '. esc_url( $this->get( 'placeholder_image_url' ) ).' ) no-repeat center 40%; background-size: 48px 48px; min-height: 48px; }';

// Article Footer Meta
echo '.amp-wp-article-footer { padding-top: 20px; } .amp-wp-article-footer .amp-wp-meta { display: block; } .penci-amp-tags-links { margin: 10px 0 5px; width: 100%; overflow: hidden; display: block; } .penci-amp-tags-links a { float: left; display: inline-block; min-height: 24px; line-height: 24px; font-size: 10px; font-weight: 700; text-align: left; color: '. sanitize_hex_color( $muted_text_color ) . '; background: #ececec; transition: all 0.3s; margin: 0 2.5px 5px; text-transform: uppercase; padding-left: 10px; padding-right: 10px; } .penci-amp-tax-category { overflow: hidden; } .penci-amp-tax-category a { float: left; background: #000000; border: 1px solid #000000; font-size: 10px; font-weight: 700; line-height: 20px; height: 20px; text-align: left; text-transform: uppercase; padding-left: 7px; padding-right: 7px; margin-right: 7px; margin-bottom: 7px; transition: all 0.3s; color: #ffffff; } .penci-amp-single .penci-social-buttons { margin-top: 19px; margin-bottom: 35px; display: block; border: 1px solid '. sanitize_hex_color( $border_color ) .'; padding: 6px 20px; } .penci-social-buttons .penci-social-share-text { text-transform: uppercase; font-weight: 700; margin-right: 20px; font-size: 14px; color: '. $text_color . '; } .penci-social-buttons .penci-social-item { display: inline-block; margin: 5px 9px 5px 0; font-size: 14px; font-weight: normal; line-height: 32px; text-align: left; color: #ffffff; text-transform: none; height: 32px; border: 0; background-color: #0d47a1; padding: 0 12px; transition: opacity 0.3s; border-radius: 2px; vertical-align: middle; } .penci-social-buttons .penci-social-item .dt-share { display: none; } .penci-social-buttons .penci-social-item.twitter { background-color: #40c4ff; } .penci-social-buttons .penci-social-item.google_plus { background-color: #eb4026; } .penci-social-buttons .penci-social-item.instagram { background-color: #417096; } .penci-social-buttons .penci-social-item.pinterest { background-color: #C92228; } .penci-social-buttons .penci-social-item.email { background-color: #a7a7a7; } .penci-social-buttons .penci-social-item.linkedin { background-color: #0077B5; } .penci-social-buttons .penci-social-item.tumblr { background-color: #34465d; } .penci-social-buttons .penci-social-item.reddit { background-color: #ff4500; } .penci-social-buttons .penci-social-item.stumbleupon { background-color: #ee4813; } .penci-social-buttons .penci-social-item.whatsapp { background-color: #00c853; } .penci-social-buttons .penci-social-item.telegram { background-color: #179cde; } .penci-social-buttons .penci-social-item.line { background-color: #00c300; color: #00c300; padding: 0; width: 32px; height: 32px; position: relative; } .penci-social-buttons .penci-social-item.line:before { content: ""; position: absolute; width: 25px; height: 25px; top: 5px; left: 3px; background: #fff; } .penci-social-buttons .penci-social-item.line span { width: 32px; height: 32px; display: block; position: relative; } .penci-social-buttons .penci-social-item.line svg { height: 36px; position: absolute; top: -2px; } .penci-social-buttons .penci-social-item.viber { padding: 5px; } .penci-social-buttons .penci-social-item.viber svg { width: 20px; }';


echo '.penci-post-pagination { width: 100%; margin: 0; overflow: hidden; padding: 0 0 30px; } .penci-post-pagination .prev-post-title { margin-top: -8px; } .penci-post-pagination span { color: #888888; display: inline-block; font-size: 10px; font-weight: bold; line-height: 2.4; text-transform: uppercase; } .penci-post-pagination span i { margin-right: 6px; } .penci-post-pagination span i.fa-angle-right { margin: 0 0 0 6px; } .penci-post-pagination h5 { font-size: 15px; line-height: 1.33; margin: 0; padding: 0 15px 0 0; position: relative; } .penci-post-pagination h5.next-title { padding: 0 0 0 15px; } .penci-post-pagination a { color: '. sanitize_hex_color( $link_color ) .'; } .penci-post-pagination a:hover { color:'. sanitize_hex_color( $text_color ) .'; } .pagi-text { margin-top: 6px; } .penci-post-pagination .prev-post, .penci-post-pagination .next-post { width: 100%; padding: 0; text-align: center; } .penci-post-pagination .prev-post + .next-post { padding-top: 20px; margin-top: 20px; padding-left: 0; width: 100%; border-top: 1px solid '. sanitize_hex_color( $border_color ) .'; } .penci-ajax-more .penci-block-ajax-more-button { width: 100%; } ';

if( is_singular() ) {
	echo '.penci-post-related{ border-top: 1px solid ' . sanitize_hex_color( $border_color ) . '; overflow: hidden; margin: 0 0 20px; padding: 32px 0 0px; width: 100%; } .penci-amp-single .post-title-box { margin-bottom: 13px; } .post-title-box .post-box-title { font-size: 18px; text-transform: uppercase; position: relative; z-index: 10; display: inline-block; margin: 0; line-height: 1.67; color: ' . $text_color . '; } .penci-post-related .post-related_content { margin-left: -10px; margin-right: -10px; overflow: hidden; } .penci-post-related .post-related_content:after { content: ""; display: block; clear: both; width:100%; } .penci-post-related .item-related { width: 33.3333%; float: left; padding: 0 10px; } .penci-post-related .item-related h4 { margin: 15px 0 0; font-size: 15px; font-weight: 600; line-height: 1.3; } .penci-post-related .item-related h4 a{ color:' . $link_color . '; } .penci-post-related .item-related h4 a:hover{ color: ' . $text_color . '; } .amp-wp-comments-link { color: ' . sanitize_hex_color( $muted_text_color ) . '; font-size: .875em; line-height: 1.5em; text-align: center; margin: 2.25em 0 1.5em; } .amp-wp-comments-link a { border-style: solid; border-color: ' . sanitize_hex_color( $border_color ) . '; border-width: 1px 1px 2px; border-radius: 4px; background-color: transparent; color: ' . sanitize_hex_color( $link_color ) . '; cursor: pointer; display: block; font-size: 14px; font-weight: 600; line-height: 18px; margin: 0 auto; max-width: 200px; padding: 11px 16px; text-decoration: none; width: 50%; -webkit-transition: background-color 0.2s ease; transition: background-color 0.2s ease; }';
}

if( is_archive() ){
	echo '.penci-amp-archive-page-header { padding: 15px 0px 11px; margin: 0 0 15px; font-weight: 500; border-bottom: 1px solid '. sanitize_hex_color( $border_color ) .'; position: relative; }';
	echo '.penci-amp-archive-page-header .pre-title { font-size: 14px; margin-bottom: 3px; font-weight: 400; color: #868686; text-transform: capitalize; } .penci-amp-archive-page-header .archive-title { margin: 0; font-size: 25px; text-transform: capitalize; } .penci-amp-archive-page-header .archive-title .fa { margin-right: 10px; }';
}


if ( is_archive() || is_front_page() || is_home() || is_search() ) {

	echo '.penci-archive__list_posts.listing-1 .article_content, .penci-archive__list_posts.listing-3 .article_content{ display: -webkit-box; display: -webkit-flex; display: -ms-flexbox; display: flex; -webkit-box-align: start; -webkit-align-items: flex-start; -ms-flex-align: start; align-items: flex-start; } .penci-archive__list_posts .penci-post-item{ margin-top: 20px; } .penci-archive__list_posts .penci-post-item-1{ margin-top: 0; } .penci-archive__list_posts .entry-media a, .penci-archive__list_posts .entry-media img{ display: block; } .penci-archive__list_posts.listing-1 .entry-media, .penci-archive__list_posts.listing-3 .entry-media{ margin-right: 15px; width: 35%; } .penci-archive__list_posts .penci-post-thumb{ width:100%; height: auto; } .penci-archive__list_posts.listing-1 .entry-text, .penci-archive__list_posts.listing-3 .entry-text{ flex: 1; }';

	// AMP listing 1
	echo ' .penci-archive__list_posts.listing-1 .penci__post-title, .penci-archive__list_posts.listing-3 .penci__post-title{font-size: 14px;margin-top: 0;margin-bottom: 0;position: relative;font-weight: 500;font-family: ' . $font_Roboto . ' }.penci-archive__list_posts.listing-1 .penci-posted-on, .penci-archive__list_posts.listing-3 .penci-posted-on{margin-top: 6px;}.penci-archive__list_posts .penci__post-title a, .penci-block-vc .penci__post-title a{color: ' . $title_color . ';text-decoration: none;}.penci-archive__list_posts .penci__post-title a:hover, .penci-block-vc .penci__post-title a:hover{color: ' . $link_color . ';}.penci-archive__list_posts.listing-1 .post-excerpt, .penci-archive__list_posts.listing-3 .post-excerpt{display: none;}.penci-archive__list_posts .penci-posted-on {margin-top: 9px;font-size: 11px;display:block;}.penci-archive__list_posts .penci-posted-on, .penci-archive__list_posts .penci-posted-on a{color: #999999;}.penci-archive__list_posts .penci-posted-on .fa{margin-right: 5px;}.penci-archive__list_posts .post-excerpt p:last-child{margin-bottom:0;}.penci-archive__list_posts.listing-2 a.post-read-more, .penci-archive__list_posts.listing-3 .penci-post-item-1 a.post-read-more {margin-top: 10px;display: block;}.penci-archive__list_posts a.post-read-more {font-family: ' . $font_Roboto . ' font-weight: 600;text-decoration: none;padding: 0;border-radius: 33px;display: inline-block;line-height: 24px;margin-top: 0;text-transform: uppercase;border: 0;padding: 0;font-size: 11px;line-height: 1;}.penci-archive__list_posts a.post-read-more .fa {margin-left: 3px;font-size: 15px;vertical-align: middle;top: -2px;position: relative;}';
	// AMP listing 2
	echo '.penci-block-vc .penci__post-title,.penci-archive__list_posts.listing-2 .penci__post-title, .penci-archive__list_posts.listing-3 .penci-post-item-1 .penci__post-title{font-size: 17px;margin-top: 10px;margin-bottom: 0;position: relative;font-weight: 500;font-family: ' . $font_Roboto . ';}.penci-archive__list_posts.listing-2 .post-excerpt, .penci-archive__list_posts.listing-3 .penci-post-item-1 .post-excerpt{line-height: 1.71;color: #666666;display:block;margin-top: 5px;}.penci-archive__list_posts.listing-2 .post-excerpt .link-more, .penci-archive__list_posts.listing-3 .penci-post-item-1 .post-excerpt .link-more{display:none;}.penci-archive__list_posts.listing-3 .penci-post-item-1 .article_content {display:block;}.penci-archive__list_posts.listing-3 .penci-post-item-1 .entry-media {margin-right: 0;width: 100%;}.penci-archive__list_posts .penci-amp-byline, .penci-archive__list_posts .penci-comment-count {display: none;}';
	// Pagination
	echo '.pagination {clear: both;overflow: hidden;text-align: center;padding: 20px 0 9px;width: 100%;font-size: 12px;font-weight: 600;}.pagination .nav-links {display: inline-block;margin: -2px -2px 0;vertical-align: top;text-align: center;margin-left: auto;margin-right: auto;}.pagination a, .pagination span.page-numbers {margin-left: 2px;margin-right: 2px;margin-top: 2px;float: left;display: inline-block;background: transparent;border: solid 1px ' . sanitize_hex_color( $border_color ) . ';color: ' . $text_color . ';min-width: 30px;height: 30px;line-height: 28px;transition: all 0.3s;text-decoration: none;box-sizing: border-box;}.pagination span.current, .pagination a:hover {background: ' . sanitize_hex_color( $button_hbgcolor ) . ';border-color: ' . sanitize_hex_color( $button_hbgcolor ) . ';color : ' . sanitize_hex_color( $button_hcolor ) . ';}';
}

if( is_singular() ){
// Comments
	echo '.penci-amp-comment {border-top: 1px solid '. sanitize_hex_color( $border_color ) . ';padding-top: 21px;margin-top: 26px;}.penci-post-item + .post-comments h3.comment-reply-title {padding-top: 0;}h3.comment-reply-title {padding-top: 32px ;}.penci-comments-button {margin-top: 20px;padding-top: 20px;border-top: 1px solid '. sanitize_hex_color( $border_color ) . ';}.penci-comments-button a {display: block;width: 50%;margin-right: auto;margin-left: auto;line-height: 38px;padding: 0px 15px 0;font-weight: bold;}.penci-comments-button + .post-comments {display: none;}.penci-comments-button + .post-comments .comment-reply-title, .penci-post-related + .post-comments .comment-reply-title, .penci-post-related + .post-comments .post-title-box {margin-top: 20px ;border-top: 1px solid '. sanitize_hex_color( $border_color ) . ';}.comments .comment {border-top: 1px solid '. sanitize_hex_color( $border_color ) . ';}';
	echo '.comments > .comment:first-child, .comments .comment > .comment:first-child {border-top: none;}.thecomment {padding-top: 20px;padding-bottom: 0;display: table;width: 100%;}.comments > .comment:first-child > .thecomment {padding-top: 0;}.thecomment .author-img {float: left;margin-right: 20px;width: 60px;border-radius: 50%;}.thecomment .author-img img {border-radius: 50%;max-width:100%;height:auto;}.thecomment .comment-text {margin-left: 0;position: relative;}.thecomment .comment-text span.author, .thecomment .comment-text span.author a {display: block;margin-top: -3px;margin-bottom: 5px;font-family: "Mukta Vaani", sans-serif;font-size: 18px;font-weight: bold;line-height: 1.33;text-align: left;color: #111111;}.thecomment .comment-text span.author a {display: inline-block;margin: 0;}.thecomment .comment-text span.author a:hover {color: #9e9e9e;}.thecomment .comment-text span.date {font-size: 12px;color: #888888;display: block;}.thecomment .comment-text span.date i {margin-right: 5px;}.thecomment .comment-text em {font-size: 12px;display: block;color: orange;letter-spacing: 1px;margin: 5px 0 0;}.thecomment .comment-text em i {font-size: 14px;color: #f3bd00;}.thecomment .comment-content {margin-top: 15px;margin-bottom: 0;}.thecomment .comment-text span.reply {position: absolute;top: 0;right: 0;}.post-comments span.reply a {font-size: 11px;color: #888888;margin-left: 18px;font-family: "Raleway", sans-serif;font-weight: 500;-o-transition: .3s;-moz-transition: .3s;-webkit-transition: .3s;transition: .3s;text-transform: uppercase;line-height: 1;display: inline-block;text-align: center;}.post-comments span.reply a:hover {color: '. $title_color . ';}';
	echo '.comments .comment + #respond {margin-bottom: 20px;}#respond {overflow: hidden;position: relative;}.no-comment-yet #respond {padding-top: 0;border-top: 0;}#respond h3 {font-size: 18px;text-transform: uppercase;position: relative;z-index: 10;display: inline-block;margin: 0;width: 100%;font-size: 18px;font-weight: bold;line-height: 1.67;color: #111111;margin-bottom: 13px;}#respond h3 a {color: #000;display: inline-block;}#respond h3 small a {text-transform: uppercase;font-size: 12px;color: #888888;padding: 0;margin-left: 7px;letter-spacing: 0;-o-transition: .3s;-ms-transition: .3s;-moz-transition: .3s;-webkit-transition: .3s;transition: .3s;font-weight: 500;position: absolute;right: 0;}#respond #cancel-comment-reply-link {font-size: 11px;font-family: '. $font_Roboto . ' font-weight: normal;}#respond h3 small a:hover {color: '. $title_color . ';}#respond form#commentform, form.wpcf7-form {margin-left: -10px;margin-right: -10px;}.mc4wp-form label {text-align: left;margin-bottom: 10px;}#respond p.comment-form-author, #respond p.comment-form-email, #respond p.comment-form-url, .wpcf7 p.name, .wpcf7 p.email, .wpcf7 p.subject {width: 33.333333%;padding: 0 10px;float: left;display: inline-block;margin: 0;}#respond p.comment-form-comment, .wpcf7 p.message {clear: both;margin: 0 10px;}form.comment-form > p, form.comment-form > div, form.comment-form > input, form.comment-form > textarea, form.comment-form > label, form.comment-form > span, form.wpcf7-form > div, form.wpcf7-form > p, form.wpcf7-form > input, form.wpcf7-form > textarea, form.wpcf7-form > label, form.wpcf7-form > span, form#commentform > p, form#commentform > div, form#commentform > input, form#commentform > textarea, form#commentform > label, form#commentform > span {margin: 0 14px;}form#commentform > input[type="checkbox"] {margin-left: 14px ;margin-right: 14px ;}.captchaSizeDivLarge {clear: both;}label#captcha_code_label {display: inline-block;}.woocommerce div.product .woocommerce-tabs .panel #respond p.comment-form-author, .woocommerce div.product .woocommerce-tabs .panel #respond p.comment-form-email {padding: 0;}.penci-amp-single-product .entry-meta-hide, .woocommerce .penci-product-item .entry-meta-hide {display: none;}.woocommerce #review_form #respond p {margin: 10px 14px;}.woocommerce #review_form #respond p.stars {margin-left: 0;margin-right: 0;}#respond label, .wpcf7 label {color: #939393;font-size: 12px;display: block;text-transform: uppercase;font-weight: bold;letter-spacing: 1px;margin-bottom: 8px;}#respond p.form-submit, .wpcf7 p.submit {margin: 0 10px;}#respond input, .wpcf7 input, .widget_wysija input {padding: 10px 15px;max-width: 100%;border: 1px solid '. sanitize_hex_color( $border_color ) . ';margin-bottom: 19px;width: 100%;max-height: 40px;font-size: 12px;line-height: 1.3;color: #888888;}#respond input[type="checkbox"], .wpcf7 input[type="checkbox"], .widget_wysija input[type="checkbox"] {display: inline-block;max-width: none;width: auto;margin-right: 5px;margin-bottom: 0;}#respond input:focus, .wpcf7 input:focus {outline: none;}.jetpack_subscription_widget #subscribe-email input {width: 100% ;padding: 12px 19px 11px ;margin-top: 10px;}#respond textarea, .wpcf7 textarea {padding: 12px 15px;border: 1px solid '. sanitize_hex_color( $border_color ) . ';width: 100%;min-height: 120px;font-size: 12px;margin-bottom: 19px;outline: none;vertical-align: top;font-size: 12px;line-height: 1.3;color: '. sanitize_hex_color( $text_color ) . ';background: transparent;}#respond textarea:focus, .wpcf7 textarea:focus {outline: none;}#respond #submit, .wpcf7 input[type="submit"], .widget_wysija input[type="submit"] {text-transform: uppercase;border-radius: 0;display: inline-block;transition: all .3s;cursor: pointer;width: auto;min-width: 91px;margin: 0;border: none;line-height: 1;font-size: 14px;font-weight: bold;color: #ffffff;}.contact-form input[type=email], .contact-form input[type=text] {max-width: 300px;width: 100%;padding: 10px 15px;}.button.add-comment, #respond #submit, .wpcf7 input[type="submit"], .widget_wysija input[type="submit"] {text-transform: uppercase;border-radius: 0;display: inline-block;transition: all .3s;cursor: pointer;width: auto;min-width: 91px;margin: 0;border: none;line-height: 1;font-size: 14px;font-weight: bold;color: #ffffff;padding: 12px 19px 11px;max-width: 500px;}';

	if( $button_bgcolor ||  $button_color  ){
		echo '.button.add-comment, #respond #submit, .wpcf7 input[type="submit"], .widget_wysija input[type="submit"]{ border-color: '. $button_bgcolor .';  background-color: '. $button_bgcolor .'; color: '. $button_color .'; }';
	}

	if( $button_hbgcolor || $button_hcolor ){
		echo '.button.add-comment:hover, #respond #submit:hover, .wpcf7 input[type="submit"]:hover, .widget_wysija input[type="submit"]:hover { border-color: '. $button_hbgcolor .'; background-color: '. $button_hbgcolor .'; color:'. $button_hcolor .'; }';
	}
}

// Footer
echo '.penci-amp-footer {border-top: 1px solid '. sanitize_hex_color( $border_color ) . ';margin: calc(1.5em - 1px) -15px 0;clear: both;}.penci-amp-footer-nav {padding: 7px 15px;}.penci-amp-footer .penci-amp-footer-container {margin: 0 auto;max-width: calc(840px - 32px);padding: 0;position: relative;}.penci-footer-navigation {list-style: none;margin: 0;padding: 0;text-align: center;}.penci-footer-navigation li {display: inline-block;margin: 0 8px 5px;line-height: 1.3;}.penci-footer-navigation ul.sub-menu{display: none;}.penci-footer-navigation a {color: #494949;font-family: '. $font_Roboto . ';font-weight: 400;font-size: 14px;}.penci-footer-navigation li li {display: none;}.penci-footer-navigation .fa {margin-right: 5px;}.penci-amp-footer h2 {font-size: 1em;line-height: 1.375em;margin: 0 0 .5em;}.penci-amp-footer p {color: '. sanitize_hex_color( $muted_text_color ) . ';font-size: .8em;margin: 0 85px 0 0;}.penci-amp-footer a {text-decoration: none;}.footer__copyright_menu a{color: #fff;}.footer__copyright_menu a:hover{text-decoration: underline;}.back-to-top {bottom: 1.275em;font-size: .8em;font-weight: 600;line-height: 2em;position: absolute;right: 16px;top:7px;}.back-to-top .fa{margin-left: 5px;}.penci-amp-main-link {text-align: center;padding: 17px 10px;}.penci-amp-main-link a {color: '. sanitize_hex_color( $button_color ) . ';text-decoration: none;padding: 1px 15px 0;display: inline-block;border: 0;line-height: 28px;font-size: 11px;font-weight: 400;transition: all 0.3s;letter-spacing: 1px;text-transform: uppercase;background: '. $button_bgcolor . ';}.penci-amp-main-link .fa{padding-right: 5px;}.penci-amp-main-link a:hover {color: '. sanitize_hex_color( $button_hcolor ) . ';border-color: '. sanitize_hex_color( $button_hbgcolor ) . ';background-color: '. sanitize_hex_color( $button_hbgcolor ) . ';}.footer__copyright_menu {clear: both;overflow: hidden;background: #111111;padding-left: 15px;position: relative;padding-top: 11px;padding-bottom: 11px;line-height: 1.3;text-align: left;color: #414141;}';

// Mobile sidebar
echo '.mobile-sidebar .penci-amphtml-accordion-header {background-color: transparent;border: 0;}.sidebar-nav-social .screen-reader-text {clip: rect(1px, 1px, 1px, 1px);position: absolute ;height: 1px;width: 1px;overflow: hidden;}.mobile-sidebar {padding: 5px 15px 15px;width:270px;max-width: 100%;background :#fff;}#close-sidebar-nav {border: 0;background: transparent;position: absolute;top: 5px;right: 10px;z-index: 100;padding:0;}#close-sidebar-nav i {width: 24px;height: 24px;background-color: #fff;line-height: 24px;text-align: center;border-radius: 12px;font-size: 14px;vertical-align: top;color: '. $text_color . ';}.mobile-sidebar .mobile-navigation {clear: both;}.mobile-sidebar .primary-menu-mobile {margin: 0;padding: 0;list-style: none;}.mobile-sidebar .primary-menu-mobile li > ul, .mobile-sidebar .primary-menu-mobile li > ol {margin-bottom: 0;}.mobile-sidebar .primary-menu-mobile li {display: block;border-bottom: 1px solid #dedede;}.mobile-sidebar .primary-menu-mobile > li:last-child, .mobile-sidebar .primary-menu-mobile ul > li:last-child {border-bottom: none;}.mobile-sidebar .primary-menu-mobile li {position: relative;}.mobile-sidebar .primary-menu-mobile li a {font-size: 14px;font-weight: normal;letter-spacing: 0;text-transform: uppercase;color: #131313;margin: 0;position: relative;padding: 12px 0 12px 0;display: block;line-height: 1.3em;text-decoration: none;}.mobile-sidebar .primary-menu-mobile li.menu-item-has-children a {padding-right: 17px;}.mobile-sidebar .primary-menu-mobile li a > i {display: none;}.mobile-sidebar ul.sub-menu {border-top: 1px solid '. sanitize_hex_color( $border_color ) . ';padding: 10px 0 10px 12px;margin-left: 0;}.mobile-sidebar ul.sub-menu ul.sub-menu {border: none;padding: 5px 0 5px 12px;padding-right: 0;margin-left: 0;}.mobile-sidebar ul.sub-menu li {overflow: hidden;border: none;}.mobile-sidebar ul.sub-menu li a {margin: 0 0 0 0;padding: 10px 0;transition: all 0.3s;-webkit-transition: all 0.3s;-moz-transition: all 0.3s;}.mobile-sidebar .primary-menu-mobile .dropdown-toggle {text-decoration: none;position: absolute;top: 0;right: 0;z-index: 20;font-size: 17px;font-style: normal;text-align: right;padding: 11px 0 11px 5px;line-height: 1;color: #131313;transition: all 0.3s;}.mobile-sidebar .primary-menu-mobile .sub-menu li a .dropdown-toggle {padding: 8px 0 8px 5px;}.mobile-sidebar .primary-menu-mobile li.toggled-on > a, .mobile-sidebar .primary-menu-mobile li.toggled-on > .dropdown-toggle, .mobile-sidebar .primary-menu-mobile li.current-menu-item > a, .mobile-sidebar .primary-menu-mobile li.current-menu-item > .dropdown-toggle {color: #3f51b5;}.mobile-sidebar #sidebar-nav-logo {max-width: 230px;padding: 24px 0 0;text-align: center;margin: 0;position: relative;overflow: hidden;font-size: 2em;}.mobile-sidebar #sidebar-nav-logo a {font-family: "Teko", sans-serif;font-weight: 700;line-height: 1;color: #000;padding: 0;margin: 0;text-decoration: none;}.mobile-sidebar .sidebar-nav-social {margin: 0 0 20px 0;padding: 0 10px;text-align: center;}.mobile-sidebar .sidebar-nav-social .inner-header-social {display: inline-block;vertical-align: top;position: relative;}.mobile-sidebar .sidebar-nav-social a {float: left;display: inline-block;vertical-align: top;margin-right: 13px;color: #131313;}';

if( is_search() ){
	echo 'body.penci-amp-body.search-results .penci-search-form.empty {padding: 35px 0;border-bottom: none;min-height: 250px;}.penci-search-form {font-family: '. $font_Roboto . ';font-size: 16px;padding: 0 0 18px;margin: 0 0 6px;}.penci-search-form label {display: block;padding: 0 0 10px;color: '. $text_color . ';}.penci-search-form .search-input {position: relative;}.penci-search-form .search-field {-webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);-moz-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);box-shadow: inset 0 1px 1px rgba(0,0,0,.075);background: transparent;display: block;border: 1px solid '. sanitize_hex_color( $border_color ) . ';font-size: 15px;padding: 0 100px 0 18px;line-height: 36px;width: 100%;-webkit-appearance: textfield;color: '. $text_color . ';}.penci-search-form .search-submit {position: absolute;top: 0;right: 0;bottom: 0;width: auto;text-transform: uppercase;border: none;cursor: pointer;line-height: 38px;padding: 0 22px;}.penci-search-form + .penci-archive__list_posts {border-top:1px solid '. sanitize_hex_color( $border_color ) . ';padding-top: 20px;}';
}

if( is_rtl() ){
	echo 'body.rtl {direction: rtl;unicode-bidi: embed;}.rtl th {text-align: right;}.rtl dd {margin-right: 0;margin-left: auto }.rtl blockquote {border-left: 0;border-right: 2px solid '. sanitize_hex_color( $link_color ) . ';}.rtl blockquote.alignleft {margin: 5px 0 10px 10px;}.rtl blockquote.alignright {margin: 5px 10px 10px 0;}.rtl .penci-owl-featured-area .penci-slider__text {text-align: right;}.rtl .amp-wp-article-header .amp-wp-meta:last-of-type {text-align: left;}.rtl .amp-wp-article-header .amp-wp-meta:first-of-type {text-align: right;}.rtl .penci-amp-entry-meta .entry-meta-item {padding-left: 0;padding-right: 17px;}.rtl .penci-amp-entry-meta i {margin-right: 0;margin-left: 5px;}.rtl .amp-wp-article-content ul, .rtl .amp-wp-article-content ol {margin-left: 0;margin-right: 19px;}.rtl .penci-amp-entry-meta .entry-meta-item:first-child {padding-left: 0;padding-right: 1px;}.rtl .amp-wp-article-content amp-img.alignright {margin-right: 1.5em;margin-left: 0;}.rtl .amp-wp-article-content amp-img.alignright {margin-right: 0;margin-left: 1.5em;}.rtl .wp-caption.alignright {margin-right: 16px;}.rtl .wp-caption.alignleft {margin-left: 16px;}.rtl .penci-amp-tax-category a, .rtl .penci-amp-tags-links a {float: right;text-align: right;}.rtl .penci-amp-tax-category a{margin-right: 0;margin-left: 7px;}.rtl .penci-social-buttons .penci-social-item{text-align: right;}.rtl .penci-post-related .item-related {float: right;}.rtl .penci-archive__list_posts a.post-read-more .fa {margin-left: 0;margin-right: 3px;}.rtl .penci-post-pagination span i {margin-right: 0;margin-left: 6px;}.rtl .penci-post-pagination span i.fa-angle-right {margin: 0 6px 0 0;}.rtl .penci-post-pagination span i.fa-angle-right:before{content: "\f104";}.rtl .penci-post-pagination span i.fa-angle-left:before{content: "\f105";}.rtl .thecomment .author-img {float: right;margin-right: 0;margin-left: 20px;}.rtl .penci-archive__list_posts.listing-1 .entry-media, .rtl .penci-archive__list_posts.listing-3 .entry-media {margin-right: 0;margin-left: 15px;}.rtl .penci-archive__list_posts .penci-posted-on .fa {margin-right: 0;margin-left: 5px;}.rtl .penci-archive__list_posts a.post-read-more .fa {margin-left: 3px;margin-right: 0;}.rtl .penci-archive__list_posts a.post-read-more .fa-angle-right:before {content: "\f104";}.rtl .thecomment .comment-text span.author, .rtl .thecomment .comment-text span.author a {text-align: right;}.rtl .thecomment .comment-text span.date i {margin-right: 0;margin-left: 5px;}.rtl .penci-social-buttons .penci-social-share-text {margin-right: 0;margin-left: 14px;}.rtl .footer__copyright_menu{text-align: right;padding-left: 0;padding-right: 15px;}.penci-amp-footer p {margin: 0 0 0 85px;}.rtl .back-to-top {right: auto;left: 16px;}.rtl .back-to-top .fa {margin-left: 0;margin-right: 5px;}.pagination a, .pagination span.page-numbers{float: right;}.rtl .pagination a i.fa-angle-right:before{content: "\f104";}.rtl .pagination a i.fa-angle-left:before{content: "\f105";}.rtl .penci-amp-main-link .fa {padding-right: 0;padding-left: 3px;}.rtl .penci-amp-wp-header .navbar-search {right: auto;left: 0;}.rtl .penci-amp-wp-header .navbar-toggle {left: auto;right: 0;}.rtl #close-sidebar-nav {right: auto;left: 10px;}.rtl .mobile-sidebar .primary-menu-mobile .dropdown-toggle {right: auto;left: 0;}.rtl .mobile-sidebar .penci-amphtml-accordion-header {background-color: transparent;padding-right: 0;padding-left: 20px;}.rtl .mobile-sidebar .primary-menu-mobile li.menu-item-has-children a {padding-right: 0;padding-left: 17px;}.rtl .mobile-sidebar ul.sub-menu {padding: 10px 12px 10px 0;}.rtl .penci-search-form .search-submit {right: auto;left: 0;}.rtl .penci-search-form .search-field {padding: 0 18px 0 100px;}';
}

if( get_theme_mod( 'penci_enable_cookie_law' ) ){
	$gprd_bgcolor = get_theme_mod( 'penci_gprd_bgcolor' );
	$gprd_bgcolor = $gprd_bgcolor ? $gprd_bgcolor : '#f5f5f5';

	$gprd_color = get_theme_mod( 'penci_gprd_color' );
	$gprd_color = $gprd_color ? $gprd_color : '#212121';

	$gprd_btn_color = get_theme_mod( 'penci_gprd_btn_color' );
	$gprd_btn_color = $gprd_btn_color ? $gprd_btn_color : '#ffffff';

	$gprd_btn_bgcolor = get_theme_mod( 'penci_gprd_btn_bgcolor' );
	$gprd_btn_bgcolor = $gprd_btn_bgcolor ? $gprd_btn_bgcolor : '#212121';

	$gprd_border      = get_theme_mod( 'penci_gprd_border' );
	$gprd_border = $gprd_border ? $gprd_border : '';

	echo '#amp-user-notification-gdpr {display: block;color: '. $gprd_color . ';font-size: 14px;}.penci-gprd-law {padding: 7px 15px;color: inherit;font-size: inherit;display: block;text-align: center;transition: all 0.3s;-webkit-transition: all 0.3s;background: '. $gprd_bgcolor . ';'. ( $gprd_border ? 'border-top: 2px solid ' . $gprd_border . ';' : '' ) . ' }.penci-gprd-law p {font-size: inherit;color: inherit;margin: 0;display: inline-block;}.penci-gprd-law .penci-gprd-accept, .penci-gprd-law .penci-gprd-more {display: inline-block;padding: 0;line-height: 1;font-size: inherit;color: inherit;margin-left: 10px;transition: opacity 0.3s;-webkit-transition: opacity 0.3s;}.penci-gprd-law .penci-gprd-accept {background: '. $gprd_btn_bgcolor . ';color: '. $gprd_btn_color . ';padding: 6px 15px;border: 0;text-transform: none;}.penci-gprd-law .penci-gprd-accept:hover, .penci-gprd-law .penci-gprd-more:hover {opacity: 0.8;}.penci-gprd-law, #amp-user-notification-gdpr .penci-gdrd-show {position: fixed;z-index: 19999;left: 0;bottom: 0;right: 0;width: 100%;}#amp-user-notification-gdpr .penci-gdrd-show {display: inline-block;width: auto;right: 100px;left: auto;padding: 6px 15px;font-size: inherit;color: inherit;background: #f5f5f5;line-height: 1;transition: all 0.3s;-webkit-transition: all 0.3s;transition-delay: 0.2s;-webkit-transition-delay: 0.2s;}';
}

if ( class_exists( 'WooCommerce' ) ){
	echo "@font-face{font-family:'star';src:url('" . penci_amp_get_asset_url( 'fonts/star.eot' ) ."');src:url('" . penci_amp_get_asset_url( 'fonts/star.eot?#iefix' ) ."') format('embedded-opentype'),url('" . penci_amp_get_asset_url( 'fonts/star.woff' ) ."') format('woff'),url('" . penci_amp_get_asset_url( 'fonts/star.ttf' ) ."') format('truetype'),url('" . penci_amp_get_asset_url( 'fonts/star.svg#star' ) ."') format('svg');font-weight:400;font-style:normal}@font-face{font-family:'WooCommerce';src:url('" . penci_amp_get_asset_url( 'fonts/WooCommerce.eot' ) ."');src:url('" . penci_amp_get_asset_url( 'fonts/WooCommerce.eot?#iefix' ) ."') format('embedded-opentype'),url('" . penci_amp_get_asset_url( 'fonts/WooCommerce.woff' ) ."') format('woff'),url('" . penci_amp_get_asset_url( 'fonts/WooCommerce.ttf' ) ."') format('truetype'),url('" . penci_amp_get_asset_url( 'fonts/WooCommerce.svg#WooCommerce' ) ."') format('svg');font-weight:400;font-style:normal}";
	echo '.penci-archive__list_product {margin: -20px -10px 0;overflow: hidden;}.penci-archive__list_product .penci-product-item {width: 50%;padding:20px 10px 0;float:left;}.penci-archive__list_product .penci-product-item:nth-child( 2n+ 1 ) {clear: both;}.penci-archive__list_product .penci-product-item .article_content{position: relative;padding:0;}.onsale {margin: 0;right: 10px;top: 10px;position: absolute;min-width: 38px;height: 20px;line-height: 20px;background: #111111;text-align: center;padding: 0 7px;font-weight: bold;font-size: 12px;text-transform: uppercase;color: #fff;border-radius: 0;-webkit-border-radius: 0;-moz-border-radius: 0;white-space: nowrap;-webkit-font-smoothing: antialiased;z-index: 9;display: inline-block;}.penci-product-item .star-rating {margin: 0;position: absolute;top: 16px;left: 10px;z-index: 5;display: block;overflow: hidden;height: 1em;line-height: 1;font-size: 11px;width: 5.4em;font-family: star;}.star-rating::before {content: "\73\73\73\73\73";color: #d3ced2;float: left;top: 0;left: 0;position: absolute;}.star-rating span {color: '. $link_color . ';overflow: hidden;float: left;top: 0;left: 0;position: absolute;padding-top: 1.5em;}.star-rating span::before {content: "\53\53\53\53\53";top: 0;position: absolute;left: 0;}.penci-product-item .entry-text {text-align: center;}.penci-product-item .penci__product__title {font-size: 18px;text-align: center;padding: 0;margin: 20 0 8px 0;color: '. $title_color . ';letter-spacing: 0;}.penci-product-item .penci__product__title a{color: ' . $title_color . ';}.penci-product-item .penci__product__title a:hover {color: '. $link_color . ';}.penci-product-item .woocommerce-price {margin: 0;text-align: center;font-size: 18px;color: '. $text_color . ';text-decoration: none;font-weight: normal;display: block;}.penci-product-item .woocommerce-price del {display: inline-block;font-size: 16px;color: #ccc;margin-right: 10px;opacity: 1;text-decoration: line-through;}.penci-product-item .woocommerce-price ins {font-weight: normal;}.penci-product-item .button {font-size: 14px;font-weight: bold;margin-top: 15px;display: block;border-radius: 0;-webkit-border-radius: 0;-moz-border-radius: 0;text-align: center;text-transform: uppercase;padding: 0;height: 40px;line-height: 40px;transition: .3s;cursor: pointer;width:100%;}.penci-amp-single-product {position: relative;}.penci-amp-single-product .product-thumbnails{width:45%;float: left;}.penci-amp-single-product .product-thumbnails + .entry-summary {width:55%;float: left;padding-left:20px;}.product-gallery {margin-top:0 -10px;}.penci-amp-product-gallery__image {width:33.3333%;float:left;padding: 10px 5px;}.penci-amp-product-gallery__image:nth-child( 3n + 1 ) {clear: both;}.penci-amp-single-product .star-rating, .penci-amp-woo-tabs .star-rating {float: left;overflow: hidden;position: relative;height: 1em;line-height: 1;font-size: 1em;width: 5.4em;font-family: star;}.penci-amp-single-product .onsale {display: none;}.penci-amp-woo-tabs {clear: both;padding-top: 20px;display: block;}.penci-amp-single-product .woocommerce-review-link {position: relative;top: -3px;padding-left: 5px;padding-left: 5px;}.penci-amp-woo-tabs .woocommerce-Tabs-panel{padding: 10px;border-right: 1px solid '. $border_color . ';border-left: 1px solid '. $border_color . ';}.penci-amp-woo-tabs section:last-child .woocommerce-Tabs-panel{padding: 10px;border-bottom: 1px solid '. $border_color . ';}#reviews #comments h2 {font-size: 15px;color: '. $text_color . ';clear: both;letter-spacing: 0;line-height: 1.3em;margin-bottom: 17px;text-transform: uppercase;font-weight: bold;text-align: left;display: block;}#reviews #comments ol.commentlist {margin: 0;width: 100%;background: 0 0;list-style: none;}#reviews #comments ol.commentlist li {padding: 0;margin: 0 0 20px;border: 0;position: relative;background: 0;border: 0;}#reviews #comments ol.commentlist li img.avatar {display:none;}#reviews #comments ol.commentlist li .comment-text {border: 1px solid '. $border_color . ';padding: 12px 20px;border-radius: 0;-webkit-border-radius: 0;-moz-border-radius: 0;margin: 0;}#reviews .star-rating {float: right;}#respond .comment-reply-title {font-size: 15px;color: '. $text_color . ';clear: both;letter-spacing: 0;line-height: 1.3em;margin-bottom: 17px;text-transform: uppercase;font-weight: bold;text-align: left;display: block;margin-top: 24px;}.penci-post-related.products .penci-archive__list_product{margin-top: 0;}.tab-title-description {padding: 5px 10px;}img {height: auto;max-width: 100%;}.alignnone {margin: 5px 0 20px }.alignleft {display: inline;float: left;margin-right: 1.5em }.alignright {display: inline;float: right;margin-left: 1.5em }.woocommerce div.product .woocommerce-tabs #tab-description ul, .woocommerce div.product .woocommerce-tabs #tab-description ol {padding-left: 20px;}';
}


// Reponsive
echo '@media only screen and (max-width : 680px){.amp-featured-slider .content-holder h3 {font-size: 15px;}}';
echo '@media only screen and (max-width : 480px){.penci-search-form .search-submit {padding: 0 15px;}.amp-featured-slider .img-holder:before {padding-top: 80%;}.amp-featured-slider .content-holder{padding-left: 15px;padding-right:15px;width: 100%;}.penci-archive__list_posts.listing-1 .entry-media, .penci-archive__list_posts.listing-3 .entry-media {width: 108px;}.penci-post-related .item-related {width: 100%;margin-bottom: 20px;}.penci-post-related .item-related:last-child {margin-bottom: 0;}#respond p.comment-form-author, #respond p.comment-form-email, #respond p.comment-form-url, .wpcf7 p.name, .wpcf7 p.email, .wpcf7 p.subject {width:100%;}.penci-archive__list_product .penci-product-item {width: 100%;padding: 20px 10px 0;float: left;}.penci-amp-single-product .product-thumbnails, .penci-amp-single-product .product-thumbnails + .entry-summary {width:100%;}}';
echo '@media only screen and (min-width : 600px){.amp-featured-slider .content-holder {left: 26px;right: 26px;}}';

echo 'h1, h2, h3, h4, h5, h6, .mobile-sidebar .primary-menu-mobile li a, .penci-archive__list_posts.listing-1 .penci__post-title, .penci-archive__list_posts.listing-3 .penci__post-title,.penci-block-vc .penci__post-title, .penci-archive__list_posts.listing-2 .penci__post-title, .penci-archive__list_posts.listing-3 .penci-post-item-1 .penci__post-title, .penci-archive__list_posts a.post-read-more, .penci-footer-navigation a, .penci-search-form, #respond h3, .penci-post-related .item-related h4, #respond #cancel-comment-reply-link {'. $custom_typo_title .';}';

if( $font_size_title = penci_amp_get_setting( 'penci_amp_font_for_size_title' ) ){
	echo '.penci-post-pagination h5, .penci-post-related .item-related h4, .penci-archive__list_posts.listing-1 .penci__post-title, .penci-archive__list_posts.listing-3 .penci__post-title,.penci-block-vc .penci__post-title, .penci-archive__list_posts.listing-2 .penci__post-title, .penci-archive__list_posts.listing-3 .penci-post-item-1 .penci__post-title{font-size:'. $font_size_title . 'px;}';
}
if( is_page() ) {
	$ct_css_block = '.penci-post-cat,.penci-schema-markup,.penci-posted-on .updated, .penci-comment-count,';
	$ct_css_block .= '.penci_block_weather,.penci-fancy-heading,.penci-mailchimp,.penci-block-vc .entry-meta-item,';
	$ct_css_block .= '.penci-banner-box .penci-block-heading, .penci-promo-text,.penci-block-vc .social-buttons,';
	$ct_css_block .= '.penci-post-excerpt,.penci-piechart,.icon-post-format,.penci-cat-links,.penci-block_36 .penci_mobj__img ,.penci-block_38{ display: none; }';
	$ct_css_block .= '.penci-block-vc .penci__post-title{margin: 0;}.penci-block-vc .penci__post-title a{color: #131313;text-decoration: none;margin: 0;}.penci-block-vc .penci__post-title a:hover{ color: #3f51b5;}';
	$ct_css_block .= '.penci-block-vc .penci_post-meta{margin-top: 6px;color: #999999; margin-bottom:0; font-size: 11px;display: block; }';
	$ct_css_block .= '.penci-block-vc article ,.penci_media_object,.penci-post-item-inner-relative,';
	$ct_css_block .= '.penci-block-vc article  .penci-post-item__inner{display: flex;align-items: flex-start; width: 100%; }';
	$ct_css_block .= '.penci_media_object .penci_mobj__img,';
	$ct_css_block .= '.penci-block-vc article > .penci-pthumb-wrap,';
	$ct_css_block .= '.penci-post-item__inner > .penci_post_thumb,';
	$ct_css_block .= '.penci-post-item-inner-relative > .penci_post_thumb,';
	$ct_css_block .= '.penci-post-item__inner > .penci-pthumb-wrap,';
	$ct_css_block .= '.penci-block-vc article > .penci_post_thumb{ margin-right: 20px; position: relative;margin-right: 15px; width: 35%;  }';
	$ct_css_block .= '.penci_media_object .penci_mobj__body,.penci-block-vc .penci_post_thumb + .penci_post_content, .penci-block-vc .penci_post_content{ flex: 1; }';
	$ct_css_block .= '.penci-block-vc .amp-wp-article-content amp-img {margin-top:0; margin-bottom: 0;}';
	$ct_css_block .= '.penci-block-vc article .penci_media_object{ width: 100%; }.penci-irp-type-grid ul{margin-left: 0;}.penci-irp-type-grid li{list-style:none;}';
	$ct_css_block .= '.penci-block_29 .penci-block_content__items > .penci_media_object{display:block;}';
	$ct_css_block .= '.penci-block_10 article,.penci-block_15 article{margin-bottom:20px;} .penci-block_10 .penci-posted-on,.penci-block_15 .penci-post-order { padding: 7px 5px 5px; border: 1px solid #111; font-size: 14px; font-weight: 700; line-height: 1.29; text-align: center; color: #111111; width: 60px; text-transform: uppercase; }';
	echo $ct_css_block;
}

/**
 * Customizer
 */
penci_amp_css_hidden_attr( 'penci_amp_home_show_slider', '.homepage-slider' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_comment', '.penci-amp-comment' );

// Header bar
penci_amp_css_hidden_attr( 'penci_amp_show_sidebar', '.penci-amp-wp-header .navbar-toggle' );
penci_amp_css_hidden_attr( 'penci_amp_show_search', '.penci-amp-wp-header .navbar-search' );

// Featured posts
penci_amp_css_hidden_attr( 'penci_amp_home_show_pdate', '.penci-archive__list_posts .penci-post-item .penci-posted-on' );
penci_amp_css_hidden_attr( 'penci_amp_home_show_excrept', '.penci-archive__list_posts.listing-2 .post-excerpt, .penci-archive__list_posts.listing-3 .penci-post-item-1 .post-excerpt' );
penci_amp_css_hidden_attr( 'penci_amp_home_show_readmore', '.penci-archive__list_posts a.post-read-more, .penci-archive__list_posts.listing-2 a.post-read-more, .penci-archive__list_posts.listing-3 .penci-post-item-1 a.post-read-more' );

// Post
penci_amp_css_hidden_attr( 'penci_amp_posts_show_thumb', '.amp-wp-article-featured-image' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_ptag', '.penci-amp-tags-links' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_pcat', '.penci-amp-tax-category' );
penci_amp_css_hidden_attr( 'penci_amp_home_show_pagination', '.penci-amp-pagination' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_show_pag', '.penci-post-pagination' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_related', '.penci-post-related' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_pmeta', '.penci-amp-entry-meta' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_share', '.penci-social-share-footer, .penci-amp-single .penci-social-buttons' );
// Sidebar
penci_amp_css_hidden_attr( 'penci_amp_sidebar_show_socail', '.sidebar-nav-social' );
penci_amp_css_hidden_attr( 'penci_amp_sidebar_show_logo', '#sidebar-nav-logo' );

// Footer
penci_amp_css_hidden_attr( 'penci_amp_no_version_link', '.penci-amp-main-link' );
penci_amp_css_hidden_attr( 'penci_amp_gototop', '.back-to-top' );
?>

<?php
// Custom css
echo get_theme_mod( 'penci_amp_customcss' );
?>
