<!doctype html>
<html amp <?php echo Penci_AMP_HTML_Utils::build_attributes_string( $this->get( 'html_tag_attributes' ) ); ?>>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no">
	<?php do_action( 'penci_amp_post_template_head', $this ); ?>
	<style amp-custom>
		<?php $this->load_parts( array( 'style', 'style-viral-quiz' ) ); ?>
		<?php do_action( 'penci_amp_post_template_css', $this ); ?>
	</style>
	<script async custom-element="amp-consent" src="https://cdn.ampproject.org/v0/amp-consent-0.1.js"></script>
</head>

<?php $sticky_header = penci_amp_get_setting( 'penci_amp_sticky_header' ) ? ' sticky-header' : ''; ?>
<body  class="<?php echo join( ' ', get_body_class( 'penci-amp-body penci-amp-single' . $sticky_header ) ); ?>">
<?php do_action( 'penci_amp_after_body_tag', $this ); ?>
<?php $this->load_parts( array( 'sidebar' ) ); ?>
<div class="penci-amp-wrapper">
	<?php $this->load_parts( array( 'header-bar' ) ); ?>
	<div class="wrap">
		<?php  if( is_page_template( 'page-templates/full-width.php' ) ){ ?>
		<div class="amp-wp-article-content">
			<?php echo $this->get( 'post_penci_amp_content' ); // amphtml content; no kses ?>
		</div>
		<?php }else{ ?>
		<article class="amp-wp-article">
			<header class="amp-wp-article-header">
				<?php penci_amp_render_google_adsense( 'penci_amp_ad_single_above_cat' ); ?>
				<?php $this->load_parts( array( 'meta-taxonomy' ) ); ?>
				<h1 class="amp-wp-title"><?php echo wp_kses_data( $this->get( 'post_title' ) ); ?></h1>
				<div class="penci-amp-entry-meta">
					<?php $this->load_parts( array( 'entry-meta' ) ); ?>
				</div>
			</header>

			<?php $this->load_parts( array( 'featured-image' ) ); ?>
			<?php penci_amp_render_google_adsense( 'penci_amp_ad_single_below_img' ); ?>
			<div class="amp-wp-article-content">
				<?php echo $this->get( 'post_penci_amp_content' ); // amphtml content; no kses ?>
			</div>
			<?php penci_amp_render_google_adsense( 'penci_amp_ad_single_below_content' ); ?>
			<footer class="amp-wp-article-footer">
				<?php $this->load_parts( array( 'meta-tag', 'social-share' ) ); ?>
			</footer>

		</article>

		<?php $this->load_parts( array( 'post_pagination','related_posts' ) ); ?>
		<?php $this->load_parts( array( 'comments' ) ); ?>

		<?php } ?>
		<?php $this->load_parts( array( 'footer' ) ); ?>
	</div>
	<?php do_action( 'penci_amp_post_template_footer', $this ); ?>
</div>
</body>
</html>
