<?php

if ( !class_exists( 'Penci_AMP_Social_Share' ) ):
	class Penci_AMP_Social_Share {
		/**
		 * @param $list_social array( 'total_share','facebook','twitter','google_plus','pinterest','linkedin','tumblr','reddit' ,'stumbleupon','email'  )
		 * @param bool $echo
		 *
		 * @return string
		 */
		public static function get_social_share( $list_social ) {
			$output      = '';


			$icon_line_svg = '<svg aria-hidden="true" data-prefix="fab" data-icon="line" class="svg-inline--fa fa-line fa-w-14" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M272.1 204.2v71.1c0 1.8-1.4 3.2-3.2 3.2h-11.4c-1.1 0-2.1-.6-2.6-1.3l-32.6-44v42.2c0 1.8-1.4 3.2-3.2 3.2h-11.4c-1.8 0-3.2-1.4-3.2-3.2v-71.1c0-1.8 1.4-3.2 3.2-3.2H219c1 0 2.1.5 2.6 1.4l32.6 44v-42.2c0-1.8 1.4-3.2 3.2-3.2h11.4c1.8-.1 3.3 1.4 3.3 3.1zm-82-3.2h-11.4c-1.8 0-3.2 1.4-3.2 3.2v71.1c0 1.8 1.4 3.2 3.2 3.2h11.4c1.8 0 3.2-1.4 3.2-3.2v-71.1c0-1.7-1.4-3.2-3.2-3.2zm-27.5 59.6h-31.1v-56.4c0-1.8-1.4-3.2-3.2-3.2h-11.4c-1.8 0-3.2 1.4-3.2 3.2v71.1c0 .9.3 1.6.9 2.2.6.5 1.3.9 2.2.9h45.7c1.8 0 3.2-1.4 3.2-3.2v-11.4c0-1.7-1.4-3.2-3.1-3.2zM332.1 201h-45.7c-1.7 0-3.2 1.4-3.2 3.2v71.1c0 1.7 1.4 3.2 3.2 3.2h45.7c1.8 0 3.2-1.4 3.2-3.2v-11.4c0-1.8-1.4-3.2-3.2-3.2H301v-12h31.1c1.8 0 3.2-1.4 3.2-3.2V234c0-1.8-1.4-3.2-3.2-3.2H301v-12h31.1c1.8 0 3.2-1.4 3.2-3.2v-11.4c-.1-1.7-1.5-3.2-3.2-3.2zM448 113.7V399c-.1 44.8-36.8 81.1-81.7 81H81c-44.8-.1-81.1-36.9-81-81.7V113c.1-44.8 36.9-81.1 81.7-81H367c44.8.1 81.1 36.8 81 81.7zm-61.6 122.6c0-73-73.2-132.4-163.1-132.4-89.9 0-163.1 59.4-163.1 132.4 0 65.4 58 120.2 136.4 130.6 19.1 4.1 16.9 11.1 12.6 36.8-.7 4.1-3.3 16.1 14.1 8.8 17.4-7.3 93.9-55.3 128.2-94.7 23.6-26 34.9-52.3 34.9-81.5z"></path></svg>';
			$icon_viber_svg = '<svg aria-hidden="true" data-prefix="fab" data-icon="viber" class="svg-inline--fa fa-viber fa-w-16" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M444 49.9C431.3 38.2 379.9.9 265.3.4c0 0-135.1-8.1-200.9 52.3C27.8 89.3 14.9 143 13.5 209.5c-1.4 66.5-3.1 191.1 117 224.9h.1l-.1 51.6s-.8 20.9 13 25.1c16.6 5.2 26.4-10.7 42.3-27.8 8.7-9.4 20.7-23.2 29.8-33.7 82.2 6.9 145.3-8.9 152.5-11.2 16.6-5.4 110.5-17.4 125.7-142 15.8-128.6-7.6-209.8-49.8-246.5zM457.9 287c-12.9 104-89 110.6-103 115.1-6 1.9-61.5 15.7-131.2 11.2 0 0-52 62.7-68.2 79-5.3 5.3-11.1 4.8-11-5.7 0-6.9.4-85.7.4-85.7-.1 0-.1 0 0 0-101.8-28.2-95.8-134.3-94.7-189.8 1.1-55.5 11.6-101 42.6-131.6 55.7-50.5 170.4-43 170.4-43 96.9.4 143.3 29.6 154.1 39.4 35.7 30.6 53.9 103.8 40.6 211.1zm-139-80.8c.4 8.6-12.5 9.2-12.9.6-1.1-22-11.4-32.7-32.6-33.9-8.6-.5-7.8-13.4.7-12.9 27.9 1.5 43.4 17.5 44.8 46.2zm20.3 11.3c1-42.4-25.5-75.6-75.8-79.3-8.5-.6-7.6-13.5.9-12.9 58 4.2 88.9 44.1 87.8 92.5-.1 8.6-13.1 8.2-12.9-.3zm47 13.4c.1 8.6-12.9 8.7-12.9.1-.6-81.5-54.9-125.9-120.8-126.4-8.5-.1-8.5-12.9 0-12.9 73.7.5 133 51.4 133.7 139.2zM374.9 329v.2c-10.8 19-31 40-51.8 33.3l-.2-.3c-21.1-5.9-70.8-31.5-102.2-56.5-16.2-12.8-31-27.9-42.4-42.4-10.3-12.9-20.7-28.2-30.8-46.6-21.3-38.5-26-55.7-26-55.7-6.7-20.8 14.2-41 33.3-51.8h.2c9.2-4.8 18-3.2 23.9 3.9 0 0 12.4 14.8 17.7 22.1 5 6.8 11.7 17.7 15.2 23.8 6.1 10.9 2.3 22-3.7 26.6l-12 9.6c-6.1 4.9-5.3 14-5.3 14s17.8 67.3 84.3 84.3c0 0 9.1.8 14-5.3l9.6-12c4.6-6 15.7-9.8 26.6-3.7 14.7 8.3 33.4 21.2 45.8 32.9 7 5.7 8.6 14.4 3.8 23.6z"></path></svg>';
			$post_id = get_the_ID();

			foreach ( ( array ) $list_social as $social ) {

				$link     = Penci_AMP_Link_Sanitizer::__pre_url_off( get_the_permalink() );
				$text     = get_the_title( get_the_ID() );
				$img_link = self::get_featured( $post_id, 'post-thumbnail' );


				if ( 'email' == $social ) {
					$output .= sprintf(
						'<a class="penci-social-item email" target="_blank" href="%s"><i class="fa fa-envelope"></i></a>',
						self::get_link_share_post( 'email', $link, $text, '' )
					);
					continue;
				}elseif ( 'line' == $social ) {
					$output .= sprintf(
						'<a class="penci-social-item line" href="https://lineit.line.me/share/ui?url=%s&text=%s"><span>%s</span></a>',
						$link,
						get_the_title( $post_id ),
						$icon_line_svg
					);
					continue;
				}

				$link_share  = self::get_link_share_post( $social, $link, $text, $img_link );

				if( 'viber' == $social ) {

					$output .= sprintf(
						'<a class="penci-social-item %s" target="_blank" href="%s"><span>%s</span></a>',
						esc_attr( $social ),
						$link_share,
						$icon_viber_svg
					);

					continue;
				}

				$output .= sprintf(
					'<a class="penci-social-item %s" target="_blank" href="%s"><i class="fa fa-%s"></i></a>',
					esc_attr( $social ),
					$link_share,
					'google_plus' == $social ? 'google-plus' : esc_attr( $social )

				);
			}

			echo ( $output );
		}

		public static function get_link_share_post( $social_key, $link, $text = '', $img_link = '' ) {
			switch ( $social_key ) {
				case 'facebook':
					$link = htmlentities( add_query_arg( array( 'u' => rawurlencode( $link ), ), 'https://www.facebook.com/sharer/sharer.php' ) );;
					break;
				case 'twitter':
					$link = htmlentities( add_query_arg( array(
						'url'  => rawurlencode( $link ),
						'text' => rawurlencode( $text ),
					), 'https://twitter.com/intent/tweet' ) );
					break;
				case 'pinterest':
					$link = htmlentities( add_query_arg( array(
						'url'         => rawurlencode( $link ),
						'media'       => rawurlencode( $img_link ),
						'description' => rawurlencode( $text ),
					), esc_url( 'http://pinterest.com/pin/create/button' ) ) );
					break;

				case 'google_plus':
					$link = htmlentities( add_query_arg( array( 'url' => rawurlencode( $link ), ), 'https://plus.google.com/share' ) );
					break;

				case 'linkedin':
					$link = htmlentities( add_query_arg( array(
						'url'   => rawurlencode( $link ),
						'title' => rawurlencode( $text ),
					), 'https://www.linkedin.com/shareArticle?mini=true' ) );
					break;

				case 'tumblr':
					$link = htmlentities( add_query_arg( array(
						'url'  => rawurlencode( $link ),
						'name' => rawurlencode( $text ),
					), 'https://www.tumblr.com/share/link' ) );
					break;
				case 'reddit':
					$link = htmlentities( add_query_arg( array(
						'url'   => rawurlencode( $link ),
						'title' => rawurlencode( $text ),
					), 'https://reddit.com/submit' ) );
					break;
				case 'stumbleupon':
					$link = htmlentities( add_query_arg( array(
						'url'   => rawurlencode( $link ),
						'title' => rawurlencode( $text ),
					), 'https://www.stumbleupon.com/submit' ) );
					break;
				case 'email':
					$link = esc_url ( 'mailto:?subject=' . $text . '&BODY=' . $link );
					break;
				case 'telegram':
					$link = htmlentities( add_query_arg( array(
						'url'  => rawurlencode( $link ),
						'text' => rawurlencode( $text ),
					), 'https://telegram.me/share/url' ) );
					break;

				case 'whatsapp':
					$link = htmlentities( add_query_arg( array(
						'text' => rawurlencode( $text ) . ' %0A%0A ' . rawurlencode( $link ),
					), 'whatsapp://send' ) );
					break;

				case 'digg':
					$link = htmlentities( add_query_arg( array(
						'url' => rawurlencode( $link ),
					), 'https://www.digg.com/submit' ) );
					break;
				case 'vk':
					$link = htmlentities( add_query_arg( array(
						'url' => rawurlencode( $link ),
					), 'https://vkontakte.ru/share.php' ) );
					break;

				case 'line':
					$link = htmlentities( add_query_arg( array(
						'text' => rawurlencode( $text ) . ' %0A%0A ' . rawurlencode( $link ),
					), 'https://line.me/R/msg/text/' ) );
					break;
				case 'viber':
					$link = 'iber://forward?text=Check out this article: ' . rawurlencode( $link );
					break;
				default:
					return '';
			}

			return $link;
		}

		public static function get_featured($post_id){
			$image_html = get_the_post_thumbnail( $post_id, 'post-thumbnail' );
			preg_match( '@src="([^"]+)"@', $image_html, $match );
			$src = array_pop( $match );

			return Penci_AMP_Link_Sanitizer::__pre_url_off( $src );
		}
	}
endif;