<?php
/**
 * The default template for displaying content
 *
 * @author      Nanopeflican
 * @link        http://nanopeflican.co
 * @copyright   Copyright (c) 2015 Nanopeflican
 * @license     GPL v2
 */
$format = get_post_format();
$placeholder_image = get_template_directory_uri(). '/assets/images/layzyload-grid.jpg';
//share
$share = get_theme_mod('peflican_post_meta_share', false);
?>

<article <?php post_class('post-item post-grid disss clearfix'); ?>>
    <div class="article-tran hover-share-item">
        <?php if(has_post_thumbnail()) : ?>
            <?php if(!get_theme_mod('sp_post_thumb')) : ?>
                <?php if(has_post_thumbnail()) : ?>
                    <?php
                    $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "peflican-blog-featured" );
                    ?>
                    <div class="post-image">
                        <a href="<?php echo get_permalink() ?>" class="bgr-item hidden-xs"></a>
                        <a href="<?php echo get_permalink();?>">
                            <img  class="lazy" src="<?php echo esc_url($placeholder_image);?>" data-src="<?php echo esc_attr($thumbnail_src[0]);?>" alt="post-image"/>
                        </a>
                        <?php if(has_post_format('video')) : ?>
                            <div class="post-video">
                                <?php if ( current_theme_supports( 'post-formats', $format ) ):?>
                                    <a  href="<?php echo get_post_format_link( $format ); ?>" class="post-format"><i class="fa fa-play"></i></a>
                                <?php endif;?>
                            </div>
                        <?php endif;?>
                    </div>
                <?php endif;?>
                <div class="article-content">
                    <span class="post-cat"><?php echo peflican_category(' '); ?></span>
                    <span class="post-date">
                        <?php echo get_the_date('M d, Y'); ?>
                    </span>
                    <div class="entry-header clearfix">
                        <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php else :
            $placeholder_image = get_template_directory_uri(). '/assets/images/layzyload-tran.jpg';
            ?>
            <div class="post-image  placeholder-trans">
                <?php
                if ($share) { ?>
                    <?php get_template_part('templates/share');
                }
                ?>
            </div>
            <div class="article-content no-thumb">
                <span class="post-cat"><?php echo peflican_category(' '); ?></span>
                <div class="entry-header clearfix">
                    <header class="entry-header-title">
                        <?php
                        the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
                        ?>
                    </header>
                </div>
                <div class="article-meta clearfix">
                    <?php peflican_entry_meta(); ?>
                </div>
                <div class="entry-content">
                    <div>
                        <?php echo peflican_content(25);?>
                    </div>
                    <a  class="btn-read" href="<?php echo get_permalink() ?>"><?php esc_html_e('Read More','peflican')?></a>
                </div>
            </div>
        <?php endif; ?>
    </div>

</article><!-- #post-## -->
