<?php


// COLOR SCHEME
if ( is_file( dirname(__FILE__) . '/../../../../plugins/bold-page-builder/content_elements_misc/misc.php' ) ) {
	require_once( dirname(__FILE__) . '/../../../../plugins/bold-page-builder/content_elements_misc/misc.php' );
}
if ( function_exists('bt_bb_get_color_scheme_param_array') ) {
	$color_scheme_arr = bt_bb_get_color_scheme_param_array();
} else {
	$color_scheme_arr = array();
}


// COLUMN - PADDING, SHADOW, SHAPE, BORDER
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_column', 'padding' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column', array(
		array( 'param_name' => 'padding', 'type' => 'dropdown', 'heading' => esc_html__( 'Inner padding', 'pawsitive' ), 'preview' => true,
			 'responsive_override' => true,
			'value' => array(
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Double', 'pawsitive' ) 		=> 'double',
				esc_html__( 'Text Indent', 'pawsitive' ) 	=> 'text_indent',
				esc_html__( '0px', 'pawsitive' ) 			=> '0',
				esc_html__( '5px', 'pawsitive' ) 			=> '5',
				esc_html__( '10px', 'pawsitive' ) 		=> '10',
				esc_html__( '15px', 'pawsitive' ) 		=> '15',
				esc_html__( '20px', 'pawsitive' ) 		=> '20',
				esc_html__( '25px', 'pawsitive' ) 		=> '25',
				esc_html__( '30px', 'pawsitive' ) 		=> '30',
				esc_html__( '35px', 'pawsitive' ) 		=> '35',
				esc_html__( '40px', 'pawsitive' ) 		=> '40',
				esc_html__( '45px', 'pawsitive' ) 		=> '45',
				esc_html__( '50px', 'pawsitive' ) 		=> '50',
				esc_html__( '60px', 'pawsitive' ) 		=> '60',
				esc_html__( '70px', 'pawsitive' ) 		=> '70',
				esc_html__( '80px', 'pawsitive' ) 		=> '80',
				esc_html__( '90px', 'pawsitive' ) 		=> '90',
				esc_html__( '100px', 'pawsitive' ) 		=> '100',
				esc_html__( '110px', 'pawsitive' ) 		=> '110',
				esc_html__( '120px', 'pawsitive' ) 		=> '120',
				esc_html__( '130px', 'pawsitive' ) 		=> '130',
				esc_html__( '140px', 'pawsitive' ) 		=> '140',
				esc_html__( '150px', 'pawsitive' ) 		=> '150'
			)
		),
		array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Show shadow', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'No', 'pawsitive' ) 									=> '',
				esc_html__( 'Yes', 'pawsitive' ) 									=> 'visible',
				esc_html__( 'Yes (inner content)', 'pawsitive' ) 					=> 'inner_shadow',
				esc_html__( 'Yes (on hover)', 'pawsitive' ) 						=> 'hover_visible',
				esc_html__( 'Yes (on hover - inner content)', 'pawsitive' ) 		=> 'hover_inner_visible'
			)
		),
		array( 'param_name' => 'shape', 'default' => 'inherit', 'type' => 'dropdown', 'heading' => esc_html__( 'Column shape', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Inherit', 'pawsitive' ) 		=> 'inherit',
				esc_html__( 'Square', 'pawsitive' ) 		=> 'square',
				esc_html__( 'Hard rounded', 'pawsitive' ) => 'hard-rounded',
				esc_html__( 'Soft rounded', 'pawsitive' ) => 'soft-rounded'
			)
		),
		array( 'param_name' => 'border', 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Column border', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'No', 'pawsitive' ) 			=> '',
				esc_html__( 'Yes', 'pawsitive' ) 		=> 'yes'
			)
		),
	));
}

function pawsitive_bt_bb_column_class( $class, $atts ) {
	if ( isset( $atts['shadow'] ) && $atts['shadow'] != '' ) {
		$class[] = 'bt_bb_shadow' . '_' . $atts['shadow'];
	}
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	if ( isset( $atts['border'] ) && $atts['border'] != '' ) {
		$class[] = 'bt_bb_border' . '_' . $atts['border'];
	}
	return $class;
}

add_filter( 'bt_bb_column_class', 'pawsitive_bt_bb_column_class', 10, 2 );



// INNER COLUMN - PADDING, SHADOW, SHAPE
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_column_inner', 'padding' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column_inner', array(
		array( 'param_name' => 'padding', 'type' => 'dropdown', 'heading' => esc_html__( 'Inner padding', 'pawsitive' ), 'preview' => true,
			 'responsive_override' => true,
			 'value' => array(
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Double', 'pawsitive' ) 		=> 'double',
				esc_html__( 'Text Indent', 'pawsitive' ) 	=> 'text_indent',
				esc_html__( '0px', 'pawsitive' ) 			=> '0',
				esc_html__( '5px', 'pawsitive' ) 			=> '5',
				esc_html__( '10px', 'pawsitive' ) 		=> '10',
				esc_html__( '15px', 'pawsitive' ) 		=> '15',
				esc_html__( '20px', 'pawsitive' ) 		=> '20',
				esc_html__( '25px', 'pawsitive' ) 		=> '25',
				esc_html__( '30px', 'pawsitive' ) 		=> '30',
				esc_html__( '35px', 'pawsitive' ) 		=> '35',
				esc_html__( '40px', 'pawsitive' ) 		=> '40',
				esc_html__( '45px', 'pawsitive' ) 		=> '45',
				esc_html__( '50px', 'pawsitive' ) 		=> '50',
				esc_html__( '60px', 'pawsitive' ) 		=> '60',
				esc_html__( '70px', 'pawsitive' ) 		=> '70',
				esc_html__( '80px', 'pawsitive' ) 		=> '80',
				esc_html__( '90px', 'pawsitive' ) 		=> '90',
				esc_html__( '100px', 'pawsitive' ) 		=> '100',
				esc_html__( '110px', 'pawsitive' ) 		=> '110',
				esc_html__( '120px', 'pawsitive' ) 		=> '120',
				esc_html__( '130px', 'pawsitive' ) 		=> '130',
				esc_html__( '140px', 'pawsitive' ) 		=> '140',
				esc_html__( '150px', 'pawsitive' ) 		=> '150'
			)
		),
		array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Show shadow', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'No', 'pawsitive' ) 									=> '',
				esc_html__( 'Yes', 'pawsitive' ) 									=> 'visible',
				esc_html__( 'Yes (inner content)', 'pawsitive' ) 					=> 'inner_shadow',
				esc_html__( 'Yes (on hover)', 'pawsitive' ) 						=> 'hover_visible',
				esc_html__( 'Yes (on hover - inner content)', 'pawsitive' ) 		=> 'hover_inner_visible'
			)
		),
		array( 'param_name' => 'shape', 'default' => 'inherit', 'type' => 'dropdown', 'heading' => esc_html__( 'Column shape', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Inherit', 'pawsitive' ) 		=> 'inherit',
				esc_html__( 'Square', 'pawsitive' ) 		=> 'square',
				esc_html__( 'Hard rounded', 'pawsitive' ) => 'hard-rounded',
				esc_html__( 'Soft rounded', 'pawsitive' ) => 'soft-rounded'
			)
		),
		array( 'param_name' => 'border', 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Column border', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'No', 'pawsitive' ) 			=> '',
				esc_html__( 'Yes', 'pawsitive' ) 		=> 'yes'
			)
		),
	));
}

function pawsitive_bt_bb_column_inner_class( $class, $atts ) {
	if ( isset( $atts['shadow'] ) && $atts['shadow'] != '' ) {
		$class[] = 'bt_bb_shadow' . '_' . $atts['shadow'];
	}
	if ( isset( $atts['shape'] ) && $atts['shape'] != '' ) {
		$class[] = 'bt_bb_shape' . '_' . $atts['shape'];
	}
	if ( isset( $atts['border'] ) && $atts['border'] != '' ) {
		$class[] = 'bt_bb_border' . '_' . $atts['border'];
	}
	return $class;
}

add_filter( 'bt_bb_column_inner_class', 'pawsitive_bt_bb_column_inner_class', 10, 2 );



// SEPARATOR - SPACING
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_separator', 'top_spacing' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_separator', 'bottom_spacing' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_separator', array(
		array( 'param_name' => 'top_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Top spacing', 'pawsitive' ), 'weight' => 0, 'preview' => true,
			 'responsive_override' => true,
			 'value' => array(
				esc_html__( 'No spacing', 'pawsitive' ) 	=> 'none',
				esc_html__( 'Extra small', 'pawsitive' ) 	=> 'extra_small',
				esc_html__( 'Small', 'pawsitive' ) 		=> 'small',		
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Medium', 'pawsitive' )	 	=> 'medium',
				esc_html__( 'Large', 'pawsitive' ) 		=> 'large',
				esc_html__( 'Extra large', 'pawsitive' ) 	=> 'extra_large',
				esc_html__( '5px', 'pawsitive' ) 			=> '5',
				esc_html__( '10px', 'pawsitive' ) 		=> '10',
				esc_html__( '15px', 'pawsitive' ) 		=> '15',
				esc_html__( '20px', 'pawsitive' ) 		=> '20',
				esc_html__( '25px', 'pawsitive' ) 		=> '25',
				esc_html__( '30px', 'pawsitive' ) 		=> '30',
				esc_html__( '35px', 'pawsitive' ) 		=> '35',
				esc_html__( '40px', 'pawsitive' ) 		=> '40',
				esc_html__( '45px', 'pawsitive' ) 		=> '45',
				esc_html__( '50px', 'pawsitive' ) 		=> '50',
				esc_html__( '60px', 'pawsitive' )			=> '60',
				esc_html__( '70px', 'pawsitive' ) 		=> '70',
				esc_html__( '80px', 'pawsitive' ) 		=> '80',
				esc_html__( '90px', 'pawsitive' ) 		=> '90',
				esc_html__( '100px', 'pawsitive' ) 		=> '100',
				esc_html__( '110px', 'pawsitive' ) 		=> '110',
				esc_html__( '120px', 'pawsitive' ) 		=> '120',
				esc_html__( '130px', 'pawsitive' ) 		=> '130',
				esc_html__( '140px', 'pawsitive' ) 		=> '140',
				esc_html__( '150px', 'pawsitive' ) 		=> '150'
			)
		),
		array( 'param_name' => 'bottom_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Bottom spacing', 'pawsitive' ), 'weight' => 1, 'preview' => true,  'responsive_override' => true,
			'value' => array(
				esc_html__( 'No spacing', 'pawsitive' ) 	=> 'none',
				esc_html__( 'Extra small', 'pawsitive' ) 	=> 'extra_small',
				esc_html__( 'Small', 'pawsitive' ) 		=> 'small',		
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
				esc_html__( 'Large', 'pawsitive' ) 		=> 'large',
				esc_html__( 'Extra large', 'pawsitive' ) 	=> 'extra_large',
				esc_html__( '5px', 'pawsitive' ) 			=> '5',
				esc_html__( '10px', 'pawsitive' ) 		=> '10',
				esc_html__( '15px', 'pawsitive' ) 		=> '15',
				esc_html__( '20px', 'pawsitive' ) 		=> '20',
				esc_html__( '25px', 'pawsitive' ) 		=> '25',
				esc_html__( '30px', 'pawsitive' ) 		=> '30',
				esc_html__( '35px', 'pawsitive' ) 		=> '35',
				esc_html__( '40px', 'pawsitive' ) 		=> '40',
				esc_html__( '45px', 'pawsitive' ) 		=> '45',
				esc_html__( '50px', 'pawsitive' ) 		=> '50',
				esc_html__( '60px', 'pawsitive' ) 		=> '60',
				esc_html__( '70px', 'pawsitive' ) 		=> '70',
				esc_html__( '80px', 'pawsitive' ) 		=> '80',
				esc_html__( '90px', 'pawsitive' ) 		=> '90',
				esc_html__( '100px', 'pawsitive' ) 		=> '100',
				esc_html__( '110px', 'pawsitive' ) 		=> '110',
				esc_html__( '120px', 'pawsitive' ) 		=> '120',
				esc_html__( '130px', 'pawsitive' ) 		=> '130',
				esc_html__( '140px', 'pawsitive' ) 		=> '140',
				esc_html__( '150px', 'pawsitive' ) 		=> '150'
			)
		),
	));
}


// HEADLINE - FONT WEIGHT, SUPERHEADLINE FONT WEIGHT
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_headline', 'font_weight' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_headline', 'size' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_headline', 'superheadline_font_weight' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_headline', 'subheadline_font_weight' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_headline', array(
		array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Font', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Default', 'pawsitive' ) 		=> '',
				esc_html__( 'Thin', 'pawsitive' ) 		=> 'thin',
				esc_html__( 'Lighter', 'pawsitive' ) 		=> 'lighter',
				esc_html__( 'Light', 'pawsitive' ) 		=> 'light',
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
				esc_html__( 'Semi bold', 'pawsitive' ) 	=> 'semi-bold',
				esc_html__( 'Bold', 'pawsitive' ) 		=> 'bold',
				esc_html__( 'Bolder', 'pawsitive' ) 		=> 'bolder',
				esc_html__( 'Black', 'pawsitive' ) 		=> 'black'
			)
		),
		array( 'param_name' => 'size', 'type' => 'dropdown', 'preview' => true, 'heading' => esc_html__( 'Size', 'pawsitive' ), 'description' => 'Predefined heading sizes, independent of html tag', 'responsive_override' => true,
			'value' => array(
				esc_html__( 'Inherit', 'pawsitive' ) 				=> 'inherit',
				esc_html__( 'Extra small', 'pawsitive' ) 			=> 'extrasmall',
				esc_html__( 'Small', 'pawsitive' ) 				=> 'small',
				esc_html__( 'Medium', 'pawsitive' ) 				=> 'medium',
				esc_html__( 'Normal', 'pawsitive' ) 				=> 'normal',
				esc_html__( 'Large', 'pawsitive' ) 				=> 'large',
				esc_html__( 'Extra large', 'pawsitive' ) 			=> 'extralarge',
				esc_html__( 'Huge', 'pawsitive' ) 				=> 'huge',
				esc_html__( 'Extra huge', 'pawsitive' ) 			=> 'extrahuge'
			)
		),
		array( 'param_name' => 'superheadline_font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Superheadline font weight', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Font', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Default', 'pawsitive' ) 		=> '',
				esc_html__( 'Thin', 'pawsitive' ) 		=> 'thin',
				esc_html__( 'Lighter', 'pawsitive' ) 		=> 'lighter',
				esc_html__( 'Light', 'pawsitive' ) 		=> 'light',
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
				esc_html__( 'Semi bold', 'pawsitive' ) 	=> 'semi-bold',
				esc_html__( 'Bold', 'pawsitive' ) 		=> 'bold',
				esc_html__( 'Bolder', 'pawsitive' ) 		=> 'bolder',
				esc_html__( 'Black', 'pawsitive' ) 		=> 'black'
			)
		),
		array( 'param_name' => 'subheadline_font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Subheadline font weight', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Font', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Default', 'pawsitive' ) 		=> '',
				esc_html__( 'Thin', 'pawsitive' ) 		=> 'thin',
				esc_html__( 'Lighter', 'pawsitive' ) 		=> 'lighter',
				esc_html__( 'Light', 'pawsitive' ) 		=> 'light',
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
				esc_html__( 'Semi bold', 'pawsitive' ) 	=> 'semi-bold',
				esc_html__( 'Bold', 'pawsitive' ) 		=> 'bold',
				esc_html__( 'Bolder', 'pawsitive' ) 		=> 'bolder',
				esc_html__( 'Black', 'pawsitive' ) 		=> 'black'
			)
		),
	));
}

function pawsitive_bt_bb_headline_class( $class, $atts ) {
	if ( isset( $atts['superheadline_font_weight'] ) && $atts['superheadline_font_weight'] != '' ) {
		$class[] = 'bt_bb_superheadline_font_weight' . '_' . $atts['superheadline_font_weight'];
	}
	if ( isset( $atts['subheadline_font_weight'] ) && $atts['subheadline_font_weight'] != '' ) {
		$class[] = 'bt_bb_subheadline_font_weight' . '_' . $atts['subheadline_font_weight'];
	}

	if ( isset( $atts['headline'] ) && $atts['headline'] == '' ) {
		$class[] = 'btNoHeadline';
	}

	return $class;
}

add_filter( 'bt_bb_headline_class', 'pawsitive_bt_bb_headline_class', 10, 2 );




// BUTTONS - SHAPE, STYLE, WEIGHT
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_button', 'shape' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_button', 'size' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_button', 'style' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_button', 'font_weight' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_button', array(
		array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Extra small', 'pawsitive' ) 	=> 'extra_small',
						esc_html__( 'Small', 'pawsitive' ) 		=> 'small',
						esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
						esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
						esc_html__( 'Large', 'pawsitive' ) 		=> 'large'
					)
				),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Inherit', 'pawsitive' ) 		=> 'inherit',
				esc_html__( 'Square', 'pawsitive' ) 		=> 'square',
				esc_html__( 'Rounded', 'pawsitive' ) 		=> 'rounded',
				esc_html__( 'Round', 'pawsitive' ) 		=> 'round',
				esc_html__( 'Drop', 'pawsitive' ) 		=> 'drop'
			)
		),
		array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Style', 'pawsitive' ), 'preview' => true, 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Outline', 'pawsitive' ) 		=> 'outline',
				esc_html__( 'Filled', 'pawsitive' ) 		=> 'filled',
				esc_html__( 'Clean', 'pawsitive' ) 		=> 'clean',
				esc_html__( 'Underline', 'pawsitive' ) 	=> 'underline'
			)
		),
		array( 'param_name' => 'weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'pawsitive' ), 'group' => esc_html__( 'Design', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Default', 'pawsitive' ) 		=> '',
				esc_html__( 'Thin', 'pawsitive' ) 		=> 'thin',
				esc_html__( 'Lighter', 'pawsitive' ) 		=> 'lighter',
				esc_html__( 'Light', 'pawsitive' ) 		=> 'light',
				esc_html__( 'Normal', 'pawsitive' ) 		=> 'normal',
				esc_html__( 'Medium', 'pawsitive' ) 		=> 'medium',
				esc_html__( 'Semi bold', 'pawsitive' ) 	=> 'semi-bold',
				esc_html__( 'Bold', 'pawsitive' ) 		=> 'bold',
				esc_html__( 'Bolder', 'pawsitive' ) 		=> 'bolder',
				esc_html__( 'Black', 'pawsitive' ) 		=> 'black'
			)
		),
	));
}

function pawsitive_bt_bb_button_class( $class, $atts ) {
	if ( isset( $atts['weight'] ) && $atts['weight'] != '' ) {
		$class[] = 'bt_bb_font_weight' . '_' . $atts['weight'];
	}
	return $class;
}

add_filter( 'bt_bb_button_class', 'pawsitive_bt_bb_button_class', 10, 2 );




// SLIDER - DOTS COLOR SCHEME
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider', array(
		array( 'param_name' => 'dots_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Dots color scheme', 'pawsitive' ), 'value' => $color_scheme_arr ),
	));
}

function pawsitive_bt_bb_content_slider_class( $class, $atts ) {
	if ( isset( $atts['dots_color_scheme'] ) && $atts['dots_color_scheme'] != '' ) {
		$class[] = 'bt_bb_dots_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['dots_color_scheme'] );
	}
	return $class;
}

function pawsitive_bt_bb_content_slider_style( $style, $atts ) {
	if ( isset( $atts['dots_color_scheme'] ) && $atts['dots_color_scheme'] != '' ) {
	
		$dots_color_scheme_id = NULL;
		if ( is_numeric ( $atts['dots_color_scheme'] ) ) {
			$dots_color_scheme_id = $atts['dots_color_scheme'];
		} else if ( $atts['dots_color_scheme'] != '' ) {
			$dots_color_scheme_id = bt_bb_get_color_scheme_id( $atts['dots_color_scheme'] );
		}
		$dots_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $dots_color_scheme_id - 1 );
		if ( $dots_color_scheme_colors ) $style .= '; --dots-primary-color:' . $dots_color_scheme_colors[0] . '; --dots-secondary-color:' . $dots_color_scheme_colors[1] . ';';
	}
	return $style;
}

add_filter( 'bt_bb_content_slider_class', 'pawsitive_bt_bb_content_slider_class', 10, 2 );
add_filter( 'bt_bb_content_slider_style', 'pawsitive_bt_bb_content_slider_style', 10, 2 );




// ACCORDION - ICON COLOR SCHEME, SHAPE, ICON STYLE
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_accordion', 'shape' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_accordion', array(
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Shape', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Inherit', 'pawsitive' ) 		=> '',
				esc_html__( 'Square', 'pawsitive' ) 		=> 'square',
				esc_html__( 'Rounded', 'pawsitive' ) 		=> 'rounded',
				esc_html__( 'Round', 'pawsitive' ) 		=> 'round'
			)
		),
		array( 'param_name' => 'icon_style', 'type' => 'dropdown', 'default' => '', 'heading' => esc_html__( 'Icon style', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Filled', 'pawsitive' ) 		=> 'filled',
				esc_html__( 'Borderless', 'pawsitive' ) 	=> 'borderless',
				esc_html__( 'Outline', 'pawsitive' ) 		=> 'outline'
			)
		),
		array( 'param_name' => 'icons_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Icons color scheme', 'pawsitive' ), 'value' => $color_scheme_arr ),
	));
}

function pawsitive_bt_bb_accordion_class( $class, $atts ) {
	if ( isset( $atts['icons_color_scheme'] ) && $atts['icons_color_scheme'] != '' ) {
		$class[] = 'bt_bb_icons_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['icons_color_scheme'] );
	}
	if ( isset( $atts['icon_style'] ) && $atts['icon_style'] != '' ) {
		$class[] = 'bt_bb_icon_style' . '_' . $atts['icon_style'];
	}
	return $class;
}

function pawsitive_bt_bb_accordion_style( $style, $atts ) {
	if ( isset( $atts['icons_color_scheme'] ) && $atts['icons_color_scheme'] != '' ) {
	
		$icons_color_scheme_id = NULL;
		if ( is_numeric ( $atts['icons_color_scheme'] ) ) {
			$icons_color_scheme_id = $atts['icons_color_scheme'];
		} else if ( $atts['icons_color_scheme'] != '' ) {
			$icons_color_scheme_id = bt_bb_get_color_scheme_id( $atts['icons_color_scheme'] );
		}
		$icons_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $icons_color_scheme_id - 1 );
		if ( $icons_color_scheme_colors ) $style .= '; --icons-primary-color:' . $icons_color_scheme_colors[0] . '; --icons-secondary-color:' . $icons_color_scheme_colors[1] . ';';
	}
	return $style;
}

add_filter( 'bt_bb_accordion_class', 'pawsitive_bt_bb_accordion_class', 10, 2 );
add_filter( 'bt_bb_accordion_style', 'pawsitive_bt_bb_accordion_style', 10, 2 );



// TABS - SHAPE
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_tabs', 'shape' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_tabs', array(
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'pawsitive' ),
			'value' => array(
				esc_html__( 'Inherit', 'pawsitive' ) 		=> '',
				esc_html__( 'Square', 'pawsitive' ) 		=> 'square',
				esc_html__( 'Rounded', 'pawsitive' ) 		=> 'rounded',
				esc_html__( 'Round', 'pawsitive' ) 		=> 'round',
				esc_html__( 'Drop', 'pawsitive' ) 		=> 'drop'
			)
		),
	));
}


// COUNTDOWN - COLOR SCHEME
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_countdown', array(
		array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'pawsitive' ), 'value' => $color_scheme_arr ),
	));
}

function pawsitive_bt_bb_countdown_class( $class, $atts ) {
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
		$class[] = 'bt_bb_color_scheme' . '_' . bt_bb_get_color_scheme_id( $atts['color_scheme'] );
	}
	return $class;
}

function pawsitive_bt_bb_countdown_style( $style, $atts ) {
	if ( isset( $atts['color_scheme'] ) && $atts['color_scheme'] != '' ) {
	
		$color_scheme_id = NULL;
		if ( is_numeric ( $atts['color_scheme'] ) ) {
			$color_scheme_id = $atts['color_scheme'];
		} else if ( $atts['color_scheme'] != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $atts['color_scheme'] );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $style .= '; --countdown-primary-color:' . $color_scheme_colors[0] . '; --countdown-secondary-color:' . $color_scheme_colors[1] . ';';
	}
	return $style;
}

add_filter( 'bt_bb_countdown_class', 'pawsitive_bt_bb_countdown_class', 10, 2 );
add_filter( 'bt_bb_countdown_style', 'pawsitive_bt_bb_countdown_style', 10, 2 );




// Woocommerce products per row
add_filter( 'loop_shop_columns', 'loop_columns', 999 );
if ( !function_exists('loop_columns') ) {
	function loop_columns() {
		$num = ( BoldThemesFramework::$has_sidebar == true || is_active_sidebar( 'bt_shop_sidebar' ) ) ? 3 : 4;
		return $num; // 3 or 4 products per row
	}
}

add_filter( 'loop_shop_per_page', 'pawsitive_products_per_page', 9999 );
function pawsitive_products_per_page( $per_page ) {
  $per_page = BoldThemesFramework::$has_sidebar == true ? 9 : 12;
  return $per_page;
}



/* FRONT EDITOR */
function pawsitive_bt_bb_fe( $elements ) {
	$elements[ 'bt_bb_before_after_image' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			//'before_image'			=> array(),
			//'after_image'			=> array(),
			'headline'      		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_before_after_image_headline', 'type' => 'inner_html' ) ),
			'subheadline' 			=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_before_after_image_subheadline', 'type' => 'inner_html' ) ),
			'smaler_subheadline'   	=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_before_after_image_smaler_subheadline', 'type' => 'inner_html' ) ),
			'before_text'          	=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_before_after_image_before_text', 'type' => 'inner_html' ) ),
			'after_text'          	=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_before_after_image_after_text', 'type' => 'inner_html' ) ),
		),
	);
	$elements[ 'bt_bb_card' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'icon'      					=> array(),
			'colored_icon'         			=> array(),
			'title'							=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_card_title', 'type' => 'inner_html' ) ),
			'text'							=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_card_text', 'type' => 'inner_html' ) ),
			'background_image'				=> array(),
			'shape'							=> array(),
		),
	);
	$elements[ 'bt_bb_floating_image' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'image'				=>  array(),
		),
	);
	$elements[ 'bt_bb_menu_item' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'menu_item_title'			=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_menu_item_title span', 'type' => 'inner_html' ) ),
			'menu_item_description'		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_menu_item_description span', 'type' => 'inner_html' ) ),
			'menu_item_price'			=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_menu_item_price span', 'type' => 'inner_html' ) ),
			'color_scheme'				=> array( 'ajax_filter' => array( 'class' ) ),
		),
	);
	$elements[ 'bt_bb_organic_animation' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'image'      					=> array(),
			'background_shape'  			=> array(),
			'foreground_shape'  			=> array(),
			'background_type'  				=> array(),
			'icon'							=> array(),
			'title'      					=> array( 'js_handler' => array( 'target_selector' => '.item__title', 'type' => 'inner_html' ) ),
			'subtitle'      				=> array( 'js_handler' => array( 'target_selector' => '.item__subtitle', 'type' => 'inner_html' ) ),
			'title_size'      				=> array( 'ajax_filter' => array( 'class' ) ),
			'title_color_scheme' 			=> array( 'ajax_filter' => array( 'class' ) ),
			'button_text'      				=> array( 'js_handler' => array( 'target_selector' => '.item__button_text .item__button_link', 'type' => 'inner_html' ) ),
			'button_url'      				=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target'       					=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
		),
	);
	$elements[ 'bt_bb_progress_bar_advanced' ] = array(
		'edit_box_selector' => '',
		'ajax_trigger_scroll' => true,
		'params' => array(
			'type'        				=> array(),
			'percentage'        		=> array(),
			'duration'     	   			=> array(),
			'easing'       	 			=> array(),
			'title'        				=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_progress_bar_advanced_text', 'type' => 'inner_html' ) ),
			'text'        				=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_progress_bar_advanced_text', 'type' => 'inner_html' ) ),
			'icon'						=> array(),
			'regular_icon'         		=> array(),
			'progress_text'        		=> array(),
			'url'						=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target' 					=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
		),
	);
	$elements[ 'bt_bb_single_product' ] = array(
		'edit_box_selector' => '',
		'params' => array(
			'product_id'        		=> array(),
			'product_image'      		=> array(),
			'product_title'        		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_single_product_title a', 'type' => 'inner_html' ) ),
			'product_price'      		=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_single_product_price', 'type' => 'inner_html' ) ),
		),
	);
	return $elements;
}
add_filter( 'bt_bb_fe_elements', 'pawsitive_bt_bb_fe' );